/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.ModelChangeStructureDataType;
import com.prosysopc.ua.types.opcua.GeneralModelChangeEventType;
import com.prosysopc.ua.types.opcua.client.BaseModelChangeEventTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2133")
public abstract class GeneralModelChangeEventTypeImplBase
extends BaseModelChangeEventTypeImpl
implements GeneralModelChangeEventType {
    protected GeneralModelChangeEventTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getChangesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Changes");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ModelChangeStructureDataType[] getChanges() {
        UaProperty uaProperty = this.getChangesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ModelChangeStructureDataType[])object;
    }

    @Override
    @Mandatory
    public void setChanges(ModelChangeStructureDataType[] modelChangeStructureDataTypeArray) throws StatusException {
        UaProperty uaProperty = this.getChangesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Changes failed, the Optional node does not exist)");
        }
        uaProperty.setValue(modelChangeStructureDataTypeArray);
    }
}

