/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.CartesianCoordinates;
import com.prosysopc.ua.stack.core.Orientation;
import com.prosysopc.ua.types.opcua.BaseDataVariableType;
import com.prosysopc.ua.types.opcua.CartesianCoordinatesType;
import com.prosysopc.ua.types.opcua.FrameType;
import com.prosysopc.ua.types.opcua.OrientationType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18786")
public abstract class FrameTypeImplBase
extends BaseDataVariableTypeImpl
implements FrameType {
    protected FrameTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Optional
    public UaProperty getConstantNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Constant");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isConstant() {
        UaProperty uaProperty = this.getConstantNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setConstant(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getConstantNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Constant failed, the Optional node does not exist)");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Optional
    public UaProperty getFixedBaseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FixedBase");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isFixedBase() {
        UaProperty uaProperty = this.getFixedBaseNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setFixedBase(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getFixedBaseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting FixedBase failed, the Optional node does not exist)");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Optional
    public BaseDataVariableType getBaseFrameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BaseFrame");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public NodeId getBaseFrame() {
        BaseDataVariableType baseDataVariableType = this.getBaseFrameNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Optional
    public void setBaseFrame(NodeId nodeId) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getBaseFrameNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting BaseFrame failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(nodeId);
    }

    @Override
    @Mandatory
    public OrientationType getOrientationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Orientation");
        return (OrientationType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Orientation getOrientation() {
        OrientationType orientationType = this.getOrientationNode();
        if (orientationType == null) {
            return null;
        }
        Object object = orientationType.getValue().getValue().getValue();
        return (Orientation)object;
    }

    @Override
    @Mandatory
    public void setOrientation(Orientation orientation) throws StatusException {
        OrientationType orientationType = this.getOrientationNode();
        if (orientationType == null) {
            throw new RuntimeException("Setting Orientation failed, the Optional node does not exist)");
        }
        orientationType.setValue(orientation);
    }

    @Override
    @Mandatory
    public CartesianCoordinatesType getCartesianCoordinatesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CartesianCoordinates");
        return (CartesianCoordinatesType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public CartesianCoordinates getCartesianCoordinates() {
        CartesianCoordinatesType cartesianCoordinatesType = this.getCartesianCoordinatesNode();
        if (cartesianCoordinatesType == null) {
            return null;
        }
        Object object = cartesianCoordinatesType.getValue().getValue().getValue();
        return (CartesianCoordinates)object;
    }

    @Override
    @Mandatory
    public void setCartesianCoordinates(CartesianCoordinates cartesianCoordinates) throws StatusException {
        CartesianCoordinatesType cartesianCoordinatesType = this.getCartesianCoordinatesNode();
        if (cartesianCoordinatesType == null) {
            throw new RuntimeException("Setting CartesianCoordinates failed, the Optional node does not exist)");
        }
        cartesianCoordinatesType.setValue(cartesianCoordinates);
    }
}

