/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodArgumentTransformer;
import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.types.opcua.DialogConditionType;
import com.prosysopc.ua.types.opcua.TwoStateVariableType;
import com.prosysopc.ua.types.opcua.client.ConditionTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2830")
public abstract class DialogConditionTypeImplBase
extends ConditionTypeImpl
implements DialogConditionType {
    protected DialogConditionTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getDefaultResponseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DefaultResponse");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getDefaultResponse() {
        UaProperty uaProperty = this.getDefaultResponseNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setDefaultResponse(Integer n2) throws StatusException {
        UaProperty uaProperty = this.getDefaultResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DefaultResponse failed, the Optional node does not exist)");
        }
        uaProperty.setValue(n2);
    }

    @Override
    @Mandatory
    public UaProperty getOkResponseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OkResponse");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getOkResponse() {
        UaProperty uaProperty = this.getOkResponseNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setOkResponse(Integer n2) throws StatusException {
        UaProperty uaProperty = this.getOkResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting OkResponse failed, the Optional node does not exist)");
        }
        uaProperty.setValue(n2);
    }

    @Override
    @Mandatory
    public UaProperty getCancelResponseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CancelResponse");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getCancelResponse() {
        UaProperty uaProperty = this.getCancelResponseNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setCancelResponse(Integer n2) throws StatusException {
        UaProperty uaProperty = this.getCancelResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CancelResponse failed, the Optional node does not exist)");
        }
        uaProperty.setValue(n2);
    }

    @Override
    @Mandatory
    public UaProperty getLastResponseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastResponse");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getLastResponse() {
        UaProperty uaProperty = this.getLastResponseNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setLastResponse(Integer n2) throws StatusException {
        UaProperty uaProperty = this.getLastResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LastResponse failed, the Optional node does not exist)");
        }
        uaProperty.setValue(n2);
    }

    @Override
    @Mandatory
    public UaProperty getPromptNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Prompt");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getPrompt() {
        UaProperty uaProperty = this.getPromptNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setPrompt(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getPromptNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Prompt failed, the Optional node does not exist)");
        }
        uaProperty.setValue(localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getResponseOptionSetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ResponseOptionSet");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText[] getResponseOptionSet() {
        UaProperty uaProperty = this.getResponseOptionSetNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText[])object;
    }

    @Override
    @Mandatory
    public void setResponseOptionSet(LocalizedText[] localizedTextArray) throws StatusException {
        UaProperty uaProperty = this.getResponseOptionSetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ResponseOptionSet failed, the Optional node does not exist)");
        }
        uaProperty.setValue(localizedTextArray);
    }

    @Override
    @Mandatory
    public TwoStateVariableType getEnabledStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnabledState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getEnabledState() {
        TwoStateVariableType twoStateVariableType = this.getEnabledStateNode();
        if (twoStateVariableType == null) {
            return null;
        }
        Object object = twoStateVariableType.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setEnabledState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getEnabledStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting EnabledState failed, the Optional node does not exist)");
        }
        twoStateVariableType.setValue(localizedText);
    }

    @Override
    @Mandatory
    public TwoStateVariableType getDialogStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DialogState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getDialogState() {
        TwoStateVariableType twoStateVariableType = this.getDialogStateNode();
        if (twoStateVariableType == null) {
            return null;
        }
        Object object = twoStateVariableType.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setDialogState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getDialogStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting DialogState failed, the Optional node does not exist)");
        }
        twoStateVariableType.setValue(localizedText);
    }

    @Override
    @Mandatory
    public UaMethod getRespondNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Respond");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void respond(Integer n2) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Respond"));
        this.call(nodeId, n2);
    }

    public AsyncResult<Void> respondAsync(Integer n2) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Respond"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void g(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.g(variantArray);
            }
        }, n2);
    }
}

