/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodArgumentTransformer;
import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ConfigurationVersionDataType;
import com.prosysopc.ua.stack.core.DataSetFieldContentMask;
import com.prosysopc.ua.stack.core.DataSetMetaDataType;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.FieldTargetDataType;
import com.prosysopc.ua.stack.core.KeyValuePair;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.RolePermissionType;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.types.opcua.DataSetReaderMessageType;
import com.prosysopc.ua.types.opcua.DataSetReaderTransportType;
import com.prosysopc.ua.types.opcua.DataSetReaderType;
import com.prosysopc.ua.types.opcua.PubSubDiagnosticsDataSetReaderType;
import com.prosysopc.ua.types.opcua.PubSubStatusType;
import com.prosysopc.ua.types.opcua.SubscribedDataSetType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15306")
public abstract class DataSetReaderTypeImplBase
extends BaseObjectTypeImpl
implements DataSetReaderType {
    protected DataSetReaderTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getPublisherIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PublisherId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Object getPublisherId() {
        UaProperty uaProperty = this.getPublisherIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return object;
    }

    @Override
    @Mandatory
    public void setPublisherId(Object object) throws StatusException {
        UaProperty uaProperty = this.getPublisherIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PublisherId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(object);
    }

    @Override
    @Mandatory
    public UaProperty getDataSetMetaDataNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetMetaData");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DataSetMetaDataType getDataSetMetaData() {
        UaProperty uaProperty = this.getDataSetMetaDataNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DataSetMetaDataType)object;
    }

    @Override
    @Mandatory
    public void setDataSetMetaData(DataSetMetaDataType dataSetMetaDataType) throws StatusException {
        UaProperty uaProperty = this.getDataSetMetaDataNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetMetaData failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dataSetMetaDataType);
    }

    @Override
    @Mandatory
    public UaProperty getMessageReceiveTimeoutNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MessageReceiveTimeout");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getMessageReceiveTimeout() {
        UaProperty uaProperty = this.getMessageReceiveTimeoutNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setMessageReceiveTimeout(Double d2) throws StatusException {
        UaProperty uaProperty = this.getMessageReceiveTimeoutNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MessageReceiveTimeout failed, the Optional node does not exist)");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Optional
    public UaProperty getSecurityKeyServicesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityKeyServices");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public EndpointDescription[] getSecurityKeyServices() {
        UaProperty uaProperty = this.getSecurityKeyServicesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EndpointDescription[])object;
    }

    @Override
    @Optional
    public void setSecurityKeyServices(EndpointDescription[] endpointDescriptionArray) throws StatusException {
        UaProperty uaProperty = this.getSecurityKeyServicesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityKeyServices failed, the Optional node does not exist)");
        }
        uaProperty.setValue(endpointDescriptionArray);
    }

    @Override
    @Mandatory
    public UaProperty getWriterGroupIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "WriterGroupId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getWriterGroupId() {
        UaProperty uaProperty = this.getWriterGroupIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setWriterGroupId(UnsignedShort unsignedShort) throws StatusException {
        UaProperty uaProperty = this.getWriterGroupIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting WriterGroupId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedShort);
    }

    @Override
    @Mandatory
    public UaProperty getKeyFrameCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "KeyFrameCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getKeyFrameCount() {
        UaProperty uaProperty = this.getKeyFrameCountNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setKeyFrameCount(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getKeyFrameCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting KeyFrameCount failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Optional
    public UaProperty getSecurityModeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityMode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public MessageSecurityMode getSecurityMode() {
        UaProperty uaProperty = this.getSecurityModeNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (MessageSecurityMode)variant.asEnum(MessageSecurityMode.class);
    }

    @Override
    @Optional
    public void setSecurityMode(MessageSecurityMode messageSecurityMode) throws StatusException {
        UaProperty uaProperty = this.getSecurityModeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityMode failed, the Optional node does not exist)");
        }
        uaProperty.setValue(messageSecurityMode);
    }

    @Override
    @Mandatory
    public UaProperty getDataSetReaderPropertiesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetReaderProperties");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public KeyValuePair[] getDataSetReaderProperties() {
        UaProperty uaProperty = this.getDataSetReaderPropertiesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (KeyValuePair[])object;
    }

    @Override
    @Mandatory
    public void setDataSetReaderProperties(KeyValuePair[] keyValuePairArray) throws StatusException {
        UaProperty uaProperty = this.getDataSetReaderPropertiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetReaderProperties failed, the Optional node does not exist)");
        }
        uaProperty.setValue(keyValuePairArray);
    }

    @Override
    @Mandatory
    public UaProperty getDataSetFieldContentMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetFieldContentMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DataSetFieldContentMask getDataSetFieldContentMask() {
        UaProperty uaProperty = this.getDataSetFieldContentMaskNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DataSetFieldContentMask)object;
    }

    @Override
    @Mandatory
    public void setDataSetFieldContentMask(DataSetFieldContentMask dataSetFieldContentMask) throws StatusException {
        UaProperty uaProperty = this.getDataSetFieldContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetFieldContentMask failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dataSetFieldContentMask);
    }

    @Override
    @Mandatory
    public UaProperty getDataSetWriterIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetWriterId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getDataSetWriterId() {
        UaProperty uaProperty = this.getDataSetWriterIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setDataSetWriterId(UnsignedShort unsignedShort) throws StatusException {
        UaProperty uaProperty = this.getDataSetWriterIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetWriterId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedShort);
    }

    @Override
    @Mandatory
    public UaProperty getHeaderLayoutUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HeaderLayoutUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getHeaderLayoutUri() {
        UaProperty uaProperty = this.getHeaderLayoutUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setHeaderLayoutUri(String string) throws StatusException {
        UaProperty uaProperty = this.getHeaderLayoutUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting HeaderLayoutUri failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getSecurityGroupIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityGroupId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getSecurityGroupId() {
        UaProperty uaProperty = this.getSecurityGroupIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setSecurityGroupId(String string) throws StatusException {
        UaProperty uaProperty = this.getSecurityGroupIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityGroupId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public SubscribedDataSetType getSubscribedDataSetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SubscribedDataSet");
        return (SubscribedDataSetType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public DataSetReaderMessageType getMessageSettingsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MessageSettings");
        return (DataSetReaderMessageType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public PubSubStatusType getStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Status");
        return (PubSubStatusType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public DataSetReaderTransportType getTransportSettingsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransportSettings");
        return (DataSetReaderTransportType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public PubSubDiagnosticsDataSetReaderType getDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Diagnostics");
        return (PubSubDiagnosticsDataSetReaderType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public UaMethod getCreateDataSetMirrorNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CreateDataSetMirror");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public NodeId createDataSetMirror(String string, RolePermissionType[] rolePermissionTypeArray) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "CreateDataSetMirror"));
        return this.call(nodeId, new MethodArgumentTransformer<NodeId>(){

            public NodeId d(Variant[] variantArray) {
                return (NodeId)variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.d(variantArray);
            }
        }, string, rolePermissionTypeArray);
    }

    public AsyncResult<? extends NodeId> createDataSetMirrorAsync(String string, RolePermissionType[] rolePermissionTypeArray) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "CreateDataSetMirror"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<NodeId>(){

            public NodeId d(Variant[] variantArray) {
                return (NodeId)variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.d(variantArray);
            }
        }, string, rolePermissionTypeArray);
    }

    @Override
    @Optional
    public UaMethod getCreateTargetVariablesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CreateTargetVariables");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public StatusCode[] createTargetVariables(ConfigurationVersionDataType configurationVersionDataType, FieldTargetDataType[] fieldTargetDataTypeArray) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "CreateTargetVariables"));
        return this.call(nodeId, new MethodArgumentTransformer<StatusCode[]>(){

            public StatusCode[] r(Variant[] variantArray) {
                return (StatusCode[])variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.r(variantArray);
            }
        }, configurationVersionDataType, fieldTargetDataTypeArray);
    }

    public AsyncResult<? extends StatusCode[]> createTargetVariablesAsync(ConfigurationVersionDataType configurationVersionDataType, FieldTargetDataType[] fieldTargetDataTypeArray) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "CreateTargetVariables"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<StatusCode[]>(){

            public StatusCode[] r(Variant[] variantArray) {
                return (StatusCode[])variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.r(variantArray);
            }
        }, configurationVersionDataType, fieldTargetDataTypeArray);
    }
}

