/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.AxisInformation;
import com.prosysopc.ua.types.opcua.CubeItemType;
import com.prosysopc.ua.types.opcua.client.ArrayItemTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12057")
public abstract class CubeItemTypeImplBase
extends ArrayItemTypeImpl
implements CubeItemType {
    protected CubeItemTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getZAxisDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ZAxisDefinition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisInformation getZAxisDefinition() {
        UaProperty uaProperty = this.getZAxisDefinitionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (AxisInformation)object;
    }

    @Override
    @Mandatory
    public void setZAxisDefinition(AxisInformation axisInformation) throws StatusException {
        UaProperty uaProperty = this.getZAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ZAxisDefinition failed, the Optional node does not exist)");
        }
        uaProperty.setValue(axisInformation);
    }

    @Override
    @Mandatory
    public UaProperty getYAxisDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "YAxisDefinition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisInformation getYAxisDefinition() {
        UaProperty uaProperty = this.getYAxisDefinitionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (AxisInformation)object;
    }

    @Override
    @Mandatory
    public void setYAxisDefinition(AxisInformation axisInformation) throws StatusException {
        UaProperty uaProperty = this.getYAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting YAxisDefinition failed, the Optional node does not exist)");
        }
        uaProperty.setValue(axisInformation);
    }

    @Override
    @Mandatory
    public UaProperty getXAxisDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "XAxisDefinition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisInformation getXAxisDefinition() {
        UaProperty uaProperty = this.getXAxisDefinitionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (AxisInformation)object;
    }

    @Override
    @Mandatory
    public void setXAxisDefinition(AxisInformation axisInformation) throws StatusException {
        UaProperty uaProperty = this.getXAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting XAxisDefinition failed, the Optional node does not exist)");
        }
        uaProperty.setValue(axisInformation);
    }
}

