/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.CertificateUpdatedAuditEventType;
import com.prosysopc.ua.types.opcua.client.AuditUpdateMethodEventTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12620")
public abstract class CertificateUpdatedAuditEventTypeImplBase
extends AuditUpdateMethodEventTypeImpl
implements CertificateUpdatedAuditEventType {
    protected CertificateUpdatedAuditEventTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getCertificateTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CertificateType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getCertificateType() {
        UaProperty uaProperty = this.getCertificateTypeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setCertificateType(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getCertificateTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CertificateType failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeId);
    }

    @Override
    @Mandatory
    public UaProperty getCertificateGroupNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CertificateGroup");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getCertificateGroup() {
        UaProperty uaProperty = this.getCertificateGroupNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setCertificateGroup(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getCertificateGroupNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CertificateGroup failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeId);
    }
}

