/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.CertificateExpirationAlarmType;
import com.prosysopc.ua.types.opcua.client.SystemOffNormalAlarmTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=13225")
public abstract class CertificateExpirationAlarmTypeImplBase
extends SystemOffNormalAlarmTypeImpl
implements CertificateExpirationAlarmType {
    protected CertificateExpirationAlarmTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getCertificateTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CertificateType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getCertificateType() {
        UaProperty uaProperty = this.getCertificateTypeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setCertificateType(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getCertificateTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CertificateType failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeId);
    }

    @Override
    @Optional
    public UaProperty getExpirationLimitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ExpirationLimit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getExpirationLimit() {
        UaProperty uaProperty = this.getExpirationLimitNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setExpirationLimit(Double d2) throws StatusException {
        UaProperty uaProperty = this.getExpirationLimitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ExpirationLimit failed, the Optional node does not exist)");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Mandatory
    public UaProperty getExpirationDateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ExpirationDate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getExpirationDate() {
        UaProperty uaProperty = this.getExpirationDateNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setExpirationDate(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getExpirationDateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ExpirationDate failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Mandatory
    public UaProperty getCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Certificate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ByteString getCertificate() {
        UaProperty uaProperty = this.getCertificateNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Mandatory
    public void setCertificate(ByteString byteString) throws StatusException {
        UaProperty uaProperty = this.getCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Certificate failed, the Optional node does not exist)");
        }
        uaProperty.setValue(byteString);
    }
}

