/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodArgumentTransformer;
import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.types.opcua.AcknowledgeableConditionType;
import com.prosysopc.ua.types.opcua.TwoStateVariableType;
import com.prosysopc.ua.types.opcua.client.ConditionTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2881")
public abstract class AcknowledgeableConditionTypeImplBase
extends ConditionTypeImpl
implements AcknowledgeableConditionType {
    protected AcknowledgeableConditionTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public TwoStateVariableType getEnabledStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnabledState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getEnabledState() {
        TwoStateVariableType twoStateVariableType = this.getEnabledStateNode();
        if (twoStateVariableType == null) {
            return null;
        }
        Object object = twoStateVariableType.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setEnabledState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getEnabledStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting EnabledState failed, the Optional node does not exist)");
        }
        twoStateVariableType.setValue(localizedText);
    }

    @Override
    @Mandatory
    public TwoStateVariableType getAckedStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AckedState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getAckedState() {
        TwoStateVariableType twoStateVariableType = this.getAckedStateNode();
        if (twoStateVariableType == null) {
            return null;
        }
        Object object = twoStateVariableType.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setAckedState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getAckedStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting AckedState failed, the Optional node does not exist)");
        }
        twoStateVariableType.setValue(localizedText);
    }

    @Override
    @Optional
    public TwoStateVariableType getConfirmedStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConfirmedState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getConfirmedState() {
        TwoStateVariableType twoStateVariableType = this.getConfirmedStateNode();
        if (twoStateVariableType == null) {
            return null;
        }
        Object object = twoStateVariableType.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setConfirmedState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getConfirmedStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting ConfirmedState failed, the Optional node does not exist)");
        }
        twoStateVariableType.setValue(localizedText);
    }

    @Override
    @Optional
    public UaMethod getConfirmNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Confirm");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void confirm(ByteString byteString, LocalizedText localizedText) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Confirm"));
        this.call(nodeId, byteString, localizedText);
    }

    public AsyncResult<Void> confirmAsync(ByteString byteString, LocalizedText localizedText) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Confirm"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void g(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.g(variantArray);
            }
        }, byteString, localizedText);
    }

    @Override
    @Mandatory
    public UaMethod getAcknowledgeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Acknowledge");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void acknowledge(ByteString byteString, LocalizedText localizedText) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Acknowledge"));
        this.call(nodeId, byteString, localizedText);
    }

    public AsyncResult<Void> acknowledgeAsync(ByteString byteString, LocalizedText localizedText) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Acknowledge"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void g(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.g(variantArray);
            }
        }, byteString, localizedText);
    }
}

