/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.gds.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.gds.KeyCredentialServiceType;
import com.prosysopc.ua.types.gds.server.KeyCredentialServiceTypeFinishRequestMethod;
import com.prosysopc.ua.types.gds.server.KeyCredentialServiceTypeNode;
import com.prosysopc.ua.types.gds.server.KeyCredentialServiceTypeRevokeMethod;
import com.prosysopc.ua.types.gds.server.KeyCredentialServiceTypeStartRequestMethod;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/GDS/;i=1020")
public abstract class KeyCredentialServiceTypeNodeBase
extends BaseObjectTypeNode
implements KeyCredentialServiceType {
    private static GeneratedNodeInitializer<KeyCredentialServiceTypeNode> AD;
    private static KeyCredentialServiceTypeStartRequestMethod AE;
    private static KeyCredentialServiceTypeFinishRequestMethod AF;
    private static KeyCredentialServiceTypeRevokeMethod AG;

    protected KeyCredentialServiceTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<KeyCredentialServiceTypeNode> generatedNodeInitializer = KeyCredentialServiceTypeNodeBase.getKeyCredentialServiceTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((KeyCredentialServiceTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<KeyCredentialServiceTypeNode> getKeyCredentialServiceTypeNodeInitializer() {
        return AD;
    }

    public static void setKeyCredentialServiceTypeNodeInitializer(GeneratedNodeInitializer<KeyCredentialServiceTypeNode> generatedNodeInitializer) {
        AD = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getResourceUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "ResourceUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getResourceUri() {
        UaProperty uaProperty = this.getResourceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ResourceUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setResourceUri(String string) {
        UaProperty uaProperty = this.getResourceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ResourceUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ResourceUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getProfileUrisNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "ProfileUris");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getProfileUris() {
        UaProperty uaProperty = this.getProfileUrisNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ProfileUris does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setProfileUris(String[] stringArray) {
        UaProperty uaProperty = this.getProfileUrisNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ProfileUris failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ProfileUris failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "StartRequest"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (String)variantArray[0].getValue(), (ByteString)variantArray[1].getValue(), (String)variantArray[2].getValue(), (NodeId[])variantArray[3].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "FinishRequest"), nodeId)) {
            return this.a(serviceContext, (NodeId)variantArray[0].getValue(), (Boolean)variantArray[1].getValue()).asVariantArray();
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "Revoke"), nodeId)) {
            this.b(serviceContext, (String)variantArray[0].getValue());
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getStartRequestNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "StartRequest");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract NodeId onStartRequest(ServiceContext var1, String var2, ByteString var3, String var4, NodeId[] var5) throws StatusException;

    @Override
    public NodeId startRequest(String string, ByteString byteString, String string2, NodeId[] nodeIdArray) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, string, byteString, string2, nodeIdArray);
    }

    private NodeId a(ServiceContext serviceContext, String string, ByteString byteString, String string2, NodeId[] nodeIdArray) throws StatusException {
        KeyCredentialServiceTypeStartRequestMethod keyCredentialServiceTypeStartRequestMethod = KeyCredentialServiceTypeNodeBase.getStartRequestMethodImplementation();
        if (keyCredentialServiceTypeStartRequestMethod != null) {
            return keyCredentialServiceTypeStartRequestMethod.startRequest(serviceContext, (KeyCredentialServiceTypeNode)this, string, byteString, string2, nodeIdArray);
        }
        return this.onStartRequest(serviceContext, string, byteString, string2, nodeIdArray);
    }

    public static KeyCredentialServiceTypeStartRequestMethod getStartRequestMethodImplementation() {
        return AE;
    }

    public static void setStartRequestMethodImplementation(KeyCredentialServiceTypeStartRequestMethod keyCredentialServiceTypeStartRequestMethod) {
        AE = keyCredentialServiceTypeStartRequestMethod;
    }

    @Override
    @Mandatory
    public UaMethod getFinishRequestNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "FinishRequest");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract KeyCredentialServiceType.FinishRequestMethodOutputs onFinishRequest(ServiceContext var1, NodeId var2, Boolean var3) throws StatusException;

    @Override
    public KeyCredentialServiceType.FinishRequestMethodOutputs finishRequest(NodeId nodeId, Boolean bl) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId, bl);
    }

    private KeyCredentialServiceType.FinishRequestMethodOutputs a(ServiceContext serviceContext, NodeId nodeId, Boolean bl) throws StatusException {
        KeyCredentialServiceTypeFinishRequestMethod keyCredentialServiceTypeFinishRequestMethod = KeyCredentialServiceTypeNodeBase.getFinishRequestMethodImplementation();
        if (keyCredentialServiceTypeFinishRequestMethod != null) {
            return keyCredentialServiceTypeFinishRequestMethod.finishRequest(serviceContext, (KeyCredentialServiceTypeNode)this, nodeId, bl);
        }
        return this.onFinishRequest(serviceContext, nodeId, bl);
    }

    public static KeyCredentialServiceTypeFinishRequestMethod getFinishRequestMethodImplementation() {
        return AF;
    }

    public static void setFinishRequestMethodImplementation(KeyCredentialServiceTypeFinishRequestMethod keyCredentialServiceTypeFinishRequestMethod) {
        AF = keyCredentialServiceTypeFinishRequestMethod;
    }

    @Override
    @Optional
    public UaMethod getRevokeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "Revoke");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onRevoke(ServiceContext var1, String var2) throws StatusException;

    @Override
    public void revoke(String string) throws StatusException {
        this.b(ServiceContext.INTERNAL_OPERATION_CONTEXT, string);
    }

    private void b(ServiceContext serviceContext, String string) throws StatusException {
        KeyCredentialServiceTypeRevokeMethod keyCredentialServiceTypeRevokeMethod = KeyCredentialServiceTypeNodeBase.getRevokeMethodImplementation();
        if (keyCredentialServiceTypeRevokeMethod != null) {
            keyCredentialServiceTypeRevokeMethod.revoke(serviceContext, (KeyCredentialServiceTypeNode)this, string);
        } else {
            this.onRevoke(serviceContext, string);
        }
    }

    public static KeyCredentialServiceTypeRevokeMethod getRevokeMethodImplementation() {
        return AG;
    }

    public static void setRevokeMethodImplementation(KeyCredentialServiceTypeRevokeMethod keyCredentialServiceTypeRevokeMethod) {
        AG = keyCredentialServiceTypeRevokeMethod;
    }
}

