/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.gds;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.ApplicationType;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IDecoder;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.IEncoder;
import com.prosysopc.ua.stack.encoding.binary.IEncodeableSerializer;
import com.prosysopc.ua.types.gds.ApplicationRecordDataType;
import java.util.ArrayList;

public class GdsSerializers {
    public static final IEncodeableSerializer[] SERIALIZERS;

    static {
        ArrayList<ApplicationRecordDataTypeSerializer> arrayList = new ArrayList<ApplicationRecordDataTypeSerializer>();
        arrayList.add(new ApplicationRecordDataTypeSerializer());
        SERIALIZERS = arrayList.toArray(new IEncodeableSerializer[0]);
    }

    public static class ApplicationRecordDataTypeSerializer
    extends StructureSerializer {
        public ApplicationRecordDataTypeSerializer() {
            super(ApplicationRecordDataType.class, ApplicationRecordDataType.BINARY, ApplicationRecordDataType.XML);
        }

        @Override
        public void calcEncodeable(IEncodeable iEncodeable, IEncoder iEncoder) throws EncodingException {
            super.calcEncodeable(iEncodeable, iEncoder);
            ApplicationRecordDataType applicationRecordDataType = (ApplicationRecordDataType)iEncodeable;
            iEncoder.put(null, applicationRecordDataType == null ? null : applicationRecordDataType.getApplicationId(), NodeId.class);
            iEncoder.put(null, applicationRecordDataType == null ? null : applicationRecordDataType.getApplicationUri(), String.class);
            iEncoder.put(null, applicationRecordDataType == null ? null : applicationRecordDataType.getApplicationType(), ApplicationType.class);
            iEncoder.put(null, applicationRecordDataType == null ? null : applicationRecordDataType.getApplicationNames(), LocalizedText[].class);
            iEncoder.put(null, applicationRecordDataType == null ? null : applicationRecordDataType.getProductUri(), String.class);
            iEncoder.put(null, applicationRecordDataType == null ? null : applicationRecordDataType.getDiscoveryUrls(), String[].class);
            iEncoder.put(null, applicationRecordDataType == null ? null : applicationRecordDataType.getServerCapabilities(), String[].class);
        }

        @Override
        public void getEncodeable(IDecoder iDecoder, IEncodeable iEncodeable) throws DecodingException {
            ApplicationRecordDataType applicationRecordDataType = (ApplicationRecordDataType)iEncodeable;
            super.getEncodeable(iDecoder, applicationRecordDataType);
            applicationRecordDataType.setApplicationId(iDecoder.get("ApplicationId", NodeId.class));
            applicationRecordDataType.setApplicationUri(iDecoder.get("ApplicationUri", String.class));
            applicationRecordDataType.setApplicationType(iDecoder.get("ApplicationType", ApplicationType.class));
            applicationRecordDataType.setApplicationNames(iDecoder.get("ApplicationNames", LocalizedText[].class));
            applicationRecordDataType.setProductUri(iDecoder.get("ProductUri", String.class));
            applicationRecordDataType.setDiscoveryUrls(iDecoder.get("DiscoveryUrls", String[].class));
            applicationRecordDataType.setServerCapabilities(iDecoder.get("ServerCapabilities", String[].class));
        }

        @Override
        public IEncodeable newEncodeable() {
            return new ApplicationRecordDataType();
        }

        @Override
        public void putEncodeable(IEncodeable iEncodeable, IEncoder iEncoder) throws EncodingException {
            super.putEncodeable(iEncodeable, iEncoder);
            ApplicationRecordDataType applicationRecordDataType = (ApplicationRecordDataType)iEncodeable;
            iEncoder.put("ApplicationId", applicationRecordDataType == null ? null : applicationRecordDataType.getApplicationId(), NodeId.class);
            iEncoder.put("ApplicationUri", applicationRecordDataType == null ? null : applicationRecordDataType.getApplicationUri(), String.class);
            iEncoder.put("ApplicationType", applicationRecordDataType == null ? null : applicationRecordDataType.getApplicationType(), ApplicationType.class);
            iEncoder.put("ApplicationNames", applicationRecordDataType == null ? null : applicationRecordDataType.getApplicationNames(), LocalizedText[].class);
            iEncoder.put("ProductUri", applicationRecordDataType == null ? null : applicationRecordDataType.getProductUri(), String.class);
            iEncoder.put("DiscoveryUrls", applicationRecordDataType == null ? null : applicationRecordDataType.getDiscoveryUrls(), String[].class);
            iEncoder.put("ServerCapabilities", applicationRecordDataType == null ? null : applicationRecordDataType.getServerCapabilities(), String[].class);
        }
    }
}

