/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.typedictionary;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaException;
import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.client.AddressSpaceException;
import com.prosysopc.ua.client.InternalAddressSpaceAccessHelper;
import com.prosysopc.ua.client.InternalBrowseResults;
import com.prosysopc.ua.client.InternalGetNodesResults;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.client.nodes.InternalClientNodesAccessHelper;
import com.prosysopc.ua.client.nodes.UaDataTypeImpl;
import com.prosysopc.ua.client.nodes.UaTypeImpl;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.BrowseDirection;
import com.prosysopc.ua.stack.core.BrowseResultMask;
import com.prosysopc.ua.stack.core.DataTypeDefinition;
import com.prosysopc.ua.stack.core.DataTypeIdentifiers;
import com.prosysopc.ua.stack.core.EnumDefinition;
import com.prosysopc.ua.stack.core.EnumField;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.InternalDataTypeIdentifiersHelper;
import com.prosysopc.ua.stack.core.InternalObjectTypeIdentifiersHelper;
import com.prosysopc.ua.stack.core.InternalReferenceTypeIdentifiersHelper;
import com.prosysopc.ua.stack.core.InternalVariableTypeIdentifiersHelper;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.ReferenceDescription;
import com.prosysopc.ua.stack.core.ReferenceTypeIdentifiers;
import com.prosysopc.ua.stack.core.StructureDefinition;
import com.prosysopc.ua.stack.core.StructureField;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.binary.IEncodeableSerializer;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.XMLFactoryCache;
import com.prosysopc.ua.typedictionary.DataTypeDictionary;
import com.prosysopc.ua.typedictionary.DynamicEnumeration;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.DynamicStructureSerializer;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.TypeDictionaryException;
import com.prosysopc.ua.typedictionary.a;
import com.prosysopc.ua.typedictionary.b;
import com.prosysopc.ua.typedictionary.c;
import com.prosysopc.ua.typedictionary.d;
import com.prosysopc.ua.typedictionary.e;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.xml.parsers.DocumentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TypeDictionary {
    private static final Logger logger = LoggerFactory.getLogger(TypeDictionary.class);
    final Map<NodeId, String> zK = new ConcurrentHashMap<NodeId, String>();
    private final Map<UaNodeId, StructureSpecification> zL = new ConcurrentHashMap<UaNodeId, StructureSpecification>();
    private final Map<UaNodeId, EnumerationSpecification> zM = new ConcurrentHashMap<UaNodeId, EnumerationSpecification>();
    private final Map<UaQualifiedName, EnumerationSpecification> zN = new ConcurrentHashMap<UaQualifiedName, EnumerationSpecification>();
    private final Map<UaNodeId, Map<EncodeType, UaNodeId>> zO = new ConcurrentHashMap<UaNodeId, Map<EncodeType, UaNodeId>>();
    private final Map<UaNodeId, UaNodeId> zP = new ConcurrentHashMap<UaNodeId, UaNodeId>();
    private final UaClient cs;
    private boolean zQ = false;
    private boolean zR = true;
    private boolean zS = false;
    private boolean zT = false;

    private static EncoderContext a(EncoderContext encoderContext) {
        EncoderContext encoderContext2 = new EncoderContext(encoderContext.getNamespaceTable(), encoderContext.getServerTable(), encoderContext.getEncodeableSerializer());
        encoderContext2.setMaxArrayLength(encoderContext.getMaxArrayLength());
        encoderContext2.setMaxByteStringLength(encoderContext.getMaxByteStringLength());
        encoderContext2.setMaxMessageSize(encoderContext.getMaxMessageSize());
        encoderContext2.setMaxStringLength(encoderContext.getMaxStringLength());
        return encoderContext2;
    }

    static EnumerationSpecification a(UaNodeId uaNodeId, b b2) {
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setName(b2.getName());
        builder.setMappings(b2.aQo());
        builder.setTypeId(uaNodeId);
        return builder.build();
    }

    static a J(String string) throws UaException {
        try {
            Object object;
            Object object2;
            Object object3;
            DocumentBuilder documentBuilder = XMLFactoryCache.getDocumentBuilderFactory().newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(string));
            Document document = documentBuilder.parse(inputSource);
            String string2 = null;
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            NamedNodeMap namedNodeMap = document.getDocumentElement().getAttributes();
            for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                object3 = namedNodeMap.item(i2);
                if (!(object3 instanceof Attr)) continue;
                Attr attr = (Attr)object3;
                object2 = attr.getName();
                object = attr.getValue();
                if ("TargetNamespace".equals(object2)) {
                    string2 = object;
                    continue;
                }
                if (!((String)object2).startsWith("xmlns:")) continue;
                object2 = ((String)object2).substring(((String)object2).indexOf(":") + 1);
                if ("http://opcfoundation.org/BinarySchema/".equals(object)) {
                    object = NamespaceTable.OPCUA_NAMESPACE;
                }
                hashMap.put(object2, object);
            }
            if (string2 == null) {
                throw new TypeDictionaryException("The dictionary does not define TargetNamespace XML Attribute");
            }
            a a2 = new a(string2);
            object3 = document.getDocumentElement().getChildNodes();
            for (int i3 = 0; i3 < object3.getLength(); ++i3) {
                int n2;
                String string3;
                Object object4;
                Element element;
                Node node;
                int n3;
                NodeList nodeList;
                Object object5;
                object2 = object3.item(i3);
                if (!(object2 instanceof Element)) continue;
                object = (Element)object2;
                String string4 = object.getTagName();
                if ("opc:StructuredType".equals(string4)) {
                    object5 = new e();
                    ((e)object5).I(object.getAttribute("Name"));
                    ((e)object5).setNamespaceURI(string2);
                    nodeList = object.getChildNodes();
                    for (n3 = 0; n3 < nodeList.getLength(); ++n3) {
                        node = nodeList.item(n3);
                        if (!(node instanceof Element) || !"opc:Field".equals((element = (Element)node).getTagName())) continue;
                        object4 = new c();
                        ((c)object4).C(element.getAttribute("Length"));
                        ((c)object4).B(element.getAttribute("Name"));
                        ((c)object4).E(element.getAttribute("SourceType"));
                        ((c)object4).F(element.getAttribute("SwitchField"));
                        ((c)object4).D(element.getAttribute("LengthField"));
                        string3 = element.getAttribute("TypeName");
                        n2 = string3.indexOf(":");
                        String string5 = string3.substring(0, n2);
                        String string6 = (String)hashMap.get(string5);
                        String string7 = string3.substring(n2 + 1);
                        ((c)object4).G(string7);
                        ((c)object4).H(string6);
                        ((e)object5).getFields().add((c)object4);
                    }
                    a2.aQn().add((e)object5);
                    continue;
                }
                if (!"opc:EnumeratedType".equals(string4)) continue;
                object5 = new b();
                ((b)object5).setName(object.getAttribute("Name"));
                ((b)object5).setNamespaceURI(string2);
                nodeList = object.getChildNodes();
                for (n3 = 0; n3 < nodeList.getLength(); ++n3) {
                    node = nodeList.item(n3);
                    if (!(node instanceof Element) || !"opc:EnumeratedValue".equals((element = (Element)node).getTagName())) continue;
                    object4 = element.getAttribute("Name");
                    string3 = element.getAttribute("Value");
                    n2 = Integer.parseInt(string3);
                    ((b)object5).aQo().put(n2, (String)object4);
                }
                a2.aQm().add((b)object5);
            }
            return a2;
        }
        catch (Exception exception) {
            throw new TypeDictionaryException("Cannot parse TypeDictionary", exception);
        }
    }

    public TypeDictionary(UaClient uaClient) {
        this.cs = uaClient;
    }

    public synchronized ExtensionObject binaryEncode(DynamicStructure dynamicStructure) throws EncodingException {
        if (!this.zQ) {
            try {
                this.init();
            }
            catch (Exception exception) {
                throw new EncodingException("Cannot init typedictionaries", exception);
            }
        }
        EncoderContext encoderContext = this.cs.getEncoderContext();
        IEncodeableSerializer iEncodeableSerializer = encoderContext.getEncodeableSerializer();
        DynamicStructureSerializer dynamicStructureSerializer = new DynamicStructureSerializer(iEncodeableSerializer, dynamicStructure.getSpecification());
        EncoderContext encoderContext2 = TypeDictionary.a(this.cs.getEncoderContext());
        encoderContext2.setEncodeableSerializer(dynamicStructureSerializer);
        return ExtensionObject.binaryEncode(dynamicStructure, dynamicStructureSerializer, encoderContext2);
    }

    public synchronized void clearCaches() {
        this.zK.clear();
        this.zL.clear();
        this.zN.clear();
        this.zM.clear();
        this.zO.clear();
        this.zP.clear();
        this.zQ = false;
    }

    public synchronized DynamicStructure decode(ExtensionObject extensionObject) throws DecodingException {
        StructureSpecification structureSpecification;
        if (extensionObject.getEncodeType() != EncodeType.Binary) {
            throw new DecodingException("TypeDictionary currently only supports Binary decoding");
        }
        try {
            this.init();
        }
        catch (TypeDictionaryException typeDictionaryException) {
            throw new DecodingException(typeDictionaryException);
        }
        ExpandedNodeId expandedNodeId = extensionObject.getTypeId();
        try {
            structureSpecification = this.d(expandedNodeId);
        }
        catch (DecodingException decodingException) {
            throw decodingException;
        }
        catch (Exception exception) {
            throw new DecodingException(exception, "Cannot decode");
        }
        EncoderContext encoderContext = this.cs.getEncoderContext();
        EncoderContext encoderContext2 = TypeDictionary.a(encoderContext);
        DynamicStructureSerializer dynamicStructureSerializer = this.c(structureSpecification);
        encoderContext2.setEncodeableSerializer(dynamicStructureSerializer);
        NamespaceTable namespaceTable = this.cs.getNamespaceTable();
        return (DynamicStructure)extensionObject.decode(dynamicStructureSerializer, encoderContext2, namespaceTable);
    }

    public StructureSpecification getStructureSpecification(UaNodeId uaNodeId) {
        StructureSpecification structureSpecification = this.zL.get(uaNodeId);
        if (structureSpecification == null) {
            structureSpecification = this.b(uaNodeId);
        }
        return structureSpecification;
    }

    public synchronized void init() throws TypeDictionaryException {
        if (!this.zQ) {
            try {
                Set<Object> set = new HashSet();
                Set<Object> set2 = new HashSet();
                this.aQw();
                if (this.cs.getAddressSpace().isRead104Attributes()) {
                    set = this.aQx();
                    set2 = this.aQy();
                }
                if (this.cs.getAddressSpace().isRead104Attributes() && set.isEmpty() && set2.isEmpty()) {
                    logger.debug("Resolved all Structure and Enumeration DataTypes via DataTypeDefinition, skipping DataTypeDictionaries");
                    this.zQ = true;
                } else {
                    HashSet<UaNamespace> hashSet = new HashSet<UaNamespace>();
                    for (UaNodeId uaNodeId : set) {
                        hashSet.add(uaNodeId.getNamespace());
                    }
                    for (UaNodeId uaNodeId : set2) {
                        hashSet.add(uaNodeId.getNamespace());
                    }
                    this.b(hashSet);
                    this.zQ = true;
                }
            }
            catch (Exception exception) {
                throw new TypeDictionaryException("Cannot init typedictionaries", exception);
            }
            logger.info("TypeDictionary initialized successfully");
        }
    }

    public boolean isUseParallelCalls() {
        return this.zT;
    }

    public synchronized void refresh() throws TypeDictionaryException {
        this.clearCaches();
        this.init();
    }

    public void setTreatOpcStringAsOpcCharArray(boolean bl) {
        this.zR = bl;
    }

    public void setUseParallelCalls(boolean bl) {
        this.zT = bl;
    }

    public void setWarnOnlyOnErroneousDictionaries(boolean bl) {
        this.zS = bl;
    }

    private void addEnumerationSpecification(EnumerationSpecification enumerationSpecification) {
        this.zM.put(enumerationSpecification.getTypeId(), enumerationSpecification);
    }

    private void addStructureSpecification(StructureSpecification structureSpecification) {
        this.zL.put(structureSpecification.getTypeId(), structureSpecification);
        this.zL.put(structureSpecification.getBinaryEncodeId(), structureSpecification);
        if (structureSpecification.getXmlEncodeId() != null) {
            this.zL.put(structureSpecification.getXmlEncodeId(), structureSpecification);
        }
        if (structureSpecification.getJsonEncodeId() != null) {
            this.zL.put(structureSpecification.getJsonEncodeId(), structureSpecification);
        }
    }

    private DynamicStructureSerializer c(StructureSpecification structureSpecification) {
        EncoderContext encoderContext = this.cs.getEncoderContext();
        IEncodeableSerializer iEncodeableSerializer = encoderContext.getEncodeableSerializer();
        return new DynamicStructureSerializer(iEncodeableSerializer, structureSpecification);
    }

    private StructureSpecification d(ExpandedNodeId expandedNodeId) throws Exception {
        UaNode uaNode = this.cs.getAddressSpace().getNode(expandedNodeId);
        NodeId nodeId = uaNode.getNodeId();
        UaNodeId uaNodeId = UaNodeId.fromLocal(nodeId, this.cs.getNamespaceTable());
        StructureSpecification structureSpecification = this.cs.getEncoderContext().getStructureSpecification(uaNodeId);
        if (structureSpecification != null) {
            return structureSpecification;
        }
        StructureSpecification structureSpecification2 = this.zL.get(uaNodeId);
        if (structureSpecification2 != null) {
            return structureSpecification2;
        }
        throw new DecodingException("Unknown encoding: " + uaNodeId);
    }

    private EnumerationSpecification p(UaNode uaNode) {
        DataTypeDefinition dataTypeDefinition = ((UaDataType)uaNode).getDataTypeDefinition();
        if (!(dataTypeDefinition instanceof EnumDefinition)) {
            logger.debug("Did not receive EnumDefinition for the DataTypeDefinition Attribute value, got: {}", (Object)dataTypeDefinition);
            return null;
        }
        EnumDefinition enumDefinition = (EnumDefinition)dataTypeDefinition;
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setName(uaNode.getBrowseName().getName());
        builder.setTypeId(UaNodeId.fromLocal(uaNode.getNodeId(), this.cs.getNamespaceTable()));
        for (EnumField enumField : enumDefinition.getFields()) {
            String string = enumField.getName();
            Long l2 = enumField.getValue();
            if (l2 > Integer.MAX_VALUE && l2 < Integer.MIN_VALUE) {
                logger.error("Encountered invalid enum value (outside of Int32 range) in type: {}, name:{}, value:{}, skipping", new Object[]{uaNode.getBrowseName().getName(), string, l2});
                continue;
            }
            builder.addMapping(l2.intValue(), string);
        }
        EnumerationSpecification enumerationSpecification = builder.build();
        this.addEnumerationSpecification(enumerationSpecification);
        return enumerationSpecification;
    }

    private StructureSpecification q(UaNode uaNode) throws ServiceException, AddressSpaceException {
        DataTypeDefinition dataTypeDefinition = ((UaDataType)uaNode).getDataTypeDefinition();
        if (!(dataTypeDefinition instanceof StructureDefinition)) {
            logger.debug("Did not receive StructureDefinition for the DataTypeDefinition Attribute value, got: {}", (Object)dataTypeDefinition);
            return null;
        }
        Map<EncodeType, UaNodeId> map = this.a((UaDataType)uaNode);
        StructureDefinition structureDefinition = (StructureDefinition)dataTypeDefinition;
        if (!map.containsKey((Object)EncodeType.Binary)) {
            logger.debug("Could not find Default Binary encoding node for node: {}, assuming DefaultEncoding is Binary", (Object)uaNode.getNodeId());
            map.put(EncodeType.Binary, UaNodeId.fromLocal(structureDefinition.getDefaultEncodingId(), this.cs.getNamespaceTable()));
        }
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.setName(uaNode.getBrowseName().getName());
        builder.setTypeId(UaNodeId.fromLocal(uaNode.getNodeId(), this.cs.getNamespaceTable()));
        builder.setBinaryEncodeId(map.get((Object)EncodeType.Binary));
        builder.setXmlEncodeId(map.get((Object)EncodeType.Xml));
        builder.setJsonEncodeId(map.get((Object)EncodeType.Json));
        switch (structureDefinition.getStructureType()) {
            case Structure: {
                builder.setStructureType(StructureSpecification.StructureType.NORMAL);
                break;
            }
            case StructureWithOptionalFields: {
                builder.setStructureType(StructureSpecification.StructureType.OPTIONAL);
                break;
            }
            case Union: {
                builder.setStructureType(StructureSpecification.StructureType.UNION);
                break;
            }
            default: {
                logger.error("Unknown enum constant: {}", (Object)structureDefinition.getStructureType());
                return null;
            }
        }
        for (StructureField structureField : structureDefinition.getFields()) {
            Object object;
            FieldSpecification.Builder builder2 = FieldSpecification.builder();
            if (structureField.getArrayDimensions() != null) {
                object = new int[structureField.getArrayDimensions().length];
                for (int i2 = 0; i2 < structureField.getArrayDimensions().length; ++i2) {
                    UnsignedInteger unsignedInteger = structureField.getArrayDimensions()[i2];
                    object[i2] = unsignedInteger.longValue() > Integer.MAX_VALUE ? Integer.MAX_VALUE : unsignedInteger.intValue();
                }
            }
            builder2.setDataTypeId(UaNodeId.fromLocal(structureField.getDataType(), this.cs.getNamespaceTable()));
            builder2.setDescription(structureField.getDescription() == null ? null : structureField.getDescription().getText());
            builder2.setIsOptional(structureField.getIsOptional());
            builder2.setMaxStringLength(structureField.getMaxStringLength().intValue());
            builder2.setName(structureField.getName());
            builder2.setValueRank(structureField.getValueRank());
            object = this.cs.getAddressSpace().getDataType(structureField.getDataType());
            Class<Object> i2 = object.getJavaClass();
            if (i2 == null && object.inheritsFrom(DataTypeIdentifiers.Structure)) {
                i2 = DynamicStructure.class;
            }
            if (i2 == null) {
                i2 = this.b((UaDataType)object);
            }
            logger.trace("class: {}, for id: {}", i2, (Object)structureField.getDataType());
            if (structureField.getValueRank() != -1) {
                if (structureField.getValueRank() < 1) {
                    logger.error("Encountered non-valid ValueRank while processing DataTypeDefinition {}", (Object)structureDefinition);
                } else {
                    i2 = MultiDimensionArrayUtils.arrayClassOf(i2, structureField.getValueRank());
                }
            }
            builder2.setJavaClass(i2);
            builder.addField(builder2.build());
        }
        StructureSpecification structureSpecification = builder.build();
        this.addStructureSpecification(structureSpecification);
        return structureSpecification;
    }

    private EnumerationSpecification a(UaNodeId uaNodeId) {
        try {
            UaNode uaNode = this.cs.getAddressSpace().getNode(uaNodeId.asNodeId(this.cs.getNamespaceTable()));
            if (uaNode instanceof UaDataType) {
                return this.p(uaNode);
            }
            UaReference uaReference = uaNode.getReference(Identifiers.HasEncoding, true);
            if (uaReference == null) {
                logger.error("Could not find reverse HasEncoding reference from node {}", (Object)uaNodeId);
                return null;
            }
            if ((uaNode = uaReference.getOppositeNode(uaNode)) instanceof UaDataType) {
                return this.p(uaNode);
            }
            logger.error("Target of reverse HasEncoding from {} was not a DataType node", (Object)uaNodeId);
            return null;
        }
        catch (Exception exception) {
            logger.debug("Could not resolve id {} to StructureSpecification via DataTypeDefinition Attribute", (Object)uaNodeId, (Object)exception);
            return null;
        }
    }

    private String o(NodeId nodeId) throws UaException {
        try {
            ByteString byteString = (ByteString)this.cs.readValue(nodeId).getValue().getValue();
            if (byteString == null || byteString.getLength() == 0) {
                return null;
            }
            String string = new String(ByteString.asByteArray(byteString), "UTF-8");
            return string;
        }
        catch (Exception exception) {
            throw new TypeDictionaryException("Cannot read DataTypeDictionary", exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void b(Set<UaNamespace> set) throws Exception {
        boolean bl;
        Object object;
        boolean bl2;
        if (set.isEmpty()) {
            logger.debug("Resolving all DataTypeDictionaries");
            bl2 = true;
        } else {
            logger.debug("Resolving DataTypeDictionaries for namespaces: {}", set);
            bl2 = false;
        }
        HashMap<UaQualifiedName, e> hashMap = new HashMap<UaQualifiedName, e>();
        HashMap<UaQualifiedName, b> hashMap2 = new HashMap<UaQualifiedName, b>();
        HashMap<NodeId, String> hashMap3 = new HashMap<NodeId, String>();
        InternalBrowseResults internalBrowseResults = InternalAddressSpaceAccessHelper.internalBrowseWithNodeIds(this.zT, this.cs.getAddressSpace(), new HashSet<NodeId>(Arrays.asList(Identifiers.OPCBinarySchema_TypeSystem)), BrowseDirection.Forward, ReferenceTypeIdentifiers.HasComponent, true, NodeClass.ALL, BrowseResultMask.ALL);
        HashSet<NodeId> hashSet = new HashSet<NodeId>();
        for (ReferenceDescription collection2 : internalBrowseResults.getReferences(Identifiers.OPCBinarySchema_TypeSystem)) {
            NodeId nodeId;
            try {
                nodeId = this.cs.getNamespaceTable().toNodeId(collection2.getNodeId());
            }
            catch (Exception exception) {
                logger.error("Cannot convert DataTypeDictionary node reference target {} to NodeId, skipping dictionary", (Object)collection2.getNodeId());
                continue;
            }
            String string = this.cs.getNamespaceTable().getUri(nodeId.getNamespaceIndex());
            UaNamespace uaNamespace = UaNamespace.from(string);
            if (!this.cs.getKnownDataTypeDictionary().knownAddressSpaceNamespaces().contains(string)) {
                if (!bl2 && !set.contains(uaNamespace)) {
                    logger.debug("Skipping dictionary for ns: {}, already resolved via DataTypeDefinitions", (Object)uaNamespace);
                    continue;
                }
                object = this.o(nodeId);
                if (object == null) {
                    logger.warn("Encountered null or empty DataTypeDictionary NodeId: {}, skipping", (Object)nodeId);
                    continue;
                }
                this.zK.put(nodeId, (String)object);
                a a2 = TypeDictionary.J((String)object);
                hashMap3.put(nodeId, a2.aQl());
                for (e e2 : a2.aQn()) {
                    hashMap.put(UaQualifiedName.from(e2.getNamespaceURI(), e2.aQv()), e2);
                }
                for (b b2 : a2.aQm()) {
                    hashMap2.put(UaQualifiedName.from(b2.getNamespaceURI(), b2.getName()), b2);
                }
                hashSet.add(nodeId);
                continue;
            }
            logger.debug("Skipping dictionary for ns: {}, already known via codegen", (Object)uaNamespace);
        }
        if (hashSet.isEmpty()) {
            logger.debug("Didn't find any dictionary, whose data would be unknown");
            return;
        }
        HashMap hashMap4 = new HashMap();
        if (!hashMap2.isEmpty()) {
            Set<UaTypeImpl> set2 = this.a((UaTypeImpl)this.cs.getAddressSpace().getType(DataTypeIdentifiers.Enumeration));
            for (UaTypeImpl uaTypeImpl : set2) {
                UaNodeId uaNodeId = UaNodeId.fromLocal(uaTypeImpl.getNodeId(), this.cs.getNamespaceTable());
                object = UaQualifiedName.from(uaNodeId.getNamespaceUri(), uaTypeImpl.getBrowseName().getName());
                hashMap4.put(object, uaNodeId);
            }
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            b b3 = (b)entry.getValue();
            UaNodeId uaNodeId = (UaNodeId)hashMap4.get(entry.getKey());
            if (uaNodeId == null) {
                logger.warn("Could not resolve NodeId for Dictionary Enumeration: ", entry.getKey());
            }
            object = TypeDictionary.a(uaNodeId, b3);
            this.zN.put((UaQualifiedName)entry.getKey(), (EnumerationSpecification)object);
        }
        CopyOnWriteArrayList<d> copyOnWriteArrayList = new CopyOnWriteArrayList<d>();
        InternalBrowseResults internalBrowseResults2 = InternalAddressSpaceAccessHelper.internalBrowseWithNodeIds(this.zT, this.cs.getAddressSpace(), hashSet, BrowseDirection.Forward, ReferenceTypeIdentifiers.HasComponent, true, EnumSet.of(NodeClass.Variable), EnumSet.allOf(BrowseResultMask.class));
        for (NodeId nodeId : hashSet) {
            Object object2;
            Object object3;
            Object object4;
            Comparable<NodeId> comparable;
            List<ReferenceDescription> list;
            List<ExpandedNodeId> list2;
            Object object52;
            Object object62;
            object = (String)hashMap3.get(nodeId);
            List<ReferenceDescription> list3 = internalBrowseResults2.getReferences(nodeId);
            HashSet<NodeId> hashSet2 = new HashSet<NodeId>();
            for (Object object62 : list3) {
                try {
                    hashSet2.add(this.cs.getNamespaceTable().toNodeId(((ReferenceDescription)object62).getNodeId()));
                }
                catch (Exception exception) {
                    logger.error("Cannot convert ExpandedNodeId for a DataTypeDictionary Description node to NodeId, ignoring", (Throwable)exception);
                }
            }
            if (hashSet2.isEmpty()) {
                logger.warn("Skipping dictionary node {} with NameSpaceUri Property Value: {}, as it does not contain any Descriptions nodes", (Object)nodeId, object);
                continue;
            }
            logger.debug("Resolving all references of Description nodes: {}", hashSet2);
            InternalBrowseResults internalBrowseResults3 = InternalAddressSpaceAccessHelper.internalBrowseAllDataWithNodeIds(this.zT, this.cs.getAddressSpace(), hashSet2);
            logger.debug("Number of ServiceRequests needed, Browse: {}, BrowseNext: {}", (Object)internalBrowseResults3.getNumberOfBrowseRequests(), (Object)internalBrowseResults3.getNumberOfBrowseNextRequests());
            logger.debug("Resolving all Description nodes: {}", hashSet2);
            object62 = InternalAddressSpaceAccessHelper.internalGetNodesWithNodeIdsAndPreBrowseData(this.zT, this.cs.getAddressSpace(), hashSet2, internalBrowseResults3);
            logger.debug("Number of ServiceRequests needed, Read: {}, Browse: {}, BrowseNext: {}", new Object[]{((InternalGetNodesResults)object62).getReadCalls(), ((InternalGetNodesResults)object62).getBrowseCalls(), ((InternalGetNodesResults)object62).getBrowseNextCalls()});
            HashSet<NodeId> hashSet3 = new HashSet<NodeId>();
            HashMap<Iterator<UaNode>, NodeId> hashMap5 = new HashMap<Iterator<UaNode>, NodeId>();
            HashMap<NodeId, Object> hashMap6 = new HashMap<NodeId, Object>();
            HashSet<NodeId> hashSet4 = new HashSet<NodeId>();
            for (Object object52 : hashSet2) {
                void var24_71;
                list2 = internalBrowseResults3.findExactMatchesAsList((NodeId)object52, NodeClass.Object, Boolean.FALSE, ReferenceTypeIdentifiers.HasDescription);
                if (list2 == null || list2.size() == 0) {
                    Object var24_68 = null;
                } else if (list2.size() == 1) {
                    ExpandedNodeId expandedNodeId = list2.get(0);
                } else {
                    logger.warn("Description node {} has more than one inverse HasDescription references: {}, selecting first one", object52, list2);
                    ExpandedNodeId expandedNodeId = list2.get(0);
                }
                if (var24_71 == null) {
                    if (this.zS) {
                        logger.warn("Ignoring DataTypeDescription node {}, it does not have an inverse HasDescription reference", object52);
                        continue;
                    }
                    throw new TypeDictionaryException("Cannot initialize, node: " + object52 + " , does not have inverse HasDescription Reference");
                }
                list = var24_71;
                comparable = this.cs.getNamespaceTable().toNodeId((ExpandedNodeId)((Object)list));
                object4 = UaNodeId.fromLocal((ExpandedNodeId)((Object)list), this.cs.getNamespaceTable());
                object3 = this.zP.get(object4);
                if (object3 != null) {
                    NodeId nodeId2 = ((UaNodeId)object3).asNodeId(this.cs.getNamespaceTable());
                    hashMap6.put((NodeId)comparable, nodeId2);
                    hashSet4.add(nodeId2);
                } else {
                    hashSet3.add((NodeId)comparable);
                }
                hashMap5.put((Iterator<UaNode>)object52, (NodeId)comparable);
            }
            if (hashSet3.isEmpty()) {
                logger.debug("All EncodingsIds were found in cache");
            } else {
                logger.debug("Number Encodings to resolve: {}, ids: {}", (Object)hashSet3.size(), hashSet3);
                object2 = InternalAddressSpaceAccessHelper.internalBrowseWithNodeIds(this.zT, this.cs.getAddressSpace(), hashSet3, BrowseDirection.Inverse, Identifiers.HasEncoding, true, EnumSet.of(NodeClass.DataType), EnumSet.allOf(BrowseResultMask.class));
                logger.debug("Number of ServiceRequests needed, Browse: {}, BrowseNext: {}", (Object)((InternalBrowseResults)object2).getNumberOfBrowseRequests(), (Object)((InternalBrowseResults)object2).getNumberOfBrowseNextRequests());
                for (NodeId nodeId3 : hashSet3) {
                    list = ((InternalBrowseResults)object2).getReferences(nodeId3);
                    if (list == null || list.size() == 0) {
                        list2 = null;
                    } else if (list.size() == 1) {
                        list2 = list.get(0);
                    } else {
                        logger.warn("Encoding node {} has more than one inverse HasEncoding references: {}, selecting first one", (Object)nodeId3, list);
                        list2 = (ReferenceDescription)list.get(0);
                    }
                    if (list2 == null) {
                        if (this.zS) {
                            logger.warn("Ignoring Encoding node {}, it does not have an inverse HasEncoding reference", (Object)nodeId3);
                            continue;
                        }
                        throw new TypeDictionaryException("Cannot initialize, node: " + nodeId3 + " , does not have inverse HasEncoding Reference");
                    }
                    comparable = ((ReferenceDescription)((Object)list2)).getNodeId();
                    object4 = this.cs.getNamespaceTable().toNodeId((ExpandedNodeId)comparable);
                    hashSet4.add((NodeId)object4);
                    hashMap6.put(nodeId3, object4);
                }
            }
            logger.debug("Resolving all needed DataTypes: {}", hashSet4);
            object2 = InternalAddressSpaceAccessHelper.internalGetNodesWithNodeIds(this.zT, this.cs.getAddressSpace(), hashSet4);
            logger.debug("Number of ServiceRequests needed, Read: {}, Browse: {}, BrowseNext: {}", new Object[]{((InternalGetNodesResults)object2).getReadCalls(), ((InternalGetNodesResults)object2).getBrowseCalls(), ((InternalGetNodesResults)object2).getBrowseNextCalls()});
            object52 = ((InternalGetNodesResults)object62).getRawMap().values().iterator();
            while (object52.hasNext()) {
                UaNode uaNode = object52.next();
                list2 = (UaVariable)uaNode;
                list = (String)list2.getValue().getValue().getValue();
                comparable = (NodeId)hashMap5.get(uaNode.getNodeId());
                if (comparable == null) {
                    if (this.zS) {
                        logger.warn("Could not find Encoding node from Description node: {}, it does not have an inverse HasDescription reference", (Object)uaNode.getNodeId());
                        continue;
                    }
                    throw new TypeDictionaryException("Cannot initialize, node: " + list2 + " , does not have inverse HasDescription Reference");
                }
                object4 = (NodeId)hashMap6.get(comparable);
                if (object4 == null) {
                    if (this.zS) {
                        logger.warn("Could not find DataType node from Encoding node: {}, it does not have an inverse HasEncoding reference", (Object)comparable);
                        continue;
                    }
                    throw new TypeDictionaryException("Cannot initialize, node: " + comparable + " , does not have inverse HasEncoding Reference");
                }
                object3 = (UaDataType)((InternalGetNodesResults)object2).getNode((NodeId)object4);
                if (object3 == null) {
                    if (this.zS) {
                        logger.warn("Could not get the DataType node: {},", object4);
                        continue;
                    }
                    throw new TypeDictionaryException("Cannot initialize, could not get the DataType node: " + object4);
                }
                boolean bl3 = object3.inheritsFrom(Identifiers.Union);
                e e3 = (e)hashMap.get(UaQualifiedName.from((String)object, (String)((Object)list)));
                UaNodeId uaNodeId = UaNodeId.fromLocal(object3.getNodeId(), this.cs.getNamespaceTable());
                UaNodeId uaNodeId2 = UaNodeId.fromLocal(comparable, this.cs.getNamespaceTable());
                UaNodeId uaNodeId3 = null;
                DataTypeDictionary dataTypeDictionary = this.cs.getKnownDataTypeDictionary();
                Object object7 = object;
                if (e3 == null) {
                    if (Boolean.TRUE.equals(object3.getIsAbstract())) {
                        logger.warn("DataTypeDictionary contains Description and Encoding nodes for an abstract type {}, but does not contain dictionary XML data for it, skipping type", (Object)uaNodeId);
                        continue;
                    }
                    logger.error("DataTypeDictionary contains Description and Encoding nodes for a type {}, but does not contain dictionary XML data for it", (Object)uaNodeId);
                }
                d d2 = new d(e3, uaNodeId, uaNodeId2, uaNodeId3, dataTypeDictionary, bl3, (String)((Object)list), (String)object7);
                copyOnWriteArrayList.add(d2);
            }
        }
        HashMap<UaQualifiedName, StructureSpecification> hashMap7 = new HashMap<UaQualifiedName, StructureSpecification>();
        boolean bl4 = true;
        while (bl) {
            bl = false;
            for (d d3 : copyOnWriteArrayList) {
                try {
                    this.a(d3, hashMap7, hashMap4);
                    bl = true;
                    copyOnWriteArrayList.remove(d3);
                }
                catch (Exception exception) {}
            }
        }
        if (!copyOnWriteArrayList.isEmpty()) {
            object = new ArrayList();
            for (d d4 : copyOnWriteArrayList) {
                object.add(d4.ze);
            }
            logger.warn("Could not parse the following Structure definitions from typedictionaries: {}", object);
        }
    }

    private void a(UaNodeId uaNodeId, Set<UaDataTypeImpl> set) throws Exception {
        this.b(uaNodeId, set);
    }

    private void b(UaNodeId uaNodeId, Set<UaDataTypeImpl> set) throws ServiceResultException, UaException {
        UaDataTypeImpl uaDataTypeImpl = (UaDataTypeImpl)this.cs.getAddressSpace().getType(uaNodeId.asNodeId(this.cs.getNamespaceTable()));
        for (UaTypeImpl uaTypeImpl : this.a(uaDataTypeImpl)) {
            set.add((UaDataTypeImpl)uaTypeImpl);
        }
    }

    private void c(Set<UaDataTypeImpl> set) throws ServiceException, StatusException {
        HashMap<EncodeType, UaNodeId> hashMap;
        HashSet<NodeId> hashSet = new HashSet<NodeId>();
        for (UaDataTypeImpl object22 : set) {
            UaNodeId uaNodeId = InternalClientNodesAccessHelper.internalGetCachedEncodingsIdFromUaDataTypeImpl(object22, EncodeType.Binary);
            if (uaNodeId == null) {
                hashSet.add(object22.getNodeId());
                continue;
            }
            UaNodeId uaNodeId2 = UaNodeId.fromLocal(object22.getNodeId(), this.cs.getNamespaceTable());
            hashMap = new HashMap<EncodeType, UaNodeId>();
            hashMap.put(EncodeType.Binary, uaNodeId);
            hashMap.put(EncodeType.Xml, InternalClientNodesAccessHelper.internalGetCachedEncodingsIdFromUaDataTypeImpl(object22, EncodeType.Xml));
            hashMap.put(EncodeType.Json, InternalClientNodesAccessHelper.internalGetCachedEncodingsIdFromUaDataTypeImpl(object22, EncodeType.Json));
            this.zO.put(uaNodeId2, hashMap);
            for (Map.Entry entry : hashMap.entrySet()) {
                if (entry.getValue() == null) continue;
                this.zP.put((UaNodeId)entry.getValue(), uaNodeId2);
            }
        }
        if (hashSet.isEmpty()) {
            logger.debug("All encodings were cached as part DataType getNodes, can skip Browsing of EncodingIds");
            return;
        }
        HashSet hashSet2 = new HashSet();
        for (NodeId nodeId : hashSet) {
            StructureSpecification structureSpecification = this.cs.getEncoderContext().getStructureSpecification(UaNodeId.fromLocal(nodeId, this.cs.getNamespaceTable()));
            if (structureSpecification == null) continue;
            hashSet2.add(structureSpecification.getTypeId().asNodeId(this.cs.getNamespaceTable()));
        }
        if (!hashSet2.isEmpty()) {
            hashSet.removeAll(hashSet2);
        }
        if (hashSet.isEmpty()) {
            logger.debug("Didn't find all encodings from DataType getNodes, but missing ones were found from existing StructureSpecifications, ids: {}", (Object)hashSet2);
            return;
        }
        logger.debug("Resolving encoding ids of Structures, number of datatypes with non-cached encodings: {}, ids: {}", (Object)hashSet.size(), hashSet);
        InternalBrowseResults internalBrowseResults = InternalAddressSpaceAccessHelper.internalBrowseWithNodeIds(this.zT, this.cs.getAddressSpace(), hashSet, BrowseDirection.Forward, ReferenceTypeIdentifiers.HasEncoding, true, EnumSet.of(NodeClass.Object), BrowseResultMask.ALL);
        logger.debug("Number of ServiceRequests needed, Browse: {}, BrowseNext: {}", (Object)internalBrowseResults.getNumberOfBrowseRequests(), (Object)internalBrowseResults.getNumberOfBrowseNextRequests());
        for (NodeId nodeId : internalBrowseResults.getGoodResults().keySet()) {
            hashMap = new HashMap();
            for (ReferenceDescription referenceDescription : internalBrowseResults.getReferences(nodeId)) {
                if (referenceDescription.getNodeId() != null && !referenceDescription.getNodeId().isLocal()) continue;
                Object object = referenceDescription.getBrowseName();
                UaNodeId uaNodeId = UaNodeId.fromLocal(referenceDescription.getNodeId(), this.cs.getNamespaceTable());
                if ("Default Binary".equals(((QualifiedName)object).getName())) {
                    hashMap.put(EncodeType.Binary, uaNodeId);
                }
                if ("Default XML".equals(((QualifiedName)object).getName())) {
                    hashMap.put(EncodeType.Xml, uaNodeId);
                }
                if (!"Default JSON".equals(((QualifiedName)object).getName())) continue;
                hashMap.put(EncodeType.Json, uaNodeId);
            }
            UaNodeId uaNodeId = UaNodeId.fromLocal(nodeId, this.cs.getNamespaceTable());
            this.zO.put(uaNodeId, hashMap);
            for (Object object : hashMap.entrySet()) {
                this.zP.put((UaNodeId)object.getValue(), uaNodeId);
            }
        }
    }

    private void aQw() throws Exception {
        InternalBrowseResults internalBrowseResults;
        HashSet<NodeId> hashSet = new HashSet<NodeId>();
        hashSet.addAll(InternalReferenceTypeIdentifiersHelper.ALL_REFERENCETYPE_IDENTIFIERS);
        hashSet.addAll(InternalDataTypeIdentifiersHelper.ALL_DATATYPE_IDENTIFIERS);
        hashSet.addAll(InternalVariableTypeIdentifiersHelper.ALL_VARIABLETYPE_IDENTIFIERS);
        hashSet.addAll(InternalObjectTypeIdentifiersHelper.ALL_OBJECTTYPE_IDENTIFIERS);
        logger.debug("Resolving all types, starting ids size: {}, ids: {}", (Object)hashSet.size(), hashSet);
        HashSet<NodeId> hashSet2 = new HashSet<NodeId>();
        hashSet2.addAll(hashSet);
        HashSet<NodeId> hashSet3 = new HashSet<NodeId>();
        ArrayList<InternalBrowseResults> arrayList = new ArrayList<InternalBrowseResults>();
        while (!hashSet2.isEmpty()) {
            logger.trace("Unvisited count: {}, nodes: {}", (Object)hashSet2.size(), hashSet2);
            hashSet3.addAll(hashSet2);
            internalBrowseResults = InternalAddressSpaceAccessHelper.internalBrowseAllDataWithNodeIds(this.zT, this.cs.getAddressSpace(), hashSet2);
            arrayList.add(internalBrowseResults);
            hashSet2.clear();
            for (List list : internalBrowseResults.asRawMap().values()) {
                for (ReferenceDescription referenceDescription : list) {
                    NodeId nodeId;
                    if (referenceDescription.getNodeId() == null || !referenceDescription.getNodeId().isLocal() || !Boolean.TRUE.equals(referenceDescription.getIsForward()) || !ReferenceTypeIdentifiers.HasSubtype.equals(referenceDescription.getReferenceTypeId()) || hashSet3.contains(nodeId = this.cs.getNamespaceTable().toNodeId(referenceDescription.getNodeId()))) continue;
                    hashSet2.add(nodeId);
                }
            }
        }
        logger.debug("Number of Types for getNodes: {}, initialset: {}", (Object)hashSet3.size(), hashSet);
        internalBrowseResults = InternalBrowseResults.mergeOf(arrayList);
        logger.debug("Number of ServiceRequests needed, Browse: {}, BrowseNext: {}", (Object)internalBrowseResults.getNumberOfBrowseRequests(), (Object)internalBrowseResults.getNumberOfBrowseNextRequests());
        InternalGetNodesResults internalGetNodesResults = InternalAddressSpaceAccessHelper.internalGetNodesWithNodeIdsAndPreBrowseData(this.zT, this.cs.getAddressSpace(), internalBrowseResults.getGoodResults().keySet(), internalBrowseResults);
        logger.debug("Number of Types found: {}, types : {}", (Object)internalGetNodesResults.getRawMap().keySet().size(), internalGetNodesResults.getRawMap().keySet());
        logger.debug("Number of ServiceRequests needed, Read: {}, Browse: {}, BrowseNext: {}", new Object[]{internalGetNodesResults.getReadCalls(), internalGetNodesResults.getBrowseCalls(), internalGetNodesResults.getBrowseNextCalls()});
    }

    private Map<EncodeType, UaNodeId> a(UaDataType uaDataType) {
        UaNodeId uaNodeId = UaNodeId.fromLocal(uaDataType.getNodeId(), this.cs.getNamespaceTable());
        Map<EncodeType, UaNodeId> map = this.zO.get(uaNodeId);
        if (map != null) {
            return map;
        }
        UaReference[] uaReferenceArray = uaDataType.getReferences(Identifiers.HasEncoding, false);
        HashMap<EncodeType, UaNodeId> hashMap = new HashMap<EncodeType, UaNodeId>();
        for (UaReference uaReference : uaReferenceArray) {
            UaNode uaNode = uaReference.getOppositeNode(uaDataType);
            if ("Default Binary".equals(uaNode.getBrowseName().getName())) {
                hashMap.put(EncodeType.Binary, UaNodeId.fromLocal(uaNode.getNodeId(), this.cs.getNamespaceTable()));
            }
            if ("Default XML".equals(uaNode.getBrowseName().getName())) {
                hashMap.put(EncodeType.Xml, UaNodeId.fromLocal(uaNode.getNodeId(), this.cs.getNamespaceTable()));
            }
            if (!"Default JSON".equals(uaNode.getBrowseName().getName())) continue;
            hashMap.put(EncodeType.Json, UaNodeId.fromLocal(uaNode.getNodeId(), this.cs.getNamespaceTable()));
        }
        this.zO.put(uaNodeId, hashMap);
        for (Map.Entry entry : hashMap.entrySet()) {
            this.zP.put((UaNodeId)entry.getValue(), uaNodeId);
        }
        return hashMap;
    }

    private Set<UaNodeId> aQx() throws Exception {
        logger.debug("Resolving all Enumeration DataTypes");
        HashSet<UaDataTypeImpl> hashSet = new HashSet<UaDataTypeImpl>();
        HashSet<UaNodeId> hashSet2 = new HashSet<UaNodeId>();
        HashSet<UaNodeId> hashSet3 = new HashSet<UaNodeId>();
        this.a(UaNodeId.fromStandard(Identifiers.Enumeration), hashSet);
        logger.debug("Number of Enumerations: {}", (Object)hashSet.size());
        for (UaDataTypeImpl uaDataTypeImpl : hashSet) {
            if (uaDataTypeImpl.getIsAbstract().booleanValue()) continue;
            UaNodeId uaNodeId = UaNodeId.fromLocal(uaDataTypeImpl.getNodeId(), this.cs.getNamespaceTable());
            EnumerationSpecification enumerationSpecification = this.cs.getEncoderContext().getEnumerationSpecification(uaNodeId);
            if (enumerationSpecification == null && uaDataTypeImpl.getDataTypeDefinition() != null) {
                enumerationSpecification = this.a(uaNodeId);
            }
            if (enumerationSpecification == null) {
                hashSet3.add(uaNodeId);
                continue;
            }
            hashSet2.add(uaNodeId);
        }
        logger.debug("Unknown Enumerations (via DataTypeDefinition): {}", hashSet3);
        logger.debug("Known Enumerations (via DataTypeDefinition): {}", hashSet2);
        return hashSet3;
    }

    private Set<UaNodeId> aQy() throws Exception {
        logger.debug("Resolving all Structure DataTypes");
        HashSet<UaDataTypeImpl> hashSet = new HashSet<UaDataTypeImpl>();
        this.a(UaNodeId.fromStandard(Identifiers.Structure), hashSet);
        this.c(hashSet);
        HashSet<UaNodeId> hashSet2 = new HashSet<UaNodeId>();
        HashSet<UaNodeId> hashSet3 = new HashSet<UaNodeId>();
        for (UaDataTypeImpl uaDataTypeImpl : hashSet) {
            if (uaDataTypeImpl.getIsAbstract().booleanValue()) continue;
            UaNodeId uaNodeId = UaNodeId.fromLocal(uaDataTypeImpl.getNodeId(), this.cs.getNamespaceTable());
            StructureSpecification structureSpecification = this.cs.getEncoderContext().getStructureSpecification(uaNodeId);
            if (structureSpecification == null && uaDataTypeImpl.getDataTypeDefinition() != null) {
                structureSpecification = this.b(uaNodeId);
            }
            if (structureSpecification == null) {
                hashSet3.add(uaNodeId);
                continue;
            }
            hashSet2.add(uaNodeId);
        }
        logger.debug("Unknown Structures (via DataTypeDefinition): {}", hashSet3);
        logger.debug("Known Structures (via DataTypeDefinition): {}", hashSet2);
        return hashSet3;
    }

    private StructureSpecification b(UaNodeId uaNodeId) {
        try {
            UaNode uaNode = this.cs.getAddressSpace().getNode(uaNodeId.asNodeId(this.cs.getNamespaceTable()));
            if (uaNode instanceof UaDataType) {
                return this.q(uaNode);
            }
            UaReference uaReference = uaNode.getReference(Identifiers.HasEncoding, true);
            if (uaReference == null) {
                logger.error("Could not find reverse HasEncoding reference from node {}", (Object)uaNodeId);
                return null;
            }
            if ((uaNode = uaReference.getOppositeNode(uaNode)) instanceof UaDataType) {
                return this.q(uaNode);
            }
            logger.error("Target of reverse HasEncoding from {} was not a DataType node", (Object)uaNodeId);
            return null;
        }
        catch (Exception exception) {
            logger.debug("Could not resolve id {} to StructureSpecification via DataTypeDefinition Attribute", (Object)uaNodeId, (Object)exception);
            return null;
        }
    }

    StructureSpecification a(d d2, Map<UaQualifiedName, StructureSpecification> map, Map<UaQualifiedName, UaNodeId> map2) throws Exception {
        e e2 = d2.zy;
        UaNodeId uaNodeId = d2.ze;
        UaNodeId uaNodeId2 = d2.zz;
        UaNodeId uaNodeId3 = d2.zA;
        DataTypeDictionary dataTypeDictionary = d2.zB;
        boolean bl = d2.zC;
        ArrayList<FieldSpecification> arrayList = new ArrayList<FieldSpecification>();
        StructureSpecification.StructureType structureType = StructureSpecification.StructureType.NORMAL;
        List<c> list = e2.getFields();
        if (bl) {
            list = list.subList(1, list.size());
        }
        for (c c2 : list) {
            if (this.zR && NamespaceTable.OPCUA_NAMESPACE.equals(c2.aQu()) && "String".equals(c2.aQt())) {
                c2.G("CharArray");
            }
            Class<Object> clazz = dataTypeDictionary.javaClassForType(c2.aQu(), c2.aQt());
            UaNodeId uaNodeId4 = dataTypeDictionary.dataTypeIdForType(c2.aQu(), c2.aQt());
            DynamicStructureSerializer dynamicStructureSerializer = null;
            EnumerationSpecification enumerationSpecification = null;
            if (!NamespaceTable.OPCUA_NAMESPACE.equals(c2.aQu()) && !"Bit".equals(c2.aQt()) && clazz == null) {
                UaQualifiedName uaQualifiedName = UaQualifiedName.from(c2.aQu(), c2.aQt());
                StructureSpecification structureSpecification = map.get(uaQualifiedName);
                if (structureSpecification == null) {
                    EnumerationSpecification enumerationSpecification2 = this.zN.get(uaQualifiedName);
                    if (enumerationSpecification2 == null) {
                        throw new DecodingException("Unknown type: " + c2.aQu() + ":" + c2.aQt());
                    }
                    enumerationSpecification = enumerationSpecification2;
                    clazz = DynamicEnumeration.class;
                    UaQualifiedName uaQualifiedName2 = UaQualifiedName.from(c2.aQu(), c2.aQt());
                    uaNodeId4 = map2.get(uaQualifiedName2);
                } else {
                    dynamicStructureSerializer = this.c(structureSpecification);
                    clazz = DynamicStructure.class;
                    uaNodeId4 = structureSpecification.getTypeId();
                }
            }
            if (clazz == null) continue;
            boolean bl2 = false;
            int n2 = -1;
            if (c2.aQq() != null && !c2.aQq().isEmpty()) {
                bl2 = true;
                n2 = 1;
                clazz = Array.newInstance(clazz, 0).getClass();
            }
            if (bl2) {
                arrayList.remove(arrayList.size() - 1);
            }
            if (c2.aQs() != null && !c2.aQs().isEmpty()) {
                arrayList.add(FieldSpecification.builder().setName(c2.getFieldName()).setJavaClass(clazz).setIsOptional(true).setSerializer(dynamicStructureSerializer).setValueRank(n2).setEnumerationSpecification(enumerationSpecification).setDataTypeId(uaNodeId4).build());
                structureType = StructureSpecification.StructureType.OPTIONAL;
                continue;
            }
            arrayList.add(FieldSpecification.builder().setName(c2.getFieldName()).setJavaClass(clazz).setIsOptional(false).setSerializer(dynamicStructureSerializer).setValueRank(n2).setEnumerationSpecification(enumerationSpecification).setDataTypeId(uaNodeId4).build());
        }
        if (bl) {
            structureType = StructureSpecification.StructureType.UNION;
        }
        StructureSpecification structureSpecification = StructureSpecification.builder().setName(e2.aQv()).setTypeId(uaNodeId).setBinaryEncodeId(uaNodeId2).setXmlEncodeId(uaNodeId3).setFields(arrayList).setStructureType(structureType).build();
        this.addStructureSpecification(structureSpecification);
        map.put(UaQualifiedName.from(d2.zD, d2.typeName), structureSpecification);
        return structureSpecification;
    }

    Set<UaTypeImpl> a(UaTypeImpl uaTypeImpl) throws UaException {
        HashSet<UaTypeImpl> hashSet = new HashSet<UaTypeImpl>();
        CopyOnWriteArraySet<NodeId> copyOnWriteArraySet = new CopyOnWriteArraySet<NodeId>();
        CopyOnWriteArraySet<NodeId> copyOnWriteArraySet2 = new CopyOnWriteArraySet<NodeId>();
        copyOnWriteArraySet.add(uaTypeImpl.getNodeId());
        while (!copyOnWriteArraySet.isEmpty()) {
            for (NodeId nodeId : copyOnWriteArraySet) {
                UaTypeImpl uaTypeImpl2 = (UaTypeImpl)this.cs.getAddressSpace().getType(nodeId);
                Set<UaTypeImpl> set = this.b(uaTypeImpl2);
                copyOnWriteArraySet.remove(nodeId);
                copyOnWriteArraySet2.add(nodeId);
                for (UaTypeImpl uaTypeImpl3 : set) {
                    if (copyOnWriteArraySet2.contains(uaTypeImpl3.getNodeId())) continue;
                    copyOnWriteArraySet.add(uaTypeImpl3.getNodeId());
                    hashSet.add(uaTypeImpl3);
                }
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    Set<UaTypeImpl> b(UaTypeImpl uaTypeImpl) {
        HashSet<UaTypeImpl> hashSet = new HashSet<UaTypeImpl>();
        for (UaReference uaReference : uaTypeImpl.getReferences(Identifiers.HasSubtype, false)) {
            hashSet.add((UaTypeImpl)uaReference.getOppositeNode(uaTypeImpl));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    Class<?> b(UaDataType uaDataType) {
        Class<?> clazz = null;
        UaDataType uaDataType2 = uaDataType;
        while (clazz == null) {
            try {
                uaDataType2 = (UaDataType)uaDataType2.getSuperType();
                if (uaDataType2 == null) break;
                clazz = uaDataType2.getJavaClass();
            }
            catch (ClassCastException classCastException) {}
        }
        if (clazz == null) {
            throw new RuntimeException("Cannot resolve Java Class for DataType node: " + uaDataType);
        }
        return clazz;
    }
}

