/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.typedictionary;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IDecoder;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.IEncoder;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.DynamicStructureSerializer;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StructureSpecification {
    public static final StructureSerializerSupplier DYNAMIC_STRUCTURE_SERIALIZER_SUPPLIER = new StructureSerializerSupplier(){

        public DynamicStructureSerializer a(StructureSpecification structureSpecification, EncoderContext encoderContext) {
            return new DynamicStructureSerializer(encoderContext.getEncodeableSerializer(), structureSpecification);
        }

        @Override
        public /* synthetic */ StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
            return this.a(structureSpecification, encoderContext);
        }
    };
    private final List<FieldSpecification> fields = new ArrayList<FieldSpecification>();
    private final UaNodeId zz;
    private final UaNodeId ze;
    private final UaNodeId zA;
    private final UaNodeId zE;
    private final String name;
    private final StructureType zF;
    private final StructureSerializerSupplier zG;
    private final StructureBuilderSupplier zH;

    public static Builder builder() {
        return new Builder();
    }

    private StructureSpecification(String string, UaNodeId uaNodeId, UaNodeId uaNodeId2, UaNodeId uaNodeId3, UaNodeId uaNodeId4, List<FieldSpecification> list, StructureType structureType, StructureSerializerSupplier structureSerializerSupplier, StructureBuilderSupplier structureBuilderSupplier) {
        for (FieldSpecification fieldSpecification : list) {
            this.fields.add(fieldSpecification);
        }
        this.zz = uaNodeId2;
        this.ze = uaNodeId;
        this.zA = uaNodeId3;
        this.zE = uaNodeId4;
        this.name = string;
        this.zF = structureType;
        this.zG = structureSerializerSupplier;
        this.zH = structureBuilderSupplier;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StructureSpecification structureSpecification = (StructureSpecification)object;
        return !(this.ze == null ? structureSpecification.ze != null : !this.ze.equals(structureSpecification.ze));
    }

    public UaNodeId getBinaryEncodeId() {
        return this.zz;
    }

    public Structure getEncodeable(IDecoder iDecoder) throws DecodingException {
        IEncodeable iEncodeable = this.zG.get(this, iDecoder.getEncoderContext()).getEncodeable(iDecoder);
        return (Structure)iEncodeable;
    }

    public FieldSpecification getField(String string) {
        for (FieldSpecification fieldSpecification : this.fields) {
            if (!string.equals(fieldSpecification.getName())) continue;
            return fieldSpecification;
        }
        throw new IllegalArgumentException("No field named: " + string + " in StructureSpecification: " + this.toString());
    }

    public List<FieldSpecification> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public UaNodeId getJsonEncodeId() {
        return this.zE;
    }

    public String getName() {
        return this.name;
    }

    public StructureType getStructureType() {
        return this.zF;
    }

    public UaNodeId getTypeId() {
        return this.ze;
    }

    public UaNodeId getXmlEncodeId() {
        return this.zA;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.ze == null ? 0 : this.ze.hashCode());
        return n3;
    }

    public boolean isType(ExpandedNodeId expandedNodeId) {
        try {
            UaNodeId uaNodeId = UaNodeId.fromLocal(expandedNodeId);
            if (this.zz.equals(uaNodeId) || this.ze.equals(uaNodeId)) {
                return true;
            }
            if (this.zA == null) {
                return false;
            }
            return this.zA.equals(uaNodeId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public void putEncodeable(Structure structure, IEncoder iEncoder) throws EncodingException {
        this.zG.get(this, iEncoder.getEncoderContext()).putEncodeable(structure, iEncoder);
    }

    public Builder toBuilder() {
        Builder builder = StructureSpecification.builder();
        builder.setBinaryEncodeId(this.zz);
        builder.setBuilderSupplier(this.zH);
        for (FieldSpecification fieldSpecification : this.getFields()) {
            builder.addField(fieldSpecification);
        }
        builder.setJsonEncodeId(this.zE);
        builder.setName(this.name);
        builder.setSerializerSupplier(this.zG);
        builder.setStructureType(this.zF);
        builder.setTypeId(this.ze);
        builder.setXmlEncodeId(this.zA);
        return builder;
    }

    public String toString() {
        return "StructureSpecification [name=" + this.name + ", typeId=" + this.ze + ", structureType=" + (Object)((Object)this.zF) + ", binaryEncodeId=" + this.zz + ", xmlEncodeId=" + this.zA + ", jsonEncodeId=" + this.zE + ", fields=" + this.fields + ", serializerSupplier=" + this.zG + "]";
    }

    public Structure.Builder toStructureBuilder() {
        if (this.zH == null) {
            return DynamicStructure.builder(this);
        }
        return this.zH.get();
    }

    public static enum StructureType {
        NORMAL,
        OPTIONAL,
        UNION;

    }

    public static interface StructureSerializerSupplier {
        public StructureSerializer get(StructureSpecification var1, EncoderContext var2);
    }

    public static interface StructureBuilderSupplier {
        public Structure.Builder get();
    }

    public static class Builder {
        private List<FieldSpecification> fields = new ArrayList<FieldSpecification>();
        private UaNodeId zz = null;
        private UaNodeId ze = null;
        private UaNodeId zA = null;
        private UaNodeId zE = null;
        private String name = null;
        private StructureType zF = StructureType.NORMAL;
        private StructureSerializerSupplier zG = DYNAMIC_STRUCTURE_SERIALIZER_SUPPLIER;
        private StructureBuilderSupplier zH = null;

        private Builder() {
        }

        public Builder addField(FieldSpecification fieldSpecification) {
            this.fields.add(fieldSpecification);
            return this;
        }

        public StructureSpecification build() {
            return new StructureSpecification(this.name, this.ze, this.zz, this.zA, this.zE, this.fields, this.zF, this.zG, this.zH);
        }

        public Builder setBinaryEncodeId(UaNodeId uaNodeId) {
            this.zz = uaNodeId;
            return this;
        }

        public Builder setBuilderSupplier(StructureBuilderSupplier structureBuilderSupplier) {
            this.zH = structureBuilderSupplier;
            return this;
        }

        public Builder setFields(List<FieldSpecification> list) {
            this.fields.clear();
            this.fields.addAll(list);
            return this;
        }

        public Builder setJsonEncodeId(UaNodeId uaNodeId) {
            this.zE = uaNodeId;
            return this;
        }

        public Builder setName(String string) {
            this.name = string;
            return this;
        }

        public Builder setSerializerSupplier(StructureSerializerSupplier structureSerializerSupplier) {
            this.zG = structureSerializerSupplier == null ? DYNAMIC_STRUCTURE_SERIALIZER_SUPPLIER : structureSerializerSupplier;
            return this;
        }

        public Builder setStructureType(StructureType structureType) {
            this.zF = structureType == null ? StructureType.NORMAL : structureType;
            return this;
        }

        public Builder setTypeId(UaNodeId uaNodeId) {
            this.ze = uaNodeId;
            return this;
        }

        public Builder setXmlEncodeId(UaNodeId uaNodeId) {
            this.zA = uaNodeId;
            return this;
        }
    }
}

