/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryWriteable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class OutputStreamWriteable
implements IBinaryWriteable {
    ByteOrder yF = ByteOrder.nativeOrder();
    OutputStream out;

    public OutputStreamWriteable(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.out = outputStream;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public OutputStream getStream() {
        return this.out;
    }

    @Override
    public ByteOrder order() {
        return this.yF;
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.yF = byteOrder;
    }

    @Override
    public void put(byte by) throws IOException {
        this.r(by);
    }

    @Override
    public void put(byte[] byArray) throws IOException {
        this.out.write(byArray);
    }

    @Override
    public void put(byte[] byArray, int n2, int n3) throws IOException {
        this.out.write(byArray, n2, n3);
    }

    @Override
    public void put(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            this.put(byArray, byteBuffer.position(), byteBuffer.remaining());
            byteBuffer.position(byteBuffer.limit());
        } else {
            while (byteBuffer.hasRemaining()) {
                this.r(byteBuffer.get());
            }
        }
    }

    @Override
    public void put(ByteBuffer byteBuffer, int n2) throws IOException {
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            this.put(byArray, byteBuffer.position(), n2);
            byteBuffer.position(n2);
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.r(byteBuffer.get());
            }
        }
    }

    @Override
    public void putDouble(double d2) throws IOException {
        this.putLong(Double.doubleToLongBits(d2));
    }

    @Override
    public void putFloat(float f2) throws IOException {
        this.putInt(Float.floatToIntBits(f2));
    }

    @Override
    public void putInt(int n2) throws IOException {
        if (this.yF == ByteOrder.BIG_ENDIAN) {
            this.r(n2 >> 24);
            this.r(n2 >> 16);
            this.r(n2 >> 8);
            this.r(n2);
        } else {
            this.r(n2);
            this.r(n2 >> 8);
            this.r(n2 >> 16);
            this.r(n2 >> 24);
        }
    }

    @Override
    public void putLong(long l2) throws IOException {
        if (this.yF == ByteOrder.BIG_ENDIAN) {
            this.r((int)(l2 >> 56));
            this.r((int)(l2 >> 48));
            this.r((int)(l2 >> 40));
            this.r((int)(l2 >> 32));
            this.r((int)(l2 >> 24));
            this.r((int)(l2 >> 16));
            this.r((int)(l2 >> 8));
            this.r((int)l2);
        } else {
            this.r((int)l2);
            this.r((int)(l2 >> 8));
            this.r((int)(l2 >> 16));
            this.r((int)(l2 >> 24));
            this.r((int)(l2 >> 32));
            this.r((int)(l2 >> 40));
            this.r((int)(l2 >> 48));
            this.r((int)(l2 >> 56));
        }
    }

    @Override
    public void putShort(short s2) throws IOException {
        if (this.yF == ByteOrder.BIG_ENDIAN) {
            this.r(s2 >> 8);
            this.r(s2);
        } else {
            this.r(s2);
            this.r(s2 >> 8);
        }
    }

    void r(int n2) throws IOException {
        this.out.write(n2);
    }
}

