/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.utils.bytebuffer.ByteQueue;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryWriteable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferArrayWriteable
implements IBinaryWriteable {
    ByteQueue xX;
    ByteBuffer yD = ByteBuffer.allocate(8);

    public ByteBufferArrayWriteable(ByteBuffer[] byteBufferArray) {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException("null");
        }
        this.xX = new ByteQueue();
        this.yD.order(this.xX.order());
        for (ByteBuffer byteBuffer : byteBufferArray) {
            this.xX.offer(byteBuffer);
        }
    }

    public ByteBufferArrayWriteable(ByteQueue byteQueue) {
        if (byteQueue == null) {
            throw new IllegalArgumentException("null");
        }
        this.xX = byteQueue;
        this.yD.order(byteQueue.order());
    }

    @Override
    public void flush() {
    }

    @Override
    public ByteOrder order() {
        return this.xX.order();
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.yD.order(byteOrder);
        this.xX.order(byteOrder);
    }

    @Override
    public void put(byte by) throws IOException {
        this.xX.getWriteChunk().put(by);
    }

    @Override
    public void put(byte[] byArray) throws IOException {
        this.xX.put(byArray);
    }

    @Override
    public void put(byte[] byArray, int n2, int n3) throws IOException {
        this.xX.put(byArray, n2, n3);
    }

    @Override
    public void put(ByteBuffer byteBuffer) throws IOException {
        this.xX.put(byteBuffer);
    }

    @Override
    public void put(ByteBuffer byteBuffer, int n2) throws IOException {
        this.xX.put(byteBuffer, n2);
    }

    @Override
    public void putDouble(double d2) throws IOException {
        if (this.xX.getWriteChunk().remaining() > 8) {
            this.xX.getWriteChunk().putDouble(d2);
        } else {
            this.yD.rewind();
            this.yD.putDouble(d2);
            this.yD.rewind();
            this.xX.put(this.yD, 8);
        }
    }

    @Override
    public void putFloat(float f2) throws IOException {
        if (this.xX.getWriteChunk().remaining() > 4) {
            this.xX.getWriteChunk().putFloat(f2);
        } else {
            this.yD.rewind();
            this.yD.putFloat(f2);
            this.yD.rewind();
            this.xX.put(this.yD, 4);
        }
    }

    @Override
    public void putInt(int n2) throws IOException {
        if (this.xX.getWriteChunk().remaining() > 4) {
            this.xX.getWriteChunk().putInt(n2);
        } else {
            this.yD.rewind();
            this.yD.putInt(n2);
            this.yD.rewind();
            this.xX.put(this.yD, 4);
        }
    }

    @Override
    public void putLong(long l2) throws IOException {
        if (this.xX.getWriteChunk().remaining() > 8) {
            this.xX.getWriteChunk().putLong(l2);
        } else {
            this.yD.rewind();
            this.yD.putLong(l2);
            this.yD.rewind();
            this.xX.put(this.yD, 8);
        }
    }

    @Override
    public void putShort(short s2) throws IOException {
        if (this.xX.getWriteChunk().remaining() > 2) {
            this.xX.getWriteChunk().putShort(s2);
        } else {
            this.yD.rewind();
            this.yD.putShort(s2);
            this.yD.rewind();
            this.xX.put(this.yD, 2);
        }
    }
}

