/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.asyncsocket;

import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSelector;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenableServerSocketChannel {
    static Logger logger = LoggerFactory.getLogger(ListenableServerSocketChannel.class);
    AtomicReference<ServerSocketChannel> ef = new AtomicReference<Object>(null);
    AsyncSelector yg;
    Executor executor;
    volatile ServerSocketAcceptable yh;
    boolean yi = false;
    boolean yj = false;
    Runnable yk;
    AsyncSelector.SelectListener yl = new AsyncSelector.SelectListener(){

        @Override
        public void onSelected(AsyncSelector asyncSelector, SelectableChannel selectableChannel, int n2, int n3) {
            Runnable runnable;
            if ((n2 & 0x10) != 0 && (runnable = ListenableServerSocketChannel.this.yk) != null) {
                if (ListenableServerSocketChannel.this.executor == null) {
                    ListenableServerSocketChannel.this.yi = true;
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                } else {
                    ListenableServerSocketChannel.this.yi = true;
                    ListenableServerSocketChannel.this.executor.execute(runnable);
                }
            }
            asyncSelector.interestOps(selectableChannel, ListenableServerSocketChannel.this.getInterestOps());
        }
    };

    public ListenableServerSocketChannel(ServerSocketChannel serverSocketChannel, Executor executor) throws IOException {
        this(serverSocketChannel, executor, new AsyncSelector(Selector.open()));
        this.yj = true;
    }

    public ListenableServerSocketChannel(ServerSocketChannel serverSocketChannel, Executor executor, AsyncSelector asyncSelector) throws ClosedChannelException {
        if (serverSocketChannel.isBlocking()) {
            throw new IllegalArgumentException("channel arg must be in non-blocking mode. (SocketChannel.configureBlocking(false))");
        }
        if (asyncSelector == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.executor = executor;
        this.ef.set(serverSocketChannel);
        this.yg = asyncSelector;
        asyncSelector.register(serverSocketChannel, 0, this.yl);
    }

    public void bind(SocketAddress socketAddress, int n2) throws IOException {
        ServerSocketChannel serverSocketChannel = this.getChannel();
        serverSocketChannel.socket().bind(socketAddress, n2);
        this.yg.register(serverSocketChannel, 16, this.yl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ServerSocketChannel serverSocketChannel = this.ef.getAndSet(null);
        if (serverSocketChannel == null) {
            return;
        }
        this.yg.unregister(serverSocketChannel);
        if (this.yj) {
            this.yg.close();
        }
        serverSocketChannel.close();
        logger.debug("closed");
    }

    public ServerSocketAcceptable getAcceptableListener() {
        return this.yh;
    }

    public ServerSocketChannel getChannel() {
        return this.ef.get();
    }

    public AsyncSelector getSelectorThread() {
        return this.yg;
    }

    public void setAcceptableListener(final ServerSocketAcceptable serverSocketAcceptable) {
        this.yh = serverSocketAcceptable;
        this.yk = serverSocketAcceptable != null ? new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    serverSocketAcceptable.onConnectionAcceptable(ListenableServerSocketChannel.this);
                }
                finally {
                    ListenableServerSocketChannel.this.yi = false;
                    ListenableServerSocketChannel.this.aQg();
                }
            }
        } : null;
        this.aQg();
    }

    int getInterestOps() {
        ServerSocketChannel serverSocketChannel = this.ef.get();
        if (serverSocketChannel == null || !serverSocketChannel.isOpen() || !serverSocketChannel.isRegistered()) {
            return 0;
        }
        int n2 = 0;
        if (this.yh != null && !this.yi) {
            n2 |= 0x10;
        }
        return n2;
    }

    void aQg() {
        ServerSocketChannel serverSocketChannel = this.ef.get();
        if (serverSocketChannel != null) {
            this.yg.interestOps(serverSocketChannel, this.getInterestOps());
        }
    }

    public static interface ServerSocketAcceptable {
        public void onConnectionAcceptable(ListenableServerSocketChannel var1);
    }
}

