/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.asyncsocket;

import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.State;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AsyncSelector
implements Runnable {
    private static final EnumSet<a> xA = EnumSet.of(a.xE);
    State<a> xB = new State<a>(a.xE);
    Selector xC;
    Map<SelectionKey, SelectListener> map = new ConcurrentHashMap<SelectionKey, SelectListener>();
    Thread thread;
    Object xD = new Object();

    public AsyncSelector() throws IOException {
        this(Selector.open());
    }

    public AsyncSelector(Selector selector) throws IOException {
        this.xC = selector;
        this.thread = new Thread((Runnable)this, StackUtils.SELECTOR_NAME_PATTERN);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void close() throws IOException {
        this.xC.close();
        try {
            this.xB.setState(a.xE);
            this.xC.wakeup();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Selector getSelector() {
        return this.xC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interestOps(SelectableChannel selectableChannel, int n2) throws CancelledKeyException {
        if (selectableChannel != null) {
            SelectionKey selectionKey = selectableChannel.keyFor(this.xC);
            if (selectionKey == null) {
                throw new IllegalArgumentException("Key is not registered to channel");
            }
            if (!selectionKey.isValid()) {
                return;
            }
            SelectableChannel selectableChannel2 = selectableChannel;
            synchronized (selectableChannel2) {
                int n3 = selectionKey.interestOps();
                switch (n2) {
                    case -9: 
                    case -5: 
                    case -2: {
                        n3 &= n2;
                        break;
                    }
                    default: {
                        n3 |= n2;
                    }
                }
                if (n3 != selectionKey.interestOps()) {
                    selectionKey.interestOps(n3);
                    this.xC.wakeup();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(SelectableChannel selectableChannel, int n2, SelectListener selectListener) throws ClosedChannelException {
        Object object = this.xD;
        synchronized (object) {
            this.disable();
            try {
                SelectionKey selectionKey = selectableChannel.register(this.xC, n2);
                this.map.put(selectionKey, selectListener);
            }
            finally {
                this.enable();
            }
        }
    }

    @Override
    public void run() {
        try {
            while (this.xC.isOpen()) {
                this.xB.waitForStateUninterruptibly(xA);
                this.xC.select(1000L);
                Set<SelectionKey> set = this.xC.selectedKeys();
                for (SelectionKey selectionKey : set) {
                    try {
                        selectionKey.interestOps(0);
                    }
                    catch (CancelledKeyException cancelledKeyException) {}
                }
                for (SelectionKey selectionKey : set) {
                    try {
                        Integer n2 = selectionKey.interestOps();
                        if (n2 == null) continue;
                        int n3 = selectionKey.readyOps();
                        SelectListener selectListener = this.map.get(selectionKey);
                        if (selectListener == null) continue;
                        selectListener.onSelected(this, selectionKey.channel(), n3, n2);
                    }
                    catch (CancelledKeyException cancelledKeyException) {}
                }
                set.clear();
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new Error(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(SelectableChannel selectableChannel) {
        SelectionKey selectionKey = selectableChannel.keyFor(this.xC);
        if (selectionKey == null || !this.map.containsKey(selectionKey)) {
            return;
        }
        Object object = this.xD;
        synchronized (object) {
            this.disable();
            try {
                selectionKey.cancel();
                this.map.remove(selectionKey);
            }
            finally {
                this.enable();
            }
        }
    }

    private void disable() {
        this.xB.setState(a.xF);
        this.xC.wakeup();
    }

    private void enable() {
        this.xB.setState(a.xE);
    }

    String o(int n2) {
        String string = "[";
        if ((n2 & 1) != 0) {
            string = string + "read";
        }
        if ((n2 & 8) != 0) {
            string = string + "connect";
        }
        if ((n2 & 4) != 0) {
            string = string + "write";
        }
        if ((n2 & 0x10) != 0) {
            string = string + "accept";
        }
        return string + "]";
    }

    private static enum a {
        xE,
        xF;

    }

    public static interface SelectListener {
        public void onSelected(AsyncSelector var1, SelectableChannel var2, int var3, int var4);
    }
}

