/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.EncodeableSerializer;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.binary.EncodeableReflectionSerializer;
import com.prosysopc.ua.stack.encoding.binary.IEncodeableSerializer;
import com.prosysopc.ua.stack.encoding.utils.EncodeableDesc;
import com.prosysopc.ua.stack.encoding.utils.EncodeableDescTable;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.ResultListener;
import com.prosysopc.ua.stack.transport.tcp.impl.Acknowledge;
import com.prosysopc.ua.stack.transport.tcp.impl.ErrorMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.Hello;
import com.prosysopc.ua.stack.transport.tcp.impl.ReverseHello;
import com.prosysopc.ua.stack.utils.TimerUtil;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSelector;
import java.io.EOFException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.util.Random;
import java.util.Timer;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackUtils {
    private static Logger logger = LoggerFactory.getLogger(StackUtils.class);
    private static int xi = 64;
    private static long xj = 3L;
    private static final int xk = Runtime.getRuntime().availableProcessors();
    private static Executor xl;
    private static Executor xm;
    private static ExecutorService xn;
    private static AsyncSelector xo;
    public static Random RANDOM;
    public static final UnsignedInteger CLIENT_TOKEN_LIFETIME_REQUEST;
    public static final UnsignedInteger SERVER_GIVEN_TOKEN_LIFETIME;
    public static final int TCP_PROTOCOL_VERSION = 0;
    public static String NON_BLOCKING_WORK_EXECUTOR_NAME_PATTERN;
    public static String BLOCKING_WORK_EXECUTOR_NAME_PATTERN;
    public static String UA_TIMER_NAME_PATTERN;
    public static String SELECTOR_NAME_PATTERN;
    private static IEncodeableSerializer xp;
    private static volatile Thread.UncaughtExceptionHandler xq;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean barrierWait(AsyncResult<?>[] asyncResultArray, long l2) throws InterruptedException {
        final Semaphore semaphore = new Semaphore(0);
        ResultListener resultListener = new ResultListener(){

            public void onCompleted(Object object) {
                semaphore.release();
            }

            @Override
            public void onError(ServiceResultException serviceResultException) {
                semaphore.release();
            }
        };
        AsyncResult<?>[] asyncResultArray2 = asyncResultArray;
        int n2 = asyncResultArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            AsyncResult<?> asyncResult;
            AsyncResult<?> asyncResult2 = asyncResult = asyncResultArray2[i2];
            synchronized (asyncResult2) {
                if (asyncResult.getStatus() != AsyncResult.AsyncResultStatus.Waiting) {
                    semaphore.release();
                } else {
                    asyncResult.setListener(resultListener);
                }
                continue;
            }
        }
        return semaphore.tryAcquire(asyncResultArray.length, l2, TimeUnit.SECONDS);
    }

    public static int cores() {
        return xk;
    }

    public static synchronized Executor createBlockingWorkExecutor(String string, int n2) {
        if (xm == null) {
            final AtomicInteger atomicInteger = new AtomicInteger(0);
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, String.format(BLOCKING_WORK_EXECUTOR_NAME_PATTERN, atomicInteger.incrementAndGet()));
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler(xq);
                    return thread;
                }
            };
            LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE);
            xm = new ThreadPoolExecutor(xi, n2, xj, TimeUnit.SECONDS, linkedBlockingQueue, threadFactory);
            ((ThreadPoolExecutor)xm).setRejectedExecutionHandler(new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    StackUtils.getRejectionExecutor().execute(runnable);
                }
            });
        }
        return xm;
    }

    public static int getBlockingWorkerThreadPoolCoreSize() {
        return xi;
    }

    public static long getBlockingWorkerThreadPoolTimeout() {
        return xj;
    }

    public static Executor getBlockingWorkExecutor() {
        return StackUtils.createBlockingWorkExecutor("Blocking-Work-Executor", 256);
    }

    public static synchronized IEncodeableSerializer getDefaultSerializer() {
        if (xp == null) {
            EncodeableSerializer encodeableSerializer = EncodeableSerializer.getInstance();
            EncodeableDescTable encodeableDescTable = new EncodeableDescTable();
            encodeableDescTable.addStructureInfo(EncodeableDesc.readFromClass(Acknowledge.class, Acknowledge.getFields()));
            encodeableDescTable.addStructureInfo(EncodeableDesc.readFromClass(Hello.class, Hello.getFields()));
            encodeableDescTable.addStructureInfo(EncodeableDesc.readFromClass(ErrorMessage.class, ErrorMessage.getFields()));
            encodeableDescTable.addStructureInfo(EncodeableDesc.readFromClass(ReverseHello.class, ReverseHello.getFields()));
            EncodeableReflectionSerializer encodeableReflectionSerializer = new EncodeableReflectionSerializer(encodeableDescTable);
            encodeableSerializer.addSerializer(encodeableReflectionSerializer);
            xp = encodeableSerializer;
        }
        return xp;
    }

    public static synchronized Executor getNonBlockingWorkExecutor() {
        if (xl == null) {
            final AtomicInteger atomicInteger = new AtomicInteger(0);
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, String.format(NON_BLOCKING_WORK_EXECUTOR_NAME_PATTERN, atomicInteger.incrementAndGet()));
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler(xq);
                    return thread;
                }
            };
            LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE);
            RejectedExecutionHandler rejectedExecutionHandler = new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    StackUtils.getBlockingWorkExecutor().execute(runnable);
                }
            };
            xl = new ThreadPoolExecutor(xk, xk, 3L, TimeUnit.SECONDS, linkedBlockingQueue, threadFactory, rejectedExecutionHandler);
        }
        return xl;
    }

    public static synchronized Executor getRejectionExecutor() {
        if (xn == null) {
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "RejectedRunnableHanlder");
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler(xq);
                    return thread;
                }
            };
            xn = Executors.newSingleThreadExecutor(threadFactory);
        }
        return xn;
    }

    public static AsyncSelector getSelector() {
        if (xo == null) {
            try {
                xo = new AsyncSelector(Selector.open());
            }
            catch (IOException iOException) {
                throw new Error(iOException);
            }
        }
        return xo;
    }

    public static Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return xq;
    }

    public static void logStatus() {
        StackUtils.a("BLOCKING_EXECUTOR", (ThreadPoolExecutor)xm);
        StackUtils.a("NON_BLOCKING_EXECUTOR", (ThreadPoolExecutor)xl);
    }

    public static ThreadFactory newNamedThreadFactory(String string) {
        return new a(string);
    }

    public static void setBlockingWorkerThreadPoolCoreSize(int n2) {
        xi = n2;
    }

    public static void setBlockingWorkerThreadPoolTimeout(long l2) {
        xj = l2;
    }

    public static void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        xq = uncaughtExceptionHandler;
    }

    public static void shutdown() {
        WeakReference<Timer> weakReference;
        Timer timer;
        if (xm != null) {
            ((ThreadPoolExecutor)xm).shutdown();
            xm = null;
        }
        if (xl != null) {
            ((ThreadPoolExecutor)xl).shutdown();
            xl = null;
        }
        if (xn != null) {
            xn.shutdown();
            xn = null;
        }
        if (xo != null) {
            try {
                xo.close();
                xo = null;
            }
            catch (IOException iOException) {
                logger.debug("SELECTOR.close failed", (Throwable)iOException);
            }
        }
        Timer timer2 = timer = (weakReference = TimerUtil.timer) == null ? null : (Timer)weakReference.get();
        if (timer != null) {
            timer.cancel();
            TimerUtil.timer = null;
        }
    }

    public static ServiceResultException toServiceResultException(Exception exception) {
        if (exception instanceof ServiceResultException) {
            return (ServiceResultException)exception;
        }
        if (exception instanceof ClosedChannelException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)exception);
        }
        if (exception instanceof EOFException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)exception, "Connection closed (graceful)");
        }
        if (exception instanceof ConnectException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)exception);
        }
        if (exception instanceof SocketException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)exception, "Connection closed (unexpected)");
        }
        if (exception instanceof IOException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)exception);
        }
        return new ServiceResultException(exception);
    }

    private static void a(String string, ThreadPoolExecutor threadPoolExecutor) {
        logger.debug("{}: ActiveCount={} CompletedTaskCount={} PoolSize={} LargestPoolSize={} TaskCount={}", new Object[]{string, threadPoolExecutor.getActiveCount(), threadPoolExecutor.getCompletedTaskCount(), threadPoolExecutor.getPoolSize(), threadPoolExecutor.getLargestPoolSize(), threadPoolExecutor.getTaskCount()});
    }

    static {
        RANDOM = new Random();
        CLIENT_TOKEN_LIFETIME_REQUEST = new UnsignedInteger(600000);
        SERVER_GIVEN_TOKEN_LIFETIME = UnsignedInteger.getFromBits(600000);
        NON_BLOCKING_WORK_EXECUTOR_NAME_PATTERN = "OPC-UA-Stack-Non-Blocking-Work-Executor-%d";
        BLOCKING_WORK_EXECUTOR_NAME_PATTERN = "OPC-UA-Stack-Blocking-Work-Executor-%d";
        UA_TIMER_NAME_PATTERN = "OPC-UA-Stack-Timer";
        SELECTOR_NAME_PATTERN = "OPC-UA-Stack-Async-Selector";
        xq = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                logger.error("Uncaught Exception in Thread " + thread, throwable);
                throwable.printStackTrace();
            }
        };
    }

    static class a
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        a(String string) {
            this.namePrefix = string + "-pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, this.namePrefix + this.threadNumber.getAndIncrement());
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            thread.setUncaughtExceptionHandler(xq);
            return thread;
        }
    }
}

