/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.SignatureData;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.CryptoProvider;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.utils.StringUtils;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoUtil {
    static Logger wP = LoggerFactory.getLogger(CryptoUtil.class);
    private static final SecureRandom random;
    private static final char[] wQ;
    private static final String wL = "com.prosysopc.ua.stack.transport.security.ScCryptoProvider";
    private static final String wM = "com.prosysopc.ua.stack.transport.security.BcCryptoProvider";
    private static final String wN = "com.prosysopc.ua.stack.transport.security.BcFipsCryptoProvider";
    private static volatile CryptoProvider wR;
    private static volatile String wS;

    @Deprecated
    public static byte[] asymmEncrypt(byte[] byArray, Key key, SecurityAlgorithm securityAlgorithm) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, ServiceResultException, NoSuchAlgorithmException, NoSuchPaddingException {
        return CryptoUtil.encryptAsymm(byArray, (PublicKey)key, securityAlgorithm);
    }

    public static byte[] base64Decode(String string) {
        return CryptoUtil.getCryptoProvider().base64Decode(string);
    }

    public static String base64Encode(byte[] byArray) {
        return CryptoUtil.getCryptoProvider().base64Encode(byArray);
    }

    public static Mac createMac(SecurityAlgorithm securityAlgorithm, byte[] byArray) throws ServiceResultException {
        return CryptoUtil.getCryptoProvider().createMac(securityAlgorithm, byArray);
    }

    public static ByteString createNonce(int n2) {
        wP.debug("createNonce: bytes={}", (Object)n2);
        byte[] byArray = new byte[n2];
        random.nextBytes(byArray);
        return ByteString.valueOf(byArray);
    }

    @Deprecated
    public static ByteString createNonce(SecurityAlgorithm securityAlgorithm) throws ServiceResultException {
        return CryptoUtil.createNonce(CryptoUtil.getNonceLength(securityAlgorithm));
    }

    public static void decryptAsymm(PrivateKey privateKey, SecurityConfiguration securityConfiguration, byte[] byArray, byte[] byArray2, int n2) throws ServiceResultException {
        CryptoUtil.getCryptoProvider().decryptAsymm(privateKey, securityConfiguration.getSecurityPolicy().getAsymmetricEncryptionAlgorithm(), byArray, byArray2, n2);
    }

    public static byte[] encryptAsymm(byte[] byArray, PublicKey publicKey, SecurityAlgorithm securityAlgorithm) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, ServiceResultException, NoSuchAlgorithmException, NoSuchPaddingException {
        int n2 = CryptoUtil.getCipherBlockSize(securityAlgorithm, publicKey);
        byte[] byArray2 = new byte[n2];
        CryptoUtil.getCryptoProvider().encryptAsymm(publicKey, securityAlgorithm, byArray, byArray2, 0);
        return byArray2;
    }

    public static void encryptAsymm(Certificate certificate, SecurityConfiguration securityConfiguration, byte[] byArray, byte[] byArray2, int n2) throws ServiceResultException {
        wP.info("encryptAsymm called.");
        CryptoUtil.getCryptoProvider().encryptAsymm(certificate.getPublicKey(), securityConfiguration.getSecurityPolicy().getAsymmetricEncryptionAlgorithm(), byArray, byArray2, n2);
    }

    public static String[] filterCipherSuiteList(String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        Pattern[] patternArray = new Pattern[stringArray2.length];
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            patternArray[i2] = Pattern.compile(stringArray2[i2]);
        }
        block1: for (String string : stringArray) {
            for (Pattern pattern : patternArray) {
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches()) continue;
                arrayList.add(string);
                continue block1;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Cipher getAsymmetricCipher(SecurityAlgorithm securityAlgorithm) throws ServiceResultException {
        if (securityAlgorithm == null) {
            throw new IllegalArgumentException();
        }
        try {
            if (securityAlgorithm.equals((Object)SecurityAlgorithm.Rsa15)) {
                return Cipher.getInstance("RSA");
            }
            if (securityAlgorithm.equals((Object)SecurityAlgorithm.RsaOaep)) {
                return Cipher.getInstance("RSA/NONE/OAEPWithSHA1AndMGF1Padding", CryptoUtil.getSecurityProviderName());
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)noSuchPaddingException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)noSuchProviderException);
        }
        throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, "Unsupported asymmetric signature algorithm: " + (Object)((Object)securityAlgorithm));
    }

    public static int getAsymmInputBlockSize(SecurityAlgorithm securityAlgorithm) throws ServiceResultException {
        if (securityAlgorithm.equals((Object)SecurityAlgorithm.Rsa15)) {
            return 117;
        }
        if (securityAlgorithm.equals((Object)SecurityAlgorithm.RsaOaep)) {
            return 86;
        }
        throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, "Unsupported asymmetric signature algorithm: {0}, " + (Object)((Object)securityAlgorithm));
    }

    public static int getCipherBlockSize(SecurityAlgorithm securityAlgorithm, Key key) throws ServiceResultException {
        if (securityAlgorithm == null) {
            return 1;
        }
        SecurityAlgorithm.AlgorithmType algorithmType = securityAlgorithm.getType();
        if (algorithmType.equals((Object)SecurityAlgorithm.AlgorithmType.SymmetricEncryption)) {
            return 16;
        }
        if (algorithmType.equals((Object)SecurityAlgorithm.AlgorithmType.AsymmetricSignature)) {
            return securityAlgorithm.getKeySize() / 8;
        }
        if (algorithmType.equals((Object)SecurityAlgorithm.AlgorithmType.AsymmetricEncryption)) {
            if (key instanceof RSAPublicKey) {
                return ((RSAPublicKey)key).getModulus().bitLength() / 8;
            }
            if (key instanceof RSAPrivateKey) {
                return ((RSAPrivateKey)key).getModulus().bitLength() / 8;
            }
        }
        throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, securityAlgorithm.getUri());
    }

    public static String[] getCipherSuiteIntersection(String[] stringArray, String[] stringArray2, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(Math.max(stringArray.length, stringArray2.length));
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : stringArray2) {
            treeSet.add(bl ? string.substring(3) : string);
        }
        for (String string : stringArray) {
            if (!treeSet.contains(bl ? string.substring(3) : string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static CryptoProvider getCryptoProvider() {
        if (wR == null) {
            if ("SC".equals(CryptoUtil.getSecurityProviderName())) {
                try {
                    wR = (CryptoProvider)Class.forName(wL).newInstance();
                }
                catch (Exception exception) {
                    throw new RuntimeException("Cannot init com.prosysopc.ua.stack.transport.security.ScCryptoProvider", exception);
                }
            } else if ("BC".equals(CryptoUtil.getSecurityProviderName())) {
                try {
                    wR = (CryptoProvider)Class.forName(wM).newInstance();
                }
                catch (Exception exception) {
                    throw new RuntimeException("Cannot init com.prosysopc.ua.stack.transport.security.BcCryptoProvider", exception);
                }
            } else if ("BCFIPS".equals(CryptoUtil.getSecurityProviderName())) {
                try {
                    wR = (CryptoProvider)Class.forName(wN).newInstance();
                }
                catch (Exception exception) {
                    throw new RuntimeException("Cannot init com.prosysopc.ua.stack.transport.security.BcFipsCryptoProvider", exception);
                }
            } else {
                throw new RuntimeException("NO CRYPTO PROVIDER AVAILABLE!");
            }
            wP.info("Using CryptoProvider {}", (Object)wR.getClass().getCanonicalName());
        }
        return wR;
    }

    @Deprecated
    public static int getNonceLength(SecurityAlgorithm securityAlgorithm) throws ServiceResultException {
        if (securityAlgorithm == null) {
            return 0;
        }
        if (securityAlgorithm.equals((Object)SecurityAlgorithm.Rsa15)) {
            return 32;
        }
        if (securityAlgorithm.equals((Object)SecurityAlgorithm.RsaOaep)) {
            return 32;
        }
        if (SecurityAlgorithm.AlgorithmType.SymmetricEncryption == securityAlgorithm.getType()) {
            return securityAlgorithm.getKeySize() / 8;
        }
        wP.error("getNonceLength: Unsupported algorithm={}", (Object)securityAlgorithm);
        throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, securityAlgorithm.getUri());
    }

    public static int getPlainTextBlockSize(SecurityAlgorithm securityAlgorithm, Key key) throws ServiceResultException {
        int n2;
        if (securityAlgorithm == null) {
            return 1;
        }
        switch (securityAlgorithm) {
            case Rsa15: {
                n2 = 11;
                break;
            }
            case RsaOaep: {
                n2 = 42;
                break;
            }
            case RsaOaep256: {
                n2 = 66;
                break;
            }
            default: {
                throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, securityAlgorithm.getUri());
            }
        }
        try {
            return ((RSAPublicKey)key).getModulus().bitLength() / 8 - n2;
        }
        catch (ClassCastException classCastException) {
            wP.error("key is not instance of RSAPublicKey", (Throwable)classCastException);
            throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, securityAlgorithm.getUri());
        }
    }

    public static SecureRandom getRandom() {
        return random;
    }

    public static String getSecurityProviderName() {
        if (wS == null) {
            boolean bl;
            if (wP.isDebugEnabled()) {
                wP.debug("Providers={}", (Object)Arrays.toString(Security.getProviders()));
            }
            wS = (bl = System.getProperty("java.vendor").toLowerCase().contains("android")) ? "SC" : "BC";
        }
        return wS;
    }

    public static String getSecurityProviderName(Class<?> clazz) {
        return CryptoUtil.getCryptoProvider().getSecurityProviderName(clazz);
    }

    public static int getSignatureSize(SecurityAlgorithm securityAlgorithm, Key key) throws ServiceResultException {
        if (securityAlgorithm == null) {
            return 0;
        }
        if (securityAlgorithm.getType().equals((Object)SecurityAlgorithm.AlgorithmType.SymmetricSignature)) {
            return securityAlgorithm.getKeySize() / 8;
        }
        if (key instanceof RSAPublicKey) {
            return ((RSAPublicKey)key).getModulus().bitLength() / 8;
        }
        if (key instanceof RSAPrivateKey) {
            return ((RSAPrivateKey)key).getModulus().bitLength() / 8;
        }
        if (securityAlgorithm.equals((Object)SecurityAlgorithm.RsaSha1)) {
            if (key instanceof RSAPublicKey) {
                return ((RSAPublicKey)key).getModulus().bitLength() / 8;
            }
            if (key instanceof RSAPrivateKey) {
                return ((RSAPrivateKey)key).getModulus().bitLength() / 8;
            }
        }
        if (securityAlgorithm.equals((Object)SecurityAlgorithm.RsaSha256)) {
            if (key instanceof RSAPublicKey) {
                return ((RSAPublicKey)key).getModulus().bitLength() / 8;
            }
            if (key instanceof RSAPrivateKey) {
                return ((RSAPrivateKey)key).getModulus().bitLength() / 8;
            }
        }
        throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, securityAlgorithm.getUri());
    }

    public static byte[] hexToBytes(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("0x")) {
            string = string.substring(2);
        }
        int n2 = string.length();
        byte[] byArray = new byte[n2 / 2];
        for (int i2 = 0; i2 < n2; i2 += 2) {
            byArray[i2 / 2] = (byte)((Character.digit(string.charAt(i2), 16) << 4) + Character.digit(string.charAt(i2 + 1), 16));
        }
        return byArray;
    }

    public static synchronized Provider loadOrInstallProvider(String string, String string2) throws IllegalArgumentException {
        Provider provider = Security.getProvider(string);
        if (provider != null) {
            return provider;
        }
        try {
            provider = (Provider)Class.forName(string2).newInstance();
            Security.addProvider(provider);
            return provider;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot add Security Provider class: " + string2, exception);
        }
    }

    public static void setCryptoProvider(CryptoProvider cryptoProvider) {
        wR = cryptoProvider;
        wS = cryptoProvider == null ? null : cryptoProvider.getSecurityProviderName(null);
    }

    public static void setSecurityProviderName(String string) {
        if (!StringUtils.equals(string, wS)) {
            wS = string;
            wR = null;
        }
    }

    public static SignatureData signAsymm(PrivateKey privateKey, SecurityAlgorithm securityAlgorithm, byte[] byArray) throws ServiceResultException {
        if (securityAlgorithm == null) {
            return new SignatureData(null, null);
        }
        return new SignatureData(securityAlgorithm.getUri(), ByteString.valueOf(CryptoUtil.getCryptoProvider().signAsymm(privateKey, securityAlgorithm, byArray)));
    }

    public static String toHex(byte[] byArray) {
        return CryptoUtil.toHex(byArray, byArray != null && byArray.length > 64 ? 64 : 0);
    }

    public static String toHex(byte[] byArray, int n2) {
        if (byArray == null) {
            return "(null)";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[" + byArray.length + "] 0x");
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (n2 > 0 && i2 % n2 == 0) {
                stringBuffer.append(StringUtils.lineSeparator());
            }
            stringBuffer.append(wQ[byArray[i2] >> 4 & 0xF]);
            stringBuffer.append(wQ[byArray[i2] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static boolean verifyAsymm(X509Certificate x509Certificate, SecurityAlgorithm securityAlgorithm, byte[] byArray, byte[] byArray2) throws ServiceResultException {
        return CryptoUtil.getCryptoProvider().verifyAsymm(x509Certificate.getPublicKey(), securityAlgorithm, byArray, byArray2);
    }

    static {
        try {
            wP.debug("CryptoUtil init");
            random = SecureRandom.getInstance("SHA1PRNG");
            wP.debug("CryptoUtil init: random={}", (Object)random);
            random.setSeed(System.currentTimeMillis());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error(noSuchAlgorithmException);
        }
        wQ = "0123456789abcdef".toCharArray();
    }
}

