/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConcurrentBijectionMap<L, R> {
    private Map<L, R> wI = new HashMap<L, R>();
    private Map<R, L> wJ = new HashMap<R, L>();

    public synchronized void addAll(ConcurrentBijectionMap<L, R> concurrentBijectionMap) {
        for (Map.Entry<L, R> entry : concurrentBijectionMap.wI.entrySet()) {
            this.map(entry.getKey(), entry.getValue());
        }
    }

    public synchronized void clear() {
        this.wI.clear();
        this.wJ.clear();
    }

    public synchronized boolean contains(L l2, R r2) {
        if (l2 == r2) {
            return true;
        }
        if (l2 == null || r2 == null) {
            return false;
        }
        R r3 = this.wI.get(l2);
        if (r3 == r2) {
            return true;
        }
        return this.wI.get(l2).equals(r3);
    }

    public synchronized boolean containsLeft(L l2) {
        return this.wI.containsKey(l2);
    }

    public synchronized boolean containsRight(R r2) {
        return this.wJ.containsKey(r2);
    }

    public synchronized Set<Map.Entry<L, R>> getEntries() {
        return new HashSet<Map.Entry<L, R>>(this.wI.entrySet());
    }

    public synchronized L getLeft(R r2) {
        return this.wJ.get(r2);
    }

    public synchronized Set<L> getLeftSet() {
        return Collections.unmodifiableSet(this.wI.keySet());
    }

    public synchronized R getRight(L l2) {
        return this.wI.get(l2);
    }

    public synchronized Set<R> getRightSet() {
        return Collections.unmodifiableSet(this.wJ.keySet());
    }

    public synchronized boolean isEmpty() {
        return this.wI.isEmpty();
    }

    public synchronized void map(L l2, R r2) {
        R r3 = this.wI.remove(l2);
        if (r3 != null) {
            this.wJ.remove(r3);
        } else {
            L l3 = this.wJ.remove(r2);
            if (l3 != null) {
                this.wI.remove(l3);
            }
        }
        this.wI.put(l2, r2);
        this.wJ.put(r2, l2);
    }

    public synchronized R removeWithLeft(L l2) {
        R r2 = this.wI.remove(l2);
        if (r2 != null) {
            this.wJ.remove(r2);
        }
        return r2;
    }

    public synchronized L removeWithRight(R r2) {
        L l2 = this.wJ.remove(r2);
        if (l2 != null) {
            this.wI.remove(l2);
        }
        return l2;
    }

    public synchronized boolean retainAllLeft(Collection<L> collection) {
        boolean bl = false;
        for (L l2 : collection) {
            if (this.wI.containsKey(l2)) continue;
            this.removeWithLeft(l2);
            bl = true;
        }
        return bl;
    }

    public synchronized boolean retainAllRight(Collection<R> collection) {
        boolean bl = false;
        for (R r2 : collection) {
            if (this.wJ.containsKey(r2)) continue;
            this.removeWithRight(r2);
            bl = true;
        }
        return bl;
    }

    public synchronized int size() {
        return this.wI.size();
    }

    public synchronized String toString() {
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (Map.Entry<L, R> entry : this.wI.entrySet()) {
            if (n2++ > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey().toString());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue().toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

