/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.NodeClass;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AttributesUtil {
    private static final Map<NodeClass, Set<UnsignedInteger>> wH;

    public static Set<UnsignedInteger> getSupportedAttributes(NodeClass nodeClass) {
        if (nodeClass == null || NodeClass.Unspecified == nodeClass) {
            return Collections.emptySet();
        }
        return wH.get(nodeClass);
    }

    public static EnumSet<AttributeWriteMask.Fields> getSupportedWriteAccess(UnsignedInteger ... unsignedIntegerArray) {
        EnumSet<AttributeWriteMask.Fields> enumSet = EnumSet.noneOf(AttributeWriteMask.Fields.class);
        if (unsignedIntegerArray != null) {
            for (UnsignedInteger unsignedInteger : unsignedIntegerArray) {
                if (Attributes.Value.equals(unsignedInteger)) continue;
                AttributeWriteMask.Fields fields = Attributes.getAttributeWriteMask(unsignedInteger);
                if (fields == null) {
                    throw new IllegalArgumentException("Unrecognized attribute id: " + unsignedInteger);
                }
                enumSet.add(fields);
            }
        }
        return enumSet;
    }

    public static boolean hasAccessToAttribute(AttributeWriteMask attributeWriteMask, UnsignedInteger unsignedInteger) {
        AttributeWriteMask.Fields fields = Attributes.getAttributeWriteMask(unsignedInteger);
        if (fields == null) {
            return false;
        }
        return attributeWriteMask.contains(fields);
    }

    public static boolean isValid(NodeClass nodeClass, UnsignedInteger unsignedInteger) {
        if (nodeClass == null || unsignedInteger == null) {
            return false;
        }
        Set<UnsignedInteger> set = wH.get(nodeClass);
        return set.contains(unsignedInteger);
    }

    public static boolean isValid(UnsignedInteger unsignedInteger) {
        if (unsignedInteger == null) {
            return false;
        }
        return unsignedInteger.compareTo(Attributes.NodeId) >= 0 && unsignedInteger.compareTo(Attributes.AccessLevelEx) <= 0;
    }

    public static String toString(UnsignedInteger unsignedInteger) {
        String string = Attributes.getAttributeName(unsignedInteger);
        if (string == null) {
            string = "<InvalidAttributeValue " + unsignedInteger + ">";
        }
        return string;
    }

    private static void a(Map<NodeClass, Set<UnsignedInteger>> map, UnsignedInteger unsignedInteger, Iterable<NodeClass> iterable) {
        for (NodeClass nodeClass : iterable) {
            map.get(nodeClass).add(unsignedInteger);
        }
    }

    private static void a(Map<NodeClass, Set<UnsignedInteger>> map, UnsignedInteger unsignedInteger, NodeClass ... nodeClassArray) {
        for (NodeClass nodeClass : nodeClassArray) {
            map.get(nodeClass).add(unsignedInteger);
        }
    }

    static {
        HashMap<NodeClass, Set<UnsignedInteger>> hashMap = new HashMap<NodeClass, Set<UnsignedInteger>>();
        EnumSet<NodeClass[]> enumSet = EnumSet.of(NodeClass.DataType, new NodeClass[]{NodeClass.Method, NodeClass.Object, NodeClass.ObjectType, NodeClass.ReferenceType, NodeClass.Variable, NodeClass.VariableType, NodeClass.View});
        for (NodeClass object : enumSet) {
            hashMap.put(object, new HashSet());
        }
        AttributesUtil.a(hashMap, Attributes.NodeId, enumSet);
        AttributesUtil.a(hashMap, Attributes.NodeClass, enumSet);
        AttributesUtil.a(hashMap, Attributes.BrowseName, enumSet);
        AttributesUtil.a(hashMap, Attributes.DisplayName, enumSet);
        AttributesUtil.a(hashMap, Attributes.Description, enumSet);
        AttributesUtil.a(hashMap, Attributes.WriteMask, enumSet);
        AttributesUtil.a(hashMap, Attributes.UserWriteMask, enumSet);
        AttributesUtil.a(hashMap, Attributes.IsAbstract, NodeClass.ReferenceType, NodeClass.ObjectType, NodeClass.VariableType, NodeClass.DataType);
        AttributesUtil.a(hashMap, Attributes.Symmetric, NodeClass.ReferenceType);
        AttributesUtil.a(hashMap, Attributes.InverseName, NodeClass.ReferenceType);
        AttributesUtil.a(hashMap, Attributes.ContainsNoLoops, NodeClass.View);
        AttributesUtil.a(hashMap, Attributes.EventNotifier, NodeClass.View, NodeClass.Object);
        AttributesUtil.a(hashMap, Attributes.Value, NodeClass.Variable, NodeClass.VariableType);
        AttributesUtil.a(hashMap, Attributes.DataType, NodeClass.Variable, NodeClass.VariableType);
        AttributesUtil.a(hashMap, Attributes.ValueRank, NodeClass.Variable, NodeClass.VariableType);
        AttributesUtil.a(hashMap, Attributes.ArrayDimensions, NodeClass.Variable, NodeClass.VariableType);
        AttributesUtil.a(hashMap, Attributes.AccessLevel, NodeClass.Variable);
        AttributesUtil.a(hashMap, Attributes.UserAccessLevel, NodeClass.Variable);
        AttributesUtil.a(hashMap, Attributes.MinimumSamplingInterval, NodeClass.Variable);
        AttributesUtil.a(hashMap, Attributes.Historizing, NodeClass.Variable);
        AttributesUtil.a(hashMap, Attributes.Executable, NodeClass.Method);
        AttributesUtil.a(hashMap, Attributes.UserExecutable, NodeClass.Method);
        AttributesUtil.a(hashMap, Attributes.DataTypeDefinition, NodeClass.DataType);
        AttributesUtil.a(hashMap, Attributes.RolePermissions, enumSet);
        AttributesUtil.a(hashMap, Attributes.UserRolePermissions, enumSet);
        AttributesUtil.a(hashMap, Attributes.AccessRestrictions, enumSet);
        AttributesUtil.a(hashMap, Attributes.AccessLevelEx, NodeClass.Variable);
        HashMap hashMap2 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            hashMap2.put(entry.getKey(), Collections.unmodifiableSet((Set)entry.getValue()));
        }
        wH = Collections.unmodifiableMap(hashMap2);
    }
}

