/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStructure
implements Structure {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStructure.class);

    @Override
    public AbstractStructure clone() {
        try {
            return (AbstractStructure)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error("Got a CloneNotSupportedException, should be impossible", (Throwable)cloneNotSupportedException);
            throw new Error("Every Structure implementation shall be Cloneable", cloneNotSupportedException);
        }
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return null;
    }

    public String toString() {
        StructureSpecification structureSpecification = this.specification();
        if (structureSpecification == null) {
            logger.warn("StructureSpecification is null, cannot do toString properly");
            return super.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(structureSpecification.getName());
        stringBuilder.append(" [");
        List<FieldSpecification> list = structureSpecification.getFields();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FieldSpecification fieldSpecification = list.get(i2);
            stringBuilder.append(fieldSpecification.getName());
            stringBuilder.append("=\"");
            if (fieldSpecification.getValueRank() > 1) {
                stringBuilder.append(Arrays.deepToString((Object[])this.get(fieldSpecification)));
            } else if (fieldSpecification.getValueRank() == 1) {
                stringBuilder.append(Arrays.toString((Object[])this.get(fieldSpecification)));
            } else {
                stringBuilder.append(this.get(fieldSpecification));
            }
            if (i2 == list.size() - 1) {
                stringBuilder.append("\"");
                continue;
            }
            stringBuilder.append("\", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected static abstract class Builder
    implements Structure.Builder {
        protected Builder() {
        }

        @Override
        public abstract AbstractStructure build();
    }
}

