/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.stack.utils.CurrentThreadExecutor;
import com.prosysopc.ua.stack.utils.IStatefulObject;
import com.prosysopc.ua.stack.utils.SnapshotArray;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.StateListener;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractState<T, E extends Throwable>
implements IStatefulObject<T, E> {
    private T state = null;
    private T wz = null;
    private E wA;
    private SnapshotArray<StateListener<T>> wB = null;
    private SnapshotArray<StateListener<T>> wC = null;
    private Object lock = new Object();

    public AbstractState(T t) {
        this.state = t;
    }

    public AbstractState(T t, T t2) {
        this.state = t;
        this.wz = t2;
    }

    @Override
    public synchronized void addStateListener(StateListener<T> stateListener) {
        if (stateListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        if (this.wB == null) {
            this.wB = new SnapshotArray<StateListener>(StateListener.class);
        }
        this.wB.add(stateListener);
    }

    @Override
    public synchronized void addStateNotifiable(StateListener<T> stateListener) {
        if (stateListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        if (this.wC == null) {
            this.wC = new SnapshotArray<StateListener>(StateListener.class);
        }
        this.wC.add(stateListener);
    }

    @Override
    public E getError() {
        return this.wA;
    }

    @Override
    public synchronized T getState() {
        return this.state;
    }

    public boolean hasError() {
        return this.wA != null;
    }

    @Override
    public synchronized void removeStateListener(StateListener<T> stateListener) {
        if (stateListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        if (this.wB == null) {
            return;
        }
        this.wB.remove(stateListener);
        if (this.wB.isEmpty()) {
            this.wB = null;
        }
    }

    @Override
    public synchronized void removeStateNotifiable(StateListener<T> stateListener) {
        if (this.wC != null) {
            this.wC.remove(stateListener);
        }
        if (this.wC.isEmpty()) {
            this.wC = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T waitForState(Set<T> set) throws InterruptedException, E {
        Object object = this.lock;
        synchronized (object) {
            while (!set.contains(this.state)) {
                this.lock.wait();
            }
            E e2 = this.getError();
            if (e2 != null) {
                throw e2;
            }
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T waitForState(Set<T> set, long l2, TimeUnit timeUnit) throws InterruptedException, TimeoutException, E {
        long l3 = System.currentTimeMillis() + timeUnit.toMillis(l2);
        Object object = this.lock;
        synchronized (object) {
            while (!set.contains(this.state)) {
                long l4 = System.currentTimeMillis() - l3;
                if (l4 < 0L) {
                    throw new TimeoutException("timeout");
                }
                this.lock.wait(l4);
                E e2 = this.getError();
                if (e2 == null) continue;
                throw e2;
            }
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T waitForStateUninterruptibly(Set<T> set) throws E {
        Object object = this.lock;
        synchronized (object) {
            while (!set.contains(this.state)) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            E e2 = this.getError();
            if (e2 != null) {
                throw e2;
            }
            return this.state;
        }
    }

    protected T attemptSetState(Set<T> set, T t) {
        if (set == null || t == null) {
            throw new IllegalArgumentException("null arg");
        }
        return this.setState(t, null, set);
    }

    protected void clearError() {
        this.wA = null;
    }

    protected boolean isStateTransitionAllowed(T t, T t2) {
        return true;
    }

    protected void onListenerException(RuntimeException runtimeException) {
        runtimeException.printStackTrace();
    }

    protected void onStateTransition(T t, T t2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setError(E e2) {
        this.wA = e2;
        if (this.wz == null || !this.setState(this.wz)) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    protected boolean setState(T t) {
        return this.setState(t, null, null) == t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T setState(T t, Executor executor, Set<T> set) {
        Runnable runnable;
        if (executor != null && executor instanceof CurrentThreadExecutor) {
            executor = null;
        }
        StateListener<T>[] stateListenerArray = null;
        StateListener<T>[] stateListenerArray2 = null;
        T t2 = null;
        Object StateType2 = null;
        final Object object = this;
        synchronized (object) {
            t2 = this.state;
            StateType2 = t;
            if (t2 == StateType2) {
                return t;
            }
            if (set != null && !set.contains(this.state)) {
                return t;
            }
            if (!this.isStateTransitionAllowed(t2, StateType2)) {
                return t;
            }
            this.state = StateType2;
            if (this.wB != null) {
                stateListenerArray = this.wB.getArray();
            }
            if (this.wC != null) {
                stateListenerArray2 = this.wC.getArray();
            }
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
        this.onStateTransition(t2, StateType2);
        object = t2;
        final Object StateType3 = StateType2;
        if (stateListenerArray != null && executor == null) {
            for (final StateListener<T> stateListener : stateListenerArray) {
                try {
                    stateListener.onStateTransition(this, object, StateType3);
                }
                catch (RuntimeException runtimeException) {
                    this.onListenerException(runtimeException);
                }
            }
        }
        if (stateListenerArray != null && executor != null) {
            for (final StateListener<T> stateListener : stateListenerArray) {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            stateListener.onStateTransition(AbstractState.this, object, StateType3);
                        }
                        catch (RuntimeException runtimeException) {
                            AbstractState.this.onListenerException(runtimeException);
                        }
                    }
                };
                executor.execute(runnable);
            }
        }
        if (stateListenerArray2 != null) {
            for (final StateListener<T> stateListener : stateListenerArray2) {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            stateListener.onStateTransition(AbstractState.this, object, StateType3);
                        }
                        catch (RuntimeException runtimeException) {
                            AbstractState.this.onListenerException(runtimeException);
                        }
                    }
                };
                StackUtils.getBlockingWorkExecutor().execute(runnable);
            }
        }
        return t;
    }

    protected void throwIfError() throws E {
        E e2 = this.wA;
        if (e2 != null) {
            throw e2;
        }
    }
}

