/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.nio;

import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkAsymmDecryptVerifier;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkSymmDecryptVerifier;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkUtils;
import com.prosysopc.ua.stack.transport.tcp.impl.SecurityToken;
import com.prosysopc.ua.stack.transport.tcp.impl.TcpConnectionParameters;
import com.prosysopc.ua.stack.transport.tcp.nio.InputMessage;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.IncubationBuffer;
import com.prosysopc.ua.stack.utils.bytebuffer.InputStreamReadable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureInputMessageBuilder
implements InputMessage {
    static Logger ou = LoggerFactory.getLogger(SecureInputMessageBuilder.class);
    MessageListener wj;
    Object wk;
    TcpConnectionParameters vv;
    EncoderContext ru;
    Exception wl;
    IncubationBuffer wm;
    Runnable wn;
    int wo;
    IEncodeable qT;
    Integer wp;
    Integer wq;
    int messageType;
    boolean wr = true;
    boolean done;
    String securityPolicyUri;
    byte[] tS;
    byte[] tT;
    List<Integer> ws = new ArrayList<Integer>(1);
    AtomicInteger wt;

    public SecureInputMessageBuilder(Object object, MessageListener messageListener, TcpConnectionParameters tcpConnectionParameters, EncoderContext encoderContext, AtomicInteger atomicInteger) {
        this.wj = messageListener;
        this.wk = object;
        this.vv = tcpConnectionParameters;
        this.ru = encoderContext;
        this.wt = atomicInteger;
        ou.debug("SecureInputMessageBuilder: expectedSequenceNumber={}", (Object)atomicInteger);
        this.wm = new IncubationBuffer();
        int n2 = tcpConnectionParameters.maxRecvMessageSize == 0 ? Integer.MAX_VALUE : tcpConnectionParameters.maxRecvMessageSize;
        InputStreamReadable inputStreamReadable = new InputStreamReadable(this.wm, n2);
        inputStreamReadable.order(ByteOrder.LITTLE_ENDIAN);
        final BinaryDecoder binaryDecoder = new BinaryDecoder(inputStreamReadable);
        binaryDecoder.setEncoderContext(encoderContext);
        this.wn = new Runnable(){

            @Override
            public void run() {
                try {
                    Object t = binaryDecoder.getMessage();
                    if (!(SecureInputMessageBuilder.this.wk instanceof SecurityToken)) {
                        for (int i2 = 1; i2 < SecureInputMessageBuilder.this.ws.size(); ++i2) {
                            if (SecureInputMessageBuilder.this.ws.get(i2) == SecureInputMessageBuilder.this.ws.get(i2 - 1) - 1) continue;
                            String string = "Sequence numbers of chunks are not consecutive";
                            ou.info(string);
                            SecureInputMessageBuilder.this.setError(new ServiceResultException(StatusCodes.Bad_DecodingError, string));
                            return;
                        }
                    }
                    SecureInputMessageBuilder.this.setMessage((IEncodeable)t);
                }
                catch (Exception exception) {
                    SecureInputMessageBuilder.this.setError(exception);
                }
                catch (StackOverflowError stackOverflowError) {
                    SecureInputMessageBuilder.this.setError(new ServiceResultException(StatusCodes.Bad_DecodingError, "Stack overflow: " + Arrays.toString(Arrays.copyOf(stackOverflowError.getStackTrace(), 30)) + "..."));
                }
            }
        };
    }

    public synchronized void addChunk(final ByteBuffer byteBuffer) throws ServiceResultException {
        if (!this.wr) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Final chunk added to message builder");
        }
        final int n2 = this.wo++;
        this.ws.add(null);
        int n3 = ChunkUtils.getMessageType(byteBuffer);
        int n4 = n3 & 0xFFFFFF;
        int n5 = n3 & 0xFF000000;
        if (n5 == 0x46000000) {
            this.wr = false;
        }
        final Integer n6 = this.wt != null ? Integer.valueOf(this.wt.getAndIncrement()) : null;
        ou.debug("addChunk: expectedSequenceNumber={}", (Object)n6);
        if (n5 == 0x41000000) {
            this.setMessage(null);
        }
        if (n2 == 0) {
            this.messageType = n4;
            this.wq = ChunkUtils.getSecureChannelId(byteBuffer);
        }
        this.wm.incubate(byteBuffer);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (SecureInputMessageBuilder.this.hasError()) {
                    return;
                }
                try {
                    ou.debug("token: {}", SecureInputMessageBuilder.this.wk);
                    if (SecureInputMessageBuilder.this.wk instanceof SecurityToken) {
                        new ChunkSymmDecryptVerifier(byteBuffer, (SecurityToken)SecureInputMessageBuilder.this.wk).run();
                    } else if (SecureInputMessageBuilder.this.wk instanceof SecurityConfiguration) {
                        ChunkAsymmDecryptVerifier chunkAsymmDecryptVerifier = new ChunkAsymmDecryptVerifier(byteBuffer, (SecurityConfiguration)SecureInputMessageBuilder.this.wk);
                        chunkAsymmDecryptVerifier.run();
                        SecureInputMessageBuilder.this.securityPolicyUri = chunkAsymmDecryptVerifier.getSecurityPolicyUri();
                        SecureInputMessageBuilder.this.tS = chunkAsymmDecryptVerifier.getSenderCertificate();
                        SecureInputMessageBuilder.this.tT = chunkAsymmDecryptVerifier.getReceiverCertificateThumbprint();
                    }
                    int n22 = byteBuffer.position();
                    byte[] byArray = new byte[byteBuffer.remaining()];
                    byteBuffer.get(byArray);
                    byteBuffer.position(n22);
                    int n3 = byteBuffer.position();
                    byteBuffer.position(n3 - 8);
                    int n4 = byteBuffer.getInt();
                    SecureInputMessageBuilder.this.ws.set(n2, n4);
                    if (n6 != null) {
                        if (n4 > n6) {
                            long l2 = System.currentTimeMillis();
                            long l3 = 100L;
                            while (n4 > n6 && System.currentTimeMillis() - l2 < l3) {
                                Thread.sleep(1L);
                            }
                        }
                        if (n6 != n4) {
                            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "chunkSequenceNumber=" + n4 + ", expectedSequenceNumber=" + n6);
                        }
                    }
                    int n5 = byteBuffer.getInt();
                    SecureInputMessageBuilder.this.k(n5);
                    int n62 = ChunkUtils.getSecureChannelId(byteBuffer);
                    if (n62 != SecureInputMessageBuilder.this.wq) {
                        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "secureChannelId=" + n62 + ", expected Id");
                    }
                    byteBuffer.position(n3);
                    SecureInputMessageBuilder.this.wm.hatch(byteBuffer);
                }
                catch (Exception exception) {
                    ou.info("addChunk: failed", (Throwable)exception);
                    SecureInputMessageBuilder.this.wm.forceClose();
                    SecureInputMessageBuilder.this.setError(exception);
                }
            }
        };
        StackUtils.getNonBlockingWorkExecutor().execute(runnable);
        if (n2 == 0) {
            StackUtils.getBlockingWorkExecutor().execute(this.wn);
        }
    }

    public void close() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.wm.forceClose();
    }

    @Override
    public Exception getError() {
        return this.wl;
    }

    @Override
    public IEncodeable getMessage() {
        return this.qT;
    }

    @Override
    public int getMessageType() {
        return this.messageType;
    }

    public byte[] getReceiverCertificateThumbprint() {
        return this.tT;
    }

    @Override
    public int getRequestId() {
        return this.wp;
    }

    @Override
    public int getSecureChannelId() {
        return this.wq;
    }

    public String getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    public byte[] getSenderCertificate() {
        return this.tS;
    }

    @Override
    public List<Integer> getSequenceNumbers() {
        return this.ws;
    }

    @Override
    public Object getToken() {
        return this.wk;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public synchronized boolean moreChunksRequired() {
        return this.wr;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("token=" + this.wk);
        stringBuilder.append(", secureChannelId=" + this.wq);
        stringBuilder.append(", more=" + this.moreChunksRequired());
        return stringBuilder.toString();
    }

    private synchronized void k(int n2) throws ServiceResultException {
        if (this.wp != null && this.wp != n2) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
        }
        this.wp = n2;
    }

    protected void fireComplete() {
        if (this.wj != null) {
            this.wj.onMessageComplete(this);
        }
    }

    protected synchronized boolean hasError() {
        return this.wl != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setError(Exception exception) {
        SecureInputMessageBuilder secureInputMessageBuilder = this;
        synchronized (secureInputMessageBuilder) {
            if (this.done) {
                ou.info("setError[when done]", (Throwable)exception);
                return;
            }
            this.done = true;
            this.wl = exception;
            this.wm.forceClose();
        }
        this.fireComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMessage(IEncodeable iEncodeable) {
        SecureInputMessageBuilder secureInputMessageBuilder = this;
        synchronized (secureInputMessageBuilder) {
            if (this.done) {
                return;
            }
            this.wm.close();
            this.done = true;
            this.qT = iEncodeable;
        }
        this.fireComplete();
    }

    public static interface MessageListener {
        public void onMessageComplete(InputMessage var1);
    }
}

