/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.io;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ChannelSecurityToken;
import com.prosysopc.ua.stack.core.CloseSecureChannelRequest;
import com.prosysopc.ua.stack.core.EncodeableSerializer;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.OpenSecureChannelRequest;
import com.prosysopc.ua.stack.core.OpenSecureChannelResponse;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.encoding.binary.IEncodeableSerializer;
import com.prosysopc.ua.stack.transport.IConnectionListener;
import com.prosysopc.ua.stack.transport.ReverseConnectionListener;
import com.prosysopc.ua.stack.transport.ReverseTransportChannelSettings;
import com.prosysopc.ua.stack.transport.TransportChannelSettings;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.Acknowledge;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkAsymmDecryptVerifier;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkAsymmEncryptSigner;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkFactory;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkSymmDecryptVerifier;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkSymmEncryptSigner;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkUtils;
import com.prosysopc.ua.stack.transport.tcp.impl.ErrorMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.Hello;
import com.prosysopc.ua.stack.transport.tcp.impl.ReverseHello;
import com.prosysopc.ua.stack.transport.tcp.impl.SecurityToken;
import com.prosysopc.ua.stack.transport.tcp.io.IConnection;
import com.prosysopc.ua.stack.transport.tcp.io.OpcTcpSettings;
import com.prosysopc.ua.stack.transport.tcp.io.SequenceNumber;
import com.prosysopc.ua.stack.transport.tcp.io.TcpConnectionLimits;
import com.prosysopc.ua.stack.transport.tcp.io.TcpQuotas;
import com.prosysopc.ua.stack.utils.CertificateUtils;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.SizeCalculationOutputStream;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.TimerUtil;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferArrayReadable;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferArrayWriteable2;
import com.prosysopc.ua.stack.utils.bytebuffer.InputStreamReadable;
import com.prosysopc.ua.stack.utils.bytebuffer.OutputStreamWriteable;
import com.prosysopc.ua.types.opcua.Ids;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpConnection
implements IConnection {
    static Logger logger = LoggerFactory.getLogger(TcpConnection.class);
    private static int uP = 0;
    private static int uQ = 60000;
    private static int uR = 0;
    private static int uS = 0;
    private static SocketFactory uT = new DefaultSocketFactory();
    private static ReverseConnectionProvider uU = new DefaultReverseConnectionProvider();
    EncodeType oU;
    PrivKey oD;
    Cert oC;
    Cert oB;
    EndpointConfiguration em;
    EndpointDescription uV;
    IEncodeableSerializer rq = EncodeableSerializer.getInstance();
    CertificateValidator cb;
    InetSocketAddress addr;
    TcpConnectionLimits uW;
    TcpQuotas uX = TcpQuotas.DEFAULT_CLIENT_QUOTA;
    EnumSet<OpcTcpSettings.Flag> us = EnumSet.noneOf(OpcTcpSettings.Flag.class);
    int connectTimeout = uQ;
    int ut = uQ;
    SecurityConfiguration securityConfiguration;
    final List<SecurityToken> uY = new CopyOnWriteArrayList<SecurityToken>();
    final Map<Integer, SecurityToken> uZ = new ConcurrentHashMap<Integer, SecurityToken>();
    final Map<Integer, ByteString> va = new ConcurrentHashMap<Integer, ByteString>();
    final Map<Integer, SequenceNumber> vb = new ConcurrentHashMap<Integer, SequenceNumber>();
    private SocketWrapper vc = null;
    int vd;
    OutputStreamWriteable ve;
    ReentrantLock lock = new ReentrantLock();
    b vf;
    EncoderContext pX;
    List<IConnection.IMessageListener> listeners = new CopyOnWriteArrayList<IConnection.IMessageListener>();
    List<IConnectionListener> vg = new CopyOnWriteArrayList<IConnectionListener>();
    ReverseConnectionListener eV = null;
    boolean vh = false;
    int uu = uR;

    public static int getDefaultHandshakeTimeout() {
        return uQ;
    }

    public static int getDefaultReverseHelloAcceptTimeout() {
        return uR;
    }

    public static int getReceiveBufferSize() {
        return uP;
    }

    public static ReverseConnectionProvider getReverseConnectionProvider() {
        return uU;
    }

    public static int getSendBufferSize() {
        return uS;
    }

    public static SocketFactory getSocketFactory() {
        return uT;
    }

    public static void setDefaultHandshakeTimeout(int n2) {
        uQ = n2;
    }

    public static void setDefaultReverseHelloAcceptTimeout(int n2) {
        uR = n2;
    }

    public static void setReceiveBufferSize(int n2) {
        uP = n2;
    }

    public static void setReverseConnectionProvider(ReverseConnectionProvider reverseConnectionProvider) {
        uU = reverseConnectionProvider;
    }

    public static void setSendBufferSize(int n2) {
        uS = n2;
    }

    public static void setSocketFactory(SocketFactory socketFactory) {
        uT = socketFactory;
    }

    @Override
    public void addConnectionListener(IConnectionListener iConnectionListener) {
        this.vg.add(iConnectionListener);
    }

    @Override
    public void addMessageListener(IConnection.IMessageListener iMessageListener) {
        this.listeners.add(iMessageListener);
    }

    @Override
    public void close() {
        b b2 = this.vf;
        if (b2 != null) {
            b2.vp = true;
        }
        this.a(new ServiceResultException(StatusCodes.Bad_CommunicationError, "Socket closed by the user"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.lock.lock();
        try {
            this.close();
            this.oD = null;
            this.oC = null;
            this.oB = null;
            this.em = null;
            this.uV = null;
            this.rq = null;
            this.cb = null;
            this.setSocket(null);
            this.pX = null;
            this.ve = null;
            this.uX = null;
            this.uW = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.em;
    }

    public EndpointDescription getEndpointDescription() {
        return this.uV;
    }

    public int getHandshakeTimeout() {
        return this.ut;
    }

    public EncoderContext getMessageContext() {
        return this.pX;
    }

    public int getProtocolVersion() {
        return this.vd;
    }

    public int getReverseHelloAcceptTimeout() {
        return this.uu;
    }

    public SocketAddress getSocketAddress() {
        return this.addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(InetSocketAddress inetSocketAddress, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.lock.lock();
        try {
            if (transportChannelSettings.getOpctcpSettings().getConnectTimeout() >= 0) {
                this.connectTimeout = transportChannelSettings.getOpctcpSettings().getConnectTimeout();
            }
            if (transportChannelSettings.getOpctcpSettings().getHandshakeTimeout() >= 0) {
                this.ut = transportChannelSettings.getOpctcpSettings().getHandshakeTimeout();
            }
            if (transportChannelSettings.getOpctcpSettings().getReverseHelloAcceptTimeout() >= 0) {
                this.uu = transportChannelSettings.getOpctcpSettings().getReverseHelloAcceptTimeout();
            }
            this.addr = inetSocketAddress;
            if (transportChannelSettings instanceof ReverseTransportChannelSettings) {
                this.eV = ((ReverseTransportChannelSettings)transportChannelSettings).getReverseConnectionListener();
                this.vh = true;
            } else {
                this.eV = null;
                this.vh = false;
            }
            this.em = transportChannelSettings.getConfiguration().clone();
            this.uV = transportChannelSettings.getDescription().clone();
            this.cb = transportChannelSettings.getOpctcpSettings().getCertificateValidator();
            this.pX = encoderContext;
            this.oC = transportChannelSettings.getOpctcpSettings().getClientCertificate();
            this.oB = transportChannelSettings.getServerCertificate();
            this.oD = transportChannelSettings.getOpctcpSettings().getPrivKey();
            this.oU = EncodeType.Binary;
            if (this.em.getUseBinaryEncoding() != null && !this.em.getUseBinaryEncoding().booleanValue()) {
                this.oU = EncodeType.Xml;
            }
            this.us = transportChannelSettings.getOpctcpSettings().getFlags();
            KeyPair keyPair = this.oC == null ? null : new KeyPair(this.oC, this.oD);
            SecurityPolicy securityPolicy = SecurityPolicy.getSecurityPolicy(this.uV.getSecurityPolicyUri());
            SecurityMode securityMode = new SecurityMode(securityPolicy, this.uV.getSecurityMode());
            this.securityConfiguration = new SecurityConfiguration(securityMode, keyPair, this.oB);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void initialize(String string, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        try {
            URI uRI = new URI(string);
            InetSocketAddress inetSocketAddress = UriUtil.getSocketAddress(uRI);
            this.initialize(inetSocketAddress, transportChannelSettings, encoderContext);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid, (Throwable)uRISyntaxException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("Error while TcpConnection.initialize", (Throwable)illegalArgumentException);
            throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid);
        }
    }

    public void initialize(TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.initialize(transportChannelSettings.getDescription().getEndpointUrl(), transportChannelSettings, encoderContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws ServiceResultException {
        this.lock.lock();
        try {
            SocketWrapper socketWrapper = this.getSocket();
            if (socketWrapper != null && socketWrapper.isConnected()) {
                return;
            }
            if (!this.vh) {
                try {
                    logger.info("{} Connecting", (Object)this.addr);
                    socketWrapper = uT.createSocket(this);
                    socketWrapper.setTcpNoDelay(true);
                    if (uP > 0) {
                        socketWrapper.setReceiveBufferSize(uP);
                    }
                    if (uS > 0) {
                        socketWrapper.setSendBufferSize(uS);
                    }
                    this.setSocket(socketWrapper);
                    if (this.ut > 0) {
                        socketWrapper.setSoTimeout(this.ut);
                    }
                    if (this.connectTimeout == 0) {
                        socketWrapper.connect(this.addr);
                    } else {
                        socketWrapper.connect(this.addr, this.connectTimeout);
                    }
                }
                catch (ConnectException connectException) {
                    logger.info(this.addr + " Connect failed", (Throwable)connectException);
                    throw new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)connectException);
                }
                catch (IOException iOException) {
                    logger.info(this.addr + " Connect failed", (Throwable)iOException);
                    throw new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid);
                }
                logger.debug("{} Socket connected", (Object)this.addr);
            } else {
                try {
                    try {
                        socketWrapper = uU.provideOpenReverseConnectionSocket(this);
                    }
                    catch (SocketException socketException) {
                        logger.info("ServerSocket.accept {} failed (or the socket was closed while waiting)", (Object)this.addr, (Object)socketException);
                        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, (Throwable)socketException, "ServerSocket.accept failed (or was closed, possibly due to a timeout)");
                    }
                    socketWrapper.setTcpNoDelay(true);
                    if (uP > 0) {
                        socketWrapper.setReceiveBufferSize(uP);
                    }
                    if (uS > 0) {
                        socketWrapper.setSendBufferSize(uS);
                    }
                    if (this.ut > 0) {
                        socketWrapper.setSoTimeout(this.ut);
                    }
                    this.setSocket(socketWrapper);
                    logger.debug("{} Socket connected", (Object)socketWrapper.getRemoteSocketAddress());
                }
                catch (IOException iOException) {
                    logger.info(this.addr + " Connect failed", (Throwable)iOException);
                    throw new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
                }
            }
            try {
                IEncodeable iEncodeable;
                this.aPV();
                OutputStreamWriteable outputStreamWriteable = new OutputStreamWriteable(new BufferedOutputStream(socketWrapper.getOutputStream()));
                outputStreamWriteable.order(ByteOrder.LITTLE_ENDIAN);
                InputStreamReadable inputStreamReadable = new InputStreamReadable(socketWrapper.getInputStream(), Long.MAX_VALUE);
                inputStreamReadable.order(ByteOrder.LITTLE_ENDIAN);
                BinaryDecoder binaryDecoder = new BinaryDecoder(inputStreamReadable);
                binaryDecoder.setEncoderContext(this.pX);
                BinaryEncoder binaryEncoder = new BinaryEncoder(outputStreamWriteable);
                binaryEncoder.setEncoderContext(this.pX);
                if (this.vh) {
                    iEncodeable = this.a(inputStreamReadable, binaryDecoder);
                    logger.debug("Got ReverseHello: {}", (Object)iEncodeable);
                    if (((ReverseHello)iEncodeable).getServerUri() == null || ((ReverseHello)iEncodeable).getServerUri().length() > 4096) {
                        logger.error("ReverseHello did not contain ServerUri, or is too long, got:{}", (Object)((ReverseHello)iEncodeable).getServerUri());
                        throw new ServiceResultException(StatusCodes.Bad_TcpEndpointUrlInvalid);
                    }
                    if (((ReverseHello)iEncodeable).getEndpointUrl() == null || ((ReverseHello)iEncodeable).getEndpointUrl().length() > 4096) {
                        logger.error("ReverseHello did not contain correct EndpointUrl, or is too long, got:{}", (Object)((ReverseHello)iEncodeable).getEndpointUrl());
                        throw new ServiceResultException(StatusCodes.Bad_TcpEndpointUrlInvalid);
                    }
                    if (this.eV != null && !this.eV.onConnect(((ReverseHello)iEncodeable).getServerUri(), ((ReverseHello)iEncodeable).getEndpointUrl(), socketWrapper.getRemoteSocketAddress())) {
                        throw new ServiceResultException(StatusCodes.Bad_ConnectionClosed, "Reverse Connection rejected by the ReverseConnectionListener");
                    }
                    if (this.uV.getEndpointUrl() == null) {
                        this.uV.setEndpointUrl(((ReverseHello)iEncodeable).getEndpointUrl());
                    }
                }
                iEncodeable = new Hello();
                ((Hello)iEncodeable).setEndpointUrl(this.uV.getEndpointUrl());
                ((Hello)iEncodeable).setMaxChunkCount(UnsignedInteger.valueOf(this.em.getMaxBufferSize() == null ? 65535L : (long)this.em.getMaxBufferSize().intValue()));
                ((Hello)iEncodeable).setMaxMessageSize(UnsignedInteger.valueOf(this.pX.getMaxMessageSize()));
                ((Hello)iEncodeable).setReceiveBufferSize(UnsignedInteger.valueOf(this.uX.maxBufferSize));
                ((Hello)iEncodeable).setSendBufferSize(UnsignedInteger.valueOf(this.uX.maxBufferSize));
                ((Hello)iEncodeable).setProtocolVersion(UnsignedInteger.valueOf(0L));
                if (this.uW != null) {
                    ((Hello)iEncodeable).setProtocolVersion(UnsignedInteger.valueOf(this.vd));
                    ((Hello)iEncodeable).setMaxChunkCount(UnsignedInteger.valueOf(this.uW.maxRecvChunkCount));
                    ((Hello)iEncodeable).setMaxMessageSize(UnsignedInteger.valueOf(this.uW.maxRecvMessageSize));
                    ((Hello)iEncodeable).setSendBufferSize(UnsignedInteger.valueOf(this.uW.maxSendBufferSize));
                    ((Hello)iEncodeable).setReceiveBufferSize(UnsignedInteger.valueOf(this.uW.maxRecvBufferSize));
                }
                SizeCalculationOutputStream sizeCalculationOutputStream = new SizeCalculationOutputStream();
                BinaryEncoder binaryEncoder2 = new BinaryEncoder(sizeCalculationOutputStream);
                binaryEncoder2.setEncoderContext(this.pX);
                outputStreamWriteable.putInt(1179403592);
                binaryEncoder2.putEncodeable(null, Hello.class, iEncodeable);
                int n2 = sizeCalculationOutputStream.getLength() + 8;
                outputStreamWriteable.putInt(n2);
                binaryEncoder.putEncodeable(null, Hello.class, iEncodeable);
                outputStreamWriteable.flush();
                int n3 = -1;
                while (n3 == -1) {
                    try {
                        n3 = inputStreamReadable.getInt();
                    }
                    catch (EOFException eOFException) {
                        n3 = inputStreamReadable.getInt();
                    }
                }
                n2 = inputStreamReadable.getInt();
                if (n2 < 8 || n2 > 4096) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
                }
                if (n3 == 1179800133) {
                    binaryDecoder.getEncoderContext().setMaxStringLength(4096);
                    ErrorMessage errorMessage = binaryDecoder.getEncodeable(null, ErrorMessage.class);
                    throw new ServiceResultException(StatusCode.valueOf(errorMessage.getError()), errorMessage.getReason());
                }
                if (n3 != 1179337537) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpMessageTypeInvalid, "Message type was " + n3 + ", expected " + 1179337537);
                }
                Acknowledge acknowledge = binaryDecoder.getEncodeable(null, Acknowledge.class);
                if (acknowledge.getProtocolVersion().intValue() < ((Hello)iEncodeable).getProtocolVersion().intValue()) {
                    throw new ServiceResultException(StatusCodes.Bad_ProtocolVersionUnsupported, "Version " + ((Hello)iEncodeable).getProtocolVersion().intValue() + " requested, got " + acknowledge.getProtocolVersion());
                }
                this.vd = Math.min(((Hello)iEncodeable).getProtocolVersion().intValue(), acknowledge.getProtocolVersion().intValue());
                if (acknowledge.getMaxMessageSize().equals(UnsignedInteger.valueOf(0L))) {
                    acknowledge.setMaxMessageSize(UnsignedInteger.valueOf(Integer.MAX_VALUE));
                }
                if (acknowledge.getMaxChunkCount().equals(UnsignedInteger.valueOf(0L))) {
                    acknowledge.setMaxChunkCount(UnsignedInteger.valueOf(Integer.MAX_VALUE));
                }
                if (acknowledge.getReceiveBufferSize().longValue() > ((Hello)iEncodeable).getReceiveBufferSize().longValue()) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Acknowledge.ReceiveBufferSize > Hello.ReceiveBufferSize");
                }
                if (acknowledge.getReceiveBufferSize().longValue() < 8192L) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Server recv buffer size < 8192");
                }
                if (acknowledge.getSendBufferSize().longValue() > ((Hello)iEncodeable).getSendBufferSize().longValue()) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Acknowledge.SendBufferSize > Hello.SendBufferSize");
                }
                if (acknowledge.getSendBufferSize().longValue() < 8192L) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Server send buffer size < 8192");
                }
                this.uW = new TcpConnectionLimits();
                this.uW.maxSendBufferSize = (int)Math.min(acknowledge.getSendBufferSize().longValue(), Integer.MAX_VALUE);
                this.uW.maxRecvBufferSize = (int)Math.min(acknowledge.getReceiveBufferSize().longValue(), Integer.MAX_VALUE);
                this.uW.maxSendChunkCount = (int)Math.min(acknowledge.getMaxChunkCount().longValue(), Integer.MAX_VALUE);
                this.uW.maxRecvChunkCount = (int)Math.min(((Hello)iEncodeable).getMaxChunkCount().longValue(), Integer.MAX_VALUE);
                this.uW.maxSendMessageSize = (int)Math.min(acknowledge.getMaxMessageSize().longValue(), Integer.MAX_VALUE);
                this.uW.maxRecvMessageSize = (int)Math.min(((Hello)iEncodeable).getMaxMessageSize().longValue(), Integer.MAX_VALUE);
                socketWrapper.setSoTimeout(0);
                socketWrapper.setKeepAlive(true);
                if (this.vh) {
                    logger.info("Connected (reverse), handshake completed, local={}, remote={}", (Object)socketWrapper.getLocalSocketAddress(), (Object)socketWrapper.getRemoteSocketAddress());
                } else {
                    logger.info("Connected (non-reverse), handshake completed, local={}, remote={}", (Object)socketWrapper.getLocalSocketAddress(), (Object)socketWrapper.getRemoteSocketAddress());
                }
                for (IConnectionListener iConnectionListener : this.vg) {
                    iConnectionListener.onOpen();
                }
                logger.debug("Creating ReadThread");
                this.vf = new b(socketWrapper, binaryDecoder.getEncoderContext());
                this.vf.start();
                this.pX = binaryEncoder.getEncoderContext();
                this.ve = outputStreamWriteable;
            }
            catch (IOException iOException) {
                try {
                    socketWrapper.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this.setSocket(null);
                logger.info(this.addr + " Connect failed", (Throwable)iOException);
                throw new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)iOException);
            }
            catch (ServiceResultException serviceResultException) {
                try {
                    socketWrapper.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.setSocket(null);
                logger.info(this.addr + " Connect failed", (Throwable)serviceResultException);
                throw serviceResultException;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect() throws ServiceResultException {
        this.lock.lock();
        try {
            SocketWrapper socketWrapper = this.getSocket();
            if (socketWrapper != null && socketWrapper.isConnected() && !socketWrapper.isClosed()) {
                this.close();
            }
            this.open();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        this.vg.remove(iConnectionListener);
    }

    @Override
    public void removeMessageListener(IConnection.IMessageListener iMessageListener) {
        this.listeners.remove(iMessageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequest(ServiceRequest serviceRequest, int n2, int n3) throws ServiceResultException {
        block16: {
            if (serviceRequest == null) {
                logger.warn("sendRequest: request=null");
            }
            boolean bl = serviceRequest instanceof OpenSecureChannelRequest;
            SocketWrapper socketWrapper = this.getSocket();
            logger.debug("sendRequest: socket={}", (Object)socketWrapper);
            try {
                ByteBuffer[] byteBufferArray;
                ByteBuffer[] byteBufferArray2;
                a a2;
                if (socketWrapper == null || !socketWrapper.isConnected() || socketWrapper.isClosed()) {
                    throw new ServiceResultException(StatusCodes.Bad_ServerNotConnected);
                }
                logger.debug("sendRequest: {} Sending Request rid:{}", (Object)n2, (Object)n3);
                logger.trace("sendrequest: request={}", (Object)serviceRequest);
                SecurityToken securityToken = null;
                SizeCalculationOutputStream sizeCalculationOutputStream = new SizeCalculationOutputStream();
                BinaryEncoder binaryEncoder = new BinaryEncoder(sizeCalculationOutputStream);
                binaryEncoder.setEncoderContext(this.pX);
                binaryEncoder.putMessage(serviceRequest);
                int n4 = sizeCalculationOutputStream.getLength();
                if (n2 != 0) {
                    securityToken = this.j(n2);
                }
                logger.debug("sendRequest: token={}", (Object)securityToken);
                SecurityMode securityMode = this.a(bl, serviceRequest, securityToken);
                int n5 = securityToken != null ? securityToken.getSecurityPolicy().getEncryptionKeySize() : 0;
                logger.debug("sendRequest: keySize={}", (Object)n5);
                ChunkFactory chunkFactory = this.a(bl, securityMode, n5);
                if (chunkFactory == null || (a2 = this.a(chunkFactory, n4, serviceRequest)) == null || !((byteBufferArray2 = a2.aPW()) != null & (byteBufferArray = a2.aPX()) != null)) break block16;
                try {
                    this.lock.lock();
                    try {
                        if (bl) {
                            ByteString byteString = ((OpenSecureChannelRequest)serviceRequest).getClientNonce();
                            this.va.put(n3, byteString);
                            for (int i2 = 0; i2 < byteBufferArray2.length; ++i2) {
                                boolean bl2 = i2 == byteBufferArray2.length - 1;
                                this.a(n2, n3, securityMode, byteBufferArray2[i2], byteBufferArray[i2], bl2);
                                byteBufferArray[i2] = null;
                                byteBufferArray2[i2] = null;
                            }
                        } else {
                            this.uZ.put(n2, securityToken);
                            SequenceNumber sequenceNumber = this.vb.get(n2);
                            for (int i3 = 0; i3 < byteBufferArray2.length; ++i3) {
                                ByteBuffer byteBuffer = byteBufferArray2[i3];
                                ByteBuffer byteBuffer2 = byteBufferArray[i3];
                                boolean bl3 = byteBuffer == byteBufferArray2[byteBufferArray2.length - 1];
                                int n6 = 1128747853;
                                if (bl3) {
                                    n6 = 1179079501;
                                }
                                if (serviceRequest instanceof CloseSecureChannelRequest) {
                                    n6 = 1179601987;
                                }
                                this.a(n3, securityToken, sequenceNumber, byteBuffer, byteBuffer2, n6);
                                byteBufferArray[i3] = null;
                                byteBufferArray2[i3] = null;
                            }
                        }
                        this.ve.flush();
                    }
                    catch (IOException iOException) {
                        this.va.remove(n3);
                        logger.info(this.addr + " Connect failed", (Throwable)iOException);
                        this.close();
                        throw new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)iOException);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (RuntimeException runtimeException) {
                logger.warn(String.format("sendRequest %s failed: socket=%s, asymm=%s", serviceRequest.getClass().getName(), socketWrapper, bl), (Throwable)runtimeException);
                throw runtimeException;
            }
        }
    }

    public void setHandshakeTimeout(int n2) {
        this.ut = n2;
    }

    public void setReverseHelloAcceptTimeout(int n2) {
        this.uu = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ServiceResultException serviceResultException) {
        this.lock.lock();
        try {
            SocketWrapper socketWrapper = this.getSocket();
            if (socketWrapper == null || !socketWrapper.isConnected() || socketWrapper.isClosed()) {
                return;
            }
            try {
                socketWrapper.close();
            }
            catch (IOException iOException) {
                logger.warn(this.addr + " Close error", (Throwable)iOException);
            }
            this.setSocket(null);
            this.va.clear();
            logger.info(this.addr + " Closed");
        }
        finally {
            this.lock.unlock();
        }
        for (IConnectionListener iConnectionListener : this.vg) {
            iConnectionListener.onClosed(serviceResultException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private a a(ChunkFactory chunkFactory, int n2, IEncodeable iEncodeable) throws ServiceResultException {
        int n3;
        if (this.pX.maxMessageSize != 0 && n2 > this.pX.maxMessageSize) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxMessageSize " + this.pX.maxMessageSize + " < " + n2);
            logger.warn("encodeMessage: failed", (Throwable)encodingException);
            throw encodingException;
        }
        int n4 = (n2 + chunkFactory.maxPlaintextSize - 1) / chunkFactory.maxPlaintextSize;
        this.lock.lock();
        try {
            if (this.uW == null) {
                a a2 = null;
                return a2;
            }
            n3 = this.uW.maxSendChunkCount;
        }
        finally {
            this.lock.unlock();
        }
        if (n3 != 0 && n4 > n3) {
            throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
        }
        int n5 = n2;
        ByteBuffer[] byteBufferArray = new ByteBuffer[n4];
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            byteBufferArray[i2] = chunkFactory.allocate(n5);
            byteBufferArray2[i2] = chunkFactory.expandToCompleteChunk(byteBufferArray[i2]);
            n5 -= byteBufferArray[i2].remaining();
        }
        ByteBufferArrayWriteable2.ChunkListener chunkListener = new ByteBufferArrayWriteable2.ChunkListener(){

            @Override
            public void onChunkComplete(ByteBuffer[] byteBufferArray, int n2) {
            }
        };
        ByteBufferArrayWriteable2 byteBufferArrayWriteable2 = new ByteBufferArrayWriteable2(byteBufferArray, chunkListener);
        byteBufferArrayWriteable2.order(ByteOrder.LITTLE_ENDIAN);
        BinaryEncoder binaryEncoder = new BinaryEncoder(byteBufferArrayWriteable2);
        binaryEncoder.setEncoderContext(this.pX);
        binaryEncoder.putMessage(iEncodeable);
        return new a(byteBufferArray2, byteBufferArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkFactory a(boolean bl, SecurityMode securityMode, int n2) throws ServiceResultException {
        int n3;
        MessageSecurityMode messageSecurityMode = securityMode.getMessageSecurityMode();
        this.lock.lock();
        try {
            if (this.uW == null) {
                ChunkFactory chunkFactory = null;
                return chunkFactory;
            }
            n3 = this.uW.maxSendBufferSize;
        }
        finally {
            this.lock.unlock();
        }
        if (bl) {
            return new ChunkFactory.AsymmMsgChunkFactory(n3, this.securityConfiguration);
        }
        SecurityPolicy securityPolicy = securityMode.getSecurityPolicy();
        SecurityAlgorithm securityAlgorithm = securityPolicy.getSymmetricEncryptionAlgorithm();
        SecurityAlgorithm securityAlgorithm2 = securityPolicy.getSymmetricSignatureAlgorithm();
        int n4 = CryptoUtil.getCipherBlockSize(securityAlgorithm, null);
        int n5 = CryptoUtil.getSignatureSize(securityAlgorithm2, null);
        return new ChunkFactory(n3, 8, 8, 8, n5, n4, messageSecurityMode, n2);
    }

    private SecurityMode a(boolean bl, ServiceRequest<?> serviceRequest, SecurityToken securityToken) {
        SecurityPolicy securityPolicy;
        MessageSecurityMode messageSecurityMode;
        if (bl) {
            messageSecurityMode = ((OpenSecureChannelRequest)serviceRequest).getSecurityMode();
            securityPolicy = this.securityConfiguration.getSecurityMode().getSecurityPolicy();
        } else {
            messageSecurityMode = securityToken.getMessageSecurityMode();
            securityPolicy = securityToken.getSecurityPolicy();
        }
        return new SecurityMode(securityPolicy, messageSecurityMode);
    }

    private SecurityToken j(int n2) throws ServiceResultException {
        this.aPJ();
        SecurityToken securityToken = null;
        logger.debug("tokens={}", this.uY);
        for (SecurityToken securityToken2 : this.uY) {
            if (securityToken2.getSecureChannelId() != n2 || securityToken != null && securityToken.getCreationTime() >= securityToken2.getCreationTime()) continue;
            securityToken = securityToken2;
        }
        logger.debug("getSecurityTokenToUse={}", securityToken);
        if (securityToken == null) {
            throw new ServiceResultException(StatusCodes.Bad_CommunicationError, "All security tokens have expired");
        }
        return securityToken;
    }

    private void aPV() {
        int n2 = Math.min(this.em.getMaxMessageSize() != null ? this.em.getMaxMessageSize() : Integer.MAX_VALUE, this.uX.maxMessageSize);
        this.pX.setMaxMessageSize(n2);
        this.pX.setMaxArrayLength(this.em.getMaxArrayLength() != null ? this.em.getMaxArrayLength() : 0);
        this.pX.setMaxStringLength(this.em.getMaxStringLength() != null ? this.em.getMaxStringLength() : 0);
        this.pX.setMaxByteStringLength(this.em.getMaxByteStringLength() != null ? this.em.getMaxByteStringLength() : 0);
    }

    private void aPJ() {
        logger.debug("pruneInvalidTokens: tokens({})={}", (Object)this.uY.size(), this.uY);
        for (SecurityToken securityToken : this.uY) {
            if (securityToken.isValid()) continue;
            this.uY.remove(securityToken);
        }
    }

    private ReverseHello a(InputStreamReadable inputStreamReadable, BinaryDecoder binaryDecoder) throws IOException, ServiceResultException, DecodingException {
        int n2 = -1;
        while (n2 == -1) {
            try {
                n2 = inputStreamReadable.getInt();
            }
            catch (EOFException eOFException) {
                n2 = inputStreamReadable.getInt();
            }
        }
        int n3 = inputStreamReadable.getInt();
        if (n3 < 8 || n3 > 4096) {
            throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
        }
        if (n2 != 1178945618) {
            logger.error("Did not receive correct message type, expecting: {}, got: {}", (Object)1178945618, (Object)n2);
            throw new ServiceResultException(StatusCodes.Bad_TcpMessageTypeInvalid, "Message type was " + n2 + ", expected " + 1178945618);
        }
        ReverseHello reverseHello = binaryDecoder.getEncodeable(null, ReverseHello.class);
        return reverseHello;
    }

    private void a(int n2, int n3, SecurityMode securityMode, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl) throws ServiceResultException, IOException {
        SequenceNumber sequenceNumber;
        byteBuffer.rewind();
        byteBuffer.putInt(bl ? 1179537487 : 1129205839);
        byteBuffer.position(8);
        byteBuffer.putInt(n2);
        byte[] byArray = securityMode.getSecurityPolicy().getEncodedPolicyUri();
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        byArray = this.securityConfiguration.getEncodedLocalCertificate();
        byteBuffer.putInt(byArray == null ? -1 : byArray.length);
        if (byArray != null) {
            byteBuffer.put(byArray);
        }
        byteBuffer.putInt((byArray = this.securityConfiguration.getEncodedRemoteCertificateThumbprint()) == null ? -1 : byArray.length);
        if (byArray != null) {
            byteBuffer.put(byArray);
        }
        int n4 = (sequenceNumber = this.vb.get(n2)) == null ? 1 : sequenceNumber.getNextSendSequencenumber();
        byteBuffer.putInt(n4);
        byteBuffer.putInt(n3);
        logger.debug("SecureChannelId={} SequenceNumber={}, RequestId={}", new Object[]{n2, n4, n3});
        try {
            new ChunkAsymmEncryptSigner(byteBuffer, byteBuffer2, this.securityConfiguration).run();
        }
        catch (RuntimeServiceResultException runtimeServiceResultException) {
            throw runtimeServiceResultException.getCause();
        }
        byteBuffer.rewind();
        this.ve.put(byteBuffer);
    }

    private void a(int n2, SecurityToken securityToken, SequenceNumber sequenceNumber, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n3) throws ServiceResultException, IOException {
        byteBuffer.rewind();
        byteBuffer.putInt(n3);
        byteBuffer.position(8);
        byteBuffer.putInt(securityToken.getSecureChannelId());
        byteBuffer.putInt(securityToken.getTokenId());
        int n4 = sequenceNumber.getNextSendSequencenumber();
        byteBuffer.putInt(n4);
        byteBuffer.putInt(n2);
        try {
            new ChunkSymmEncryptSigner(byteBuffer, byteBuffer2, securityToken).run();
        }
        catch (RuntimeServiceResultException runtimeServiceResultException) {
            throw runtimeServiceResultException.getCause();
        }
        byteBuffer.rewind();
        this.ve.put(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SocketWrapper getSocket() {
        this.lock.lock();
        try {
            SocketWrapper socketWrapper = this.vc;
            return socketWrapper;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setSocket(SocketWrapper socketWrapper) {
        this.vc = socketWrapper;
    }

    class b
    extends Thread {
        SocketWrapper vn;
        EncoderContext pX;
        ServiceResultException vo;
        boolean vp;

        b(SocketWrapper socketWrapper, EncoderContext encoderContext) {
            super("TcpConnection/Read");
            this.vo = null;
            this.vp = false;
            this.setDaemon(true);
            this.vn = socketWrapper;
            this.pX = encoderContext;
        }

        @Override
        public void run() {
            block47: {
                try {
                    InputStreamReadable inputStreamReadable = new InputStreamReadable(this.vn.getInputStream(), Long.MAX_VALUE);
                    inputStreamReadable.order(ByteOrder.LITTLE_ENDIAN);
                    ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>(256);
                    while (this.vn == TcpConnection.this.getSocket()) {
                        byte[] byArray;
                        int n2;
                        int n3;
                        int n4;
                        block48: {
                            Object object;
                            Object object2;
                            Object object3;
                            Object object4;
                            Object object5;
                            int n5;
                            arrayList.clear();
                            int n6 = 0;
                            int n7 = 0;
                            int n8 = 0;
                            n4 = 0;
                            n3 = 0;
                            do {
                                Object object6;
                                if (n7 > TcpConnection.this.uW.maxRecvChunkCount) {
                                    this.vo = new ServiceResultException("Recv chunk count exceeded (max = " + n7 + ")");
                                    logger.warn("{} Recv chunk count exceeded (max = {})", (Object)TcpConnection.this.addr, (Object)n7);
                                    break block47;
                                }
                                int n9 = inputStreamReadable.getInt();
                                n5 = n9 & 0xFFFFFF;
                                n8 = n9 & 0xFF000000;
                                if (n7 == 0) {
                                    n6 = n5;
                                } else if (n5 != n6) {
                                    this.vo = new ServiceResultException("Error, message type changed between chunks");
                                    logger.warn("{} Error, message type changed between chunks", (Object)TcpConnection.this.addr);
                                    break block47;
                                }
                                if (n5 != 5132367 && n5 != 4674381 && n9 != 1179800133) {
                                    this.vo = new ServiceResultException("Error, unknown message type " + String.format("0x%08x", n9));
                                    logger.warn("{} Error, unknown message type {}", (Object)TcpConnection.this.addr, (Object)String.format("0x%08x", n9));
                                    break block47;
                                }
                                int n10 = inputStreamReadable.getInt();
                                if (n10 > TcpConnection.this.uW.maxRecvBufferSize) {
                                    this.vo = new ServiceResultException("Error, chunk too large (max = " + TcpConnection.this.uW.maxRecvBufferSize + ")");
                                    logger.warn("{} Error, chunk too large (max = {})", (Object)TcpConnection.this.addr, (Object)TcpConnection.this.uW.maxRecvBufferSize);
                                    break block47;
                                }
                                object5 = ByteBuffer.allocate(n10);
                                ((ByteBuffer)object5).order(ByteOrder.LITTLE_ENDIAN);
                                ((ByteBuffer)object5).putInt(n9);
                                ((ByteBuffer)object5).putInt(n10);
                                inputStreamReadable.get((ByteBuffer)object5, n10 - 8);
                                if (n9 == 1179800133) {
                                    ServiceResultException serviceResultException;
                                    ((ByteBuffer)object5).position(8);
                                    BinaryDecoder binaryDecoder = new BinaryDecoder((ByteBuffer)object5);
                                    binaryDecoder.setEncoderContext(this.pX);
                                    ErrorMessage errorMessage = binaryDecoder.getEncodeable(null, ErrorMessage.class);
                                    this.vo = serviceResultException = new ServiceResultException(errorMessage.getError(), errorMessage.getReason());
                                    logger.warn(this.vn.getRemoteSocketAddress() + " Error", (Throwable)serviceResultException);
                                    break block47;
                                }
                                int n11 = ChunkUtils.getSecureChannelId((ByteBuffer)object5);
                                if (n7 == 0) {
                                    n3 = n11;
                                } else if (n3 != n11) {
                                    this.vo = new ServiceResultException("Error, SecureChannelId mismatch");
                                    logger.warn("{} Error, SecureChannelId mismatch", (Object)TcpConnection.this.addr);
                                    break block47;
                                }
                                if (n6 == 5132367) {
                                    try {
                                        String string = ChunkUtils.getSecurityPolicyUri((ByteBuffer)object5);
                                        object4 = SecurityPolicy.getSecurityPolicy(string);
                                        object6 = ChunkUtils.getByteString((ByteBuffer)object5);
                                        object3 = ChunkUtils.getByteString((ByteBuffer)object5);
                                        if (object4 != TcpConnection.this.securityConfiguration.getSecurityPolicy()) {
                                            this.vo = new ServiceResultException("Error, unexpected security policy in OpenSecureChannelResponse");
                                            logger.warn("{} Error, unexpected security policy in OpenSecureChannelResponse", (Object)TcpConnection.this.addr);
                                            break block47;
                                        }
                                        if (TcpConnection.this.securityConfiguration.getSecurityPolicy() != SecurityPolicy.NONE && !Arrays.equals((byte[])object3, TcpConnection.this.securityConfiguration.getEncodedLocalCertificateThumbprint())) {
                                            this.vo = new ServiceResultException("Error, certificate thumbprint mismatch");
                                            logger.warn("{} Error, certificate thumbprint mismatch", (Object)TcpConnection.this.addr);
                                            break block47;
                                        }
                                        object2 = null;
                                        if (object6 != null && ((Object)object6).length > 0) {
                                            try {
                                                object2 = new Cert(CertificateUtils.decodeX509Certificate((byte[])object6));
                                            }
                                            catch (CertificateException certificateException) {
                                                this.vo = new ServiceResultException(StatusCodes.Bad_CertificateInvalid, "Error, Invalid Remote Certificate");
                                                logger.warn(TcpConnection.this.addr + " Error, Invalid Remote Certificate", (Throwable)certificateException);
                                                break block47;
                                            }
                                        }
                                        if (TcpConnection.this.cb != null && (object = TcpConnection.this.cb.validateCertificate((Cert)object2)) != null && !((StatusCode)object).isGood()) {
                                            this.vo = new ServiceResultException((StatusCode)object, "Remote certificate not accepted");
                                            logger.info("{} Remote certificate not accepted: {}", (Object)TcpConnection.this.addr, object);
                                            break block47;
                                        }
                                        TcpConnection.this.securityConfiguration = new SecurityConfiguration(TcpConnection.this.securityConfiguration.getSecurityMode(), TcpConnection.this.securityConfiguration.getLocalCertificate2(), (Cert)object2);
                                        object = new ChunkAsymmDecryptVerifier((ByteBuffer)object5, TcpConnection.this.securityConfiguration);
                                        ((ChunkAsymmDecryptVerifier)object).run();
                                    }
                                    catch (ServiceResultException serviceResultException) {
                                        this.vo = serviceResultException;
                                        logger.warn(TcpConnection.this.addr + "", (Throwable)serviceResultException);
                                        break block47;
                                    }
                                }
                                if (n6 == 4674381) {
                                    int n12 = ChunkUtils.getTokenId((ByteBuffer)object5);
                                    object4 = null;
                                    logger.debug("tokens({})={}", (Object)TcpConnection.this.uY.size(), TcpConnection.this.uY);
                                    object6 = TcpConnection.this.uY.iterator();
                                    while (object6.hasNext()) {
                                        object3 = (SecurityToken)object6.next();
                                        if (((SecurityToken)object3).getTokenId() != n12 || ((SecurityToken)object3).getSecureChannelId() != n11) continue;
                                        object4 = object3;
                                    }
                                    logger.debug("token={}", object4);
                                    if (object4 == null) {
                                        this.vo = new ServiceResultException("Unexpected securityTokenId = " + n12);
                                        logger.warn("{} Unexpected securityTokenId = {}", (Object)TcpConnection.this.addr, (Object)n12);
                                        break block47;
                                    }
                                    if (!((SecurityToken)object4).isValid()) {
                                        this.vo = new ServiceResultException("SecurityToken " + n12 + " has timeouted");
                                        logger.warn("{} SecurityToken {} has timeouted", (Object)TcpConnection.this.addr, object4);
                                        break block47;
                                    }
                                    TcpConnection.this.uZ.put(n11, (SecurityToken)object4);
                                    object6 = new ChunkSymmDecryptVerifier((ByteBuffer)object5, (SecurityToken)object4);
                                    ((ChunkSymmDecryptVerifier)object6).run();
                                    ((ByteBuffer)object5).position(24);
                                }
                                ((ByteBuffer)object5).position(((Buffer)object5).position() - 8);
                                int n13 = ((ByteBuffer)object5).getInt();
                                object4 = TcpConnection.this.vb.get(n3);
                                if (!(n6 != 4674381 && object4 == null || ((SequenceNumber)object4).testAndSetRecvSequencenumber(n13))) {
                                    this.vo = new ServiceResultException("Sequence number mismatch");
                                    logger.warn("{} Sequence number mismatch: {} vs. {}", new Object[]{TcpConnection.this.addr, ((SequenceNumber)object4).getRecvSequenceNumber(), n13});
                                    break block47;
                                }
                                n2 = ((ByteBuffer)object5).getInt();
                                if (n7 == 0) {
                                    n4 = n2;
                                } else if (n2 != n4) {
                                    this.vo = new ServiceResultException("Request id mismatch");
                                    logger.warn("{} Request id mismatch", (Object)TcpConnection.this.addr);
                                    break block47;
                                }
                                arrayList.add((ByteBuffer)object5);
                                ++n7;
                            } while (n8 == 0x43000000);
                            if (n8 == 0x41000000) continue;
                            ByteBufferArrayReadable byteBufferArrayReadable = new ByteBufferArrayReadable(arrayList.toArray(new ByteBuffer[arrayList.size()]));
                            byteBufferArrayReadable.order(ByteOrder.LITTLE_ENDIAN);
                            n5 = (int)byteBufferArrayReadable.getByteQueue().remaining();
                            byArray = new byte[n5];
                            byteBufferArrayReadable.getByteQueue().get(byArray);
                            object5 = new BinaryDecoder(byArray);
                            ((BinaryDecoder)object5).setEncoderContext(this.pX);
                            NodeId nodeId = ((BinaryDecoder)object5).getNodeId(null);
                            NodeId nodeId2 = new NodeId(0, (UnsignedInteger)Ids.OpenSecureChannelResponse_DefaultBinary.getValue());
                            if (nodeId2.equals(nodeId)) {
                                object5 = new BinaryDecoder(byArray);
                                ((BinaryDecoder)object5).setEncoderContext(this.pX);
                                object4 = ((BinaryDecoder)object5).getMessage();
                                OpenSecureChannelResponse openSecureChannelResponse = (OpenSecureChannelResponse)object4;
                                object3 = openSecureChannelResponse.getSecurityToken();
                                object2 = TcpConnection.this.va.get(n4);
                                object = openSecureChannelResponse.getServerNonce();
                                int n14 = n3;
                                int n15 = ((ChannelSecurityToken)object3).getChannelId().intValue();
                                if (n15 != n14) {
                                    logger.warn("{} OpenSecureChannel, server sent two secureChannelIds {} and {} using {}", new Object[]{TcpConnection.this.addr, n14, n15, n14});
                                }
                                try {
                                    SecurityToken securityToken = new SecurityToken(TcpConnection.this.securityConfiguration, n14, ((ChannelSecurityToken)object3).getTokenId().intValue(), System.currentTimeMillis(), ((ChannelSecurityToken)object3).getRevisedLifetime().longValue(), (ByteString)object2, (ByteString)object);
                                    logger.debug("new token={}", (Object)securityToken);
                                    TcpConnection.this.uY.add(securityToken);
                                    if (TcpConnection.this.vb.containsKey(n14)) break block48;
                                    TcpConnection.this.vb.put(n14, new SequenceNumber());
                                }
                                catch (ServiceResultException serviceResultException) {
                                    this.vo = serviceResultException;
                                    logger.warn(TcpConnection.this.addr + " SecurityTokenError ", (Throwable)serviceResultException);
                                    break;
                                }
                            }
                        }
                        TcpConnection.this.va.remove(n4);
                        final int n16 = n4;
                        n2 = n3;
                        StackUtils.getBlockingWorkExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                Object t;
                                BinaryDecoder binaryDecoder = new BinaryDecoder(byArray);
                                binaryDecoder.setEncoderContext(b.this.pX);
                                try {
                                    t = binaryDecoder.getMessage();
                                }
                                catch (DecodingException decodingException) {
                                    logger.error("Decoding error for Message", (Throwable)decodingException);
                                    return;
                                }
                                for (IConnection.IMessageListener iMessageListener : TcpConnection.this.listeners) {
                                    iMessageListener.onMessage(n16, n2, (IEncodeable)t);
                                }
                            }
                        });
                    }
                }
                catch (IOException iOException) {
                    if (iOException instanceof SocketException) {
                        if (!this.vp) {
                            logger.info("{} Closed (unexpected)", (Object)TcpConnection.this.addr);
                            this.vo = new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException, "Connection closed (unexpected)");
                        } else {
                            logger.info("{} Closed (expected)", (Object)TcpConnection.this.addr);
                            this.vo = new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException, "Connection closed (expected)");
                        }
                    } else if (iOException instanceof EOFException) {
                        this.vo = new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException, "Connection closed (graceful)");
                        logger.info("{} Closed (graceful)", (Object)TcpConnection.this.addr);
                    } else {
                        this.vo = StackUtils.toServiceResultException(iOException);
                        logger.warn(TcpConnection.this.addr + " Error", (Throwable)iOException);
                    }
                }
                catch (DecodingException decodingException) {
                    if (decodingException.getCause() != null && decodingException.getCause() instanceof EOFException) {
                        logger.info("{} Closed", (Object)TcpConnection.this.addr);
                    } else {
                        logger.warn(TcpConnection.this.addr + " Error", (Throwable)decodingException);
                    }
                    this.vo = decodingException;
                }
                catch (RuntimeServiceResultException runtimeServiceResultException) {
                    ServiceResultException serviceResultException = runtimeServiceResultException.getCause();
                    logger.warn(TcpConnection.this.addr + " Error", (Throwable)serviceResultException);
                    this.vo = serviceResultException;
                }
                catch (Exception exception) {
                    this.vo = new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)exception);
                    logger.error("Error in ReadThread", (Throwable)this.vo);
                }
                catch (StackOverflowError stackOverflowError) {
                    this.vo = new ServiceResultException(StatusCodes.Bad_DecodingError, (Throwable)stackOverflowError);
                    logger.error("Error in ReadThread", (Throwable)this.vo);
                }
            }
            TcpConnection.this.a(this.vo);
        }
    }

    private class a {
        private ByteBuffer[] vl;
        private ByteBuffer[] vm;

        public a(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) {
            this.vl = byteBufferArray;
            this.vm = byteBufferArray2;
        }

        public ByteBuffer[] aPW() {
            return this.vl;
        }

        public ByteBuffer[] aPX() {
            return this.vm;
        }
    }

    public static interface SocketWrapper {
        public void close() throws IOException;

        public void connect(InetSocketAddress var1) throws IOException;

        public void connect(InetSocketAddress var1, int var2) throws IOException;

        public InputStream getInputStream() throws IOException;

        public SocketAddress getLocalSocketAddress();

        public OutputStream getOutputStream() throws IOException;

        public SocketAddress getRemoteSocketAddress();

        public boolean isClosed();

        public boolean isConnected();

        public void setKeepAlive(boolean var1) throws IOException;

        public void setReceiveBufferSize(int var1) throws IOException;

        public void setSendBufferSize(int var1) throws IOException;

        public void setSoTimeout(int var1) throws IOException;

        public void setTcpNoDelay(boolean var1) throws IOException;
    }

    public static interface SocketFactory {
        public SocketWrapper createSocket(TcpConnection var1) throws IOException;
    }

    public static interface ReverseConnectionProvider {
        public SocketWrapper provideOpenReverseConnectionSocket(TcpConnection var1) throws IOException;
    }

    public static class DelegatingSocketWrapper
    implements SocketWrapper {
        protected final Socket delegate;

        public DelegatingSocketWrapper(Socket socket) {
            this.delegate = socket;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void connect(InetSocketAddress inetSocketAddress) throws IOException {
            this.delegate.connect(inetSocketAddress);
        }

        @Override
        public void connect(InetSocketAddress inetSocketAddress, int n2) throws IOException {
            this.delegate.connect(inetSocketAddress, n2);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.delegate.getInputStream();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.delegate.getLocalSocketAddress();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.delegate.getOutputStream();
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this.delegate.getRemoteSocketAddress();
        }

        @Override
        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        @Override
        public boolean isConnected() {
            return this.delegate.isConnected();
        }

        @Override
        public void setKeepAlive(boolean bl) throws IOException {
            this.delegate.setKeepAlive(bl);
        }

        @Override
        public void setReceiveBufferSize(int n2) throws IOException {
            this.delegate.setReceiveBufferSize(n2);
        }

        @Override
        public void setSendBufferSize(int n2) throws IOException {
            this.delegate.setSendBufferSize(n2);
        }

        @Override
        public void setSoTimeout(int n2) throws IOException {
            this.delegate.setSoTimeout(n2);
        }

        @Override
        public void setTcpNoDelay(boolean bl) throws IOException {
            this.delegate.setTcpNoDelay(bl);
        }
    }

    public static class DefaultSocketFactory
    implements SocketFactory {
        @Override
        public SocketWrapper createSocket(TcpConnection tcpConnection) {
            return new DelegatingSocketWrapper(new Socket());
        }
    }

    public static class DefaultReverseConnectionProvider
    implements ReverseConnectionProvider {
        @Override
        public SocketWrapper provideOpenReverseConnectionSocket(TcpConnection tcpConnection) throws IOException {
            final ServerSocket serverSocket = new ServerSocket();
            serverSocket.bind(tcpConnection.addr);
            logger.info("Opened ServerSocket at:{}, waiting ReverseHello connection", (Object)tcpConnection.addr);
            if (tcpConnection.uu > 0) {
                TimerUtil.getTimer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            serverSocket.close();
                        }
                        catch (IOException iOException) {
                            logger.error("Could not close ServerSocket in timeout", (Throwable)iOException);
                        }
                    }
                }, tcpConnection.uu);
            }
            DelegatingSocketWrapper delegatingSocketWrapper = new DelegatingSocketWrapper(serverSocket.accept());
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                try {
                    delegatingSocketWrapper.delegate.close();
                }
                catch (Exception exception) {
                    logger.warn("Closing ReverseHello related ServerSocket failed and also closing the accepted connection failed", (Throwable)exception);
                }
                throw iOException;
            }
            logger.debug("ReverseHello ServerSocket {} closed.", (Object)tcpConnection.addr);
            return delegatingSocketWrapper;
        }
    }
}

