/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.io;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ChannelSecurityToken;
import com.prosysopc.ua.stack.core.CloseSecureChannelRequest;
import com.prosysopc.ua.stack.core.EncodeableSerializer;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.OpenSecureChannelRequest;
import com.prosysopc.ua.stack.core.OpenSecureChannelResponse;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.SecurityTokenRequestType;
import com.prosysopc.ua.stack.core.ServiceFault;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.IEncodeableSerializer;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.IConnectionListener;
import com.prosysopc.ua.stack.transport.SecureChannel;
import com.prosysopc.ua.stack.transport.TransportChannelSettings;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.impl.AsyncResultImpl;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.io.IConnection;
import com.prosysopc.ua.stack.transport.tcp.io.ITransportChannel;
import com.prosysopc.ua.stack.transport.tcp.io.TcpConnection;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.ObjectUtils;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.TimerUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureChannelTcp
implements IConnectionListener,
SecureChannel,
IConnection.IMessageListener,
ITransportChannel {
    static Logger logger = LoggerFactory.getLogger(SecureChannelTcp.class);
    private static final int[] uw = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 120, 120, 120};
    private static final double lQ = 0.1;
    private EncoderContext pX;
    Executor executor = StackUtils.getBlockingWorkExecutor();
    int re = -1;
    long ux;
    long uy;
    IEncodeableSerializer rq = EncodeableSerializer.getInstance();
    TransportChannelSettings uz;
    InetSocketAddress addr;
    AtomicInteger ri = new AtomicInteger(0);
    AtomicReference<IConnection> uA = new AtomicReference<Object>(null);
    Map<Integer, a> rr = new ConcurrentHashMap<Integer, a>();
    int uB = 0;
    TimerTask uC;
    boolean uD = false;
    Object uE = new Object();
    TimerTask uF;
    AtomicReference<TimerTask> rt = new AtomicReference<Object>(null);
    Timer rs;
    Runnable rx = new Runnable(){

        @Override
        public void run() {
            SecureChannelTcp.this.aPL();
            long l2 = System.currentTimeMillis();
            for (a a2 : SecureChannelTcp.this.rr.values()) {
                if (l2 < a2.rA) continue;
                logger.warn("Request id={} timeouted {}ms elapsed. timeout at {}ms", new Object[]{a2.requestId, System.currentTimeMillis() - a2.gO, a2.rA - a2.gO});
                a2.rB.setError(new ServiceResultException(StatusCodes.Bad_Timeout));
                SecureChannelTcp.this.rr.remove(a2.requestId);
            }
            SecureChannelTcp.this.aPM();
        }
    };
    private Runnable uG = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable runnable = SecureChannelTcp.this.uG;
            synchronized (runnable) {
                try {
                    SecureChannelTcp.this.aPT();
                }
                catch (ServiceResultException serviceResultException) {
                    serviceResultException.printStackTrace();
                }
            }
        }
    };
    Runnable uH = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = SecureChannelTcp.this.uE;
            synchronized (object) {
                if (!SecureChannelTcp.this.uD) {
                    return;
                }
            }
            if (!SecureChannelTcp.this.isOpen()) {
                SecureChannelTcp.this.c(false);
                logger.info("{}: Error recovery failed, security token has expired", (Object)SecureChannelTcp.this.re);
                SecureChannelTcp.this.close();
                return;
            }
            try {
                logger.debug("{}: Error recovery reconnect", (Object)SecureChannelTcp.this.re);
                if (SecureChannelTcp.this.aPU() == null) {
                    throw new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
                }
                SecureChannelTcp.this.aPU().open();
                SecureChannelTcp.this.b(true);
                SecureChannelTcp.this.c(false);
                SecureChannelTcp.this.executor.execute(SecureChannelTcp.this.uG);
            }
            catch (ServiceResultException serviceResultException) {
                if (serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_TcpSecureChannelUnknown) || serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_SecureChannelTokenUnknown) || serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_NotFound)) {
                    logger.info(SecureChannelTcp.this.re + ": The secure channel has been closed by the server", (Throwable)serviceResultException);
                    SecureChannelTcp.this.close();
                    return;
                }
                Object object2 = SecureChannelTcp.this.uE;
                synchronized (object2) {
                    ++SecureChannelTcp.this.uB;
                    long l2 = System.currentTimeMillis();
                    long l3 = SecureChannelTcp.this.uB >= uw.length ? (long)(uw[uw.length - 1] * 1000) : (long)(uw[SecureChannelTcp.this.uB] * 1000);
                    long l4 = (long)((double)SecureChannelTcp.this.uy * 1.25) + SecureChannelTcp.this.ux;
                    if (l2 + l3 > l4) {
                        logger.info("{}: Error recovery failed, security token has expired", (Object)SecureChannelTcp.this.re);
                        SecureChannelTcp.this.close();
                        return;
                    }
                    SecureChannelTcp.this.uC = TimerUtil.schedule(SecureChannelTcp.this.rs, SecureChannelTcp.this.uH, SecureChannelTcp.this.executor, l2 + l3);
                }
            }
        }
    };
    private Runnable uI = new Runnable(){

        @Override
        public void run() {
            try {
                logger.debug("{} Renewing security token", (Object)SecureChannelTcp.this.re);
                SecureChannelTcp.this.b(true);
            }
            catch (ServiceResultException serviceResultException) {
                logger.error(SecureChannelTcp.this.re + " Failed to renew security token. ", (Throwable)serviceResultException);
            }
        }
    };

    @Override
    public void close() {
        Cloneable cloneable;
        this.c(false);
        Object object = this.uF;
        this.uF = null;
        if (object != null) {
            ((TimerTask)object).cancel();
        }
        if ((object = this.aPU()) != null) {
            cloneable = new CloseSecureChannelRequest();
            try {
                this.serviceRequest((ServiceRequest)cloneable);
            }
            catch (ServiceResultException serviceResultException) {
                // empty catch block
            }
            if (this.re != -1) {
                logger.info("{} Closed", (Object)this.re);
            }
            this.re = -1;
            object.close();
            object.removeMessageListener(this);
            object.removeConnectionListener(this);
            object.dispose();
            this.setTransportChannel(null);
        }
        this.aPL();
        cloneable = new ArrayList<a>(this.rr.values());
        logger.debug("requests.clear()");
        this.rr.clear();
        if (!cloneable.isEmpty()) {
            ServiceResultException serviceResultException = new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
            Iterator iterator = cloneable.iterator();
            while (iterator.hasNext()) {
                a a2 = (a)iterator.next();
                a2.rB.setError(serviceResultException);
            }
        }
    }

    @Override
    public AsyncResult<SecureChannel> closeAsync() {
        final AsyncResultImpl<SecureChannel> asyncResultImpl = new AsyncResultImpl<SecureChannel>();
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SecureChannelTcp.this.close();
                }
                finally {
                    asyncResultImpl.setResult(SecureChannelTcp.this);
                }
            }
        });
        return asyncResultImpl;
    }

    @Override
    public void dispose() {
        this.close();
        this.uA = null;
        this.rq = null;
        this.uz = null;
        this.addr = null;
        this.rr = null;
        this.rs = null;
    }

    @Override
    public String getConnectURL() {
        return this.getEndpointDescription().getEndpointUrl();
    }

    @Override
    public EndpointConfiguration getEndpointConfiguration() {
        if (this.uz == null) {
            return null;
        }
        return this.uz.getConfiguration();
    }

    @Override
    public EndpointDescription getEndpointDescription() {
        if (this.uz == null) {
            return null;
        }
        return this.uz.getDescription();
    }

    @Override
    public EncoderContext getMessageContext() {
        return this.pX;
    }

    @Override
    public MessageSecurityMode getMessageSecurityMode() {
        return this.getEndpointDescription().getSecurityMode();
    }

    @Override
    public int getOperationTimeout() {
        Integer n2 = this.uz.getConfiguration().getOperationTimeout();
        return n2 == null ? 0 : n2;
    }

    @Override
    public int getSecureChannelId() {
        return this.re;
    }

    @Override
    public SecurityPolicy getSecurityPolicy() {
        try {
            return SecurityPolicy.getSecurityPolicy(this.getEndpointDescription().getSecurityPolicyUri());
        }
        catch (ServiceResultException serviceResultException) {
            return null;
        }
    }

    @Override
    public EnumSet<ITransportChannel.TransportChannelFeature> getSupportedFeatures() {
        return EnumSet.of(ITransportChannel.TransportChannelFeature.open, new ITransportChannel.TransportChannelFeature[]{ITransportChannel.TransportChannelFeature.openAsync, ITransportChannel.TransportChannelFeature.close, ITransportChannel.TransportChannelFeature.closeAync, ITransportChannel.TransportChannelFeature.sendRequest, ITransportChannel.TransportChannelFeature.sendRequestAsync});
    }

    public void initialize(InetSocketAddress inetSocketAddress, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        if (this.re != -1) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, "Cannot reconfigure already opened secure channel");
        }
        this.uz = transportChannelSettings.clone();
        this.addr = inetSocketAddress;
        this.pX = encoderContext;
        this.uC = null;
        this.uB = 0;
        this.rs = TimerUtil.getTimer();
        String string = transportChannelSettings.getDescription().getEndpointUrl();
        if (string != null && !string.isEmpty() && !"opc.tcp".equals(UriUtil.getTransportProtocol(string))) {
            throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid, "The protocol is not supported by the this SecureChannelTcp");
        }
        this.setTransportChannel(new TcpConnection());
        this.aPU().initialize(inetSocketAddress, transportChannelSettings, encoderContext);
        this.aPU().addConnectionListener(this);
        this.aPU().addMessageListener(this);
    }

    @Override
    public void initialize(String string, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        logger.debug("initialize: url={}", (Object)string);
        if (logger.isTraceEnabled()) {
            logger.trace("initialize: settings={}", (Object)ObjectUtils.printFields(transportChannelSettings));
        }
        InetSocketAddress inetSocketAddress = UriUtil.getSocketAddress(string);
        this.initialize(inetSocketAddress, transportChannelSettings, encoderContext);
    }

    @Override
    public void initialize(TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.initialize(transportChannelSettings.getDescription().getEndpointUrl(), transportChannelSettings, encoderContext);
    }

    @Override
    public boolean isOpen() {
        if (this.re == -1) {
            return false;
        }
        long l2 = (long)((double)this.uy * 1.25) + this.ux;
        long l3 = System.currentTimeMillis();
        return l2 > l3;
    }

    @Override
    public void onClosed(ServiceResultException serviceResultException) {
        StatusCode statusCode;
        if (this.re == -1) {
            return;
        }
        StatusCode statusCode2 = statusCode = serviceResultException == null ? null : serviceResultException.getStatusCode();
        if (statusCode != null && statusCode.isStatusCode(StatusCodes.Bad_ConnectionClosed)) {
            this.c(true);
        } else {
            if (serviceResultException == null) {
                serviceResultException = new ServiceResultException(StatusCodes.Bad_UnexpectedError);
            }
            while (!this.rr.isEmpty()) {
                ArrayList<a> arrayList = new ArrayList<a>(this.rr.values());
                for (a a2 : arrayList) {
                    a2.rB.setError(serviceResultException);
                }
                this.rr.values().removeAll(arrayList);
            }
            this.c(false);
        }
        if (statusCode != null && statusCode.isStatusCode(StatusCodes.Bad_ConnectionClosed)) {
            this.c(true);
        }
        boolean bl = serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_ConnectionClosed);
        this.c(bl);
    }

    @Override
    public void onMessage(int n2, int n3, IEncodeable iEncodeable) {
        if (n3 != this.re) {
            return;
        }
        a a2 = this.rr.remove(n2);
        if (a2 == null) {
            if (!(iEncodeable instanceof OpenSecureChannelResponse)) {
                ServiceFault serviceFault;
                ServiceFault serviceFault2 = serviceFault = iEncodeable instanceof ServiceFault ? (ServiceFault)iEncodeable : null;
                if (serviceFault != null && serviceFault.getResponseHeader().getServiceResult().equals(StatusCodes.Bad_TooManyPublishRequests)) {
                    logger.info("ServiceFault={}", (Object)serviceFault);
                } else {
                    logger.warn("{} Unidentified message, RequestId={}, type={}!", new Object[]{n3, n2, iEncodeable.getClass().getSimpleName()});
                    if (serviceFault != null) {
                        logger.warn("ServiceFault={}", (Object)serviceFault);
                    }
                }
            }
            return;
        }
        if (iEncodeable instanceof ServiceFault) {
            a2.rB.setError(new ServiceFaultException((ServiceFault)iEncodeable));
        } else {
            try {
                a2.rB.setResult(iEncodeable);
            }
            catch (ClassCastException classCastException) {
                logger.error("onMessage: Cannot set result", (Throwable)classCastException);
            }
        }
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void open() throws ServiceResultException {
        logger.debug("open");
        if (this.re == -1) {
            try {
                this.aPU().open();
            }
            catch (ServiceResultException serviceResultException) {
                logger.warn("Connection failed: {}", (Object)serviceResultException.getMessage());
                if (serviceResultException.getStatusCode().getValue().equals(StatusCodes.Bad_CommunicationError)) {
                    logger.warn("Bad_CommunicationError: Retrying");
                    this.aPU().open();
                }
                throw serviceResultException;
            }
            this.b(false);
        }
    }

    @Override
    public AsyncResult<SecureChannel> openAsync() {
        final AsyncResultImpl<SecureChannel> asyncResultImpl = new AsyncResultImpl<SecureChannel>();
        if (this.re != -1) {
            asyncResultImpl.setResult(this);
            return asyncResultImpl;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SecureChannelTcp.this.open();
                    asyncResultImpl.setResult(SecureChannelTcp.this);
                }
                catch (ServiceResultException serviceResultException) {
                    asyncResultImpl.setError(serviceResultException);
                }
            }
        });
        return asyncResultImpl;
    }

    @Override
    public <T extends ServiceResponse> T serviceRequest(ServiceRequest<T> serviceRequest) throws ServiceFaultException, ServiceResultException {
        long l2 = this.getRequestTimeout(serviceRequest);
        return this.serviceRequest(serviceRequest, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ServiceResponse> T serviceRequest(ServiceRequest<T> serviceRequest, long l2) throws ServiceFaultException, ServiceResultException {
        int n2 = 0;
        while (!this.isOpen()) {
            try {
                if (n2++ > 100) {
                    throw new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
                }
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        a<T> a2 = this.a(serviceRequest, l2);
        a2.rB = new AsyncResultImpl();
        this.rr.put(a2.requestId, a2);
        logger.debug("serviceRequest: requests.size={}", (Object)this.rr.size());
        try {
            Object object;
            try {
                object = this.aPU();
                if (object != null) {
                    object.sendRequest(serviceRequest, this.re, a2.requestId);
                }
                logger.debug("serviceRequest: Message sent, requestId={} secureChannelId={}", (Object)a2.requestId, (Object)this.re);
                logger.trace("serviceRequest: message={}", serviceRequest);
            }
            catch (ServiceResultException serviceResultException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("serviceRequest: While sending requestId=" + a2.requestId + ", secureChannelId=" + this.re + ", message=" + serviceRequest, (Throwable)serviceResultException);
                }
                if (serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_CommunicationError)) {
                    a2.uO = serviceRequest;
                    this.executor.execute(this.uG);
                }
                throw serviceResultException;
            }
            if (serviceRequest instanceof CloseSecureChannelRequest) {
                object = null;
                return (T)object;
            }
            if (l2 == 0L) {
                object = (ServiceResponse)a2.rB.waitForResult();
            } else {
                long l3 = a2.rA - System.currentTimeMillis();
                object = (ServiceResponse)a2.rB.waitForResult(l3, TimeUnit.MILLISECONDS);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Response: {}", object);
            } else {
                logger.debug("Response: {}", (Object)object.getClass().getSimpleName());
            }
            ResponseHeader responseHeader = object.getResponseHeader();
            StatusCode statusCode = responseHeader.getServiceResult();
            if (statusCode.isBad()) {
                logger.debug("BAD response: {}", (Object)statusCode);
                throw new ServiceFaultException(new ServiceFault(responseHeader));
            }
            Object object2 = object;
            return (T)object2;
        }
        finally {
            this.rr.remove(a2.requestId);
        }
    }

    @Override
    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest) {
        long l2 = this.getRequestTimeout(serviceRequest);
        return this.serviceRequestAsync(serviceRequest, l2);
    }

    @Override
    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest, long l2) {
        AsyncResultImpl asyncResultImpl = new AsyncResultImpl();
        if (!this.isOpen()) {
            asyncResultImpl.setError(new ServiceResultException(StatusCodes.Bad_SecureChannelClosed));
            return asyncResultImpl;
        }
        a<T> a2 = this.a(serviceRequest, l2);
        a2.rB = asyncResultImpl;
        a2.uO = serviceRequest;
        this.rr.put(a2.requestId, a2);
        logger.debug("serviceRequestAsync: requests.size={}", (Object)this.rr.size());
        if (l2 != 0L) {
            this.aPM();
        }
        this.executor.execute(this.uG);
        return asyncResultImpl;
    }

    @Override
    public void setOperationTimeout(int n2) {
        this.uz.getConfiguration().setOperationTimeout(n2);
    }

    public String toString() {
        return "SecureChannel " + this.re + " " + (this.isOpen() ? "open" : "closed");
    }

    private void aPL() {
        TimerTask timerTask = this.rt.getAndSet(null);
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    private void b(boolean bl) throws ServiceResultException {
        IConnection iConnection = this.aPU();
        logger.debug("createSecureChannel: renew={} channel={}", (Object)bl, (Object)iConnection);
        if (iConnection == null) {
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
        }
        long l2 = System.currentTimeMillis();
        int n2 = this.ri.incrementAndGet();
        logger.debug("createSecureChannel: requestId={}", (Object)n2);
        OpenSecureChannelRequest openSecureChannelRequest = new OpenSecureChannelRequest();
        SecurityPolicy securityPolicy = SecurityPolicy.getSecurityPolicy(this.uz.getDescription().getSecurityPolicyUri());
        ByteString byteString = CryptoUtil.createNonce(securityPolicy.getSecureChannelNonceLength());
        Integer n3 = this.uz.getConfiguration().getSecurityTokenLifetime();
        if (n3 == null) {
            n3 = 3600000;
        }
        logger.debug("tokenLifetime: {}", (Object)n3);
        openSecureChannelRequest.setClientNonce(byteString);
        openSecureChannelRequest.setClientProtocolVersion(UnsignedInteger.valueOf(0L));
        openSecureChannelRequest.setRequestedLifetime(UnsignedInteger.valueOf(n3.intValue()));
        openSecureChannelRequest.setRequestType(bl ? SecurityTokenRequestType.Renew : SecurityTokenRequestType.Issue);
        openSecureChannelRequest.setSecurityMode(this.uz.getDescription().getSecurityMode());
        int n4 = bl ? this.re : 0;
        final Semaphore semaphore = new Semaphore(0);
        final ServiceResultException[] serviceResultExceptionArray = new ServiceResultException[1];
        final IEncodeable[] iEncodeableArray = new IEncodeable[1];
        final int[] nArray = new int[1];
        final int n5 = n2;
        IConnection.IMessageListener iMessageListener = new IConnection.IMessageListener(){

            @Override
            public void onMessage(int n2, int n3, IEncodeable iEncodeable) {
                if (n2 != n5) {
                    return;
                }
                iEncodeableArray[0] = iEncodeable;
                nArray[0] = n3;
                semaphore.release(Integer.MAX_VALUE);
            }
        };
        IConnectionListener iConnectionListener = new IConnectionListener(){

            @Override
            public void onClosed(ServiceResultException serviceResultException) {
                if (serviceResultException == null) {
                    serviceResultException = new ServiceResultException(StatusCodes.Bad_CommunicationError, "Connection Closed");
                }
                serviceResultExceptionArray[0] = serviceResultException;
                semaphore.release(Integer.MAX_VALUE);
            }

            @Override
            public void onOpen() {
            }
        };
        iConnection.addConnectionListener(iConnectionListener);
        iConnection.addMessageListener(iMessageListener);
        try {
            iConnection.sendRequest(openSecureChannelRequest, n4, n2);
            try {
                long l3 = this.getOperationTimeout();
                if (l3 > 0L) {
                    long l4 = (System.currentTimeMillis() - l2) / 1000L;
                    long l5 = l3 - l4;
                    semaphore.tryAcquire(1, l5, TimeUnit.MILLISECONDS);
                } else {
                    semaphore.acquire();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (serviceResultExceptionArray[0] != null) {
                throw serviceResultExceptionArray[0];
            }
            IEncodeable iEncodeable = iEncodeableArray[0];
            if (iEncodeable == null) {
                throw new ServiceResultException(StatusCodes.Bad_Timeout);
            }
            if (iEncodeable instanceof ServiceFault) {
                ServiceFaultException serviceFaultException = new ServiceFaultException((ServiceFault)iEncodeable);
                logger.error(nArray + ": CreateSecureChannel Fault", (Throwable)serviceFaultException);
                throw serviceFaultException;
            }
            if (!(iEncodeable instanceof OpenSecureChannelResponse)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Unexpected result " + iEncodeable.getClass().getName() + " OpenSecureChannelResponse expected");
            }
            OpenSecureChannelResponse openSecureChannelResponse = (OpenSecureChannelResponse)iEncodeable;
            ChannelSecurityToken channelSecurityToken = openSecureChannelResponse.getSecurityToken();
            this.re = channelSecurityToken.getChannelId().intValue();
            if (bl) {
                logger.debug("{} Secure channel renewed, SecureChannelId={}, TokenId={}", new Object[]{this.re, this.re, channelSecurityToken.getTokenId().longValue()});
            } else {
                logger.debug("{} Secure channel opened, SecureChannelId={}, TokenId={}", new Object[]{this.re, this.re, channelSecurityToken.getTokenId().longValue()});
            }
            if (bl) {
                this.re = n4;
            }
            long l6 = System.currentTimeMillis();
            this.ux = l2 / 2L + l6 / 2L;
            this.uy = channelSecurityToken.getRevisedLifetime().longValue();
            TimerTask timerTask = this.uF;
            this.uF = null;
            if (timerTask != null) {
                timerTask.cancel();
            }
            long l7 = channelSecurityToken.getRevisedLifetime().longValue();
            logger.debug("RevisedLifetime: {}", (Object)l7);
            this.uF = TimerUtil.schedule(this.rs, this.uI, this.executor, l6 + (long)((double)l7 * 0.75));
        }
        catch (ServiceResultException serviceResultException) {
            throw serviceResultException;
        }
        finally {
            iConnection.removeConnectionListener(iConnectionListener);
            iConnection.removeMessageListener(iMessageListener);
        }
    }

    private a aPR() {
        long l2 = Long.MAX_VALUE;
        a a2 = null;
        logger.debug("getNextTimeoutingPendingRequest: requests.size={}", (Object)this.rr.size());
        for (a a3 : this.rr.values()) {
            if (l2 <= a3.rA) continue;
            l2 = a3.rA;
            a2 = a3;
        }
        return a2;
    }

    private a aPS() {
        for (a a2 : this.rr.values()) {
            if (a2.uO == null) continue;
            return a2;
        }
        return null;
    }

    private <T extends ServiceResponse> a<T> a(ServiceRequest<T> serviceRequest, long l2) {
        a a2 = new a();
        a2.requestId = this.ri.incrementAndGet();
        a2.gO = System.currentTimeMillis();
        a2.rA = l2 == 0L ? Long.MAX_VALUE : (long)((double)a2.gO + (double)l2 * 1.1);
        return a2;
    }

    private void aPM() {
        a a2 = this.aPR();
        if (a2 == null) {
            this.aPL();
        } else {
            TimerTask timerTask = this.rt.get();
            if (timerTask == null || timerTask.scheduledExecutionTime() > a2.rA) {
                this.aPL();
                timerTask = TimerUtil.schedule(this.rs, this.rx, this.executor, a2.rA);
                if (!this.rt.compareAndSet(null, timerTask)) {
                    timerTask.cancel();
                }
            }
        }
    }

    private void aPT() throws ServiceResultException {
        if (!this.isOpen()) {
            return;
        }
        a a2 = null;
        while ((a2 = this.aPS()) != null) {
            IEncodeable iEncodeable = a2.uO;
            a2.uO = null;
            long l2 = System.currentTimeMillis();
            long l3 = l2 - a2.gO;
            if (l2 > a2.rA) {
                logger.debug("Request id={} timeouted {}ms elapsed. timeout at {} ms", new Object[]{a2.requestId, l3, a2.rA - a2.gO});
                this.rr.remove(a2.requestId);
                a2.rB.setError(new ServiceResultException(StatusCodes.Bad_Timeout));
                continue;
            }
            if (iEncodeable == null) continue;
            try {
                logger.debug("sendPendingRequestMessages: requestId={}", (Object)a2.requestId);
                IConnection iConnection = this.aPU();
                if (iConnection == null) continue;
                iConnection.sendRequest((ServiceRequest)iEncodeable, this.re, a2.requestId);
            }
            catch (EncodingException encodingException) {
                this.rr.remove(a2.requestId);
                a2.rB.setError(encodingException);
            }
            catch (ServiceResultException serviceResultException) {
                StatusCode statusCode = serviceResultException.getStatusCode();
                if (statusCode.isStatusCode(StatusCodes.Bad_CommunicationError)) {
                    a2.uO = iEncodeable;
                    continue;
                }
                a2.rB.setError(serviceResultException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c(boolean bl) {
        Object object = this.uE;
        synchronized (object) {
            if (this.uD == bl) {
                return;
            }
            if (bl) {
                logger.info("{}: Error recovery = true", (Object)this.re);
                this.uD = true;
                this.uB = 0;
                long l2 = System.currentTimeMillis();
                this.uC = TimerUtil.schedule(this.rs, this.uH, this.executor, l2 + (long)uw[0]);
            } else {
                logger.info("{}: Error recovery = false", (Object)this.re);
                this.uD = false;
                this.uB = 0;
                this.uC.cancel();
                this.uC = null;
            }
        }
    }

    protected long getRequestTimeout(ServiceRequest serviceRequest) {
        UnsignedInteger unsignedInteger = serviceRequest.getRequestHeader() != null ? serviceRequest.getRequestHeader().getTimeoutHint() : null;
        long l2 = unsignedInteger != null ? unsignedInteger.longValue() : (long)this.getOperationTimeout();
        return l2;
    }

    protected void setTransportChannel(IConnection iConnection) {
        this.uA.set(iConnection);
    }

    IConnection aPU() {
        return this.uA.get();
    }

    static class a<T extends ServiceResponse> {
        long gO = System.currentTimeMillis();
        long rA;
        int requestId;
        AsyncResultImpl<T> rB;
        IEncodeable uO;

        a() {
        }
    }
}

