/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.io;

import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.EnumSet;

public class OpcTcpSettings
implements Cloneable {
    PrivKey ur;
    Cert oC;
    CertificateValidator cb;
    EnumSet<Flag> us = EnumSet.noneOf(Flag.class);
    int ut = -1;
    int connectTimeout = -1;
    int uu = -1;

    public OpcTcpSettings clone() {
        OpcTcpSettings opcTcpSettings = new OpcTcpSettings();
        opcTcpSettings.setClientCertificate(this.oC);
        opcTcpSettings.setCertificateValidator(this.cb);
        opcTcpSettings.setPrivKey(this.ur);
        opcTcpSettings.us = this.us.clone();
        opcTcpSettings.setConnectTimeout(this.connectTimeout);
        opcTcpSettings.setHandshakeTimeout(this.ut);
        opcTcpSettings.setReverseHelloAcceptTimeout(this.uu);
        return opcTcpSettings;
    }

    public CertificateValidator getCertificateValidator() {
        return this.cb;
    }

    public Cert getClientCertificate() {
        return this.oC;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public EnumSet<Flag> getFlags() {
        return this.us;
    }

    public int getHandshakeTimeout() {
        return this.ut;
    }

    public PrivKey getPrivKey() {
        return this.ur;
    }

    public int getReverseHelloAcceptTimeout() {
        return this.uu;
    }

    public void readFrom(OpcTcpSettings opcTcpSettings) {
        if (opcTcpSettings.oC != null) {
            this.oC = opcTcpSettings.oC;
        }
        if (opcTcpSettings.cb != null) {
            this.cb = opcTcpSettings.cb;
        }
        if (opcTcpSettings.ur != null) {
            this.ur = opcTcpSettings.ur;
        }
        this.us = opcTcpSettings.us;
        this.uu = opcTcpSettings.uu;
        this.ut = opcTcpSettings.ut;
        this.connectTimeout = opcTcpSettings.connectTimeout;
    }

    public void setCertificateValidator(CertificateValidator certificateValidator) {
        this.cb = certificateValidator;
    }

    public void setClientCertificate(Cert cert) {
        this.oC = cert;
    }

    public void setClientCertificate(X509Certificate x509Certificate) throws CertificateEncodingException {
        this.oC = new Cert(x509Certificate);
    }

    public void setConnectTimeout(int n2) {
        this.connectTimeout = n2;
    }

    public void setFlags(EnumSet<Flag> enumSet) {
        this.us = enumSet;
    }

    public void setHandshakeTimeout(int n2) {
        this.ut = n2;
    }

    public void setPrivKey(PrivKey privKey) {
        this.ur = privKey;
    }

    public void setReverseHelloAcceptTimeout(int n2) {
        this.uu = n2;
    }

    public static enum Flag {
        MultiThread;

    }
}

