/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.impl;

import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.SecurityToken;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkSymmEncryptSigner
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(ChunkSymmEncryptSigner.class);
    ByteBuffer tQ;
    ByteBuffer ub;
    SecurityToken ua;

    public ChunkSymmEncryptSigner(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, SecurityToken securityToken) {
        this.tQ = byteBuffer;
        this.ub = byteBuffer2;
        this.ua = securityToken;
    }

    @Override
    public void run() throws RuntimeServiceResultException {
        SecurityPolicy securityPolicy = this.ua.getSecurityPolicy();
        MessageSecurityMode messageSecurityMode = this.ua.getMessageSecurityMode();
        try {
            byte[] byArray;
            int n2;
            int n3 = this.tQ.limit();
            int n4 = this.ub.limit();
            int n5 = 8;
            int n6 = 8;
            int n7 = 8;
            int n8 = securityPolicy.getSymmetricSignatureSize();
            if (messageSecurityMode == MessageSecurityMode.Sign || messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                n2 = n3 - n8;
                byArray = new byte[n8];
                this.a(this.ua, this.tQ.array(), n2, byArray);
                this.tQ.position(n3 - n8);
                this.tQ.put(byArray, 0, n8);
                if (logger.isTraceEnabled()) {
                    logger.trace("signature={}", (Object)CryptoUtil.toHex(byArray));
                }
            }
            n2 = 0;
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                this.tQ.position(n3 - n8 - 1);
                n2 = this.tQ.get() + 1;
            }
            this.tQ.position(4);
            this.tQ.putInt(n3);
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                byArray = new byte[n5 + n4 + n2 + n8];
                this.tQ.position(n6 + n7);
                this.tQ.get(byArray);
                this.b(this.ua, byArray, 0, byArray.length, this.tQ.array(), n6 + n7);
            }
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }

    private int b(SecurityToken securityToken, byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ServiceResultException {
        return CryptoUtil.getCryptoProvider().encryptSymm(securityToken.getSecurityPolicy(), securityToken.getLocalEncryptingKey(), securityToken.getLocalInitializationVector(), byArray, n2, n3, byArray2, n4);
    }

    private void a(SecurityToken securityToken, byte[] byArray, int n2, byte[] byArray2) throws ServiceResultException {
        CryptoUtil.getCryptoProvider().signSymm(securityToken.getSecurityPolicy(), securityToken.getLocalSigningKey(), byArray, 0, n2, byArray2, 0);
    }
}

