/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityPolicyUri;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public enum SecurityPolicy {
    NONE("http://opcfoundation.org/UA/SecurityPolicy#None", null, null, null, null, null, null, 0, 0, 0, 1, 1024, 2048, 0),
    BASIC128RSA15("http://opcfoundation.org/UA/SecurityPolicy#Basic128Rsa15", SecurityAlgorithm.HmacSha1, SecurityAlgorithm.Aes128, SecurityAlgorithm.RsaSha1, SecurityAlgorithm.KwRsa15, SecurityAlgorithm.Rsa15, SecurityAlgorithm.PSha1, 20, 16, 16, 16, 1024, 2048, 16),
    BASIC256("http://opcfoundation.org/UA/SecurityPolicy#Basic256", SecurityAlgorithm.HmacSha1, SecurityAlgorithm.Aes256, SecurityAlgorithm.RsaSha1, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep, SecurityAlgorithm.PSha1, 20, 24, 32, 16, 1024, 2048, 32),
    BASIC256SHA256("http://opcfoundation.org/UA/SecurityPolicy#Basic256Sha256", SecurityAlgorithm.HmacSha256, SecurityAlgorithm.Aes256, SecurityAlgorithm.RsaSha256, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep, SecurityAlgorithm.PSha256, 32, 32, 32, 16, 2048, 4096, 32),
    AES128_SHA256_RSAOAEP("http://opcfoundation.org/UA/SecurityPolicy#Aes128_Sha256_RsaOaep", SecurityAlgorithm.HmacSha256, SecurityAlgorithm.Aes128, SecurityAlgorithm.RsaSha256, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep, SecurityAlgorithm.PSha256, 32, 32, 16, 16, 2048, 4096, 32),
    AES256_SHA256_RSAPSS("http://opcfoundation.org/UA/SecurityPolicy#Aes256_Sha256_RsaPss", SecurityAlgorithm.HmacSha256, SecurityAlgorithm.Aes256, SecurityAlgorithm.RsaPssSha256, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep256, SecurityAlgorithm.PSha256, 32, 32, 32, 16, 2048, 4096, 32);

    public static final Set<SecurityPolicy> ALL_SECURE_101;
    public static final Set<SecurityPolicy> ALL_SECURE_102;
    public static final Set<SecurityPolicy> ALL_SECURE_103;
    public static final Set<SecurityPolicy> ALL_SECURE_104;
    public static final SecurityPolicy[] EMPTY_ARRAY;
    private static Map<String, SecurityPolicy> tw;
    private final SecurityAlgorithm tx;
    private final SecurityAlgorithm ty;
    private final SecurityAlgorithm tz;
    private final byte[] tA;
    private final int tB;
    private final int tC;
    private final SecurityAlgorithm tD;
    private final int td;
    private final int te;
    private final String tf;
    private final int tE;
    private final SecurityAlgorithm tF;
    private final SecurityAlgorithm tG;
    private final int tH;
    private final int tI;

    @Deprecated
    public static SecurityPolicy[] getAllSecurityPolicies() {
        return SecurityPolicy.values();
    }

    public static SecurityPolicy getSecurityPolicy(String string) throws ServiceResultException {
        if (string == null) {
            return NONE;
        }
        SecurityPolicy securityPolicy = tw.get(string);
        if (securityPolicy == null) {
            throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected);
        }
        return securityPolicy;
    }

    private static void a(SecurityPolicy securityPolicy) {
        tw.put(securityPolicy.tf, securityPolicy);
    }

    private SecurityPolicy(String string2, SecurityAlgorithm securityAlgorithm, SecurityAlgorithm securityAlgorithm2, SecurityAlgorithm securityAlgorithm3, SecurityAlgorithm securityAlgorithm4, SecurityAlgorithm securityAlgorithm5, SecurityAlgorithm securityAlgorithm6, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.tx = securityAlgorithm5;
        this.ty = securityAlgorithm4;
        this.tz = securityAlgorithm3;
        this.tD = securityAlgorithm6;
        this.tf = string2;
        this.tF = securityAlgorithm2;
        this.tG = securityAlgorithm;
        this.tA = string2.getBytes(SecurityPolicyUri.UTF8);
        this.tH = n3;
        this.tE = n4;
        this.tC = n5;
        this.tB = n6;
        this.te = n7;
        this.td = n8;
        this.tI = n9;
    }

    public SecurityAlgorithm getAsymmetricEncryptionAlgorithm() {
        return this.tx;
    }

    public SecurityAlgorithm getAsymmetricKeyWrapAlgorithm() {
        return this.ty;
    }

    public SecurityAlgorithm getAsymmetricSignatureAlgorithm() {
        return this.tz;
    }

    public byte[] getEncodedPolicyUri() {
        return this.tA;
    }

    public int getEncryptionBlockSize() {
        return this.tB;
    }

    public int getEncryptionKeySize() {
        return this.tC;
    }

    public SecurityAlgorithm getKeyDerivationAlgorithm() {
        return this.tD;
    }

    public int getMaxAsymmetricKeyLength() {
        return this.td;
    }

    public int getMinAsymmetricKeyLength() {
        return this.te;
    }

    public String getPolicyUri() {
        return this.tf;
    }

    public int getSecureChannelNonceLength() {
        return this.tI;
    }

    public int getSignatureKeySize() {
        return this.tE;
    }

    public SecurityAlgorithm getSymmetricEncryptionAlgorithm() {
        return this.tF;
    }

    public SecurityAlgorithm getSymmetricSignatureAlgorithm() {
        return this.tG;
    }

    public int getSymmetricSignatureSize() {
        return this.tH;
    }

    public boolean isUsableWith(Cert cert) {
        int n2 = cert.getKeySize();
        return n2 >= this.te && n2 <= this.td;
    }

    public String toString() {
        return this.tf;
    }

    static {
        ALL_SECURE_101 = Collections.unmodifiableSet(EnumSet.of(BASIC128RSA15, BASIC256));
        ALL_SECURE_102 = Collections.unmodifiableSet(EnumSet.of(BASIC128RSA15, BASIC256, BASIC256SHA256));
        ALL_SECURE_103 = Collections.unmodifiableSet(EnumSet.of(BASIC128RSA15, BASIC256, BASIC256SHA256));
        ALL_SECURE_104 = Collections.unmodifiableSet(EnumSet.of(BASIC256SHA256, AES128_SHA256_RSAOAEP, AES256_SHA256_RSAPSS));
        EMPTY_ARRAY = new SecurityPolicy[0];
        tw = new ConcurrentHashMap<String, SecurityPolicy>();
        SecurityPolicy.a(NONE);
        SecurityPolicy.a(BASIC128RSA15);
        SecurityPolicy.a(BASIC256);
        SecurityPolicy.a(BASIC256SHA256);
        SecurityPolicy.a(AES128_SHA256_RSAOAEP);
        SecurityPolicy.a(AES256_SHA256_RSAPSS);
    }
}

