/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConfiguration {
    public static final SecurityConfiguration NO_SECURITY;
    static Logger ou;
    SecurityMode ts;
    KeyPair tt = null;
    Cert tu = null;

    public SecurityConfiguration(SecurityMode securityMode, KeyPair keyPair, Cert cert) {
        if (securityMode == null) {
            throw new NullPointerException("SecurityMode mode is null");
        }
        this.ts = securityMode;
        if (securityMode.hasSigning()) {
            if (keyPair == null) {
                throw new NullPointerException("localApplicationInstanceCertificate is null");
            }
            this.tt = keyPair;
            if (cert == null) {
                throw new NullPointerException("remoteCertificate is null");
            }
            this.tu = cert;
        }
    }

    public byte[] getEncodedLocalCertificate() {
        if (this.tt == null) {
            return null;
        }
        return this.tt.getCertificate().getEncoded();
    }

    public byte[] getEncodedLocalCertificateThumbprint() {
        if (this.tt == null) {
            return null;
        }
        return this.tt.getCertificate().getEncodedThumbprint();
    }

    public byte[] getEncodedLocalPrivateKey() {
        if (this.tt == null) {
            return null;
        }
        return this.tt.getPrivateKey().getPrivateKey().getEncoded();
    }

    public byte[] getEncodedRemoteCertificate() {
        if (this.tu == null) {
            return null;
        }
        return this.tu.getEncoded();
    }

    public byte[] getEncodedRemoteCertificateThumbprint() {
        if (this.tu == null) {
            return null;
        }
        return this.tu.getEncodedThumbprint();
    }

    public Certificate getLocalCertificate() {
        if (this.tt == null) {
            return null;
        }
        return this.tt.getCertificate().getCertificate();
    }

    public KeyPair getLocalCertificate2() {
        return this.tt;
    }

    public RSAPrivateKey getLocalPrivateKey() {
        if (this.tt == null) {
            return null;
        }
        return this.tt.getPrivateKey().getPrivateKey();
    }

    public MessageSecurityMode getMessageSecurityMode() {
        return this.ts.getMessageSecurityMode();
    }

    public Certificate getReceiverCertificate() {
        if (this.tu == null) {
            return null;
        }
        return this.tu.getCertificate();
    }

    public Certificate getRemoteCertificate() {
        if (this.tu == null) {
            return null;
        }
        return this.tu.getCertificate();
    }

    public Cert getRemoteCertificate2() {
        return this.tu;
    }

    public SecurityMode getSecurityMode() {
        return this.ts;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.ts.getSecurityPolicy();
    }

    static {
        ou = LoggerFactory.getLogger(SecurityConfiguration.class);
        NO_SECURITY = new SecurityConfiguration(SecurityMode.NONE, null, null);
    }
}

