/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.utils.CertificateUtils;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.FileUtil;
import com.prosysopc.ua.stack.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Scanner;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivKey {
    private static final String ti = StringUtils.lineSeparator() + "-----END RSA PRIVATE KEY-----";
    private static final String tj = "-----BEGIN RSA PRIVATE KEY-----" + StringUtils.lineSeparator();
    private static final String tk = "-----END .*PRIVATE KEY-----";
    private static final String tl = "-----BEGIN .*PRIVATE KEY-----";
    private static Logger logger = LoggerFactory.getLogger(PrivKey.class);
    public final RSAPrivateKey privateKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivKey load(byte[] byArray, String string) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidParameterSpecException {
        boolean bl = false;
        String string2 = "";
        byte[] byArray2 = null;
        if (byArray[0] == 45 && byArray[1] == 45 && byArray[2] == 45 || byArray[3] == 45 && byArray[4] == 45 && byArray[5] == 45) {
            boolean bl2;
            StringBuilder stringBuilder;
            String string3 = new String(byArray);
            Scanner scanner = new Scanner(string3);
            try {
                stringBuilder = new StringBuilder();
                String string4 = "";
                bl2 = false;
                while (scanner.hasNextLine()) {
                    String string5 = scanner.nextLine();
                    if (string5.matches(tl)) {
                        bl2 = true;
                        continue;
                    }
                    if (string5.matches(tk)) {
                        break;
                    }
                    if (string5.startsWith("Proc-Type: 4,ENCRYPTED")) {
                        bl = true;
                        continue;
                    }
                    if (string5.startsWith("DEK-Info:")) {
                        String[] stringArray = string5.substring(10).split(",");
                        string2 = stringArray[0];
                        string4 = stringArray[1];
                        byArray2 = CryptoUtil.hexToBytes(string4);
                        continue;
                    }
                    stringBuilder.append(string5.trim());
                }
            }
            finally {
                scanner.close();
            }
            if (bl2) {
                byArray = CryptoUtil.base64Decode(stringBuilder.toString());
            }
        }
        if (bl) {
            if (string == null || string.isEmpty()) {
                throw new SecurityException("Encrypted private key requires a password.");
            }
            return new PrivKey(CertificateUtils.readPrivateKey(new ByteArrayInputStream(byArray), string, "AES-128-CBC").getEncoded());
        }
        return new PrivKey(byArray);
    }

    @Deprecated
    public static PrivKey load(File file) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] byArray = FileUtil.readFile(file);
        return new PrivKey(byArray);
    }

    public static PrivKey load(File file, String string) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidParameterSpecException {
        if (file.length() < 3L) {
            throw new IllegalArgumentException("file is not a valid private key (too short file)");
        }
        if (string == null || string.isEmpty()) {
            byte[] byArray = FileUtil.readFile(file);
            return PrivKey.load(byArray, string);
        }
        return new PrivKey(CertificateUtils.readPrivateKey(file, string, "AES-128-CBC").getEncoded());
    }

    public static PrivKey load(InputStream inputStream, String string) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidParameterSpecException {
        byte[] byArray = FileUtil.readStream(inputStream);
        return PrivKey.load(byArray, string);
    }

    public static PrivKey loadFromKeyStore(File file, String string) throws IOException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        return PrivKey.loadFromKeyStore(file.toURI().toURL(), string);
    }

    public static PrivKey loadFromKeyStore(URL uRL, String string) throws IOException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        RSAPrivateKey rSAPrivateKey = CertificateUtils.loadFromKeyStore(uRL, string);
        return new PrivKey(rSAPrivateKey);
    }

    private static byte[] a(int n2, byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray3 = new byte[messageDigest.getDigestLength()];
        byte[] byArray4 = new byte[n2];
        int n3 = 0;
        while (true) {
            messageDigest.update(byArray, 0, byArray.length);
            messageDigest.update(byArray2, 0, byArray2.length);
            byArray3 = messageDigest.digest();
            int n4 = n2 > byArray3.length ? byArray3.length : n2;
            System.arraycopy(byArray3, 0, byArray4, n3, n4);
            n3 += n4;
            if ((n2 -= n4) == 0) break;
            messageDigest.reset();
            messageDigest.update(byArray3, 0, byArray3.length);
        }
        return byArray4;
    }

    public PrivKey(byte[] byArray) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        if (byArray == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.privateKey = this.c(byArray);
    }

    public PrivKey(RSAPrivateKey rSAPrivateKey) {
        this.privateKey = rSAPrivateKey;
    }

    public byte[] getEncodedPrivateKey() {
        return this.privateKey.getEncoded();
    }

    public RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void save(File file) throws IOException {
        FileUtil.writeFile(file, this.getEncodedPrivateKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file, String string) throws IOException {
        if (string == null || string.length() == 0) {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(this.getPrivateKey().getEncoded());
            FileWriter fileWriter = new FileWriter(file);
            try {
                fileWriter.append(tj);
                fileWriter.append(StringUtils.addLineBreaks(CryptoUtil.base64Encode(pKCS8EncodedKeySpec.getEncoded()), 64));
                fileWriter.append(ti);
            }
            finally {
                fileWriter.close();
            }
        } else {
            CertificateUtils.writePrivateKey((PrivateKey)this.getPrivateKey(), file, string, "AES-128-CBC");
        }
    }

    public void saveToKeyStore(Cert cert, File file, String string, String string2, String string3) throws IOException, KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException {
        String string4 = "key";
        CertificateUtils.saveToProtectedStore(this.getPrivateKey(), cert.getCertificate(), file, string4, string, string2, string3);
    }

    private RSAPrivateKey c(byte[] byArray) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (Exception exception) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA", CryptoUtil.getSecurityProviderName());
                return (RSAPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                logger.error("Could not read private key with default Provider and Bouncy Castle not available");
                throw new RuntimeException("Could not read private key with default Provider and Bouncy Castle not available", noSuchProviderException);
            }
        }
    }
}

