/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

public final class KeyPair {
    public final Cert certificate;
    public final PrivKey privateKey;

    public static KeyPair load(File file, File file2, String string) throws IOException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        Cert cert = Cert.load(file);
        PrivKey privKey = PrivKey.loadFromKeyStore(file2, string);
        return new KeyPair(cert, privKey);
    }

    public static KeyPair load(URL uRL, URL uRL2, String string) throws IOException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        Cert cert = Cert.load(uRL);
        PrivKey privKey = PrivKey.loadFromKeyStore(uRL2, string);
        return new KeyPair(cert, privKey);
    }

    public KeyPair(Cert cert, PrivKey privKey) {
        if (cert == null || privKey == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.certificate = cert;
        this.privateKey = privKey;
    }

    public Cert getCertificate() {
        return this.certificate;
    }

    public PrivKey getPrivateKey() {
        return this.privateKey;
    }

    public void save(File file, File file2) throws IOException {
        this.certificate.save(file);
        this.privateKey.save(file2);
    }

    public void save(File file, File file2, String string) throws IOException {
        this.certificate.save(file);
        this.privateKey.save(file2, string);
    }

    public String toString() {
        return this.certificate.toString();
    }
}

