/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.X509TrustManager;

public class CertValidatorTrustManager
implements X509TrustManager {
    CertificateValidator sV;
    Map<X509Certificate, Cert> sW = new HashMap<X509Certificate, Cert>();
    List<Cert> sX = new ArrayList<Cert>();
    List<Cert> sY = new ArrayList<Cert>();
    X509Certificate[] sZ;

    public CertValidatorTrustManager(CertificateValidator certificateValidator) {
        this.sV = certificateValidator;
    }

    @Override
    public synchronized void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        for (X509Certificate x509Certificate : x509CertificateArray) {
            this.a(x509Certificate);
        }
    }

    @Override
    public synchronized void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        for (X509Certificate x509Certificate : x509CertificateArray) {
            this.a(x509Certificate);
        }
    }

    @Override
    public synchronized X509Certificate[] getAcceptedIssuers() {
        if (this.sZ == null) {
            int n2 = this.sY.size();
            this.sZ = new X509Certificate[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                Cert cert = this.sY.get(i2);
                this.sZ[i2] = cert.getCertificate();
            }
        }
        return this.sZ;
    }

    synchronized void a(X509Certificate x509Certificate) throws CertificateException {
        Cert cert = this.sW.get(x509Certificate);
        if (cert == null) {
            cert = new Cert(x509Certificate);
            this.sW.put(x509Certificate, cert);
        }
        if (!this.sX.contains(cert)) {
            boolean bl;
            StatusCode statusCode = this.sV.validateCertificate(cert);
            boolean bl2 = bl = statusCode == null || statusCode.isGood();
            if (bl) {
                this.sX.add(cert);
            } else {
                throw new CertificateException("Certificate is not valid: " + statusCode);
            }
        }
    }
}

