/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.impl;

import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.ResultListener;
import com.prosysopc.ua.stack.utils.StackUtils;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncResultImpl<T>
implements AsyncResult<T> {
    static Logger logger = LoggerFactory.getLogger(AsyncResultImpl.class);
    static Logger sM = LoggerFactory.getLogger(ResultListener.class);
    static Executor executor = StackUtils.getBlockingWorkExecutor();
    ServiceResultException sN;
    T result;
    ResultListener<T> sO;
    Semaphore sP = new Semaphore(0);

    @Override
    public ServiceResultException getError() {
        return this.sN;
    }

    @Override
    public T getResult() {
        return this.result;
    }

    @Override
    public AsyncResult.AsyncResultStatus getStatus() {
        if (this.sN != null) {
            return AsyncResult.AsyncResultStatus.Failed;
        }
        if (this.result != null) {
            return AsyncResult.AsyncResultStatus.Succeed;
        }
        return AsyncResult.AsyncResultStatus.Waiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setError(final ServiceResultException serviceResultException) {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.isFinished()) {
                return;
            }
            this.sN = serviceResultException;
            final ResultListener<T> resultListener = this.sO;
            if (resultListener != null) {
                executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            resultListener.onError(serviceResultException);
                        }
                        catch (RuntimeException runtimeException) {
                            sM.error("Unexpected RuntimeException in ResultListener#onError(", (Throwable)runtimeException);
                        }
                        finally {
                            AsyncResultImpl.this.finish();
                        }
                    }
                });
            }
        }
        this.sP.release(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorSync(ServiceResultException serviceResultException) throws RuntimeException {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.isFinished()) {
                return;
            }
            this.sN = serviceResultException;
            ResultListener<T> resultListener = this.sO;
            if (resultListener != null) {
                try {
                    resultListener.onError(serviceResultException);
                }
                catch (RuntimeException runtimeException) {
                    sM.error("Unexpected RuntimeException in ResultListener#onError(", (Throwable)runtimeException);
                }
                finally {
                    this.finish();
                }
            }
        }
        this.sP.release(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListener(ResultListener<T> resultListener) {
        T t;
        ServiceResultException serviceResultException;
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            this.sO = resultListener;
            serviceResultException = this.sN;
            t = this.result;
        }
        if (resultListener != null) {
            if (t != null) {
                resultListener.onCompleted(t);
            }
            if (serviceResultException != null) {
                resultListener.onError(serviceResultException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(T t) {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.isFinished()) {
                return;
            }
            this.result = t;
            final ResultListener<T> resultListener = this.sO;
            if (resultListener != null) {
                executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            resultListener.onCompleted(AsyncResultImpl.this.result);
                        }
                        catch (RuntimeException runtimeException) {
                            sM.error("Unexpected RuntimeException in ResultListener#onCompleted", (Throwable)runtimeException);
                        }
                        finally {
                            AsyncResultImpl.this.finish();
                        }
                    }
                });
            }
        }
        this.sP.release(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultSync(T t) throws RuntimeException {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.isFinished()) {
                return;
            }
            this.result = t;
            ResultListener<T> resultListener = this.sO;
            if (resultListener != null) {
                try {
                    resultListener.onCompleted(t);
                }
                catch (RuntimeException runtimeException) {
                    sM.error("Unexpected RuntimeException in ResultListener#onCompleted(", (Throwable)runtimeException);
                }
                finally {
                    this.finish();
                }
            }
        }
        this.sP.release(Integer.MAX_VALUE);
    }

    public void setSource(AsyncResult<T> asyncResult) {
        asyncResult.setListener(new ResultListener<T>(){

            @Override
            public void onCompleted(T t) {
                AsyncResultImpl.this.setResult(t);
            }

            @Override
            public void onError(ServiceResultException serviceResultException) {
                AsyncResultImpl.this.setError(serviceResultException);
            }
        });
    }

    @Override
    public T waitForResult() throws ServiceResultException {
        try {
            this.sP.acquire();
        }
        catch (InterruptedException interruptedException) {
            logger.debug("timeout: ", (Throwable)this.sN);
            throw new ServiceResultException(StatusCodes.Bad_Timeout, (Throwable)interruptedException);
        }
        if (this.result != null) {
            return this.result;
        }
        if (this.sN != null) {
            logger.debug("error: ", (Throwable)this.sN);
            if (this.sN instanceof ServiceFaultException) {
                throw new ServiceFaultException(((ServiceFaultException)this.sN).getServiceFault());
            }
            throw this.sN;
        }
        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
    }

    @Override
    public T waitForResult(long l2, TimeUnit timeUnit) throws ServiceResultException {
        try {
            this.sP.tryAcquire(l2, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            throw new ServiceResultException(StatusCodes.Bad_Timeout, (Throwable)interruptedException);
        }
        if (this.result != null) {
            return this.result;
        }
        logger.debug("error:", (Throwable)this.sN);
        if (this.sN != null) {
            if (this.sN instanceof ServiceFaultException) {
                throw new ServiceFaultException(((ServiceFaultException)this.sN).getServiceFault());
            }
            throw this.sN;
        }
        throw new ServiceResultException(StatusCodes.Bad_Timeout);
    }

    private void finish() {
        this.setListener(null);
    }

    private boolean isFinished() {
        return this.result != null || this.sN != null;
    }
}

