/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.https;

import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertValidatorTrustManager;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.HttpsSecurityPolicy;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.params.HttpParams;

public class HttpsSettings {
    X509KeyManager sH;
    TrustManager sI;
    X509HostnameVerifier sJ;
    String username;
    String password;
    HttpParams sK;
    private HttpsSecurityPolicy[] sL;

    public HttpsSettings() {
    }

    public HttpsSettings(KeyPair keyPair, CertificateValidator certificateValidator, X509HostnameVerifier x509HostnameVerifier) {
        this.setKeyPair(keyPair, new Cert[0]);
        this.setCertificateValidator(certificateValidator);
        this.sJ = x509HostnameVerifier;
    }

    public HttpsSettings(X509KeyManager x509KeyManager, TrustManager trustManager, X509HostnameVerifier x509HostnameVerifier) {
        this.sH = x509KeyManager;
        this.sI = trustManager;
        this.sJ = x509HostnameVerifier;
    }

    public HttpsSettings(X509KeyManager x509KeyManager, TrustManager trustManager, X509HostnameVerifier x509HostnameVerifier, String string, String string2) {
        this.sH = x509KeyManager;
        this.sI = trustManager;
        this.sJ = x509HostnameVerifier;
        this.username = string;
        this.password = string2;
    }

    public HttpsSettings clone() {
        HttpsSettings httpsSettings = new HttpsSettings();
        httpsSettings.sJ = this.sJ;
        httpsSettings.sI = this.sI;
        httpsSettings.sH = this.sH;
        httpsSettings.username = this.username;
        httpsSettings.password = this.password;
        httpsSettings.sK = this.sK;
        httpsSettings.sL = this.sL;
        return httpsSettings;
    }

    public X509HostnameVerifier getHostnameVerifier() {
        return this.sJ;
    }

    public HttpParams getHttpParams() {
        return this.sK;
    }

    public HttpsSecurityPolicy[] getHttpsSecurityPolicies() {
        return this.sL;
    }

    public X509KeyManager getKeyManager() {
        return this.sH;
    }

    public KeyManager[] getKeyManagers() {
        KeyManager[] keyManagerArray;
        if (this.sH == null) {
            keyManagerArray = new KeyManager[]{};
        } else {
            KeyManager[] keyManagerArray2 = new KeyManager[1];
            keyManagerArray = keyManagerArray2;
            keyManagerArray2[0] = this.sH;
        }
        return keyManagerArray;
    }

    public String getPassword() {
        return this.password;
    }

    public TrustManager getTrustManager() {
        return this.sI;
    }

    public TrustManager[] getTrustManagers() {
        TrustManager[] trustManagerArray;
        if (this.sI == null) {
            trustManagerArray = new TrustManager[]{};
        } else {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = this.sI;
        }
        return trustManagerArray;
    }

    public String getUsername() {
        return this.username;
    }

    public void readFrom(HttpsSettings httpsSettings) {
        if (httpsSettings.sJ != null) {
            this.sJ = httpsSettings.sJ;
        }
        if (httpsSettings.sI != null) {
            this.sI = httpsSettings.sI;
        }
        if (httpsSettings.sH != null) {
            this.sH = httpsSettings.sH;
        }
        if (httpsSettings.username != null && httpsSettings.password != null) {
            this.username = httpsSettings.username;
            this.password = httpsSettings.password;
        }
        if (httpsSettings.sK != null) {
            this.sK = httpsSettings.sK;
        }
        if (httpsSettings.sL != null) {
            this.sL = httpsSettings.sL;
        }
    }

    public void setCertificateValidator(CertificateValidator certificateValidator) {
        this.sI = new CertValidatorTrustManager(certificateValidator);
    }

    public void setHostnameVerifier(X509HostnameVerifier x509HostnameVerifier) {
        this.sJ = x509HostnameVerifier;
    }

    public void setHttpParams(HttpParams httpParams) {
        this.sK = httpParams;
    }

    public void setHttpsAuth(String string, String string2) {
        this.username = string;
        this.password = string2;
    }

    public void setHttpsSecurityPolicies(HttpsSecurityPolicy ... httpsSecurityPolicyArray) {
        this.sL = httpsSecurityPolicyArray;
    }

    public void setHttpsSecurityPolicies(Set<HttpsSecurityPolicy> set) {
        this.setHttpsSecurityPolicies(set.toArray(HttpsSecurityPolicy.EMPTY_ARRAY));
    }

    public void setKeyManager(X509KeyManager x509KeyManager) throws ServiceResultException {
        this.sH = x509KeyManager;
    }

    public void setKeyPair(KeyPair keyPair, Cert ... certArray) {
        if (keyPair != null) {
            try {
                KeyStore keyStore = KeyStore.getInstance("jks");
                Certificate[] certificateArray = new Certificate[]{keyPair.certificate.certificate};
                KeyStore.PrivateKeyEntry privateKeyEntry = new KeyStore.PrivateKeyEntry(keyPair.privateKey.getPrivateKey(), certificateArray);
                String string = "";
                keyStore.load(null);
                keyStore.setEntry("myentry-" + keyPair.hashCode(), privateKeyEntry, new KeyStore.PasswordProtection(string.toCharArray()));
                int n2 = certArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string2 = "cacert-" + (i2 + 1);
                    keyStore.setEntry(string2, new KeyStore.TrustedCertificateEntry(certArray[i2].certificate), null);
                }
                this.setKeyStore(keyStore, "");
            }
            catch (KeyStoreException keyStoreException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException(noSuchAlgorithmException);
            }
            catch (CertificateException certificateException) {
                throw new RuntimeException(certificateException);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            catch (ServiceResultException serviceResultException) {
                throw new RuntimeException(serviceResultException);
            }
        }
    }

    public void setKeyPairs(KeyPair[] keyPairArray, Cert ... certArray) {
        try {
            Object object;
            int n2;
            KeyStore keyStore = KeyStore.getInstance("jks");
            String string = "";
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(string.toCharArray());
            keyStore.load(null);
            for (n2 = 0; n2 < keyPairArray.length; ++n2) {
                Certificate[] certificateArray = new Certificate[1 + certArray.length];
                certificateArray[0] = keyPairArray[n2].certificate.certificate;
                for (int i2 = 0; i2 < certArray.length; ++i2) {
                    certificateArray[i2 + 1] = certArray[i2].certificate;
                }
                object = new KeyStore.PrivateKeyEntry(keyPairArray[n2].privateKey.privateKey, certificateArray);
                keyStore.setEntry("my-key-pair-entry-" + (n2 + 1), (KeyStore.Entry)object, passwordProtection);
            }
            n2 = certArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                object = "cacert-" + (i3 + 1);
                keyStore.setEntry((String)object, new KeyStore.TrustedCertificateEntry(certArray[i3].certificate), null);
            }
            this.setKeyStore(keyStore, "");
        }
        catch (KeyStoreException keyStoreException) {
            throw new RuntimeException(keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException(certificateException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeException(serviceResultException);
        }
    }

    public void setKeyStore(KeyStore keyStore, String string) throws ServiceResultException {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, string.toCharArray());
            KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
            this.sH = keyManagerArray.length == 0 ? null : (X509KeyManager)keyManagerArray[0];
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ServiceResultException(noSuchAlgorithmException);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new ServiceResultException(unrecoverableKeyException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new ServiceResultException(keyStoreException);
        }
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setTrustManager(TrustManager trustManager) throws ServiceResultException {
        this.sI = trustManager;
    }

    public void setUsername(String string) {
        this.username = string;
    }
}

