/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.https;

import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.CloseableObjectState;
import com.prosysopc.ua.stack.transport.IConnectionListener;
import com.prosysopc.ua.stack.transport.ServerConnection;
import com.prosysopc.ua.stack.transport.ServerSecureChannel;
import com.prosysopc.ua.stack.transport.https.HttpsServer;
import com.prosysopc.ua.stack.utils.AbstractState;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.impl.nio.NHttpConnectionBase;
import org.apache.http.nio.NHttpServerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsServerConnection
extends AbstractState<CloseableObjectState, ServiceResultException>
implements ServerConnection {
    private static Logger logger = LoggerFactory.getLogger(HttpsServerConnection.class);
    HttpsServer sm;
    NHttpServerConnection sn;
    Socket socket;
    Map<Integer, ServerSecureChannel> so = new ConcurrentHashMap<Integer, ServerSecureChannel>();
    CopyOnWriteArrayList<ServerConnection.SecureChannelListener> sp = new CopyOnWriteArrayList();
    CopyOnWriteArrayList<IConnectionListener> sq = new CopyOnWriteArrayList();

    public HttpsServerConnection(HttpsServer httpsServer, NHttpServerConnection nHttpServerConnection) {
        super(CloseableObjectState.Closed);
        this.sm = httpsServer;
        this.sn = nHttpServerConnection;
        this.socket = ((NHttpConnectionBase)nHttpServerConnection).getSocket();
        this.sn.setSocketTimeout(60000);
    }

    @Override
    public void addConnectionListener(IConnectionListener iConnectionListener) {
        this.sq.add(iConnectionListener);
    }

    @Override
    public void addSecureChannelListener(ServerConnection.SecureChannelListener secureChannelListener) {
        this.sp.add(secureChannelListener);
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public NHttpServerConnection getNHttpServerConnection() {
        return this.sn;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    @Override
    public void getSecureChannels(Collection<ServerSecureChannel> collection) {
        collection.addAll(this.so.values());
    }

    @Override
    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        this.sq.remove(iConnectionListener);
    }

    @Override
    public void removeSecureChannelListener(ServerConnection.SecureChannelListener secureChannelListener) {
        this.sp.remove(secureChannelListener);
    }

    @Override
    protected void onStateTransition(CloseableObjectState closeableObjectState, CloseableObjectState closeableObjectState2) {
        logger.debug("onStateTransition: {}->{}", (Object)closeableObjectState, (Object)closeableObjectState2);
        super.onStateTransition(closeableObjectState, closeableObjectState2);
        if (closeableObjectState2 == CloseableObjectState.Open) {
            for (IConnectionListener object : this.sq) {
                object.onOpen();
            }
        }
        if (closeableObjectState2 == CloseableObjectState.Closed) {
            ServiceResultException serviceResultException = new ServiceResultException(StatusCodes.Bad_CommunicationError);
            for (IConnectionListener iConnectionListener : this.sq) {
                iConnectionListener.onClosed(serviceResultException);
            }
        }
    }
}

