/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.https;

import com.prosysopc.ua.stack.application.Application;
import com.prosysopc.ua.stack.application.Server;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.CloseableObject;
import com.prosysopc.ua.stack.transport.CloseableObjectState;
import com.prosysopc.ua.stack.transport.ConnectionMonitor;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.EndpointBinding;
import com.prosysopc.ua.stack.transport.EndpointServer;
import com.prosysopc.ua.stack.transport.ServerConnection;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.endpoint.EndpointBindingCollection;
import com.prosysopc.ua.stack.transport.https.HttpsServerConnection;
import com.prosysopc.ua.stack.transport.https.HttpsServerEndpointHandler;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.impl.ConnectionCollection;
import com.prosysopc.ua.stack.transport.security.CertValidatorTrustManager;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.HttpsSecurityPolicy;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.AbstractState;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncServerSocket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.nio.DefaultHttpServerIODispatch;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.impl.nio.DefaultNHttpServerConnectionFactory;
import org.apache.http.impl.nio.NHttpConnectionBase;
import org.apache.http.impl.nio.SSLNHttpServerConnectionFactory;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandlerResolver;
import org.apache.http.nio.protocol.HttpAsyncService;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ListenerEndpoint;
import org.apache.http.nio.reactor.ListeningIOReactor;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsServer
extends AbstractState<CloseableObjectState, ServiceResultException>
implements EndpointServer {
    static Logger ou = LoggerFactory.getLogger(HttpsServer.class);
    public static final HttpParams DEFAULT_HTTPPARAMS = new SyncBasicHttpParams().setIntParameter("http.socket.timeout", 0).setIntParameter("http.socket.buffer-size", 8192).setParameter("http.origin-server", (Object)"OpcUA/1.1").setParameter("http.useragent", (Object)"OpcUA/1.1");
    Application application;
    String[] rI;
    String[] rJ;
    String[] rw;
    AtomicInteger rK = new AtomicInteger();
    AsyncServerSocket rL;
    EndpointBindingCollection endpointBindings = new EndpointBindingCollection();
    ConnectionCollection rM = new ConnectionCollection(this);
    Thread rN;
    Thread rO;
    Semaphore rP;
    Semaphore rQ;
    HttpAsyncService rR;
    ConnectionReuseStrategy rS;
    a rT;
    NHttpConnectionFactory<DefaultNHttpServerConnection> rU;
    NHttpConnectionFactory<DefaultNHttpServerConnection> rV;
    SSLEngine rW;
    SSLSetupHandler rX;
    IOEventDispatch rY;
    IOEventDispatch rZ;
    ListeningIOReactor sa;
    IOReactorConfig sb;
    HttpsSecurityPolicy[] rl;
    Map<SocketAddress, SocketHandle> sc = new HashMap<SocketAddress, SocketHandle>();
    Server discoveryServer;
    HttpsServerEndpointHandler sd;

    public static TrustManager[] makeTrustManager(CertificateValidator ... certificateValidatorArray) {
        TrustManager[] trustManagerArray = new TrustManager[certificateValidatorArray.length];
        for (int i2 = 0; i2 < trustManagerArray.length; ++i2) {
            trustManagerArray[i2] = new CertValidatorTrustManager(certificateValidatorArray[i2]);
        }
        return trustManagerArray;
    }

    public HttpsServer(Application application) throws ServiceResultException {
        super(CloseableObjectState.Closed, CloseableObjectState.Closed);
        this.application = application;
        this.sb = new IOReactorConfig();
        this.rl = application.getHttpsSettings().getHttpsSecurityPolicies();
        this.sb.setTcpNoDelay(true);
        ImmutableHttpProcessor immutableHttpProcessor = new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer(), new ResponseContent(), new ResponseConnControl()});
        this.rT = new a();
        final Map map = Collections.synchronizedMap(new HashMap());
        this.rS = new DefaultConnectionReuseStrategy();
        this.rR = new HttpAsyncService((HttpProcessor)immutableHttpProcessor, this.rS, this.rT, this.getHttpParams()){

            public void closed(NHttpServerConnection nHttpServerConnection) {
                NHttpConnectionBase nHttpConnectionBase = (NHttpConnectionBase)nHttpServerConnection;
                ou.info("closed: {} {}<-> {} context={} socketTimeout={}", new Object[]{HttpsServer.this.getBoundSocketAddresses(), nHttpConnectionBase.getLocalAddress(), nHttpConnectionBase.getRemoteAddress(), nHttpConnectionBase.getContext(), nHttpConnectionBase.getSocketTimeout()});
                HttpsServerConnection httpsServerConnection = (HttpsServerConnection)map.remove(nHttpServerConnection);
                HttpsServer.this.rM.removeConnection(httpsServerConnection);
                super.closed(nHttpServerConnection);
            }

            public void connected(NHttpServerConnection nHttpServerConnection) {
                NHttpConnectionBase nHttpConnectionBase = (NHttpConnectionBase)nHttpServerConnection;
                ou.info("connected: {} {}<-> {} context={} socketTimeout={}", new Object[]{HttpsServer.this.getBoundSocketAddresses(), nHttpConnectionBase.getLocalAddress(), nHttpConnectionBase.getRemoteAddress(), nHttpConnectionBase.getContext(), nHttpConnectionBase.getSocketTimeout()});
                HttpsServerConnection httpsServerConnection = new HttpsServerConnection(HttpsServer.this, nHttpServerConnection);
                map.put(nHttpServerConnection, httpsServerConnection);
                HttpsServer.this.rM.addConnection(httpsServerConnection);
                super.connected(nHttpServerConnection);
            }
        };
        this.discoveryServer = new Server(application);
        this.discoveryServer.setEndpointBindings(this.endpointBindings);
        EndpointBinding endpointBinding = new EndpointBinding(this, discoveryEndpoint, this.discoveryServer);
        this.sd = new HttpsServerEndpointHandler(endpointBinding);
    }

    @Override
    public void addConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.rM.addConnectionListener(connectListener);
    }

    @Override
    public EndpointServer.EndpointHandle bind(SocketAddress socketAddress, EndpointBinding endpointBinding) throws ServiceResultException {
        Object object;
        Object object2;
        String string;
        if (endpointBinding == null || socketAddress == null || endpointBinding.endpointServer != this) {
            throw new IllegalArgumentException();
        }
        String string2 = string = endpointBinding.endpointAddress.getEndpointUrl();
        string2 = UriUtil.getEndpointName(string);
        if (string2 == null) {
            string2 = "";
        }
        if ((object2 = this.rT.lookup(string2)) == null) {
            object = new HttpsServerEndpointHandler(endpointBinding);
            this.rT.a(string2, (HttpsServerEndpointHandler)object);
            this.rT.a("", this.sd);
        } else {
            object = (HttpsServerEndpointHandler)object2;
            if (((HttpsServerEndpointHandler)object).sr != endpointBinding.endpointServer) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot bind endpoint " + string + " and " + ((HttpsServerEndpointHandler)object).si.endpointAddress.getEndpointUrl() + " with two different sets of service.");
            }
        }
        string2 = UriUtil.getTransportProtocol(endpointBinding.endpointAddress.getEndpointUrl());
        object2 = this.a(socketAddress, string2);
        object = ((SocketHandle)object2).a(endpointBinding);
        try {
            ListeningIOReactor listeningIOReactor;
            this.shutdownReactor();
            this.initReactor();
            for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
                if (socketHandle.sl != null) continue;
                socketHandle.sl = this.sa.listen(socketHandle.getSocketAddress());
            }
            if ("opc.https".equals(string2) && (this.rN == null || !this.rN.isAlive())) {
                listeningIOReactor = this.sa;
                Semaphore semaphore = this.rP = new Semaphore(0);
                this.rN = new Thread((IOReactor)listeningIOReactor, semaphore){
                    final /* synthetic */ IOReactor sg;
                    final /* synthetic */ Semaphore sh;
                    {
                        this.sg = iOReactor;
                        this.sh = semaphore;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            HttpsServer.this.setState((Object)CloseableObjectState.Open);
                            this.sg.execute(HttpsServer.this.rZ);
                        }
                        catch (IOException iOException) {
                            HttpsServer.this.setError(new ServiceResultException(iOException));
                        }
                        finally {
                            this.sh.release(9999);
                        }
                    }
                };
                if (!((CloseableObjectState)((Object)this.getState())).isOpen()) {
                    this.setState(CloseableObjectState.Opening);
                }
                this.rN.start();
            }
            if ("http".equals(string2) && (this.rO == null || !this.rO.isAlive())) {
                listeningIOReactor = this.sa;
                Semaphore semaphore = this.rQ = new Semaphore(0);
                this.rO = new Thread((IOReactor)listeningIOReactor, semaphore){
                    final /* synthetic */ IOReactor sg;
                    final /* synthetic */ Semaphore sh;
                    {
                        this.sg = iOReactor;
                        this.sh = semaphore;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            HttpsServer.this.setState((Object)CloseableObjectState.Open);
                            this.sg.execute(HttpsServer.this.rY);
                        }
                        catch (IOException iOException) {
                            HttpsServer.this.setError(new ServiceResultException(iOException));
                        }
                        finally {
                            this.sh.release(9999);
                        }
                    }
                };
                if (!((CloseableObjectState)((Object)this.getState())).isOpen()) {
                    this.setState(CloseableObjectState.Opening);
                }
                this.rO.start();
            }
        }
        catch (ServiceResultException serviceResultException) {
            ((HttpsEndpointHandle)object).close();
            throw serviceResultException;
        }
        ou.info("Endpoint bound to {}", (Object)string);
        return object;
    }

    @Override
    public void bindReverse(SocketAddress socketAddress, String string) {
        throw new UnsupportedOperationException("HTTPS does not support ReverseHello");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CloseableObject close() {
        for (EndpointBinding endpointBinding : this.endpointBindings.getAll()) {
            endpointBinding.endpointServer.getEndpointBindings().remove(endpointBinding);
        }
        this.endpointBindings.clear();
        try {
            this.setState(CloseableObjectState.Closing);
            for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
                socketHandle.close();
            }
        }
        finally {
            try {
                if (this.sa != null) {
                    this.sa.shutdown();
                }
                if (this.rN != null) {
                    this.rN.interrupt();
                    this.rN = null;
                }
                if (this.rO != null) {
                    this.rO.interrupt();
                    this.rO = null;
                }
            }
            catch (IOException iOException) {}
            this.setState(CloseableObjectState.Closed);
        }
        return this;
    }

    @Override
    public List<SocketAddress> getBoundSocketAddresses() {
        ArrayList<SocketAddress> arrayList = new ArrayList<SocketAddress>();
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            arrayList.add(socketHandle.getSocketAddress());
        }
        return arrayList;
    }

    @Override
    public void getConnections(Collection<ServerConnection> collection) {
        this.rM.getConnections(collection);
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.application.getEncoderContext();
    }

    @Override
    public EndpointBindingCollection getEndpointBindings() {
        return this.endpointBindings;
    }

    public HttpsSettings getHttpsSettings() {
        return this.application.getHttpsSettings();
    }

    public Collection<HttpsSecurityPolicy> getSupportedSecurityPolicies() {
        if (this.rl == null) {
            return HttpsSecurityPolicy.getAvailablePolicies().values();
        }
        return Arrays.asList(this.rl);
    }

    public int getWorkerThreadCount() {
        return this.sb.getIoThreadCount();
    }

    @Override
    public void removeConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.rM.removeConnectionListener(connectListener);
    }

    public void setWorkerThreadCount(int n2) {
        if (this.sa != null) {
            throw new RuntimeException("Set workercount before binding the first socket address");
        }
        this.sb.setIoThreadCount(n2);
    }

    public SocketHandle[] socketHandleSnapshot() {
        return this.sc.values().toArray(new SocketHandle[this.sc.size()]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HttpServer");
        stringBuilder.append("(");
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            stringBuilder.append(socketHandle.toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    protected void initReactor() throws ServiceResultException {
        boolean bl = false;
        boolean bl2 = false;
        for (SocketHandle socketHandle : this.sc.values()) {
            bl |= socketHandle.scheme.equals("opc.https");
            bl2 |= socketHandle.scheme.equals("http");
        }
        try {
            Object[] objectArray;
            if (bl && this.rX == null) {
                try {
                    objectArray = SSLContext.getInstance("TLSv1.2");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    ou.debug("No TLSv1.2 implementation found, trying TLS");
                    objectArray = SSLContext.getInstance("TLS");
                }
                objectArray.init(this.application.getHttpsSettings().getKeyManagers(), this.application.getHttpsSettings().getTrustManagers(), null);
                this.rX = new SSLSetupHandler(){

                    public void initalize(SSLEngine sSLEngine) throws SSLException {
                    }

                    public void verify(IOSession iOSession, SSLSession sSLSession) throws SSLException {
                    }
                };
                this.rV = new SSLNHttpServerConnectionFactory((SSLContext)objectArray, this.rX, this.getHttpParams());
                this.rZ = new DefaultHttpServerIODispatch((NHttpServerEventHandler)this.rR, this.rV);
                this.rW = objectArray.createSSLEngine();
                ou.info("Enabled protocols in SSL Engine are {}", (Object)Arrays.toString(this.rW.getEnabledProtocols()));
                this.rI = this.rW.getEnabledCipherSuites();
                ou.info("Enabled CipherSuites in SSL Engine are {}", (Object)Arrays.toString(this.rI));
            }
            if (bl) {
                objectArray = this.rw;
                this.rJ = this.aPN();
                this.rw = CryptoUtil.filterCipherSuiteList(this.rI, this.rJ);
                this.rW.setEnabledCipherSuites(this.rw);
                if (objectArray == null || !Arrays.equals(objectArray, this.rw)) {
                    ou.info("CipherSuites for policies ({}) are {}", (Object)Arrays.toString((Object[])this.rl), (Object)Arrays.toString(this.rw));
                }
            }
            if (bl2 && this.rU == null) {
                this.rU = new DefaultNHttpServerConnectionFactory(this.getHttpParams());
                this.rY = new DefaultHttpServerIODispatch((NHttpServerEventHandler)this.rR, this.rU);
            }
            if (this.sa == null) {
                this.sa = new DefaultListeningIOReactor(this.sb, null);
            }
        }
        catch (KeyManagementException keyManagementException) {
            throw new ServiceResultException(keyManagementException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ServiceResultException(noSuchAlgorithmException);
        }
        catch (IOReactorException iOReactorException) {
            throw new ServiceResultException(iOReactorException);
        }
    }

    protected void shutdownReactor() {
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            ListenerEndpoint listenerEndpoint = socketHandle.sl;
            if (listenerEndpoint != null) {
                listenerEndpoint.close();
            }
            socketHandle.sl = null;
        }
        if (this.sa != null) {
            try {
                this.sa.shutdown();
            }
            catch (IOException iOException) {
                ou.error("Failed to shutdown ioReactor", (Throwable)iOException);
            }
            this.sa = null;
        }
        if (this.rN != null) {
            this.rN.interrupt();
            try {
                this.rP.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.rP = null;
            this.rN = null;
        }
        if (this.rO != null) {
            this.rO.interrupt();
            try {
                this.rQ.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.rQ = null;
            this.rO = null;
        }
    }

    String[] aPN() throws ServiceResultException {
        Collection<HttpsSecurityPolicy> collection = this.getSupportedSecurityPolicies();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HttpsSecurityPolicy httpsSecurityPolicy : collection) {
            String[] stringArray = httpsSecurityPolicy.getCipherSuites();
            if (stringArray == null) continue;
            for (String string : stringArray) {
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    Set<SecurityPolicy> aPO() {
        HashSet<SecurityPolicy> hashSet = new HashSet<SecurityPolicy>();
        for (EndpointBinding endpointBinding : this.endpointBindings.getAll()) {
            for (SecurityMode securityMode : endpointBinding.endpointAddress.getSecurityModes()) {
                hashSet.add(securityMode.getSecurityPolicy());
            }
        }
        return hashSet;
    }

    int a(Endpoint endpoint) {
        int n2 = 0;
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            for (HttpsEndpointHandle httpsEndpointHandle : socketHandle.endpointHandleSnapshot()) {
                if (!httpsEndpointHandle.si.endpointAddress.equals(endpoint)) continue;
                ++n2;
            }
        }
        return n2;
    }

    List<HttpsEndpointHandle> z(String string) {
        ArrayList<HttpsEndpointHandle> arrayList = new ArrayList<HttpsEndpointHandle>();
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            socketHandle.a(arrayList);
        }
        return arrayList;
    }

    HttpParams getHttpParams() {
        return this.application.getHttpsSettings().getHttpParams() == null ? DEFAULT_HTTPPARAMS : this.application.getHttpsSettings().getHttpParams();
    }

    synchronized SocketHandle a(SocketAddress socketAddress, String string) throws ServiceResultException {
        SocketHandle socketHandle = this.sc.get(socketAddress);
        if (socketHandle == null) {
            socketHandle = new SocketHandle(socketAddress, string);
            this.sc.put(socketAddress, socketHandle);
        } else if (!string.equals(socketHandle.scheme)) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Socket port=" + socketHandle.getPort() + " cannot be bound as http and https.");
        }
        return socketHandle;
    }

    class a
    implements HttpAsyncRequestHandlerResolver {
        Map<String, HttpsServerEndpointHandler> map = new HashMap<String, HttpsServerEndpointHandler>();

        public Map<String, HttpAsyncRequestHandler<?>> getHandlers() {
            return new HashMap(this.map);
        }

        public HttpAsyncRequestHandler<?> lookup(String string) {
            HttpAsyncRequestHandler httpAsyncRequestHandler = this.map.get(string);
            if (httpAsyncRequestHandler == null && (string.equals("") || string.equals("/"))) {
                return HttpsServer.this.sd;
            }
            return httpAsyncRequestHandler;
        }

        public void a(String string, HttpsServerEndpointHandler httpsServerEndpointHandler) {
            this.map.put(string, httpsServerEndpointHandler);
        }

        public void setHandlers(Map<String, HttpAsyncRequestHandler<?>> map) {
            this.map.clear();
            for (Map.Entry<String, HttpAsyncRequestHandler<?>> entry : map.entrySet()) {
                this.map.put(entry.getKey(), (HttpsServerEndpointHandler)entry.getValue());
            }
        }

        public void unregister(String string) {
            this.map.remove(string);
        }
    }

    public class SocketHandle {
        private SocketAddress sk;
        ListenerEndpoint sl;
        String scheme;
        Map<Endpoint, HttpsEndpointHandle> endpoints = new HashMap<Endpoint, HttpsEndpointHandle>();

        SocketHandle(SocketAddress socketAddress, String string) {
            this.setSocketAddress(socketAddress);
            this.scheme = string;
        }

        public synchronized HttpsEndpointHandle[] endpointHandleSnapshot() {
            return this.endpoints.values().toArray(new HttpsEndpointHandle[this.endpoints.size()]);
        }

        public SocketAddress getSocketAddress() {
            return this.sk;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.scheme + "(" + this.getSocketAddress() + ", ");
            for (HttpsEndpointHandle httpsEndpointHandle : this.endpoints.values()) {
                stringBuilder.append(httpsEndpointHandle.toString());
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        void close() {
            for (HttpsEndpointHandle httpsEndpointHandle : this.endpoints.values()) {
                httpsEndpointHandle.aPQ();
            }
            HttpsServer.this.sc.remove(this.getSocketAddress());
            if (this.sl != null) {
                this.sl.close();
            }
        }

        synchronized void a(Collection<HttpsEndpointHandle> collection) {
            collection.addAll(this.endpoints.values());
        }

        synchronized HttpsEndpointHandle a(EndpointBinding endpointBinding) throws ServiceResultException {
            HttpsEndpointHandle httpsEndpointHandle = this.endpoints.get(endpointBinding.endpointAddress);
            if (httpsEndpointHandle == null) {
                httpsEndpointHandle = new HttpsEndpointHandle(this, endpointBinding);
                this.endpoints.put(endpointBinding.endpointAddress, httpsEndpointHandle);
                HttpsServer.this.endpointBindings.add(endpointBinding);
                endpointBinding.serviceServer.getEndpointBindings().add(endpointBinding);
            } else if (!httpsEndpointHandle.si.equals(endpointBinding)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot bind an endpoint address to two different servers.");
            }
            return httpsEndpointHandle;
        }

        int getPort() {
            return ((InetSocketAddress)this.getSocketAddress()).getPort();
        }

        void setSocketAddress(SocketAddress socketAddress) {
            this.sk = socketAddress;
        }
    }

    public class HttpsEndpointHandle
    implements EndpointServer.EndpointHandle {
        EndpointBinding si;
        SocketHandle sj;

        HttpsEndpointHandle(SocketHandle socketHandle, EndpointBinding endpointBinding) {
            this.sj = socketHandle;
            this.si = endpointBinding;
        }

        @Override
        public void close() {
            this.aPP();
            this.aPQ();
        }

        @Override
        public EndpointBinding endpointBinding() {
            return this.si;
        }

        @Override
        public SocketAddress socketAddress() {
            return this.sj.getSocketAddress();
        }

        public String toString() {
            return "(" + this.si.endpointAddress.toString() + ")";
        }

        void aPP() {
            this.sj.endpoints.remove(this.si.endpointAddress);
            if (this.sj.endpoints.isEmpty()) {
                this.sj.close();
            }
        }

        void aPQ() {
            int n2 = HttpsServer.this.a(this.si.endpointAddress);
            if (n2 == 0) {
                String string = this.si.endpointAddress.getEndpointUrl();
                HttpsServer.this.rT.unregister(string);
                HttpsServer.this.rT.unregister("");
                HttpsServer.this.endpointBindings.remove(this.si);
                this.si.serviceServer.getEndpointBindings().remove(this.si);
            }
        }
    }
}

