/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.https;

import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.ServiceFault;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.SecureChannel;
import com.prosysopc.ua.stack.transport.TransportChannelSettings;
import com.prosysopc.ua.stack.transport.https.HttpsClient;
import com.prosysopc.ua.stack.transport.https.a;
import com.prosysopc.ua.stack.transport.impl.AsyncResultImpl;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.StackUtils;
import java.util.HashMap;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsClientSecureChannel
implements SecureChannel {
    static Logger logger = LoggerFactory.getLogger(HttpsClientSecureChannel.class);
    private EncoderContext pX;
    int re = -1;
    HttpsClient rG;
    Executor executor = StackUtils.getBlockingWorkExecutor();

    public HttpsClientSecureChannel(HttpsClient httpsClient) {
        this.rG = httpsClient;
    }

    @Override
    public void close() {
        if (this.re == -1) {
            return;
        }
        int n2 = this.re;
        this.re = -1;
        HashMap<Integer, a> hashMap = new HashMap<Integer, a>(this.rG.rr);
        for (a a2 : hashMap.values()) {
            if (a2.re != n2) continue;
            a2.cancel();
        }
    }

    @Override
    public AsyncResult<SecureChannel> closeAsync() {
        final AsyncResultImpl<SecureChannel> asyncResultImpl = new AsyncResultImpl<SecureChannel>();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                HttpsClientSecureChannel.this.close();
                asyncResultImpl.setResult(HttpsClientSecureChannel.this);
            }
        });
        return asyncResultImpl;
    }

    @Override
    public void dispose() {
        this.close();
        this.executor = null;
        this.rG = null;
    }

    @Override
    public String getConnectURL() {
        return this.rG.rk;
    }

    @Override
    public EndpointConfiguration getEndpointConfiguration() {
        return this.rG.rj.getConfiguration();
    }

    @Override
    public EndpointDescription getEndpointDescription() {
        return this.rG.rj.getDescription();
    }

    @Override
    public EncoderContext getMessageContext() {
        return this.pX;
    }

    @Override
    public MessageSecurityMode getMessageSecurityMode() {
        return this.rG.rj.getDescription().getSecurityMode();
    }

    @Override
    public int getOperationTimeout() {
        Integer n2 = this.rG.rj.getConfiguration().getOperationTimeout();
        return n2 == null ? 0 : n2;
    }

    @Override
    public int getSecureChannelId() {
        return this.re;
    }

    @Override
    public SecurityPolicy getSecurityPolicy() {
        try {
            return SecurityPolicy.getSecurityPolicy(this.getEndpointDescription().getSecurityPolicyUri());
        }
        catch (ServiceResultException serviceResultException) {
            return null;
        }
    }

    @Override
    public void initialize(String string, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.pX = encoderContext;
        this.rG.initialize(string, transportChannelSettings, encoderContext);
    }

    @Override
    public void initialize(TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.pX = encoderContext;
        this.rG.initialize(transportChannelSettings.getDescription().getEndpointUrl(), transportChannelSettings, encoderContext);
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public void open() throws ServiceResultException {
        logger.debug("open");
        if (this.re == -1) {
            this.re = this.rG.rv.incrementAndGet();
        }
    }

    @Override
    public AsyncResult<SecureChannel> openAsync() {
        final AsyncResultImpl<SecureChannel> asyncResultImpl = new AsyncResultImpl<SecureChannel>();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    HttpsClientSecureChannel.this.open();
                    asyncResultImpl.setResult(HttpsClientSecureChannel.this);
                }
                catch (ServiceResultException serviceResultException) {
                    asyncResultImpl.setError(serviceResultException);
                }
            }
        });
        return asyncResultImpl;
    }

    @Override
    public <T extends ServiceResponse> T serviceRequest(ServiceRequest<T> serviceRequest) throws ServiceResultException {
        AsyncResult<T> asyncResult = this.rG.serviceRequestAsync(serviceRequest, this.rG.b(serviceRequest), this.re);
        T t = asyncResult.waitForResult();
        if (t instanceof ServiceFault) {
            throw new ServiceFaultException((ServiceFault)t);
        }
        ServiceResponse serviceResponse = (ServiceResponse)t;
        logger.trace("Response: {}", (Object)serviceResponse);
        logger.debug("Response: {}", (Object)serviceResponse.getClass().getSimpleName());
        ResponseHeader responseHeader = serviceResponse.getResponseHeader();
        if (responseHeader.getServiceResult().isBad()) {
            logger.debug("BAD response: {}", (Object)responseHeader.getServiceResult());
            throw new ServiceFaultException(new ServiceFault(responseHeader));
        }
        return (T)serviceResponse;
    }

    @Override
    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest) {
        return this.rG.serviceRequestAsync(serviceRequest, this.rG.b(serviceRequest), this.re);
    }

    @Override
    public void setOperationTimeout(int n2) {
        EndpointConfiguration endpointConfiguration = this.rG.rj.getConfiguration();
        if (endpointConfiguration == null) {
            endpointConfiguration = new EndpointConfiguration();
            this.rG.rj.setConfiguration(endpointConfiguration);
        }
        endpointConfiguration.setOperationTimeout(n2);
    }
}

