/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.utils;

import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EncodeableDiscovery {
    private static Map<NodeId, Class<IEncodeable>> qJ;

    public static void discoverDefaultEncodeables(Map<NodeId, Class<IEncodeable>> map) {
        Class<Identifiers> clazz = Identifiers.class;
        ClassLoader classLoader = clazz.getClassLoader();
        int n2 = clazz.getCanonicalName().lastIndexOf(".");
        String string = clazz.getCanonicalName().substring(0, n2);
        for (Field field : clazz.getFields()) {
            field.setAccessible(true);
            try {
                String string2 = string + "." + field.getName();
                Class<?> clazz2 = classLoader.loadClass(string2);
                if (!IEncodeable.class.isAssignableFrom(clazz2)) continue;
                for (Field field2 : clazz2.getFields()) {
                    NodeId nodeId;
                    field2.setAccessible(true);
                    if (!field2.getType().equals(NodeId.class)) continue;
                    try {
                        nodeId = (NodeId)field2.get(null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new RuntimeException("Failed to load default identifiers", illegalArgumentException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new RuntimeException("Failed to load default identifiers", illegalAccessException);
                    }
                    if (nodeId == null) {
                        throw new RuntimeException("Failed to load default identifiers");
                    }
                    map.put(nodeId, clazz2);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public static synchronized Map<NodeId, Class<IEncodeable>> getDefault() {
        if (qJ != null) {
            return qJ;
        }
        HashMap<NodeId, Class<IEncodeable>> hashMap = new HashMap<NodeId, Class<IEncodeable>>();
        try {
            EncodeableDiscovery.discoverDefaultEncodeables(hashMap);
        }
        catch (RuntimeException runtimeException) {
            throw new Error(runtimeException);
        }
        qJ = Collections.unmodifiableMap(hashMap);
        return qJ;
    }
}

