/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.json;

import com.prosysopc.ua.OptionSetDataType;
import com.prosysopc.ua.stack.builtintypes.BuiltinsMap;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.IdType;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.IEncoder;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonEncoder
implements IEncoder {
    private static final Logger logger = LoggerFactory.getLogger(JsonEncoder.class);
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String MIN_DATETIME = "0001-01-01T00:00:00Z";
    public static final String MAX_DATETIME = "9999-12-31T23:59:59Z";
    private static final Map<Class<?>, a<?>> pL = new HashMap();
    private static final a<DateTime> qp;
    private static final a<ExtensionObject> qq;
    private static final a<Structure> qr;
    private static final a<DataValue> qs;
    private static final a<Variant> qt;
    private static final a<DiagnosticInfo> qu;
    private static final a<Enumeration> qv;
    private static final a<BigDecimal> qw;
    private static final a<OptionSetDataType<?, ?>> qx;
    private static final ExpandedNodeId pV;
    private EncoderContext pX;
    private boolean qy = false;
    private Boolean qz = false;
    private Boolean qA = true;
    private final Writer writer;

    private static <T> void a(Class<T> clazz, a<T> a2) {
        if (!Object.class.equals(clazz) && !Modifier.isFinal(clazz.getModifiers())) {
            throw new Error("Class " + clazz + " is not final, and cannot be put to known final classes serialization helper");
        }
        a<T> a3 = pL.put(clazz, a2);
        if (a3 != null) {
            throw new Error("Class " + clazz + " already has a serializer defined");
        }
    }

    private static <T> a<T> i(Class<?> clazz) throws EncodingException {
        a<?> a2 = pL.get(clazz);
        if (a2 != null) {
            return a2;
        }
        if (ExtensionObject.class.isAssignableFrom(clazz)) {
            return qq;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return qr;
        }
        if (DataValue.class.isAssignableFrom(clazz)) {
            return qs;
        }
        if (Variant.class.isAssignableFrom(clazz)) {
            return qt;
        }
        if (DiagnosticInfo.class.isAssignableFrom(clazz)) {
            return qu;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return qv;
        }
        if (DateTime.class.isAssignableFrom(clazz)) {
            return qp;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return qw;
        }
        if (OptionSetDataType.class.isAssignableFrom(clazz)) {
            return qx;
        }
        throw new EncodingException("Cannot encode class: " + clazz);
    }

    private static EncodingException b(IOException iOException) {
        if (iOException instanceof ClosedChannelException) {
            return new EncodingException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException);
        }
        if (iOException instanceof EOFException) {
            return new EncodingException(StatusCodes.Bad_EndOfStream, (Throwable)iOException);
        }
        if (iOException instanceof ConnectException) {
            return new EncodingException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
        }
        if (iOException instanceof SocketException) {
            return new EncodingException(StatusCodes.Bad_CommunicationError, (Throwable)iOException);
        }
        return new EncodingException(StatusCodes.Bad_UnexpectedError, (Throwable)iOException);
    }

    public JsonEncoder(Writer writer) throws IOException {
        this.writer = writer;
        writer.write(123);
    }

    public void close() throws IOException {
        this.endObject();
        this.writer.flush();
    }

    public void endObject() throws IOException {
        this.writer.write(125);
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.pX;
    }

    public Boolean getReversibleEncoding() {
        return this.qA;
    }

    @Override
    public void put(String string, Object object) throws EncodingException {
        if (object == null) {
            throw new EncodingException("Cannot encode null value");
        }
        this.put(string, object, object.getClass());
    }

    @Override
    public void put(String string, Object object, Class<?> clazz) throws EncodingException {
        Class<?> clazz2 = MultiDimensionArrayUtils.getComponentType(clazz);
        a<Object> a2 = JsonEncoder.i(clazz2);
        int n2 = MultiDimensionArrayUtils.getClassDimensions(clazz);
        if (object != null) {
            if (this.qy) {
                try {
                    this.writer.write(",");
                }
                catch (IOException iOException) {
                    logger.error("Failed writing to stream");
                }
            } else {
                this.qy = true;
            }
        }
        if (n2 == 0) {
            a2.a(this, string, object, clazz2);
            return;
        }
        if (n2 == 1) {
            if (object == null) {
                return;
            }
            Object[] objectArray = (Object[])object;
            int n3 = objectArray.length;
            this.h(n3);
            if (string != null) {
                try {
                    this.writer.write("\"" + string + "\":[");
                    this.qz = true;
                    for (int i2 = 0; i2 < objectArray.length; ++i2) {
                        if (objectArray[i2] == null) {
                            this.writer.write("null");
                        } else {
                            a2.a(this, null, objectArray[i2], clazz2);
                        }
                        if (i2 >= objectArray.length - 1) continue;
                        this.writer.write(",");
                    }
                    this.writer.write("]");
                }
                catch (IOException iOException) {
                    throw JsonEncoder.b(iOException);
                }
                finally {
                    this.qz = false;
                }
            }
            return;
        }
        if (object == null) {
            int[] nArray = new int[n2];
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                nArray[i3] = -1;
            }
            this.putInt32Array((String)null, nArray);
            return;
        }
        int[] nArray = MultiDimensionArrayUtils.getArrayLengths(object);
        Object[] objectArray = (Object[])MultiDimensionArrayUtils.muxArray(object, nArray, clazz2);
        int n4 = objectArray.length;
        this.h(n4);
        this.putInt32Array((String)null, nArray);
        for (Object object2 : objectArray) {
            a2.a(this, null, object2, clazz2);
        }
    }

    @Override
    public void putArray(String string, int n2, Object object) throws EncodingException {
        switch (n2) {
            case 1: {
                this.putBooleanArray(null, (Boolean[])object);
                break;
            }
            case 2: {
                this.putSByteArray(null, (Byte[])object);
                break;
            }
            case 3: {
                this.putByteArray(null, (UnsignedByte[])object);
                break;
            }
            case 4: {
                this.putInt16Array(null, (Short[])object);
                break;
            }
            case 5: {
                this.putUInt16Array(null, (UnsignedShort[])object);
                break;
            }
            case 6: {
                this.putInt32Array((String)null, (Integer[])object);
                break;
            }
            case 7: {
                this.putUInt32Array(null, (UnsignedInteger[])object);
                break;
            }
            case 8: {
                this.putInt64Array(null, (Long[])object);
                break;
            }
            case 9: {
                this.putUInt64Array(null, (UnsignedLong[])object);
                break;
            }
            case 10: {
                this.putFloatArray(null, (Float[])object);
                break;
            }
            case 11: {
                this.putDoubleArray(null, (Double[])object);
                break;
            }
            case 12: {
                this.putStringArray(null, (String[])object);
                break;
            }
            case 13: {
                this.putDateTimeArray(null, (DateTime[])object);
                break;
            }
            case 14: {
                this.putGuidArray(null, (UUID[])object);
                break;
            }
            case 15: {
                this.putByteStringArray(null, (ByteString[])object);
                break;
            }
            case 16: {
                this.putXmlElementArray(null, (XmlElement[])object);
                break;
            }
            case 17: {
                this.putNodeIdArray(null, (NodeId[])object);
                break;
            }
            case 18: {
                this.putExpandedNodeIdArray(null, (ExpandedNodeId[])object);
                break;
            }
            case 19: {
                this.putStatusCodeArray(null, (StatusCode[])object);
                break;
            }
            case 20: {
                this.putQualifiedNameArray(null, (QualifiedName[])object);
                break;
            }
            case 21: {
                this.putLocalizedTextArray(null, (LocalizedText[])object);
                break;
            }
            case 22: {
                if (object instanceof ExtensionObject[]) {
                    this.putExtensionObjectArray(null, (ExtensionObject[])object);
                    break;
                }
                if (object instanceof Structure[]) {
                    this.putStructureArray(null, (Structure[])object);
                    break;
                }
                throw new EncodingException("cannot encode " + object);
            }
            case 23: {
                this.putDataValueArray(null, (DataValue[])object);
                break;
            }
            case 24: {
                this.putVariantArray(null, (Variant[])object);
                break;
            }
            case 25: {
                this.putDiagnosticInfoArray(null, (DiagnosticInfo[])object);
                break;
            }
            default: {
                throw new EncodingException("cannot encode builtin type " + n2);
            }
        }
    }

    @Override
    public void putBoolean(String string, Boolean bl) throws EncodingException {
        try {
            if (bl != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write(bl.toString());
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putBooleanArray(String string, Boolean[] booleanArray) throws EncodingException {
        try {
            if (booleanArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(booleanArray.length);
                this.writer.write("[");
                for (Boolean bl : booleanArray) {
                    this.writer.write(bl.toString());
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putBooleanArray(String string, Collection<Boolean> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (Boolean bl : collection) {
                    this.writer.write(bl.toString());
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putByte(String string, UnsignedByte unsignedByte) throws EncodingException {
        try {
            if (unsignedByte != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write("\"" + unsignedByte.toString() + "\"");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putByteArray(String string, Collection<UnsignedByte> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (UnsignedByte unsignedByte : collection) {
                    this.writer.write(unsignedByte.toString());
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putByteArray(String string, UnsignedByte[] unsignedByteArray) throws EncodingException {
        try {
            if (unsignedByteArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(unsignedByteArray.length);
                this.writer.write("[");
                for (UnsignedByte unsignedByte : unsignedByteArray) {
                    this.writer.write(unsignedByte.toString());
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putByteString(String string, ByteString byteString) throws EncodingException {
        try {
            if (byteString != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write("\"" + this.b(byteString.getValue()) + "\"");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putByteStringArray(String string, ByteString[] byteStringArray) throws EncodingException {
        try {
            if (byteStringArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(byteStringArray.length);
                this.writer.write("[");
                for (ByteString byteString : byteStringArray) {
                    this.writer.write("\"" + this.b(byteString.getValue()) + "\"");
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putByteStringArray(String string, Collection<ByteString> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (ByteString byteString : collection) {
                    this.writer.write(this.b(byteString.getValue()));
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putDataValue(String string, DataValue dataValue) throws EncodingException {
        try {
            if (dataValue != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write("{");
                boolean bl = false;
                if (dataValue.getValue().getValue() != null) {
                    this.putVariant("Value", dataValue.getValue());
                    bl = true;
                }
                if (dataValue.getStatusCode() != StatusCode.GOOD) {
                    if (bl) {
                        this.writer.write(",");
                    }
                    this.putStatusCode("Status", dataValue.getStatusCode());
                    bl = true;
                }
                if (dataValue.getSourceTimestamp() != null) {
                    if (bl) {
                        this.writer.write(",");
                    }
                    this.writer.write("\"SourceTimestamp\":\"" + this.d(dataValue.getSourceTimestamp()) + "\"");
                    bl = true;
                }
                if (dataValue.getSourcePicoseconds() != null && dataValue.getSourcePicoseconds().intValue() != 0) {
                    if (bl) {
                        this.writer.write(",");
                    }
                    this.writer.write("\"SourcePicoSeconds\":" + dataValue.getSourcePicoseconds());
                    bl = true;
                }
                if (dataValue.getServerTimestamp() != null) {
                    if (bl) {
                        this.writer.write(",");
                    }
                    this.writer.write("\"ServerTimestamp\":\"" + this.d(dataValue.getServerTimestamp()) + "\"");
                    bl = true;
                }
                if (dataValue.getServerPicoseconds() != null && dataValue.getServerPicoseconds().intValue() != 0) {
                    if (bl) {
                        this.writer.write(",");
                    }
                    this.writer.write("\"ServerPicoSeconds\":" + dataValue.getServerPicoseconds());
                }
                this.writer.write("}");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putDataValueArray(String string, Collection<DataValue> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (DataValue dataValue : collection) {
                    if (dataValue == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putDataValue(null, dataValue);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putDataValueArray(String string, DataValue[] dataValueArray) throws EncodingException {
        try {
            if (dataValueArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(dataValueArray.length);
                this.writer.write("[");
                for (DataValue dataValue : dataValueArray) {
                    if (dataValue == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putDataValue(null, dataValue);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putDateTime(String string, DateTime dateTime) throws EncodingException {
        try {
            if (dateTime != null) {
                String string2 = this.d(dateTime);
                if (string2 != null) {
                    if (string != null) {
                        this.writer.write("\"" + string + "\":");
                    }
                    this.writer.write("\"" + string2 + "\"");
                } else if (string == null) {
                    this.writer.write("null");
                }
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putDateTimeArray(String string, Collection<DateTime> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (DateTime dateTime : collection) {
                    this.writer.write(this.d(dateTime));
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putDateTimeArray(String string, DateTime[] dateTimeArray) throws EncodingException {
        try {
            if (dateTimeArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(dateTimeArray.length);
                this.writer.write("[");
                for (DateTime dateTime : dateTimeArray) {
                    this.writer.write(this.d(dateTime));
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putDiagnosticInfo(String string, DiagnosticInfo diagnosticInfo) throws EncodingException {
        try {
            if (diagnosticInfo != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write("{");
                boolean bl = false;
                if (diagnosticInfo.getSymbolicId() != null) {
                    this.writer.write("\"SymbolicId\":" + diagnosticInfo.getSymbolicId());
                    bl = true;
                }
                if (diagnosticInfo.getNamespaceUri() != null) {
                    if (bl) {
                        this.writer.write(",");
                    }
                    this.writer.write("\"NamespaceUri\":" + diagnosticInfo.getNamespaceUri());
                    bl = true;
                }
                if (diagnosticInfo.getLocale() != null) {
                    if (bl) {
                        this.writer.write(",");
                    }
                    this.writer.write("\"Locale\":" + diagnosticInfo.getLocale());
                    bl = true;
                }
                if (diagnosticInfo.getLocalizedText() != null) {
                    if (bl) {
                        this.writer.write(",");
                    }
                    this.writer.write("\"LocalizedText\":" + diagnosticInfo.getLocalizedText());
                    bl = true;
                }
                if (diagnosticInfo.getAdditionalInfo() != null) {
                    if (bl) {
                        this.writer.write(",");
                    }
                    this.writer.write("\"Additional Info\":\"" + diagnosticInfo.getAdditionalInfo() + "\"");
                    bl = true;
                }
                if (diagnosticInfo.getInnerStatusCode() != null && diagnosticInfo.getInnerStatusCode().isNotGood()) {
                    if (bl) {
                        this.writer.write(",");
                    }
                    if (this.qA.booleanValue()) {
                        this.writer.write("\"Inner StatusCode\":" + diagnosticInfo.getInnerStatusCode().getValue());
                    } else {
                        this.putStatusCode(null, diagnosticInfo.getInnerStatusCode());
                    }
                    bl = true;
                }
                if (diagnosticInfo.getInnerDiagnosticInfo() != null) {
                    if (bl) {
                        this.writer.write(",");
                    }
                    this.writer.write("\"Inner DiagnosticInfo\":");
                    this.putDiagnosticInfo(null, diagnosticInfo.getInnerDiagnosticInfo());
                }
                this.writer.write("}");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putDiagnosticInfoArray(String string, Collection<DiagnosticInfo> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (DiagnosticInfo diagnosticInfo : collection) {
                    if (diagnosticInfo == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putDiagnosticInfo(null, diagnosticInfo);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putDiagnosticInfoArray(String string, DiagnosticInfo[] diagnosticInfoArray) throws EncodingException {
        try {
            if (diagnosticInfoArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(diagnosticInfoArray.length);
                this.writer.write("[");
                for (DiagnosticInfo diagnosticInfo : diagnosticInfoArray) {
                    if (diagnosticInfo == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putDiagnosticInfo(null, diagnosticInfo);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putDouble(String string, double d2) throws EncodingException {
        this.putDouble(string, new Double(d2));
    }

    @Override
    public void putDouble(String string, Double d2) throws EncodingException {
        try {
            if (d2 != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                if (!d2.equals(Double.NaN)) {
                    this.writer.write(d2.toString());
                } else {
                    this.writer.write("\"NaN\"");
                }
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putDoubleArray(String string, Collection<Double> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (Double d2 : collection) {
                    if (d2 == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putDouble((String)null, d2);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putDoubleArray(String string, Double[] doubleArray) throws EncodingException {
        try {
            if (doubleArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(doubleArray.length);
                this.writer.write("[");
                for (Double d2 : doubleArray) {
                    if (d2 == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putDouble((String)null, d2);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putEncodeable(String string, Class<? extends IEncodeable> clazz, IEncodeable iEncodeable) throws EncodingException {
        try {
            if (iEncodeable != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write("{");
                this.qy = false;
                this.pX.getEncodeableSerializer().putEncodeable(clazz, iEncodeable, this);
                this.writer.write("}");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putEncodeable(String string, IEncodeable iEncodeable) throws EncodingException {
        try {
            if (iEncodeable != null) {
                Class<?> clazz = iEncodeable.getClass();
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write("{");
                this.pX.getEncodeableSerializer().putEncodeable(clazz, iEncodeable, this);
                this.writer.write("}");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putEncodeableArray(String string, Class<? extends IEncodeable> clazz, Object object) throws EncodingException {
        try {
            if (object != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                int n2 = Array.getLength(object);
                this.h(n2);
                this.writer.write("[");
                for (int i2 = 0; i2 < n2; ++i2) {
                    IEncodeable iEncodeable = (IEncodeable)Array.get(object, i2);
                    if (iEncodeable == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putEncodeable(null, clazz, iEncodeable);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putEnumeration(String string, Enumeration enumeration) throws EncodingException {
        try {
            if (enumeration != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                if (!this.qA.booleanValue() && enumeration.toString() != null) {
                    this.writer.write("\"" + enumeration.toString() + "_" + enumeration.getValue() + "\"");
                } else {
                    this.writer.write(Integer.toString(enumeration.getValue()));
                }
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putEnumerationArray(String string, Object object) throws EncodingException {
        try {
            if (object != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                int n2 = Array.getLength(object);
                this.h(n2);
                this.writer.write("[");
                for (int i2 = 0; i2 < n2; ++i2) {
                    Enumeration enumeration = (Enumeration)Array.get(object, i2);
                    if (enumeration == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putEnumeration(null, enumeration);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putExpandedNodeId(String string, ExpandedNodeId expandedNodeId) throws EncodingException {
        try {
            if (expandedNodeId != null) {
                String string2;
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write("{");
                if (expandedNodeId.getIdType() == IdType.String) {
                    this.writer.write("\"IdType\":1,");
                } else if (expandedNodeId.getIdType() == IdType.Guid) {
                    this.writer.write("\"IdType\":2,");
                } else if (expandedNodeId.getIdType() == IdType.Opaque) {
                    this.writer.write("\"IdType\":3,");
                }
                if (expandedNodeId.getValue() != null) {
                    if (expandedNodeId.getIdType() == IdType.Numeric) {
                        this.writer.write("\"Id\":" + expandedNodeId.getValue().toString());
                    } else if (expandedNodeId.getIdType() == IdType.String) {
                        this.writer.write("\"Id\":\"" + expandedNodeId.getValue().toString() + "\"");
                    } else if (expandedNodeId.getIdType() == IdType.Guid) {
                        this.writer.write("\"Id\":\"" + expandedNodeId.getValue().toString() + "\"");
                    } else if (expandedNodeId.getIdType() == IdType.Opaque) {
                        this.writer.write("\"Id\":\"" + this.b(((ByteString)expandedNodeId.getValue()).getValue()) + "\"");
                    }
                }
                if (expandedNodeId.getNamespaceUri() == null || expandedNodeId.getNamespaceUri().isEmpty()) {
                    if (expandedNodeId.getNamespaceIndex() != 0) {
                        if (expandedNodeId.getNamespaceIndex() == 1 || this.qA.booleanValue()) {
                            if (expandedNodeId.getValue() != null) {
                                this.writer.write(",");
                            }
                            this.writer.write("\"Namespace\":" + expandedNodeId.getNamespaceIndex());
                        } else {
                            string2 = this.pX.getNamespaceTable().getUri(expandedNodeId.getNamespaceIndex());
                            if (string2 == null) {
                                throw new EncodingException(new String("Unable to find matching Namespace Uri for Namespace Index: " + expandedNodeId.getNamespaceIndex()));
                            }
                            if (expandedNodeId.getValue() != null) {
                                this.writer.write(",");
                            }
                            this.writer.write("\"Namespace\":\"" + string2 + "\"");
                        }
                    }
                } else {
                    if (expandedNodeId.getValue() != null) {
                        this.writer.write(",");
                    }
                    this.writer.write("\"Namespace\":\"" + expandedNodeId.getNamespaceUri() + "\"");
                }
                if (expandedNodeId.getServerIndex().intValue() != 0) {
                    if (this.qA.booleanValue()) {
                        this.writer.write(",\"ServerUri\":" + expandedNodeId.getServerIndex());
                    } else {
                        string2 = this.pX.getServerTable().getUri(expandedNodeId.getServerIndex().intValue());
                        if (string2 == null) {
                            throw new EncodingException(new String("Unable to find matching Server Uri for Server Index: " + expandedNodeId.getServerIndex()));
                        }
                        this.writer.write(",\"ServerUri\":" + string2);
                    }
                }
                this.writer.write("}");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putExpandedNodeIdArray(String string, Collection<ExpandedNodeId> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (ExpandedNodeId expandedNodeId : collection) {
                    if (expandedNodeId == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putExpandedNodeId(null, expandedNodeId);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putExpandedNodeIdArray(String string, ExpandedNodeId[] expandedNodeIdArray) throws EncodingException {
        try {
            if (expandedNodeIdArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(expandedNodeIdArray.length);
                this.writer.write("[");
                for (ExpandedNodeId expandedNodeId : expandedNodeIdArray) {
                    if (expandedNodeId == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putExpandedNodeId(null, expandedNodeId);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putExtensionObject(String string, ExtensionObject extensionObject) throws EncodingException {
        try {
            if (extensionObject != null) {
                Object object;
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write("{");
                if (extensionObject.getTypeId() != null && this.getReversibleEncoding().booleanValue()) {
                    this.putExpandedNodeId("TypeId", extensionObject.getTypeId());
                }
                if ((object = extensionObject.getObject()) != null) {
                    if (object instanceof ByteString) {
                        if (this.getReversibleEncoding().booleanValue()) {
                            this.writer.write(",\"Encoding\":1,");
                        }
                        this.putByteString("Body", (ByteString)object);
                    } else if (object instanceof XmlElement) {
                        if (this.getReversibleEncoding().booleanValue()) {
                            this.writer.write(",\"Encoding\":2,");
                        }
                        this.putXmlElement("Body", (XmlElement)object);
                    }
                } else {
                    this.putEncodeable("Body", (Structure)extensionObject.getObject());
                }
                this.writer.write("}");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putExtensionObjectArray(String string, Collection<ExtensionObject> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (ExtensionObject extensionObject : collection) {
                    if (extensionObject == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putExtensionObject(null, extensionObject);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putExtensionObjectArray(String string, ExtensionObject[] extensionObjectArray) throws EncodingException {
        try {
            if (extensionObjectArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(extensionObjectArray.length);
                this.writer.write("[");
                for (ExtensionObject extensionObject : extensionObjectArray) {
                    if (extensionObject == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putExtensionObject(null, extensionObject);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putFloat(String string, float f2) throws EncodingException {
        this.putFloat(string, new Float(f2));
    }

    @Override
    public void putFloat(String string, Float f2) throws EncodingException {
        try {
            if (f2 != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                if (!f2.equals(Float.valueOf(Float.NaN))) {
                    this.writer.write(f2.toString());
                } else {
                    this.writer.write("\"NaN\"");
                }
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putFloatArray(String string, Collection<Float> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (Float f2 : collection) {
                    if (f2 == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putFloat((String)null, f2);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putFloatArray(String string, Float[] floatArray) throws EncodingException {
        try {
            if (floatArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(floatArray.length);
                this.writer.write("[");
                for (Float f2 : floatArray) {
                    if (f2 == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putFloat((String)null, f2);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putGuid(String string, UUID uUID) throws EncodingException {
        try {
            if (uUID != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write("\"" + uUID.toString() + "\"");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putGuidArray(String string, Collection<UUID> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (UUID uUID : collection) {
                    if (uUID == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.writer.write(uUID.toString());
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putGuidArray(String string, UUID[] uUIDArray) throws EncodingException {
        try {
            if (uUIDArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(uUIDArray.length);
                this.writer.write("[");
                for (UUID uUID : uUIDArray) {
                    if (uUID == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.writer.write(uUID.toString());
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putInt16(String string, short s2) throws EncodingException {
        try {
            if (string != null) {
                this.writer.write("\"" + string + "\":");
            }
            this.writer.write(Short.toString(s2));
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putInt16(String string, Short s2) throws EncodingException {
        try {
            if (s2 != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write(s2.toString());
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putInt16Array(String string, Collection<Short> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (Short s2 : collection) {
                    this.writer.write(s2.toString());
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putInt16Array(String string, Short[] shortArray) throws EncodingException {
        try {
            if (shortArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(shortArray.length);
                this.writer.write("[");
                for (Short s2 : shortArray) {
                    this.writer.write(Short.toString(s2));
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putInt32(String string, int n2) throws EncodingException {
        try {
            if (string != null) {
                this.writer.write("\"" + string + "\":");
            }
            this.writer.write(Integer.toString(n2));
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putInt32(String string, Integer n2) throws EncodingException {
        try {
            if (n2 != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write(n2.toString());
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putInt32Array(String string, Collection<Integer> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (Integer n2 : collection) {
                    this.writer.write(n2.toString());
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putInt32Array(String string, int[] nArray) throws EncodingException {
        try {
            if (nArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(nArray.length);
                this.writer.write("[");
                for (int n2 : nArray) {
                    this.writer.write(Integer.toString(n2));
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putInt32Array(String string, Integer[] integerArray) throws EncodingException {
        try {
            if (integerArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(integerArray.length);
                this.writer.write("[");
                for (Integer n2 : integerArray) {
                    this.writer.write(n2.toString());
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putInt64(String string, long l2) throws EncodingException {
        try {
            if (string != null) {
                this.writer.write("\"" + string + "\":");
            }
            this.writer.write(Long.toString(l2));
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putInt64(String string, Long l2) throws EncodingException {
        try {
            if (l2 != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write(l2.toString());
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putInt64Array(String string, Collection<Long> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (Long l2 : collection) {
                    this.writer.write(Long.toString(l2));
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putInt64Array(String string, Long[] longArray) throws EncodingException {
        try {
            if (longArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(longArray.length);
                this.writer.write("[");
                for (Long l2 : longArray) {
                    this.writer.write(Long.toString(l2));
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putLocalizedText(String string, LocalizedText localizedText) throws EncodingException {
        try {
            if (localizedText != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                if (this.qA.booleanValue()) {
                    this.writer.write("{");
                    if (localizedText.getText() != null) {
                        this.writer.write("\"Text\":\"" + localizedText.getText() + "\"");
                    }
                    if (localizedText.getLocaleId() != null && !localizedText.getLocaleId().isEmpty()) {
                        if (localizedText.getText() != null) {
                            this.writer.write(",");
                        }
                        this.writer.write("\"Locale\":\"" + localizedText.getLocaleId() + "\"");
                    }
                    this.writer.write("}");
                } else {
                    this.writer.write("\"" + localizedText.getText() + "\"");
                }
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putLocalizedTextArray(String string, Collection<LocalizedText> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (LocalizedText localizedText : collection) {
                    if (localizedText == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putLocalizedText(null, localizedText);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putLocalizedTextArray(String string, LocalizedText[] localizedTextArray) throws EncodingException {
        try {
            if (localizedTextArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(localizedTextArray.length);
                this.writer.write("[");
                for (LocalizedText localizedText : localizedTextArray) {
                    if (localizedText == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putLocalizedText(null, localizedText);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putMessage(IEncodeable iEncodeable) throws EncodingException {
        if (iEncodeable != null) {
            this.putEncodeable(null, iEncodeable);
        }
    }

    @Override
    public void putNodeId(String string, NodeId nodeId) throws EncodingException {
        try {
            if (nodeId != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write("{");
                if (nodeId.getIdType() == IdType.String) {
                    this.writer.write("\"IdType\":1,");
                } else if (nodeId.getIdType() == IdType.Guid) {
                    this.writer.write("\"IdType\":2,");
                } else if (nodeId.getIdType() == IdType.Opaque) {
                    this.writer.write("\"IdType\":3,");
                }
                if (nodeId.getValue() != null) {
                    this.writer.write("\"Id\":");
                    if (nodeId.getIdType() == IdType.Numeric) {
                        this.writer.write(nodeId.getValue().toString());
                    } else if (nodeId.getIdType() == IdType.String) {
                        this.writer.write("\"" + (String)nodeId.getValue() + "\"");
                    } else if (nodeId.getIdType() == IdType.Opaque) {
                        this.writer.write("\"" + this.b(((ByteString)nodeId.getValue()).getValue()) + "\"");
                    } else if (nodeId.getIdType() == IdType.Guid) {
                        this.writer.write("\"" + nodeId.getValue().toString() + "\"");
                    }
                }
                if (nodeId.getNamespaceIndex() != 0) {
                    if (nodeId.getNamespaceIndex() == 1 || this.qA.booleanValue()) {
                        if (nodeId.getValue() != null) {
                            this.writer.write(",");
                        }
                        this.writer.write("\"Namespace\":" + nodeId.getNamespaceIndex());
                    } else {
                        String string2 = this.pX.getNamespaceTable().getUri(nodeId.getNamespaceIndex());
                        if (string2 == null) {
                            throw new EncodingException(new String("Unable to find matching Namespace Uri for Namespace Index: " + nodeId.getNamespaceIndex()));
                        }
                        if (nodeId.getValue() != null) {
                            this.writer.write(",");
                        }
                        this.writer.write(",\"Namespace\":" + string2);
                    }
                }
                this.writer.write("}");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putNodeIdArray(String string, Collection<NodeId> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (NodeId nodeId : collection) {
                    if (nodeId == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putNodeId(null, nodeId);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putNodeIdArray(String string, NodeId[] nodeIdArray) throws EncodingException {
        try {
            if (nodeIdArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(nodeIdArray.length);
                this.writer.write("[");
                for (NodeId nodeId : nodeIdArray) {
                    if (nodeId == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putNodeId(null, nodeId);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putObject(String string, Class<?> clazz, Object object) throws EncodingException {
    }

    @Override
    public void putObject(String string, Object object) throws EncodingException {
    }

    @Override
    public void putQualifiedName(String string, QualifiedName qualifiedName) throws EncodingException {
        try {
            if (qualifiedName != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write("{");
                if (qualifiedName.getName() != null) {
                    this.writer.write("\"Name\":\"" + qualifiedName.getName() + "\"");
                }
                if (qualifiedName.getNamespaceIndex() != 0) {
                    if (qualifiedName.getNamespaceIndex() == 1 && this.qA.booleanValue()) {
                        this.writer.write(",\"Uri\":" + qualifiedName.getNamespaceIndex());
                    } else {
                        String string2 = this.pX.getNamespaceTable().getUri(qualifiedName.getNamespaceIndex());
                        if (string2 == null) {
                            this.writer.write(",\"Uri\":" + qualifiedName.getNamespaceIndex());
                        } else {
                            this.writer.write(",\"Uri\":" + string2);
                        }
                    }
                }
                this.writer.write("}");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putQualifiedNameArray(String string, Collection<QualifiedName> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (QualifiedName qualifiedName : collection) {
                    if (qualifiedName == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putQualifiedName(null, qualifiedName);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putQualifiedNameArray(String string, QualifiedName[] qualifiedNameArray) throws EncodingException {
        try {
            if (qualifiedNameArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(qualifiedNameArray.length);
                this.writer.write("[");
                for (QualifiedName qualifiedName : qualifiedNameArray) {
                    if (qualifiedName == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putQualifiedName(null, qualifiedName);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putSByte(String string, byte by) throws EncodingException {
    }

    @Override
    public void putSByte(String string, Byte by) throws EncodingException {
    }

    @Override
    public void putSByte(String string, int n2) throws EncodingException {
    }

    @Override
    public void putSByteArray(String string, Byte[] byteArray) throws EncodingException {
    }

    @Override
    public void putSByteArray(String string, Collection<Byte> collection) throws EncodingException {
    }

    @Override
    public void putScalar(String string, int n2, Object object) throws EncodingException {
        switch (n2) {
            case 1: {
                this.putBoolean(string, (Boolean)object);
                break;
            }
            case 2: {
                this.putSByte(string, (Byte)object);
                break;
            }
            case 3: {
                this.putByte(string, (UnsignedByte)object);
                break;
            }
            case 4: {
                this.putInt16(string, (Short)object);
                break;
            }
            case 5: {
                this.putUInt16(string, (UnsignedShort)object);
                break;
            }
            case 6: {
                this.putInt32(string, (Integer)object);
                break;
            }
            case 7: {
                this.putUInt32(string, (UnsignedInteger)object);
                break;
            }
            case 8: {
                this.putInt64(string, (Long)object);
                break;
            }
            case 9: {
                this.putUInt64(string, (UnsignedLong)object);
                break;
            }
            case 10: {
                this.putFloat(string, (Float)object);
                break;
            }
            case 11: {
                this.putDouble(string, (Double)object);
                break;
            }
            case 12: {
                this.putString(string, (String)object);
                break;
            }
            case 13: {
                this.putDateTime(string, (DateTime)object);
                break;
            }
            case 14: {
                this.putGuid(string, (UUID)object);
                break;
            }
            case 15: {
                this.putByteString(string, (ByteString)object);
                break;
            }
            case 16: {
                this.putXmlElement(string, (XmlElement)object);
                break;
            }
            case 17: {
                this.putNodeId(string, (NodeId)object);
                break;
            }
            case 18: {
                this.putExpandedNodeId(string, (ExpandedNodeId)object);
                break;
            }
            case 19: {
                this.putStatusCode(string, (StatusCode)object);
                break;
            }
            case 20: {
                this.putQualifiedName(string, (QualifiedName)object);
                break;
            }
            case 21: {
                this.putLocalizedText(string, (LocalizedText)object);
                break;
            }
            case 22: {
                if (object instanceof Structure) {
                    this.putStructure(string, (Structure)object);
                    break;
                }
                this.putExtensionObject(string, (ExtensionObject)object);
                break;
            }
            case 23: {
                this.putDataValue(string, (DataValue)object);
                break;
            }
            case 24: {
                this.putVariant(string, (Variant)object);
                break;
            }
            case 25: {
                this.putDiagnosticInfo(string, (DiagnosticInfo)object);
                break;
            }
            default: {
                throw new EncodingException("cannot encode builtin type " + n2);
            }
        }
    }

    @Override
    public void putStatusCode(String string, StatusCode statusCode) throws EncodingException {
        try {
            if (statusCode == null) {
                return;
            }
            if (statusCode.isGood()) {
                if (this.qz.booleanValue()) {
                    this.writer.write("null");
                }
                return;
            }
            if (string != null) {
                this.writer.write("\"" + string + "\":");
            }
            if (!this.qA.booleanValue()) {
                this.writer.write("{");
                this.writer.write("\"Code\":" + statusCode.getValue());
                this.writer.write(",\"Symbol\":\"" + statusCode.getName() + "\"");
                this.writer.write("}");
            } else {
                this.writer.write(statusCode.getValue().toString());
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putStatusCodeArray(String string, Collection<StatusCode> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (StatusCode statusCode : collection) {
                    if (statusCode == null || statusCode == StatusCode.GOOD) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putStatusCode(null, statusCode);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putStatusCodeArray(String string, StatusCode[] statusCodeArray) throws EncodingException {
        try {
            if (statusCodeArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(statusCodeArray.length);
                this.writer.write("[");
                for (StatusCode statusCode : statusCodeArray) {
                    if (statusCode == null || statusCode.isGood()) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putStatusCode(null, statusCode);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putString(String string, String string2) throws EncodingException {
        try {
            if (string2 != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write("\"" + string2 + "\"");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putStringArray(String string, Collection<String> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (String string2 : collection) {
                    this.writer.write(string2);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putStringArray(String string, String[] stringArray) throws EncodingException {
        try {
            if (stringArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(stringArray.length);
                this.writer.write("[");
                for (String string2 : stringArray) {
                    this.writer.write(string2);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putStructure(String string, Structure structure) throws EncodingException {
        try {
            if (structure != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.putEncodeable(null, structure);
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putStructureArray(String string, Collection<Structure> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (Structure structure : collection) {
                    if (structure == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putStructure(null, structure);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putStructureArray(String string, Structure[] structureArray) throws EncodingException {
        try {
            if (structureArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(structureArray.length);
                this.writer.write("[");
                for (Structure structure : structureArray) {
                    if (structure == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.putStructure(null, structure);
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt16(String string, UnsignedShort unsignedShort) throws EncodingException {
        try {
            if (unsignedShort != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write(unsignedShort.toString());
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt16Array(String string, Collection<UnsignedShort> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (UnsignedShort unsignedShort : collection) {
                    this.writer.write(unsignedShort.toString());
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt16Array(String string, UnsignedShort[] unsignedShortArray) throws EncodingException {
        try {
            if (unsignedShortArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(unsignedShortArray.length);
                this.writer.write("[");
                for (UnsignedShort unsignedShort : unsignedShortArray) {
                    this.writer.write(unsignedShort.toString());
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt32(String string, UnsignedInteger unsignedInteger) throws EncodingException {
        try {
            if (unsignedInteger != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write(unsignedInteger.toString());
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt32Array(String string, Collection<UnsignedInteger> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (UnsignedInteger unsignedInteger : collection) {
                    this.writer.write(unsignedInteger.toString());
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt32Array(String string, UnsignedInteger[] unsignedIntegerArray) throws EncodingException {
        try {
            if (unsignedIntegerArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(unsignedIntegerArray.length);
                this.writer.write("[");
                for (UnsignedInteger unsignedInteger : unsignedIntegerArray) {
                    this.writer.write(unsignedInteger.toString());
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt64(String string, UnsignedLong unsignedLong) throws EncodingException {
        try {
            if (unsignedLong != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write(unsignedLong.toString());
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt64Array(String string, Collection<UnsignedLong> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (UnsignedLong unsignedLong : collection) {
                    this.writer.write(unsignedLong.toString());
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt64Array(String string, UnsignedLong[] unsignedLongArray) throws EncodingException {
        try {
            if (unsignedLongArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(unsignedLongArray.length);
                this.writer.write("[");
                for (UnsignedLong unsignedLong : unsignedLongArray) {
                    this.writer.write(unsignedLong.toString());
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putVariant(String string, Variant variant) throws EncodingException {
        try {
            if (variant != null) {
                Integer n2 = BuiltinsMap.ID_MAP.get(variant.getValue().getClass());
                if (n2 == null || n2 == 0) {
                    return;
                }
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                if (this.qA.booleanValue()) {
                    this.writer.write("{");
                    this.writer.write("\"Type\":" + n2 + ",");
                    this.a("Body", variant);
                    this.writer.write("}");
                } else {
                    this.a(null, variant);
                }
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putVariantArray(String string, Collection<Variant> collection) throws EncodingException {
        try {
            this.h(collection.size());
            if (string != null) {
                this.writer.write("\"" + string + "\":");
            }
            this.writer.write("[");
            for (Variant variant : collection) {
                if (variant != null && BuiltinsMap.ID_MAP.get(variant.getValue().getClass()) != 0) {
                    this.putVariant(null, variant);
                    continue;
                }
                this.writer.write("null");
            }
            this.writer.write("]");
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putVariantArray(String string, Variant[] variantArray) throws EncodingException {
        try {
            this.h(variantArray.length);
            if (string != null) {
                this.writer.write("\"" + string + "\":");
            }
            this.writer.write("[");
            for (Variant variant : variantArray) {
                if (variant != null && BuiltinsMap.ID_MAP.get(variant.getValue().getClass()) != 0) {
                    this.putVariant(null, variant);
                    continue;
                }
                this.writer.write("null");
            }
            this.writer.write("]");
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putXmlElement(String string, XmlElement xmlElement) throws EncodingException {
        try {
            if (xmlElement != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write("\"" + xmlElement.getValue() + "\"");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putXmlElementArray(String string, Collection<XmlElement> collection) throws EncodingException {
        try {
            if (collection != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(collection.size());
                this.writer.write("[");
                for (XmlElement xmlElement : collection) {
                    if (xmlElement == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.writer.write(xmlElement.getValue());
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    @Override
    public void putXmlElementArray(String string, XmlElement[] xmlElementArray) throws EncodingException {
        try {
            if (xmlElementArray != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.h(xmlElementArray.length);
                this.writer.write("[");
                for (XmlElement xmlElement : xmlElementArray) {
                    if (xmlElement == null) {
                        this.writer.write("null");
                        continue;
                    }
                    this.writer.write(xmlElement.getValue().toString());
                }
                this.writer.write("]");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    public void setEncoderContext(EncoderContext encoderContext) {
        this.pX = encoderContext;
    }

    public void setReversibleEncoding(Boolean bl) {
        this.qA = bl;
    }

    public void startNew() throws IOException {
        this.writer.write("{");
    }

    public void startNew(String string) throws IOException {
        this.writer.write("\"" + string + "\":");
        this.writer.write("{");
    }

    private void h(int n2) throws EncodingException {
        int n3 = this.pX.getMaxArrayLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxArrayLength " + n3 + " < " + n2);
            logger.warn("assertArrayLength: failed", (Throwable)encodingException);
            throw encodingException;
        }
    }

    private void f(int n2) throws EncodingException {
        int n3 = this.pX.getMaxByteStringLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxByteStringLength " + n3 + " < " + n2);
            throw encodingException;
        }
    }

    private void a(String string, BigDecimal bigDecimal) throws EncodingException {
        try {
            if (bigDecimal != null) {
                if (string != null) {
                    this.writer.write("\"" + string + "\":");
                }
                this.writer.write("{");
                this.writer.write("\"Scale\":" + bigDecimal.scale());
                this.writer.write(",\"Value\":\"" + bigDecimal.unscaledValue().toString() + "\"");
                this.writer.write("}");
            }
        }
        catch (IOException iOException) {
            throw JsonEncoder.b(iOException);
        }
    }

    private void a(String string, OptionSetDataType<?, ?> optionSetDataType, Class<? extends OptionSetDataType<?, ?>> clazz) throws EncodingException {
        if (optionSetDataType != null) {
            this.put(string, optionSetDataType.getAsBuiltInType());
        }
    }

    private void a(String string, Variant variant) throws EncodingException, IOException {
        Object object = variant.getValue();
        Integer n2 = BuiltinsMap.ID_MAP.get(variant.getCompositeClass());
        switch (n2) {
            case 1: {
                this.putBoolean(string, (Boolean)object);
                break;
            }
            case 2: {
                this.putSByte(string, (Byte)object);
                break;
            }
            case 3: {
                this.putByte(string, (UnsignedByte)object);
                break;
            }
            case 4: {
                this.putInt16(string, (Short)object);
                break;
            }
            case 5: {
                this.putUInt16(string, (UnsignedShort)object);
                break;
            }
            case 6: {
                this.putInt32(string, (Integer)object);
                break;
            }
            case 7: {
                this.putUInt32(string, (UnsignedInteger)object);
                break;
            }
            case 8: {
                this.putInt64(string, (Long)object);
                break;
            }
            case 9: {
                this.putUInt64(string, (UnsignedLong)object);
                break;
            }
            case 10: {
                this.putFloat(string, (Float)object);
                break;
            }
            case 11: {
                this.putDouble(string, (Double)object);
                break;
            }
            case 12: {
                this.putString(string, (String)object);
                break;
            }
            case 13: {
                this.putDateTime(string, (DateTime)object);
                break;
            }
            case 14: {
                this.putGuid(string, (UUID)object);
                break;
            }
            case 15: {
                this.putByteString(string, (ByteString)object);
                break;
            }
            case 16: {
                this.putXmlElement(string, (XmlElement)object);
                break;
            }
            case 17: {
                this.putNodeId(string, (NodeId)object);
                break;
            }
            case 18: {
                this.putExpandedNodeId(string, (ExpandedNodeId)object);
                break;
            }
            case 19: {
                this.putStatusCode(string, (StatusCode)object);
                break;
            }
            case 20: {
                this.putQualifiedName(string, (QualifiedName)object);
                break;
            }
            case 21: {
                this.putLocalizedText(string, (LocalizedText)object);
                break;
            }
            case 22: {
                if (object instanceof Structure) {
                    this.putStructure(string, (Structure)object);
                    break;
                }
                this.putExtensionObject(string, (ExtensionObject)object);
                break;
            }
            case 23: {
                this.putDataValue(string, (DataValue)object);
                break;
            }
            case 24: {
                this.putVariant(string, (Variant)object);
                break;
            }
            case 25: {
                this.putDiagnosticInfo(string, (DiagnosticInfo)object);
                break;
            }
            default: {
                throw new EncodingException("cannot encode builtin type " + n2);
            }
        }
    }

    private String b(byte[] byArray) throws EncodingException {
        if (byArray == null) {
            return null;
        }
        this.f(byArray.length);
        return CryptoUtil.base64Encode(byArray);
    }

    private String d(DateTime dateTime) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATETIME_FORMAT);
        try {
            if (dateTime.getTimeInMillis() <= DateTime.parseDateTime(MIN_DATETIME).getTimeInMillis()) {
                return null;
            }
            if (dateTime.compareTo(DateTime.MAX_VALUE) >= 0) {
                return MAX_DATETIME;
            }
            if (dateTime.compareTo(DateTime.MIN_VALUE) <= 0) {
                return MIN_DATETIME;
            }
            return simpleDateFormat.format(dateTime.getTimeInMillis());
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        pV = new ExpandedNodeId(NamespaceTable.OPCUA_NAMESPACE, Identifiers.Decimal.getValue());
        JsonEncoder.a(Boolean.class, new a<Boolean>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, Boolean bl, Class<? extends Boolean> clazz) throws EncodingException {
                jsonEncoder.putBoolean(string, bl);
            }
        });
        JsonEncoder.a(Byte.class, new a<Byte>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, Byte by, Class<? extends Byte> clazz) throws EncodingException {
                jsonEncoder.putSByte(string, by);
            }
        });
        JsonEncoder.a(UnsignedByte.class, new a<UnsignedByte>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, UnsignedByte unsignedByte, Class<? extends UnsignedByte> clazz) throws EncodingException {
                jsonEncoder.putByte(string, unsignedByte);
            }
        });
        JsonEncoder.a(Short.class, new a<Short>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, Short s2, Class<? extends Short> clazz) throws EncodingException {
                jsonEncoder.putInt16(string, s2);
            }
        });
        JsonEncoder.a(UnsignedShort.class, new a<UnsignedShort>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, UnsignedShort unsignedShort, Class<? extends UnsignedShort> clazz) throws EncodingException {
                jsonEncoder.putUInt16(string, unsignedShort);
            }
        });
        JsonEncoder.a(Integer.class, new a<Integer>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, Integer n2, Class<? extends Integer> clazz) throws EncodingException {
                jsonEncoder.putInt32(string, n2);
            }
        });
        JsonEncoder.a(UnsignedInteger.class, new a<UnsignedInteger>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, UnsignedInteger unsignedInteger, Class<? extends UnsignedInteger> clazz) throws EncodingException {
                jsonEncoder.putUInt32(string, unsignedInteger);
            }
        });
        JsonEncoder.a(Long.class, new a<Long>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, Long l2, Class<? extends Long> clazz) throws EncodingException {
                jsonEncoder.putInt64(string, l2);
            }
        });
        JsonEncoder.a(UnsignedLong.class, new a<UnsignedLong>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, UnsignedLong unsignedLong, Class<? extends UnsignedLong> clazz) throws EncodingException {
                jsonEncoder.putUInt64(string, unsignedLong);
            }
        });
        JsonEncoder.a(Float.class, new a<Float>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, Float f2, Class<? extends Float> clazz) throws EncodingException {
                jsonEncoder.putFloat(string, f2);
            }
        });
        JsonEncoder.a(Double.class, new a<Double>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, Double d2, Class<? extends Double> clazz) throws EncodingException {
                jsonEncoder.putDouble(string, d2);
            }
        });
        JsonEncoder.a(String.class, new a<String>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, String string2, Class<? extends String> clazz) throws EncodingException {
                jsonEncoder.putString(string, string2);
            }
        });
        JsonEncoder.a(UUID.class, new a<UUID>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, UUID uUID, Class<? extends UUID> clazz) throws EncodingException {
                jsonEncoder.putGuid(string, uUID);
            }
        });
        JsonEncoder.a(ByteString.class, new a<ByteString>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, ByteString byteString, Class<? extends ByteString> clazz) throws EncodingException {
                jsonEncoder.putByteString(string, byteString);
            }
        });
        JsonEncoder.a(XmlElement.class, new a<XmlElement>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, XmlElement xmlElement, Class<? extends XmlElement> clazz) throws EncodingException {
                jsonEncoder.putXmlElement(string, xmlElement);
            }
        });
        JsonEncoder.a(NodeId.class, new a<NodeId>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, NodeId nodeId, Class<? extends NodeId> clazz) throws EncodingException {
                jsonEncoder.putNodeId(string, nodeId);
            }
        });
        JsonEncoder.a(ExpandedNodeId.class, new a<ExpandedNodeId>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, ExpandedNodeId expandedNodeId, Class<? extends ExpandedNodeId> clazz) throws EncodingException {
                jsonEncoder.putExpandedNodeId(string, expandedNodeId);
            }
        });
        JsonEncoder.a(StatusCode.class, new a<StatusCode>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, StatusCode statusCode, Class<? extends StatusCode> clazz) throws EncodingException {
                jsonEncoder.putStatusCode(string, statusCode);
            }
        });
        JsonEncoder.a(QualifiedName.class, new a<QualifiedName>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, QualifiedName qualifiedName, Class<? extends QualifiedName> clazz) throws EncodingException {
                jsonEncoder.putQualifiedName(string, qualifiedName);
            }
        });
        JsonEncoder.a(LocalizedText.class, new a<LocalizedText>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, LocalizedText localizedText, Class<? extends LocalizedText> clazz) throws EncodingException {
                jsonEncoder.putLocalizedText(string, localizedText);
            }
        });
        qp = new a<DateTime>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, DateTime dateTime, Class<? extends DateTime> clazz) throws EncodingException {
                jsonEncoder.putDateTime(string, dateTime);
            }
        };
        qq = new a<ExtensionObject>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, ExtensionObject extensionObject, Class<? extends ExtensionObject> clazz) throws EncodingException {
                jsonEncoder.putExtensionObject(string, extensionObject);
            }
        };
        qr = new a<Structure>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, Structure structure, Class<? extends Structure> clazz) throws EncodingException {
                jsonEncoder.putEncodeable(string, clazz, structure);
            }
        };
        qs = new a<DataValue>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, DataValue dataValue, Class<? extends DataValue> clazz) throws EncodingException {
                jsonEncoder.putDataValue(string, dataValue);
            }
        };
        qt = new a<Variant>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, Variant variant, Class<? extends Variant> clazz) throws EncodingException {
                jsonEncoder.putVariant(string, variant);
            }
        };
        qu = new a<DiagnosticInfo>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, DiagnosticInfo diagnosticInfo, Class<? extends DiagnosticInfo> clazz) throws EncodingException {
                jsonEncoder.putDiagnosticInfo(string, diagnosticInfo);
            }
        };
        qv = new a<Enumeration>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, Enumeration enumeration, Class<? extends Enumeration> clazz) throws EncodingException {
                jsonEncoder.putEnumeration(string, enumeration);
            }
        };
        qw = new a<BigDecimal>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, BigDecimal bigDecimal, Class<? extends BigDecimal> clazz) throws EncodingException {
                jsonEncoder.a(string, bigDecimal);
            }
        };
        qx = new a<OptionSetDataType<?, ?>>(){

            public void b(JsonEncoder jsonEncoder, String string, OptionSetDataType<?, ?> optionSetDataType, Class<? extends OptionSetDataType<?, ?>> clazz) throws EncodingException {
                jsonEncoder.a(string, optionSetDataType, clazz);
            }

            @Override
            public /* synthetic */ void a(JsonEncoder jsonEncoder, String string, Object object, Class clazz) throws EncodingException {
                this.b(jsonEncoder, string, (OptionSetDataType)object, clazz);
            }
        };
        JsonEncoder.a(Object.class, new a<Object>(){

            @Override
            public void a(JsonEncoder jsonEncoder, String string, Object object, Class<? extends Object> clazz) throws EncodingException {
                if (object instanceof Variant) {
                    logger.warn("Object.class encoder was given a Variant directly, instead should given the value within Variant");
                    qt.a(jsonEncoder, string, (Variant)object, Variant.class);
                } else {
                    qt.a(jsonEncoder, string, new Variant(object), Variant.class);
                }
            }
        });
    }

    private static interface a<T> {
        public void a(JsonEncoder var1, String var2, T var3, Class<? extends T> var4) throws EncodingException;
    }
}

