/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.binary;

import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IDecoder;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.IEncoder;
import com.prosysopc.ua.stack.encoding.binary.DecoderUtils;
import com.prosysopc.ua.stack.encoding.binary.IEncodeableSerializer;
import com.prosysopc.ua.stack.encoding.utils.EncodeableDesc;
import com.prosysopc.ua.stack.encoding.utils.EncodeableDescTable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Set;

public class EncodeableReflectionSerializer
implements IEncodeableSerializer {
    EncodeableDescTable qj;
    Set<Class<? extends IEncodeable>> qk;
    Set<ExpandedNodeId> ql;

    public EncodeableReflectionSerializer(EncodeableDescTable encodeableDescTable) {
        this.qj = encodeableDescTable;
        this.qk = encodeableDescTable.getClassMap().keySet();
        this.ql = encodeableDescTable.getBinIdMap().keySet();
    }

    @Override
    public void calcEncodeable(Class<? extends IEncodeable> clazz, IEncodeable iEncodeable, IEncoder iEncoder) throws EncodingException {
        EncodeableDesc encodeableDesc = this.qj.get(clazz);
        if (encodeableDesc == null) {
            throw new EncodingException("Cannot encode " + clazz);
        }
        try {
            for (EncodeableDesc.FieldInfo fieldInfo : encodeableDesc.fields) {
                Field field = fieldInfo.field;
                Object object = iEncodeable == null ? null : field.get(iEncodeable);
                iEncoder.putObject(fieldInfo.field.getName(), fieldInfo.type, object);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    @Override
    public Class<? extends IEncodeable> getClass(ExpandedNodeId expandedNodeId) {
        EncodeableDesc encodeableDesc = this.qj.get(expandedNodeId);
        if (encodeableDesc == null) {
            return null;
        }
        return encodeableDesc.clazz;
    }

    @Override
    public IEncodeable getEncodeable(Class<? extends IEncodeable> clazz, IDecoder iDecoder) throws DecodingException {
        EncodeableDesc encodeableDesc = this.qj.get(clazz);
        if (encodeableDesc == null) {
            throw new DecodingException("Cannot decode " + clazz);
        }
        try {
            IEncodeable iEncodeable = encodeableDesc.clazz.newInstance();
            for (EncodeableDesc.FieldInfo fieldInfo : encodeableDesc.fields) {
                Object object;
                Object object2;
                if (fieldInfo.builtinType >= 0) {
                    object2 = fieldInfo.isArray ? iDecoder.getArrayObject(fieldInfo.field.getName(), fieldInfo.builtinType) : iDecoder.getScalarObject(fieldInfo.field.getName(), fieldInfo.builtinType);
                    fieldInfo.field.set(iEncodeable, object2);
                    continue;
                }
                object2 = this.qj.get(fieldInfo.type);
                if (object2 != null) {
                    object = fieldInfo.isArray ? iDecoder.getEncodeableArray(fieldInfo.field.getName(), ((EncodeableDesc)object2).clazz) : this.getEncodeable(((EncodeableDesc)object2).clazz, iDecoder);
                    fieldInfo.field.set(iEncodeable, object);
                    continue;
                }
                if (!fieldInfo.isArray && Enumeration.class.isAssignableFrom(fieldInfo.type)) {
                    object = iDecoder.getEnumeration(fieldInfo.field.getName(), fieldInfo.type);
                    fieldInfo.field.set(iEncodeable, object);
                    continue;
                }
                if (fieldInfo.isArray && Enumeration.class.isAssignableFrom(fieldInfo.type.getComponentType())) {
                    object = iDecoder.getEnumerationArray(fieldInfo.field.getName(), fieldInfo.type.getComponentType());
                    fieldInfo.field.set(iEncodeable, object);
                    continue;
                }
                throw new DecodingException("Cannot decode " + fieldInfo.type);
            }
            if (iEncodeable instanceof ServiceResponse) {
                DecoderUtils.fixResponseHeader(((ServiceResponse)iEncodeable).getResponseHeader());
            }
            return iEncodeable;
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    @Override
    public ExpandedNodeId getNodeId(Class<? extends IEncodeable> clazz, EncodeType encodeType) {
        EncodeableDesc encodeableDesc = this.qj.get(clazz);
        if (encodeableDesc == null) {
            return null;
        }
        if (encodeType == EncodeType.Binary) {
            return encodeableDesc.binaryId;
        }
        if (encodeType == EncodeType.Xml) {
            return encodeableDesc.xmlId;
        }
        return null;
    }

    @Override
    public void getSupportedClasses(Collection<Class<? extends IEncodeable>> collection) {
        collection.addAll(this.qk);
    }

    @Override
    public void getSupportedNodeIds(Collection<ExpandedNodeId> collection) {
        collection.addAll(this.ql);
    }

    @Override
    public void putEncodeable(Class<? extends IEncodeable> clazz, IEncodeable iEncodeable, IEncoder iEncoder) throws EncodingException {
        EncodeableDesc encodeableDesc = this.qj.get(clazz);
        if (encodeableDesc == null) {
            throw new EncodingException("Cannot encode " + clazz);
        }
        try {
            for (EncodeableDesc.FieldInfo fieldInfo : encodeableDesc.fields) {
                Field field = fieldInfo.field;
                Object object = iEncodeable == null ? null : field.get(iEncodeable);
                iEncoder.putObject(fieldInfo.field.getName(), fieldInfo.type, object);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }
}

