/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.binary;

import com.prosysopc.ua.ByteOptionSetDataType;
import com.prosysopc.ua.OptionSetDataType;
import com.prosysopc.ua.UInt16OptionSetDataType;
import com.prosysopc.ua.UInt32OptionSetDataType;
import com.prosysopc.ua.UInt64OptionSetDataType;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.IDecoder;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.NodeIdEncoding;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferReadable;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryReadable;
import com.prosysopc.ua.stack.utils.bytebuffer.InputStreamReadable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryDecoder
implements IDecoder {
    private static final Charset UTF8 = Charset.forName("utf-8");
    private static final Logger logger = LoggerFactory.getLogger(BinaryDecoder.class);
    private static final Map<Class<?>, a<?>> pL = new HashMap();
    private static final a<DateTime> pM;
    private static final a<ExtensionObject> pN;
    private static final a<Structure> pO;
    private static final a<DataValue> pP;
    private static final a<Variant> pQ;
    private static final a<DiagnosticInfo> pR;
    private static final a<Enumeration> pS;
    private static final a<BigDecimal> pT;
    private static final a<OptionSetDataType<?, ?>> pU;
    private static final ExpandedNodeId pV;
    IBinaryReadable pW;
    EncoderContext pX;

    private static <T> void a(Class<T> clazz, a<T> a2) {
        if (!Object.class.equals(clazz) && !Modifier.isFinal(clazz.getModifiers())) {
            throw new Error("Class " + clazz + " is not final, and cannot be put to known final classes serialization helper");
        }
        a<T> a3 = pL.put(clazz, a2);
        if (a3 != null) {
            throw new Error("Class " + clazz + " already has a serializer defined");
        }
    }

    private static <T> a<T> g(Class<?> clazz) throws DecodingException {
        a<?> a2 = pL.get(clazz);
        if (a2 != null) {
            return a2;
        }
        if (ExtensionObject.class.isAssignableFrom(clazz)) {
            return pN;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return pO;
        }
        if (DataValue.class.isAssignableFrom(clazz)) {
            return pP;
        }
        if (Variant.class.isAssignableFrom(clazz)) {
            return pQ;
        }
        if (DiagnosticInfo.class.isAssignableFrom(clazz)) {
            return pR;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return pS;
        }
        if (DateTime.class.isAssignableFrom(clazz)) {
            return pM;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return pT;
        }
        if (OptionSetDataType.class.isAssignableFrom(clazz)) {
            return pU;
        }
        throw new DecodingException("Cannot decode class: " + clazz);
    }

    private static DecodingException a(IOException iOException) {
        if (iOException instanceof ClosedChannelException) {
            return new DecodingException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException);
        }
        if (iOException instanceof EOFException) {
            return new DecodingException(StatusCodes.Bad_EndOfStream, (Throwable)iOException);
        }
        if (iOException instanceof ConnectException) {
            return new DecodingException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
        }
        if (iOException instanceof SocketException) {
            return new DecodingException(StatusCodes.Bad_UnexpectedError, (Throwable)iOException);
        }
        return new DecodingException(StatusCodes.Bad_UnexpectedError, (Throwable)iOException);
    }

    public BinaryDecoder(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setReadable(new ByteBufferReadable(byteBuffer));
    }

    public BinaryDecoder(byte[] byArray, int n2, int n3) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setReadable(new ByteBufferReadable(byteBuffer));
    }

    public BinaryDecoder(ByteBuffer byteBuffer) {
        this.setReadable(new ByteBufferReadable(byteBuffer));
    }

    public BinaryDecoder(IBinaryReadable iBinaryReadable) {
        this.setReadable(iBinaryReadable);
    }

    public BinaryDecoder(InputStream inputStream, int n2) {
        InputStreamReadable inputStreamReadable = new InputStreamReadable(inputStream, n2);
        inputStreamReadable.order(ByteOrder.LITTLE_ENDIAN);
        this.setReadable(inputStreamReadable);
    }

    @Override
    public <T> T get(String string, Class<T> clazz) throws DecodingException {
        int object;
        Class<?> clazz2 = MultiDimensionArrayUtils.getComponentType(clazz);
        a<Object> a2 = BinaryDecoder.g(clazz2);
        int n2 = MultiDimensionArrayUtils.getClassDimensions(clazz);
        if (n2 == 0) {
            a<Object> a3 = a2;
            return a3.c(this, string, clazz);
        }
        if (n2 == 1) {
            int n3 = this.getInt32(null);
            if (n3 == -1) {
                return null;
            }
            Object[] objectArray = (Object[])Array.newInstance(clazz2, n3);
            a<Object> a4 = a2;
            for (int objectArray2 = 0; objectArray2 < n3; ++objectArray2) {
                objectArray[objectArray2] = a4.c(this, null, clazz2);
            }
            Object[] objectArray2 = objectArray;
            return (T)objectArray2;
        }
        int[] nArray = this.getInt32Array_(null);
        if (nArray == null) {
            return null;
        }
        int n4 = 1;
        int[] objectArray = nArray;
        int a5 = objectArray.length;
        for (object = 0; object < a5; ++object) {
            int n3 = objectArray[object];
            if (n3 < 0) {
                return null;
            }
            n4 *= n3;
        }
        Object[] objectArray3 = (Object[])Array.newInstance(clazz2, n4);
        a<Object> a3 = a2;
        for (object = 0; object < n4; ++object) {
            objectArray3[object] = a3.c(this, null, clazz2);
        }
        Object object2 = MultiDimensionArrayUtils.demuxArray((Object)objectArray3, nArray, clazz2);
        return (T)object2;
    }

    @Override
    public Object getArrayObject(String string, int n2) throws DecodingException {
        switch (n2) {
            case 1: {
                return this.getBooleanArray(null);
            }
            case 2: {
                return this.getSByteArray(null);
            }
            case 3: {
                return this.getByteArray(null);
            }
            case 4: {
                return this.getInt16Array(null);
            }
            case 5: {
                return this.getUInt16Array(null);
            }
            case 6: {
                return this.getInt32Array(null);
            }
            case 7: {
                return this.getUInt32Array(null);
            }
            case 8: {
                return this.getInt64Array(null);
            }
            case 9: {
                return this.getUInt64Array(null);
            }
            case 10: {
                return this.getFloatArray(null);
            }
            case 11: {
                return this.getDoubleArray(null);
            }
            case 12: {
                return this.getStringArray(null);
            }
            case 13: {
                return this.getDateTimeArray(null);
            }
            case 14: {
                return this.getGuidArray(null);
            }
            case 15: {
                return this.getByteStringArray(null);
            }
            case 16: {
                return this.getXmlElementArray(null);
            }
            case 17: {
                return this.getNodeIdArray(null);
            }
            case 18: {
                return this.getExpandedNodeIdArray(null);
            }
            case 19: {
                return this.getStatusCodeArray(null);
            }
            case 20: {
                return this.getQualifiedNameArray(null);
            }
            case 21: {
                return this.getLocalizedTextArray(null);
            }
            case 22: {
                return this.getExtensionObjectArray(null);
            }
            case 23: {
                return this.getDataValueArray(null);
            }
            case 24: {
                return this.getVariantArray(null);
            }
            case 25: {
                return this.getDiagnosticInfoArray(null);
            }
        }
        throw new DecodingException("Cannot decode builtin type id " + n2);
    }

    @Override
    public Boolean getBoolean(String string) throws DecodingException {
        try {
            if (this.pW.get() == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public Boolean[] getBooleanArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 1);
            Boolean[] booleanArray = new Boolean[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                booleanArray[i2] = this.getBoolean(null);
            }
            return booleanArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public UnsignedByte getByte(String string) throws DecodingException {
        try {
            return UnsignedByte.getFromBits(this.pW.get());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public UnsignedByte[] getByteArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 1);
            UnsignedByte[] unsignedByteArray = new UnsignedByte[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                unsignedByteArray[i2] = this.getByte(null);
            }
            return unsignedByteArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public ByteString getByteString(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.f(n2);
            byte[] byArray = new byte[n2];
            this.pW.get(byArray);
            return ByteString.valueOf(byArray);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public ByteString[] getByteStringArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 4);
            ByteString[] byteStringArray = new ByteString[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                byteStringArray[i2] = this.getByteString(null);
            }
            return byteStringArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public DataValue getDataValue(String string) throws DecodingException {
        try {
            byte by = this.pW.get();
            Variant variant = (by & 1) != 0 ? this.getVariant(null) : null;
            StatusCode statusCode = (by & 2) != 0 ? this.getStatusCode(null) : StatusCode.GOOD;
            DateTime dateTime = (by & 4) != 0 ? this.getDateTime(null) : null;
            UnsignedShort unsignedShort = (by & 0x10) != 0 ? this.getUInt16(null) : UnsignedShort.MIN_VALUE;
            DateTime dateTime2 = (by & 8) != 0 ? this.getDateTime(null) : null;
            UnsignedShort unsignedShort2 = (by & 0x20) != 0 ? this.getUInt16(null) : UnsignedShort.MIN_VALUE;
            return new DataValue(variant, statusCode, dateTime, unsignedShort, dateTime2, unsignedShort2);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public DataValue[] getDataValueArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 1);
            DataValue[] dataValueArray = new DataValue[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                dataValueArray[i2] = this.getDataValue(null);
            }
            return dataValueArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public DateTime getDateTime(String string) throws DecodingException {
        try {
            long l2 = this.pW.getLong();
            DateTime dateTime = new DateTime(l2);
            if (dateTime.compareTo(DateTime.MAX_VALUE) > 0) {
                return DateTime.MAX_VALUE;
            }
            if (dateTime.compareTo(DateTime.MIN_VALUE) < 0) {
                return DateTime.MIN_VALUE;
            }
            return dateTime;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public DateTime[] getDateTimeArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 8);
            DateTime[] dateTimeArray = new DateTime[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                dateTimeArray[i2] = this.getDateTime(null);
            }
            return dateTimeArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public DiagnosticInfo getDiagnosticInfo(String string) throws DecodingException {
        try {
            byte by = this.pW.get();
            Integer n2 = (by & 1) != 0 ? this.getInt32(null) : null;
            Integer n3 = (by & 2) != 0 ? this.getInt32(null) : null;
            Integer n4 = (by & 8) != 0 ? this.getInt32(null) : null;
            Integer n5 = (by & 4) != 0 ? this.getInt32(null) : null;
            String string2 = (by & 0x10) != 0 ? this.getString(null) : null;
            StatusCode statusCode = (by & 0x20) != 0 ? this.getStatusCode(null) : null;
            DiagnosticInfo diagnosticInfo = (by & 0x40) != 0 ? this.getDiagnosticInfo(null) : null;
            return new DiagnosticInfo(string2, diagnosticInfo, statusCode, n4, n5, n3, n2);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public DiagnosticInfo[] getDiagnosticInfoArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 1);
            DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                diagnosticInfoArray[i2] = this.getDiagnosticInfo(null);
            }
            return diagnosticInfoArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public Double getDouble(String string) throws DecodingException {
        try {
            return this.pW.getDouble();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public Double[] getDoubleArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 8);
            Double[] doubleArray = new Double[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                doubleArray[i2] = this.getDouble(null);
            }
            return doubleArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public <T extends IEncodeable> T getEncodeable(String string, Class<? extends T> clazz) throws DecodingException {
        return (T)this.pX.getEncodeableSerializer().getEncodeable(clazz, this);
    }

    @Override
    public <T extends IEncodeable> T[] getEncodeableArray(String string, Class<? extends T> clazz) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 2);
            Object object = Array.newInstance(clazz, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                IEncodeable iEncodeable = this.pX.getEncodeableSerializer().getEncodeable(clazz, this);
                Array.set(object, i2, iEncodeable);
            }
            return (IEncodeable[])object;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.pX;
    }

    @Override
    public <T extends Enumeration> T getEnumeration(String string, Class<T> clazz) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            Method method = clazz.getMethod("valueOf", Integer.TYPE);
            return (T)((Enumeration)method.invoke(null, n2));
        }
        catch (SecurityException securityException) {
            throw new DecodingException(securityException, "cannot decode " + clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new DecodingException(noSuchMethodException, "cannot decode " + clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DecodingException(illegalArgumentException, "cannot decode " + clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DecodingException(illegalAccessException, "cannot decode " + clazz);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DecodingException(invocationTargetException, "cannot decode " + clazz);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public <T extends Enumeration> T[] getEnumerationArray(String string, Class<T> clazz) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 4);
            Object object = Array.newInstance(clazz, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                T t = this.getEnumeration(null, clazz);
                Array.set(object, i2, t);
            }
            return (Enumeration[])object;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public ExpandedNodeId getExpandedNodeId(String string) throws DecodingException {
        try {
            byte by = this.pW.get();
            boolean bl = (by & 0x40) == 64;
            boolean bl2 = (by & 0x80) == 128;
            NodeIdEncoding nodeIdEncoding = NodeIdEncoding.getNodeIdEncoding(by & 0x3F);
            if (nodeIdEncoding == null) {
                throw new DecodingException("Unexpected NodeId Encoding Byte " + by);
            }
            Object object = null;
            int n2 = 0;
            String string2 = null;
            UnsignedInteger unsignedInteger = null;
            if (nodeIdEncoding == NodeIdEncoding.TwoByte) {
                n2 = 0;
                object = UnsignedInteger.getFromBits(this.pW.get() & 0xFF);
            }
            if (nodeIdEncoding == NodeIdEncoding.FourByte) {
                n2 = this.pW.get() & 0xFF;
                object = UnsignedInteger.getFromBits(this.pW.getShort() & 0xFFFF);
            }
            if (nodeIdEncoding == NodeIdEncoding.Numeric) {
                n2 = this.pW.getShort() & 0xFFFF;
                object = UnsignedInteger.getFromBits(this.pW.getInt());
            }
            if (nodeIdEncoding == NodeIdEncoding.String) {
                n2 = this.pW.getShort() & 0xFFFF;
                object = this.getString(null);
            }
            if (nodeIdEncoding == NodeIdEncoding.ByteString) {
                n2 = this.pW.getShort() & 0xFFFF;
                object = this.getByteString(null);
                if (object != null) {
                    object = ((ByteString)object).getValue();
                }
            }
            if (nodeIdEncoding == NodeIdEncoding.Guid) {
                n2 = this.pW.getShort() & 0xFFFF;
                object = this.getGuid(null);
            }
            if (bl2) {
                string2 = this.getString(null);
            }
            if (bl) {
                unsignedInteger = this.getUInt32(null);
            }
            if (string2 != null) {
                return new ExpandedNodeId(unsignedInteger, string2, object);
            }
            return new ExpandedNodeId(unsignedInteger, n2, object);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public ExpandedNodeId[] getExpandedNodeIdArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 2);
            ExpandedNodeId[] expandedNodeIdArray = new ExpandedNodeId[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                expandedNodeIdArray[i2] = this.getExpandedNodeId(null);
            }
            return expandedNodeIdArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public ExtensionObject getExtensionObject(String string) throws DecodingException {
        try {
            ExtensionObject extensionObject;
            NodeId nodeId = this.getNodeId(null);
            ExpandedNodeId expandedNodeId = this.pX.getNamespaceTable().toExpandedNodeId(nodeId);
            byte by = this.pW.get();
            if (by == 0) {
                if (nodeId == null || nodeId.equals(NodeId.NULL)) {
                    return null;
                }
                return new ExtensionObject(expandedNodeId);
            }
            if (by == 1) {
                extensionObject = new ExtensionObject(expandedNodeId, this.getByteString(null));
            } else if (by == 2) {
                extensionObject = new ExtensionObject(expandedNodeId, this.getXmlElement(null));
            } else {
                throw new DecodingException("Unexpected encoding byte (" + by + ") in ExtensionObject");
            }
            if (this.a(extensionObject)) {
                return extensionObject;
            }
            try {
                Structure structure = (Structure)extensionObject.decode(this.getEncoderContext());
                return new ExtensionObject(structure);
            }
            catch (DecodingException decodingException) {
                return extensionObject;
            }
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public ExtensionObject[] getExtensionObjectArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 3);
            ExtensionObject[] extensionObjectArray = new ExtensionObject[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                extensionObjectArray[i2] = this.getExtensionObject(null);
            }
            return extensionObjectArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public Float getFloat(String string) throws DecodingException {
        try {
            return Float.valueOf(this.pW.getFloat());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public Float[] getFloatArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 4);
            Float[] floatArray = new Float[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                floatArray[i2] = this.getFloat(null);
            }
            return floatArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public UUID getGuid(String string) throws DecodingException {
        try {
            int n2;
            byte[] byArray = new byte[16];
            byArray[3] = this.pW.get();
            byArray[2] = this.pW.get();
            byArray[1] = this.pW.get();
            byArray[0] = this.pW.get();
            byArray[5] = this.pW.get();
            byArray[4] = this.pW.get();
            byArray[7] = this.pW.get();
            byArray[6] = this.pW.get();
            for (int i2 = 8; i2 < 16; ++i2) {
                byArray[i2] = this.pW.get();
            }
            long l2 = 0L;
            long l3 = 0L;
            for (n2 = 0; n2 < 8; ++n2) {
                l2 = l2 << 8 | (long)(byArray[n2] & 0xFF);
            }
            for (n2 = 8; n2 < 16; ++n2) {
                l3 = l3 << 8 | (long)(byArray[n2] & 0xFF);
            }
            return new UUID(l2, l3);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public UUID[] getGuidArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 16);
            UUID[] uUIDArray = new UUID[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                uUIDArray[i2] = this.getGuid(null);
            }
            return uUIDArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public Short getInt16(String string) throws DecodingException {
        try {
            return this.pW.getShort();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public Short[] getInt16Array(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 2);
            Short[] shortArray = new Short[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                shortArray[i2] = this.getInt16(null);
            }
            return shortArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public Integer getInt32(String string) throws DecodingException {
        try {
            return this.pW.getInt();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public Integer[] getInt32Array(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 4);
            Integer[] integerArray = new Integer[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                integerArray[i2] = this.getInt32(null);
            }
            return integerArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public int[] getInt32Array_(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 4);
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = this.getInt32(null);
            }
            return nArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public Long getInt64(String string) throws DecodingException {
        try {
            return this.pW.getLong();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public Long[] getInt64Array(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 8);
            Long[] longArray = new Long[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                longArray[i2] = this.getInt64(null);
            }
            return longArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public LocalizedText getLocalizedText(String string) throws DecodingException {
        try {
            byte by = this.pW.get();
            String string2 = null;
            String string3 = null;
            if ((by & 1) == 1) {
                string2 = this.getString(null);
            }
            if ((by & 2) == 2) {
                string3 = this.getString(null);
            }
            return new LocalizedText(string3, string2);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public LocalizedText[] getLocalizedTextArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 1);
            LocalizedText[] localizedTextArray = new LocalizedText[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                localizedTextArray[i2] = this.getLocalizedText(null);
            }
            return localizedTextArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public <T extends IEncodeable> T getMessage() throws DecodingException {
        NodeId nodeId = this.getNodeId(null);
        if (nodeId == null) {
            throw new DecodingException("Cannot decode " + nodeId);
        }
        Class<? extends IEncodeable> clazz = this.pX.getEncodeableClass(nodeId);
        if (clazz == null) {
            throw new DecodingException("Cannot decode " + nodeId);
        }
        return (T)this.pX.getEncodeableSerializer().getEncodeable(clazz, this);
    }

    @Override
    public NodeId getNodeId(String string) throws DecodingException {
        try {
            NodeId nodeId;
            byte by = this.pW.get();
            NodeIdEncoding nodeIdEncoding = NodeIdEncoding.getNodeIdEncoding(by);
            if (nodeIdEncoding == null) {
                throw new DecodingException("Unexpected NodeId Encoding Byte " + by);
            }
            int n2 = 0;
            if (nodeIdEncoding == NodeIdEncoding.TwoByte) {
                n2 = 0;
                UnsignedInteger unsignedInteger = UnsignedInteger.getFromBits(this.pW.get() & 0xFF);
                nodeId = new NodeId(n2, unsignedInteger);
            } else if (nodeIdEncoding == NodeIdEncoding.FourByte) {
                n2 = this.pW.get() & 0xFF;
                UnsignedInteger unsignedInteger = UnsignedInteger.getFromBits(this.pW.getShort() & 0xFFFF);
                nodeId = new NodeId(n2, unsignedInteger);
            } else if (nodeIdEncoding == NodeIdEncoding.Numeric) {
                n2 = this.pW.getShort() & 0xFFFF;
                UnsignedInteger unsignedInteger = this.getUInt32(null);
                nodeId = new NodeId(n2, unsignedInteger);
            } else if (nodeIdEncoding == NodeIdEncoding.String) {
                n2 = this.pW.getShort() & 0xFFFF;
                String string2 = this.getString(null);
                nodeId = new NodeId(n2, string2);
            } else if (nodeIdEncoding == NodeIdEncoding.ByteString) {
                n2 = this.pW.getShort() & 0xFFFF;
                ByteString byteString = this.getByteString(null);
                nodeId = new NodeId(n2, ByteString.asByteArray(byteString));
            } else if (nodeIdEncoding == NodeIdEncoding.Guid) {
                n2 = this.pW.getShort() & 0xFFFF;
                UUID uUID = this.getGuid(null);
                nodeId = new NodeId(n2, uUID);
            } else {
                throw new DecodingException("Unsupported NodeId Encoding byte " + (Object)((Object)nodeIdEncoding));
            }
            return nodeId;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public NodeId[] getNodeIdArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 2);
            NodeId[] nodeIdArray = new NodeId[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nodeIdArray[i2] = this.getNodeId(null);
            }
            return nodeIdArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public QualifiedName getQualifiedName(String string) throws DecodingException {
        UnsignedShort unsignedShort = this.getUInt16(null);
        String string2 = this.getString(null);
        if (string2 == null) {
            return new QualifiedName(unsignedShort, null);
        }
        return new QualifiedName(unsignedShort, string2);
    }

    @Override
    public QualifiedName[] getQualifiedNameArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 6);
            QualifiedName[] qualifiedNameArray = new QualifiedName[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                qualifiedNameArray[i2] = this.getQualifiedName(null);
            }
            return qualifiedNameArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    public IBinaryReadable getReadable() {
        return this.pW;
    }

    @Override
    public Byte getSByte(String string) throws DecodingException {
        try {
            return this.pW.get();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public Byte[] getSByteArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 1);
            Byte[] byteArray = new Byte[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                byteArray[i2] = this.getSByte(null);
            }
            return byteArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public Object getScalarObject(String string, int n2) throws DecodingException {
        switch (n2) {
            case 1: {
                return this.getBoolean(null);
            }
            case 2: {
                return this.getSByte(null);
            }
            case 3: {
                return this.getByte(null);
            }
            case 4: {
                return this.getInt16(null);
            }
            case 5: {
                return this.getUInt16(null);
            }
            case 6: {
                return this.getInt32(null);
            }
            case 7: {
                return this.getUInt32(null);
            }
            case 8: {
                return this.getInt64(null);
            }
            case 9: {
                return this.getUInt64(null);
            }
            case 10: {
                return this.getFloat(null);
            }
            case 11: {
                return this.getDouble(null);
            }
            case 12: {
                return this.getString(null);
            }
            case 13: {
                return this.getDateTime(null);
            }
            case 14: {
                return this.getGuid(null);
            }
            case 15: {
                return this.getByteString(null);
            }
            case 16: {
                return this.getXmlElement(null);
            }
            case 17: {
                return this.getNodeId(null);
            }
            case 18: {
                return this.getExpandedNodeId(null);
            }
            case 19: {
                return this.getStatusCode(null);
            }
            case 20: {
                return this.getQualifiedName(null);
            }
            case 21: {
                return this.getLocalizedText(null);
            }
            case 22: {
                return this.getExtensionObject(null);
            }
            case 23: {
                return this.getDataValue(null);
            }
            case 24: {
                return this.getVariant(null);
            }
            case 25: {
                return this.getDiagnosticInfo(null);
            }
        }
        throw new DecodingException("Cannot decode builtin type id " + n2);
    }

    @Override
    public StatusCode getStatusCode(String string) throws DecodingException {
        return new StatusCode(this.getUInt32(null));
    }

    @Override
    public StatusCode[] getStatusCodeArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 4);
            StatusCode[] statusCodeArray = new StatusCode[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                statusCodeArray[i2] = this.getStatusCode(null);
            }
            return statusCodeArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public String getString(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.g(n2);
            byte[] byArray = new byte[n2];
            this.pW.get(byArray);
            return new String(byArray, UTF8);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public String[] getStringArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 4);
            String[] stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = this.getString(null);
            }
            return stringArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public Structure getStructure(String string) throws DecodingException {
        try {
            NodeId nodeId = this.getNodeId(null);
            byte by = this.pW.get();
            if (by == 0) {
                return null;
            }
            if (by == 1) {
                Class<? extends IEncodeable> clazz = this.pX.getEncodeableClass(nodeId);
                this.getInt32(null);
                return (Structure)this.getEncodeable(string, clazz);
            }
            if (by == 2) {
                throw new DecodingException("XML Decoder is not implemented");
            }
            throw new DecodingException("Unexpected encoding byte (" + by + ") in ExtensionObject");
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public Structure[] getStructureArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 1);
            Structure[] structureArray = new Structure[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                structureArray[i2] = this.getStructure(null);
            }
            return structureArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public UnsignedShort getUInt16(String string) throws DecodingException {
        try {
            return UnsignedShort.getFromBits(this.pW.getShort());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public UnsignedShort[] getUInt16Array(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 2);
            UnsignedShort[] unsignedShortArray = new UnsignedShort[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                unsignedShortArray[i2] = this.getUInt16(null);
            }
            return unsignedShortArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public UnsignedInteger getUInt32(String string) throws DecodingException {
        try {
            return UnsignedInteger.getFromBits(this.pW.getInt());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public UnsignedInteger[] getUInt32Array(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 4);
            UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                unsignedIntegerArray[i2] = this.getUInt32(null);
            }
            return unsignedIntegerArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public UnsignedLong getUInt64(String string) throws DecodingException {
        try {
            return UnsignedLong.getFromBits(this.pW.getLong());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public UnsignedLong[] getUInt64Array(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 8);
            UnsignedLong[] unsignedLongArray = new UnsignedLong[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                unsignedLongArray[i2] = this.getUInt64(null);
            }
            return unsignedLongArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public Variant getVariant(String string) throws DecodingException {
        try {
            boolean bl;
            boolean bl2;
            byte by = this.pW.get();
            int n2 = by & 0x3F;
            boolean bl3 = (by & 0x80) == 128;
            boolean bl4 = (by & 0x40) == 64;
            boolean bl5 = bl2 = n2 == 0;
            if (n2 > 25) {
                n2 = 15;
            }
            Object object = bl2 ? null : (bl3 ? this.getArrayObject(null, n2) : this.getScalarObject(null, n2));
            int[] nArray = bl4 ? this.getInt32Array_(null) : null;
            boolean bl6 = bl = bl3 && nArray != null && nArray.length > 1;
            if (bl4) {
                long l2;
                long l3 = 1L;
                for (int n3 : nArray) {
                    l3 *= (long)n3;
                }
                Object[] objectArray = object;
                long l4 = l2 = objectArray == null ? -1L : (long)objectArray.length;
                if (l2 != l3) {
                    throw new DecodingException("The ArrayDimensions do not match the ArrayLength in total size");
                }
            }
            if (object instanceof ExtensionObject && this.a((ExtensionObject)object)) {
                try {
                    object = this.d((ByteString)((ExtensionObject)object).getObject());
                }
                catch (ClassCastException classCastException) {
                    throw new DecodingException("Did not get an ExtensionObject with ByteString data for Decimal type", classCastException);
                }
            }
            if (object instanceof ExtensionObject) {
                ExtensionObject extensionObject = (ExtensionObject)object;
                try {
                    object = extensionObject.decode(this.pX);
                }
                catch (DecodingException exception) {
                    object = extensionObject;
                }
            }
            if (bl3) {
                if (object instanceof ExtensionObject[]) {
                    object = this.b((ExtensionObject[])object);
                }
                if (object instanceof ExtensionObject[]) {
                    ExtensionObject[] extensionObjectArray = object;
                    try {
                        object = this.pX.decode(extensionObjectArray);
                    }
                    catch (Exception exception) {
                        object = extensionObjectArray;
                    }
                }
                if (bl) {
                    try {
                        object = MultiDimensionArrayUtils.demuxArray(object, nArray);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new DecodingException("The length of ArrayDimensions-field does not match Value-field");
                    }
                }
            }
            return new Variant(object);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public Variant[] getVariantArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 1);
            Variant[] variantArray = new Variant[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                variantArray[i2] = this.getVariant(null);
            }
            return variantArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    @Override
    public XmlElement getXmlElement(String string) throws DecodingException {
        ByteString byteString = this.getByteString(string);
        if (byteString == null) {
            return null;
        }
        return new XmlElement(ByteString.asByteArray(byteString));
    }

    @Override
    public XmlElement[] getXmlElementArray(String string) throws DecodingException {
        try {
            int n2 = this.pW.getInt();
            if (n2 == -1) {
                return null;
            }
            this.a(n2, 4);
            XmlElement[] xmlElementArray = new XmlElement[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                xmlElementArray[i2] = this.getXmlElement(null);
            }
            return xmlElementArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    public void setEncoderContext(EncoderContext encoderContext) {
        this.pX = encoderContext;
    }

    public void setReadable(IBinaryReadable iBinaryReadable) {
        if (iBinaryReadable.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("Readable must be in Little-Ending byte order");
        }
        this.pW = iBinaryReadable;
    }

    private void a(int n2, int n3) throws DecodingException {
        if (n2 < -1) {
            throw new DecodingException(StatusCodes.Bad_DecodingError, "Illegal array length " + n2);
        }
        int n4 = this.pX.getMaxArrayLength();
        if (n4 > 0 && n2 > n4) {
            throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxArrayLength=" + n4 + " < " + n2);
        }
        long l2 = n2;
        if (l2 * (long)n3 > this.remaining()) {
            throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
        }
    }

    private void f(int n2) throws DecodingException {
        if (n2 < -1) {
            throw new DecodingException(StatusCodes.Bad_DecodingError, "Unexpected byte string length " + n2);
        }
        int n3 = this.pX.getMaxByteStringLength();
        if (n3 > 0 && n2 > n3) {
            throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxByteStringLength " + n3 + " < " + n2);
        }
        if ((long)n2 > this.remaining()) {
            throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
        }
    }

    private void g(int n2) throws DecodingException {
        if (n2 < -1) {
            throw new DecodingException(StatusCodes.Bad_DecodingError, "Unexpected string length " + n2);
        }
        int n3 = this.pX.getMaxStringLength();
        if (n3 > 0 && n2 > n3) {
            throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxStringLength " + n3 + " < " + n2);
        }
        if ((long)n2 > this.remaining()) {
            throw new DecodingException(StatusCodes.Bad_EndOfStream, "Buffer underflow");
        }
    }

    private BigDecimal d(ByteString byteString) {
        byte[] byArray = byteString.getValue();
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(byArray[0]);
        byteBuffer.put(byArray[1]);
        byteBuffer.rewind();
        short s2 = byteBuffer.getShort();
        byte[] byArray2 = Arrays.copyOfRange(byArray, 2, byArray.length);
        byArray2 = com.prosysopc.ua.stack.encoding.binary.a.reverse(byArray2);
        BigInteger bigInteger = new BigInteger(byArray2);
        return new BigDecimal(bigInteger, s2);
    }

    private BigDecimal s(String string) throws DecodingException {
        ExtensionObject extensionObject = this.getExtensionObject(string);
        if (!this.getEncoderContext().getNamespaceTable().nodeIdEquals(extensionObject.getTypeId(), pV)) {
            logger.error("Encountered a Decimal that does not define correct id, is {}", (Object)extensionObject.getTypeId());
        }
        try {
            return this.d((ByteString)extensionObject.getObject());
        }
        catch (ClassCastException classCastException) {
            throw new DecodingException("Did not get an ExtensionObject with ByteString data for Decimal type", classCastException);
        }
    }

    private OptionSetDataType<?, ?> b(String string, Class<? extends OptionSetDataType<?, ?>> clazz) throws DecodingException {
        if (ByteOptionSetDataType.class.isAssignableFrom(clazz)) {
            UnsignedByte unsignedByte = this.getByte(string);
            try {
                Method method = clazz.getMethod("of", UnsignedByte.class);
                return (OptionSetDataType)method.invoke(null, unsignedByte);
            }
            catch (Exception exception) {
                throw new DecodingException("Cannot decode class " + clazz + " failure invoking method 'of'");
            }
        }
        if (UInt16OptionSetDataType.class.isAssignableFrom(clazz)) {
            UnsignedShort unsignedShort = this.getUInt16(string);
            try {
                Method method = clazz.getMethod("of", UnsignedShort.class);
                return (OptionSetDataType)method.invoke(null, unsignedShort);
            }
            catch (Exception exception) {
                throw new DecodingException("Cannot decode class " + clazz + " failure invoking method 'of'");
            }
        }
        if (UInt32OptionSetDataType.class.isAssignableFrom(clazz)) {
            UnsignedInteger unsignedInteger = this.getUInt32(string);
            try {
                Method method = clazz.getMethod("of", UnsignedInteger.class);
                return (OptionSetDataType)method.invoke(null, unsignedInteger);
            }
            catch (Exception exception) {
                throw new DecodingException("Cannot decode class " + clazz + " failure invoking method 'of'");
            }
        }
        if (UInt64OptionSetDataType.class.isAssignableFrom(clazz)) {
            UnsignedLong unsignedLong = this.getUInt64(string);
            try {
                Method method = clazz.getMethod("of", UnsignedLong.class);
                return (OptionSetDataType)method.invoke(null, unsignedLong);
            }
            catch (Exception exception) {
                throw new DecodingException("Cannot decode class " + clazz + " failure invoking method 'of'");
            }
        }
        throw new DecodingException("Unknown OptionSetDataType class:" + clazz);
    }

    private boolean a(ExtensionObject extensionObject) {
        return this.pX.getNamespaceTable().nodeIdEquals(Identifiers.Decimal, extensionObject.getTypeId());
    }

    private Object b(ExtensionObject[] extensionObjectArray) {
        BigDecimal[] bigDecimalArray = new BigDecimal[extensionObjectArray.length];
        for (int i2 = 0; i2 < extensionObjectArray.length; ++i2) {
            ExtensionObject extensionObject = extensionObjectArray[i2];
            if (!this.a(extensionObject)) {
                return extensionObjectArray;
            }
            bigDecimalArray[i2] = this.d((ByteString)extensionObject.getObject());
        }
        return bigDecimalArray;
    }

    protected long remaining() throws DecodingException {
        try {
            return this.pW.limit() - this.pW.position();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    static {
        pV = new ExpandedNodeId(NamespaceTable.OPCUA_NAMESPACE, Identifiers.Decimal.getValue());
        BinaryDecoder.a(Boolean.class, new a<Boolean>(){

            public Boolean b(BinaryDecoder binaryDecoder, String string, Class<? extends Boolean> clazz) throws DecodingException {
                return binaryDecoder.getBoolean(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.b(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(Byte.class, new a<Byte>(){

            public Byte n(BinaryDecoder binaryDecoder, String string, Class<? extends Byte> clazz) throws DecodingException {
                return binaryDecoder.getSByte(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.n(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(UnsignedByte.class, new a<UnsignedByte>(){

            public UnsignedByte y(BinaryDecoder binaryDecoder, String string, Class<? extends UnsignedByte> clazz) throws DecodingException {
                return binaryDecoder.getByte(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.y(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(Short.class, new a<Short>(){

            public Short z(BinaryDecoder binaryDecoder, String string, Class<? extends Short> clazz) throws DecodingException {
                return binaryDecoder.getInt16(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.z(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(UnsignedShort.class, new a<UnsignedShort>(){

            public UnsignedShort A(BinaryDecoder binaryDecoder, String string, Class<? extends UnsignedShort> clazz) throws DecodingException {
                return binaryDecoder.getUInt16(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.A(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(Integer.class, new a<Integer>(){

            public Integer B(BinaryDecoder binaryDecoder, String string, Class<? extends Integer> clazz) throws DecodingException {
                return binaryDecoder.getInt32(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.B(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(UnsignedInteger.class, new a<UnsignedInteger>(){

            public UnsignedInteger C(BinaryDecoder binaryDecoder, String string, Class<? extends UnsignedInteger> clazz) throws DecodingException {
                return binaryDecoder.getUInt32(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.C(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(Long.class, new a<Long>(){

            public Long D(BinaryDecoder binaryDecoder, String string, Class<? extends Long> clazz) throws DecodingException {
                return binaryDecoder.getInt64(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.D(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(UnsignedLong.class, new a<UnsignedLong>(){

            public UnsignedLong E(BinaryDecoder binaryDecoder, String string, Class<? extends UnsignedLong> clazz) throws DecodingException {
                return binaryDecoder.getUInt64(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.E(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(Float.class, new a<Float>(){

            public Float d(BinaryDecoder binaryDecoder, String string, Class<? extends Float> clazz) throws DecodingException {
                return binaryDecoder.getFloat(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.d(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(Double.class, new a<Double>(){

            public Double e(BinaryDecoder binaryDecoder, String string, Class<? extends Double> clazz) throws DecodingException {
                return binaryDecoder.getDouble(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.e(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(String.class, new a<String>(){

            public String f(BinaryDecoder binaryDecoder, String string, Class<? extends String> clazz) throws DecodingException {
                return binaryDecoder.getString(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.f(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(UUID.class, new a<UUID>(){

            public UUID g(BinaryDecoder binaryDecoder, String string, Class<? extends UUID> clazz) throws DecodingException {
                return binaryDecoder.getGuid(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.g(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(ByteString.class, new a<ByteString>(){

            public ByteString h(BinaryDecoder binaryDecoder, String string, Class<? extends ByteString> clazz) throws DecodingException {
                return binaryDecoder.getByteString(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.h(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(XmlElement.class, new a<XmlElement>(){

            public XmlElement i(BinaryDecoder binaryDecoder, String string, Class<? extends XmlElement> clazz) throws DecodingException {
                return binaryDecoder.getXmlElement(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.i(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(NodeId.class, new a<NodeId>(){

            public NodeId j(BinaryDecoder binaryDecoder, String string, Class<? extends NodeId> clazz) throws DecodingException {
                return binaryDecoder.getNodeId(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.j(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(ExpandedNodeId.class, new a<ExpandedNodeId>(){

            public ExpandedNodeId k(BinaryDecoder binaryDecoder, String string, Class<? extends ExpandedNodeId> clazz) throws DecodingException {
                return binaryDecoder.getExpandedNodeId(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.k(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(StatusCode.class, new a<StatusCode>(){

            public StatusCode l(BinaryDecoder binaryDecoder, String string, Class<? extends StatusCode> clazz) throws DecodingException {
                return binaryDecoder.getStatusCode(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.l(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(QualifiedName.class, new a<QualifiedName>(){

            public QualifiedName m(BinaryDecoder binaryDecoder, String string, Class<? extends QualifiedName> clazz) throws DecodingException {
                return binaryDecoder.getQualifiedName(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.m(binaryDecoder, string, clazz);
            }
        });
        BinaryDecoder.a(LocalizedText.class, new a<LocalizedText>(){

            public LocalizedText o(BinaryDecoder binaryDecoder, String string, Class<? extends LocalizedText> clazz) throws DecodingException {
                return binaryDecoder.getLocalizedText(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.o(binaryDecoder, string, clazz);
            }
        });
        pM = new a<DateTime>(){

            public DateTime p(BinaryDecoder binaryDecoder, String string, Class<? extends DateTime> clazz) throws DecodingException {
                return binaryDecoder.getDateTime(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.p(binaryDecoder, string, clazz);
            }
        };
        pN = new a<ExtensionObject>(){

            public ExtensionObject q(BinaryDecoder binaryDecoder, String string, Class<? extends ExtensionObject> clazz) throws DecodingException {
                return binaryDecoder.getExtensionObject(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.q(binaryDecoder, string, clazz);
            }
        };
        pO = new a<Structure>(){

            public Structure r(BinaryDecoder binaryDecoder, String string, Class<? extends Structure> clazz) throws DecodingException {
                return binaryDecoder.getEncodeable(string, clazz);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.r(binaryDecoder, string, clazz);
            }
        };
        pP = new a<DataValue>(){

            public DataValue s(BinaryDecoder binaryDecoder, String string, Class<? extends DataValue> clazz) throws DecodingException {
                return binaryDecoder.getDataValue(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.s(binaryDecoder, string, clazz);
            }
        };
        pQ = new a<Variant>(){

            public Variant t(BinaryDecoder binaryDecoder, String string, Class<? extends Variant> clazz) throws DecodingException {
                return binaryDecoder.getVariant(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.t(binaryDecoder, string, clazz);
            }
        };
        pR = new a<DiagnosticInfo>(){

            public DiagnosticInfo u(BinaryDecoder binaryDecoder, String string, Class<? extends DiagnosticInfo> clazz) throws DecodingException {
                return binaryDecoder.getDiagnosticInfo(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.u(binaryDecoder, string, clazz);
            }
        };
        pS = new a<Enumeration>(){

            public Enumeration v(BinaryDecoder binaryDecoder, String string, Class<? extends Enumeration> clazz) throws DecodingException {
                return binaryDecoder.getEnumeration(string, clazz);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.v(binaryDecoder, string, clazz);
            }
        };
        pT = new a<BigDecimal>(){

            public BigDecimal w(BinaryDecoder binaryDecoder, String string, Class<? extends BigDecimal> clazz) throws DecodingException {
                return binaryDecoder.s(string);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.w(binaryDecoder, string, clazz);
            }
        };
        pU = new a<OptionSetDataType<?, ?>>(){

            public OptionSetDataType<?, ?> x(BinaryDecoder binaryDecoder, String string, Class<? extends OptionSetDataType<?, ?>> clazz) throws DecodingException {
                return binaryDecoder.b(string, clazz);
            }

            @Override
            public /* synthetic */ Object c(BinaryDecoder binaryDecoder, String string, Class clazz) throws DecodingException {
                return this.x(binaryDecoder, string, clazz);
            }
        };
        BinaryDecoder.a(Object.class, new a<Object>(){

            @Override
            public Object c(BinaryDecoder binaryDecoder, String string, Class<? extends Object> clazz) throws DecodingException {
                return pQ.c(binaryDecoder, string, Variant.class).getValue();
            }
        });
    }

    private static interface a<T> {
        public T c(BinaryDecoder var1, String var2, Class<? extends T> var3) throws DecodingException;
    }
}

