/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding;

import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.IEncodeableSerializer;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EncoderContext {
    private static EncoderContext pG = new EncoderContext(NamespaceTable.getDefaultInstance(), null, StackUtils.getDefaultSerializer());
    public NamespaceTable namespaceTable;
    public ServerTable serverTable;
    public IEncodeableSerializer encodeableSerializer;
    public int maxMessageSize = 0;
    public int maxStringLength = 0;
    public int maxByteStringLength = 0;
    public int maxArrayLength = 0;
    private final Map<UaNodeId, StructureSpecification> pH = new ConcurrentHashMap<UaNodeId, StructureSpecification>();
    private final Map<UaNodeId, EnumerationSpecification> pI = new ConcurrentHashMap<UaNodeId, EnumerationSpecification>();
    private volatile StructureSpecificationProvider pJ;

    public static EncoderContext getDefaultInstance() {
        return pG;
    }

    public EncoderContext(NamespaceTable namespaceTable, ServerTable serverTable, IEncodeableSerializer iEncodeableSerializer) {
        this.encodeableSerializer = iEncodeableSerializer;
        this.namespaceTable = namespaceTable;
        this.serverTable = serverTable;
    }

    public EncoderContext(NamespaceTable namespaceTable, ServerTable serverTable, IEncodeableSerializer iEncodeableSerializer, int n2) {
        this.encodeableSerializer = iEncodeableSerializer;
        this.namespaceTable = namespaceTable;
        this.serverTable = serverTable;
        this.maxMessageSize = n2;
    }

    public void addEnumerationSpecification(EnumerationSpecification enumerationSpecification) {
        this.pI.put(enumerationSpecification.getTypeId(), enumerationSpecification);
    }

    public void addStructureSpecification(StructureSpecification structureSpecification) {
        this.pH.put(structureSpecification.getTypeId(), structureSpecification);
        if (structureSpecification.getBinaryEncodeId() != null) {
            this.pH.put(structureSpecification.getBinaryEncodeId(), structureSpecification);
        }
        if (structureSpecification.getXmlEncodeId() != null) {
            this.pH.put(structureSpecification.getXmlEncodeId(), structureSpecification);
        }
        if (structureSpecification.getJsonEncodeId() != null) {
            this.pH.put(structureSpecification.getJsonEncodeId(), structureSpecification);
        }
    }

    public Object decode(ExtensionObject[] extensionObjectArray) throws DecodingException {
        return this.decode(extensionObjectArray, null);
    }

    public Object decode(ExtensionObject[] extensionObjectArray, NamespaceTable namespaceTable) throws DecodingException {
        int n2 = extensionObjectArray.length;
        Structure[] structureArray = new Structure[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ExtensionObject extensionObject = extensionObjectArray[i2];
            if (extensionObject == null) continue;
            structureArray[i2] = (Structure)extensionObject.decode(this, namespaceTable);
        }
        Structure[] structureArray2 = structureArray;
        if (n2 > 0) {
            Class<?> clazz = null;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (structureArray[i3] == null) continue;
                Class<?> clazz2 = structureArray[i3].getClass();
                if (clazz == null) {
                    clazz = clazz2;
                    continue;
                }
                if (clazz2.isAssignableFrom(clazz)) continue;
                if (clazz.isAssignableFrom(clazz2)) {
                    clazz = clazz2;
                    continue;
                }
                clazz = null;
                break;
            }
            if (clazz != null) {
                structureArray2 = Arrays.copyOf(structureArray, n2, ((Structure[])Array.newInstance(clazz, 0)).getClass());
            }
        }
        return structureArray2;
    }

    public Class<? extends IEncodeable> getEncodeableClass(NodeId nodeId) {
        return this.encodeableSerializer.getClass(this.namespaceTable.toExpandedNodeId(nodeId));
    }

    public NodeId getEncodeableNodeId(Class<? extends IEncodeable> clazz, EncodeType encodeType) throws ServiceResultException {
        return this.namespaceTable.toNodeId(this.encodeableSerializer.getNodeId(clazz, encodeType));
    }

    public IEncodeableSerializer getEncodeableSerializer() {
        return this.encodeableSerializer;
    }

    public EnumerationSpecification getEnumerationSpecification(UaNodeId uaNodeId) {
        return this.pI.get(uaNodeId);
    }

    public int getMaxArrayLength() {
        return this.maxArrayLength;
    }

    public int getMaxByteStringLength() {
        return this.maxByteStringLength;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public NamespaceTable getNamespaceTable() {
        return this.namespaceTable;
    }

    public ServerTable getServerTable() {
        return this.serverTable;
    }

    public StructureSpecification getStructureSpecification(UaNodeId uaNodeId) {
        StructureSpecification structureSpecification = this.pH.get(uaNodeId);
        if (structureSpecification != null) {
            return structureSpecification;
        }
        StructureSpecificationProvider structureSpecificationProvider = this.pJ;
        if (structureSpecificationProvider != null) {
            return structureSpecificationProvider.get(uaNodeId);
        }
        return null;
    }

    public void setDynamicStructureSpecificationProvider(StructureSpecificationProvider structureSpecificationProvider) {
        this.pJ = structureSpecificationProvider;
    }

    public void setEncodeableSerializer(IEncodeableSerializer iEncodeableSerializer) {
        this.encodeableSerializer = iEncodeableSerializer;
    }

    public void setMaxArrayLength(int n2) {
        this.maxArrayLength = n2;
    }

    public void setMaxByteStringLength(int n2) {
        this.maxByteStringLength = n2;
    }

    public void setMaxMessageSize(int n2) {
        this.maxMessageSize = n2;
    }

    public void setMaxStringLength(int n2) {
        this.maxStringLength = n2;
    }

    public void setNamespaceTable(NamespaceTable namespaceTable) {
        this.namespaceTable = namespaceTable;
    }

    public void setServerTable(ServerTable serverTable) {
        this.serverTable = serverTable;
    }

    public EncoderContext shallowCopy() {
        EncoderContext encoderContext = new EncoderContext(this.getNamespaceTable(), this.getServerTable(), this.getEncodeableSerializer());
        encoderContext.setMaxArrayLength(this.getMaxArrayLength());
        encoderContext.setMaxByteStringLength(this.getMaxByteStringLength());
        encoderContext.setMaxMessageSize(this.getMaxMessageSize());
        encoderContext.setMaxStringLength(this.getMaxStringLength());
        encoderContext.pH.putAll(this.pH);
        encoderContext.pJ = this.pJ;
        return encoderContext;
    }

    public NodeId toNodeId(ExpandedNodeId expandedNodeId) throws EncodingException {
        try {
            return this.namespaceTable.toNodeId(expandedNodeId);
        }
        catch (ServiceResultException serviceResultException) {
            throw new EncodingException("Could not get namespace index for given id");
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("   namespaceTable = " + this.namespaceTable + "\n");
        stringBuilder.append("   serverTable = " + this.serverTable + "\n");
        stringBuilder.append("   maxMessageSize = " + this.maxMessageSize + "\n");
        stringBuilder.append("   maxStringLength = " + this.maxStringLength + "\n");
        stringBuilder.append("   maxByteStringLength = " + this.maxByteStringLength + "\n");
        stringBuilder.append("   maxArrayLength = " + this.maxArrayLength + "\n");
        return stringBuilder.toString();
    }

    public static interface StructureSpecificationProvider {
        public StructureSpecification get(UaNodeId var1);
    }
}

