/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12080")
public class XVType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.XVType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.XVType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.XVType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.XVType;
    public static final StructureSpecification SPECIFICATION;
    private Double x;
    private Float value;

    public XVType() {
    }

    public XVType(Double d2, Float f2) {
        this.x = d2;
        this.value = f2;
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double d2) {
        this.x = d2;
    }

    public Float getValue() {
        return this.value;
    }

    public void setValue(Float f2) {
        this.value = f2;
    }

    @Override
    public XVType clone() {
        XVType xVType = (XVType)super.clone();
        xVType.x = StructureUtils.clone(this.x);
        xVType.value = StructureUtils.clone(this.value);
        return xVType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        XVType xVType = (XVType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getX(), xVType.getX())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getValue(), xVType.getValue());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getX(), this.getValue());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.X.getSpecification().equals(fieldSpecification)) {
            return this.getX();
        }
        if (Fields.Value.getSpecification().equals(fieldSpecification)) {
            return this.getValue();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.X.getSpecification().equals(fieldSpecification)) {
            this.setX((Double)object);
            return;
        }
        if (Fields.Value.getSpecification().equals(fieldSpecification)) {
            this.setValue((Float)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = XVType.builder();
        builder.setX(this.getX());
        builder.setValue(this.getValue());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.X.getSpecification());
        builder.addField(Fields.Value.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("XVType");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.XVTypeSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return XVType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private Double x;
        private Float value;

        protected Builder() {
        }

        public Builder setX(Double d2) {
            this.x = d2;
            return this;
        }

        public Builder setValue(Float f2) {
            this.value = f2;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.X.getSpecification().equals(fieldSpecification)) {
                this.setX((Double)object);
                return this;
            }
            if (Fields.Value.getSpecification().equals(fieldSpecification)) {
                this.setValue((Float)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public XVType build() {
            return new XVType(this.x, this.value);
        }
    }

    public static enum Fields {
        X("X", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11")), -1),
        Value("Value", Float.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=10")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

