/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=325")
public class X509IdentityToken
extends UserIdentityToken {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.X509IdentityToken_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.X509IdentityToken_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.X509IdentityToken_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.X509IdentityToken;
    public static final StructureSpecification SPECIFICATION;
    private ByteString certificateData;

    public X509IdentityToken() {
    }

    public X509IdentityToken(ByteString byteString) {
        this.certificateData = byteString;
    }

    public X509IdentityToken(String string, ByteString byteString) {
        super(string);
        this.certificateData = byteString;
    }

    public ByteString getCertificateData() {
        return this.certificateData;
    }

    public void setCertificateData(ByteString byteString) {
        this.certificateData = byteString;
    }

    @Override
    public X509IdentityToken clone() {
        X509IdentityToken x509IdentityToken = (X509IdentityToken)super.clone();
        x509IdentityToken.certificateData = StructureUtils.clone(this.certificateData);
        return x509IdentityToken;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        X509IdentityToken x509IdentityToken = (X509IdentityToken)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getPolicyId(), x509IdentityToken.getPolicyId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getCertificateData(), x509IdentityToken.getCertificateData());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getPolicyId(), this.getCertificateData());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.PolicyId.getSpecification().equals(fieldSpecification)) {
            return this.getPolicyId();
        }
        if (Fields.CertificateData.getSpecification().equals(fieldSpecification)) {
            return this.getCertificateData();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.PolicyId.getSpecification().equals(fieldSpecification)) {
            this.setPolicyId((String)object);
            return;
        }
        if (Fields.CertificateData.getSpecification().equals(fieldSpecification)) {
            this.setCertificateData((ByteString)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = X509IdentityToken.builder();
        builder.setPolicyId(this.getPolicyId());
        builder.setCertificateData(this.getCertificateData());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.PolicyId.getSpecification());
        builder.addField(Fields.CertificateData.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("X509IdentityToken");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.X509IdentityTokenSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return X509IdentityToken.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends UserIdentityToken.Builder {
        private String policyId;
        private ByteString certificateData;

        protected Builder() {
        }

        @Override
        public Builder setPolicyId(String string) {
            this.policyId = string;
            return this;
        }

        public Builder setCertificateData(ByteString byteString) {
            this.certificateData = byteString;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.PolicyId.getSpecification().equals(fieldSpecification)) {
                this.setPolicyId((String)object);
                return this;
            }
            if (Fields.CertificateData.getSpecification().equals(fieldSpecification)) {
                this.setCertificateData((ByteString)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public X509IdentityToken build() {
            return new X509IdentityToken(this.policyId, this.certificateData);
        }
    }

    public static enum Fields {
        PolicyId("PolicyId", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        CertificateData("CertificateData", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

