/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.UserTokenType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=304")
public class UserTokenPolicy
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.UserTokenPolicy_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.UserTokenPolicy_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.UserTokenPolicy_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.UserTokenPolicy;
    public static final StructureSpecification SPECIFICATION;
    private String policyId;
    private UserTokenType tokenType;
    private String issuedTokenType;
    private String issuerEndpointUrl;
    private String securityPolicyUri;

    public UserTokenPolicy() {
    }

    public UserTokenPolicy(String string, UserTokenType userTokenType, String string2, String string3, String string4) {
        this.policyId = string;
        this.tokenType = userTokenType;
        this.issuedTokenType = string2;
        this.issuerEndpointUrl = string3;
        this.securityPolicyUri = string4;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public void setPolicyId(String string) {
        this.policyId = string;
    }

    public UserTokenType getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(UserTokenType userTokenType) {
        this.tokenType = userTokenType;
    }

    public String getIssuedTokenType() {
        return this.issuedTokenType;
    }

    public void setIssuedTokenType(String string) {
        this.issuedTokenType = string;
    }

    public String getIssuerEndpointUrl() {
        return this.issuerEndpointUrl;
    }

    public void setIssuerEndpointUrl(String string) {
        this.issuerEndpointUrl = string;
    }

    public String getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    public void setSecurityPolicyUri(String string) {
        this.securityPolicyUri = string;
    }

    @Override
    public UserTokenPolicy clone() {
        UserTokenPolicy userTokenPolicy = (UserTokenPolicy)super.clone();
        userTokenPolicy.policyId = StructureUtils.clone(this.policyId);
        userTokenPolicy.tokenType = StructureUtils.clone(this.tokenType);
        userTokenPolicy.issuedTokenType = StructureUtils.clone(this.issuedTokenType);
        userTokenPolicy.issuerEndpointUrl = StructureUtils.clone(this.issuerEndpointUrl);
        userTokenPolicy.securityPolicyUri = StructureUtils.clone(this.securityPolicyUri);
        return userTokenPolicy;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UserTokenPolicy userTokenPolicy = (UserTokenPolicy)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getPolicyId(), userTokenPolicy.getPolicyId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTokenType(), userTokenPolicy.getTokenType())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getIssuedTokenType(), userTokenPolicy.getIssuedTokenType())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getIssuerEndpointUrl(), userTokenPolicy.getIssuerEndpointUrl())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getSecurityPolicyUri(), userTokenPolicy.getSecurityPolicyUri());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getPolicyId(), this.getTokenType(), this.getIssuedTokenType(), this.getIssuerEndpointUrl(), this.getSecurityPolicyUri());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.PolicyId.getSpecification().equals(fieldSpecification)) {
            return this.getPolicyId();
        }
        if (Fields.TokenType.getSpecification().equals(fieldSpecification)) {
            return this.getTokenType();
        }
        if (Fields.IssuedTokenType.getSpecification().equals(fieldSpecification)) {
            return this.getIssuedTokenType();
        }
        if (Fields.IssuerEndpointUrl.getSpecification().equals(fieldSpecification)) {
            return this.getIssuerEndpointUrl();
        }
        if (Fields.SecurityPolicyUri.getSpecification().equals(fieldSpecification)) {
            return this.getSecurityPolicyUri();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.PolicyId.getSpecification().equals(fieldSpecification)) {
            this.setPolicyId((String)object);
            return;
        }
        if (Fields.TokenType.getSpecification().equals(fieldSpecification)) {
            this.setTokenType((UserTokenType)object);
            return;
        }
        if (Fields.IssuedTokenType.getSpecification().equals(fieldSpecification)) {
            this.setIssuedTokenType((String)object);
            return;
        }
        if (Fields.IssuerEndpointUrl.getSpecification().equals(fieldSpecification)) {
            this.setIssuerEndpointUrl((String)object);
            return;
        }
        if (Fields.SecurityPolicyUri.getSpecification().equals(fieldSpecification)) {
            this.setSecurityPolicyUri((String)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = UserTokenPolicy.builder();
        builder.setPolicyId(this.getPolicyId());
        builder.setTokenType(this.getTokenType());
        builder.setIssuedTokenType(this.getIssuedTokenType());
        builder.setIssuerEndpointUrl(this.getIssuerEndpointUrl());
        builder.setSecurityPolicyUri(this.getSecurityPolicyUri());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.PolicyId.getSpecification());
        builder.addField(Fields.TokenType.getSpecification());
        builder.addField(Fields.IssuedTokenType.getSpecification());
        builder.addField(Fields.IssuerEndpointUrl.getSpecification());
        builder.addField(Fields.SecurityPolicyUri.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("UserTokenPolicy");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.UserTokenPolicySerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return UserTokenPolicy.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String policyId;
        private UserTokenType tokenType;
        private String issuedTokenType;
        private String issuerEndpointUrl;
        private String securityPolicyUri;

        protected Builder() {
        }

        public Builder setPolicyId(String string) {
            this.policyId = string;
            return this;
        }

        public Builder setTokenType(UserTokenType userTokenType) {
            this.tokenType = userTokenType;
            return this;
        }

        public Builder setIssuedTokenType(String string) {
            this.issuedTokenType = string;
            return this;
        }

        public Builder setIssuerEndpointUrl(String string) {
            this.issuerEndpointUrl = string;
            return this;
        }

        public Builder setSecurityPolicyUri(String string) {
            this.securityPolicyUri = string;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.PolicyId.getSpecification().equals(fieldSpecification)) {
                this.setPolicyId((String)object);
                return this;
            }
            if (Fields.TokenType.getSpecification().equals(fieldSpecification)) {
                this.setTokenType((UserTokenType)object);
                return this;
            }
            if (Fields.IssuedTokenType.getSpecification().equals(fieldSpecification)) {
                this.setIssuedTokenType((String)object);
                return this;
            }
            if (Fields.IssuerEndpointUrl.getSpecification().equals(fieldSpecification)) {
                this.setIssuerEndpointUrl((String)object);
                return this;
            }
            if (Fields.SecurityPolicyUri.getSpecification().equals(fieldSpecification)) {
                this.setSecurityPolicyUri((String)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public UserTokenPolicy build() {
            return new UserTokenPolicy(this.policyId, this.tokenType, this.issuedTokenType, this.issuerEndpointUrl, this.securityPolicyUri);
        }
    }

    public static enum Fields {
        PolicyId("PolicyId", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        TokenType("TokenType", UserTokenType.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=303")), -1),
        IssuedTokenType("IssuedTokenType", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        IssuerEndpointUrl("IssuerEndpointUrl", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        SecurityPolicyUri("SecurityPolicyUri", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

