/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.Frame;
import com.prosysopc.ua.stack.core.ThreeDCartesianCoordinates;
import com.prosysopc.ua.stack.core.ThreeDOrientation;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18814")
public class ThreeDFrame
extends Frame {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ThreeDFrame_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ThreeDFrame_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ThreeDFrame_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ThreeDFrame;
    public static final StructureSpecification SPECIFICATION;
    private ThreeDCartesianCoordinates cartesianCoordinates;
    private ThreeDOrientation orientation;

    public ThreeDFrame() {
    }

    public ThreeDFrame(ThreeDCartesianCoordinates threeDCartesianCoordinates, ThreeDOrientation threeDOrientation) {
        this.cartesianCoordinates = threeDCartesianCoordinates;
        this.orientation = threeDOrientation;
    }

    public ThreeDCartesianCoordinates getCartesianCoordinates() {
        return this.cartesianCoordinates;
    }

    public void setCartesianCoordinates(ThreeDCartesianCoordinates threeDCartesianCoordinates) {
        this.cartesianCoordinates = threeDCartesianCoordinates;
    }

    public ThreeDOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ThreeDOrientation threeDOrientation) {
        this.orientation = threeDOrientation;
    }

    @Override
    public ThreeDFrame clone() {
        ThreeDFrame threeDFrame = (ThreeDFrame)super.clone();
        threeDFrame.cartesianCoordinates = StructureUtils.clone(this.cartesianCoordinates);
        threeDFrame.orientation = StructureUtils.clone(this.orientation);
        return threeDFrame;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ThreeDFrame threeDFrame = (ThreeDFrame)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getCartesianCoordinates(), threeDFrame.getCartesianCoordinates())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getOrientation(), threeDFrame.getOrientation());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getCartesianCoordinates(), this.getOrientation());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.CartesianCoordinates.getSpecification().equals(fieldSpecification)) {
            return this.getCartesianCoordinates();
        }
        if (Fields.Orientation.getSpecification().equals(fieldSpecification)) {
            return this.getOrientation();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.CartesianCoordinates.getSpecification().equals(fieldSpecification)) {
            this.setCartesianCoordinates((ThreeDCartesianCoordinates)object);
            return;
        }
        if (Fields.Orientation.getSpecification().equals(fieldSpecification)) {
            this.setOrientation((ThreeDOrientation)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ThreeDFrame.builder();
        builder.setCartesianCoordinates(this.getCartesianCoordinates());
        builder.setOrientation(this.getOrientation());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.CartesianCoordinates.getSpecification());
        builder.addField(Fields.Orientation.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ThreeDFrame");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ThreeDFrameSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ThreeDFrame.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends Frame.Builder {
        private ThreeDCartesianCoordinates cartesianCoordinates;
        private ThreeDOrientation orientation;

        protected Builder() {
        }

        public Builder setCartesianCoordinates(ThreeDCartesianCoordinates threeDCartesianCoordinates) {
            this.cartesianCoordinates = threeDCartesianCoordinates;
            return this;
        }

        public Builder setOrientation(ThreeDOrientation threeDOrientation) {
            this.orientation = threeDOrientation;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.CartesianCoordinates.getSpecification().equals(fieldSpecification)) {
                this.setCartesianCoordinates((ThreeDCartesianCoordinates)object);
                return this;
            }
            if (Fields.Orientation.getSpecification().equals(fieldSpecification)) {
                this.setOrientation((ThreeDOrientation)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ThreeDFrame build() {
            return new ThreeDFrame(this.cartesianCoordinates, this.orientation);
        }
    }

    public static enum Fields {
        CartesianCoordinates("CartesianCoordinates", ThreeDCartesianCoordinates.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=18810")), -1),
        Orientation("Orientation", ThreeDOrientation.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=18812")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

