/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=101")
public class StructureField
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.StructureField_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.StructureField_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.StructureField_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.StructureField;
    public static final StructureSpecification SPECIFICATION;
    private String name;
    private LocalizedText description;
    private NodeId dataType;
    private Integer valueRank;
    private UnsignedInteger[] arrayDimensions;
    private UnsignedInteger maxStringLength;
    private Boolean isOptional;

    public StructureField() {
    }

    public StructureField(String string, LocalizedText localizedText, NodeId nodeId, Integer n2, UnsignedInteger[] unsignedIntegerArray, UnsignedInteger unsignedInteger, Boolean bl) {
        this.name = string;
        this.description = localizedText;
        this.dataType = nodeId;
        this.valueRank = n2;
        this.arrayDimensions = unsignedIntegerArray;
        this.maxStringLength = unsignedInteger;
        this.isOptional = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    public void setDescription(LocalizedText localizedText) {
        this.description = localizedText;
    }

    public NodeId getDataType() {
        return this.dataType;
    }

    public void setDataType(NodeId nodeId) {
        this.dataType = nodeId;
    }

    public Integer getValueRank() {
        return this.valueRank;
    }

    public void setValueRank(Integer n2) {
        this.valueRank = n2;
    }

    public UnsignedInteger[] getArrayDimensions() {
        return this.arrayDimensions;
    }

    public void setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
        this.arrayDimensions = unsignedIntegerArray;
    }

    public UnsignedInteger getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(UnsignedInteger unsignedInteger) {
        this.maxStringLength = unsignedInteger;
    }

    public Boolean getIsOptional() {
        return this.isOptional;
    }

    public void setIsOptional(Boolean bl) {
        this.isOptional = bl;
    }

    @Override
    public StructureField clone() {
        StructureField structureField = (StructureField)super.clone();
        structureField.name = StructureUtils.clone(this.name);
        structureField.description = StructureUtils.clone(this.description);
        structureField.dataType = StructureUtils.clone(this.dataType);
        structureField.valueRank = StructureUtils.clone(this.valueRank);
        structureField.arrayDimensions = StructureUtils.clone(this.arrayDimensions);
        structureField.maxStringLength = StructureUtils.clone(this.maxStringLength);
        structureField.isOptional = StructureUtils.clone(this.isOptional);
        return structureField;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StructureField structureField = (StructureField)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getName(), structureField.getName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDescription(), structureField.getDescription())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDataType(), structureField.getDataType())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getValueRank(), structureField.getValueRank())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getArrayDimensions(), structureField.getArrayDimensions())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getMaxStringLength(), structureField.getMaxStringLength())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getIsOptional(), structureField.getIsOptional());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getName(), this.getDescription(), this.getDataType(), this.getValueRank(), this.getArrayDimensions(), this.getMaxStringLength(), this.getIsOptional());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Name.getSpecification().equals(fieldSpecification)) {
            return this.getName();
        }
        if (Fields.Description.getSpecification().equals(fieldSpecification)) {
            return this.getDescription();
        }
        if (Fields.DataType.getSpecification().equals(fieldSpecification)) {
            return this.getDataType();
        }
        if (Fields.ValueRank.getSpecification().equals(fieldSpecification)) {
            return this.getValueRank();
        }
        if (Fields.ArrayDimensions.getSpecification().equals(fieldSpecification)) {
            return this.getArrayDimensions();
        }
        if (Fields.MaxStringLength.getSpecification().equals(fieldSpecification)) {
            return this.getMaxStringLength();
        }
        if (Fields.IsOptional.getSpecification().equals(fieldSpecification)) {
            return this.getIsOptional();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Name.getSpecification().equals(fieldSpecification)) {
            this.setName((String)object);
            return;
        }
        if (Fields.Description.getSpecification().equals(fieldSpecification)) {
            this.setDescription((LocalizedText)object);
            return;
        }
        if (Fields.DataType.getSpecification().equals(fieldSpecification)) {
            this.setDataType((NodeId)object);
            return;
        }
        if (Fields.ValueRank.getSpecification().equals(fieldSpecification)) {
            this.setValueRank((Integer)object);
            return;
        }
        if (Fields.ArrayDimensions.getSpecification().equals(fieldSpecification)) {
            this.setArrayDimensions((UnsignedInteger[])object);
            return;
        }
        if (Fields.MaxStringLength.getSpecification().equals(fieldSpecification)) {
            this.setMaxStringLength((UnsignedInteger)object);
            return;
        }
        if (Fields.IsOptional.getSpecification().equals(fieldSpecification)) {
            this.setIsOptional((Boolean)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = StructureField.builder();
        builder.setName(this.getName());
        builder.setDescription(this.getDescription());
        builder.setDataType(this.getDataType());
        builder.setValueRank(this.getValueRank());
        builder.setArrayDimensions(this.getArrayDimensions());
        builder.setMaxStringLength(this.getMaxStringLength());
        builder.setIsOptional(this.getIsOptional());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Name.getSpecification());
        builder.addField(Fields.Description.getSpecification());
        builder.addField(Fields.DataType.getSpecification());
        builder.addField(Fields.ValueRank.getSpecification());
        builder.addField(Fields.ArrayDimensions.getSpecification());
        builder.addField(Fields.MaxStringLength.getSpecification());
        builder.addField(Fields.IsOptional.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("StructureField");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.StructureFieldSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return StructureField.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String name;
        private LocalizedText description;
        private NodeId dataType;
        private Integer valueRank;
        private UnsignedInteger[] arrayDimensions;
        private UnsignedInteger maxStringLength;
        private Boolean isOptional;

        protected Builder() {
        }

        public Builder setName(String string) {
            this.name = string;
            return this;
        }

        public Builder setDescription(LocalizedText localizedText) {
            this.description = localizedText;
            return this;
        }

        public Builder setDataType(NodeId nodeId) {
            this.dataType = nodeId;
            return this;
        }

        public Builder setValueRank(Integer n2) {
            this.valueRank = n2;
            return this;
        }

        public Builder setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
            this.arrayDimensions = unsignedIntegerArray;
            return this;
        }

        public Builder setMaxStringLength(UnsignedInteger unsignedInteger) {
            this.maxStringLength = unsignedInteger;
            return this;
        }

        public Builder setIsOptional(Boolean bl) {
            this.isOptional = bl;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Name.getSpecification().equals(fieldSpecification)) {
                this.setName((String)object);
                return this;
            }
            if (Fields.Description.getSpecification().equals(fieldSpecification)) {
                this.setDescription((LocalizedText)object);
                return this;
            }
            if (Fields.DataType.getSpecification().equals(fieldSpecification)) {
                this.setDataType((NodeId)object);
                return this;
            }
            if (Fields.ValueRank.getSpecification().equals(fieldSpecification)) {
                this.setValueRank((Integer)object);
                return this;
            }
            if (Fields.ArrayDimensions.getSpecification().equals(fieldSpecification)) {
                this.setArrayDimensions((UnsignedInteger[])object);
                return this;
            }
            if (Fields.MaxStringLength.getSpecification().equals(fieldSpecification)) {
                this.setMaxStringLength((UnsignedInteger)object);
                return this;
            }
            if (Fields.IsOptional.getSpecification().equals(fieldSpecification)) {
                this.setIsOptional((Boolean)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public StructureField build() {
            return new StructureField(this.name, this.description, this.dataType, this.valueRank, this.arrayDimensions, this.maxStringLength, this.isOptional);
        }
    }

    public static enum Fields {
        Name("Name", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        Description("Description", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1),
        DataType("DataType", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        ValueRank("ValueRank", Integer.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=6")), -1),
        ArrayDimensions("ArrayDimensions", UnsignedInteger[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), 1),
        MaxStringLength("MaxStringLength", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1),
        IsOptional("IsOptional", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

