/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.core.DataTypeDescription;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15005")
public class SimpleTypeDescription
extends DataTypeDescription {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.SimpleTypeDescription_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.SimpleTypeDescription_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.SimpleTypeDescription_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.SimpleTypeDescription;
    public static final StructureSpecification SPECIFICATION;
    private NodeId baseDataType;
    private UnsignedByte builtInType;

    public SimpleTypeDescription() {
    }

    public SimpleTypeDescription(NodeId nodeId, UnsignedByte unsignedByte) {
        this.baseDataType = nodeId;
        this.builtInType = unsignedByte;
    }

    public SimpleTypeDescription(NodeId nodeId, QualifiedName qualifiedName, NodeId nodeId2, UnsignedByte unsignedByte) {
        super(nodeId, qualifiedName);
        this.baseDataType = nodeId2;
        this.builtInType = unsignedByte;
    }

    public NodeId getBaseDataType() {
        return this.baseDataType;
    }

    public void setBaseDataType(NodeId nodeId) {
        this.baseDataType = nodeId;
    }

    public UnsignedByte getBuiltInType() {
        return this.builtInType;
    }

    public void setBuiltInType(UnsignedByte unsignedByte) {
        this.builtInType = unsignedByte;
    }

    @Override
    public SimpleTypeDescription clone() {
        SimpleTypeDescription simpleTypeDescription = (SimpleTypeDescription)super.clone();
        simpleTypeDescription.baseDataType = StructureUtils.clone(this.baseDataType);
        simpleTypeDescription.builtInType = StructureUtils.clone(this.builtInType);
        return simpleTypeDescription;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SimpleTypeDescription simpleTypeDescription = (SimpleTypeDescription)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getDataTypeId(), simpleTypeDescription.getDataTypeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getName(), simpleTypeDescription.getName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getBaseDataType(), simpleTypeDescription.getBaseDataType())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getBuiltInType(), simpleTypeDescription.getBuiltInType());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getDataTypeId(), this.getName(), this.getBaseDataType(), this.getBuiltInType());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.DataTypeId.getSpecification().equals(fieldSpecification)) {
            return this.getDataTypeId();
        }
        if (Fields.Name.getSpecification().equals(fieldSpecification)) {
            return this.getName();
        }
        if (Fields.BaseDataType.getSpecification().equals(fieldSpecification)) {
            return this.getBaseDataType();
        }
        if (Fields.BuiltInType.getSpecification().equals(fieldSpecification)) {
            return this.getBuiltInType();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.DataTypeId.getSpecification().equals(fieldSpecification)) {
            this.setDataTypeId((NodeId)object);
            return;
        }
        if (Fields.Name.getSpecification().equals(fieldSpecification)) {
            this.setName((QualifiedName)object);
            return;
        }
        if (Fields.BaseDataType.getSpecification().equals(fieldSpecification)) {
            this.setBaseDataType((NodeId)object);
            return;
        }
        if (Fields.BuiltInType.getSpecification().equals(fieldSpecification)) {
            this.setBuiltInType((UnsignedByte)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = SimpleTypeDescription.builder();
        builder.setDataTypeId(this.getDataTypeId());
        builder.setName(this.getName());
        builder.setBaseDataType(this.getBaseDataType());
        builder.setBuiltInType(this.getBuiltInType());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.DataTypeId.getSpecification());
        builder.addField(Fields.Name.getSpecification());
        builder.addField(Fields.BaseDataType.getSpecification());
        builder.addField(Fields.BuiltInType.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("SimpleTypeDescription");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.SimpleTypeDescriptionSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return SimpleTypeDescription.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends DataTypeDescription.Builder {
        private NodeId dataTypeId;
        private QualifiedName name;
        private NodeId baseDataType;
        private UnsignedByte builtInType;

        protected Builder() {
        }

        @Override
        public Builder setDataTypeId(NodeId nodeId) {
            this.dataTypeId = nodeId;
            return this;
        }

        @Override
        public Builder setName(QualifiedName qualifiedName) {
            this.name = qualifiedName;
            return this;
        }

        public Builder setBaseDataType(NodeId nodeId) {
            this.baseDataType = nodeId;
            return this;
        }

        public Builder setBuiltInType(UnsignedByte unsignedByte) {
            this.builtInType = unsignedByte;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.DataTypeId.getSpecification().equals(fieldSpecification)) {
                this.setDataTypeId((NodeId)object);
                return this;
            }
            if (Fields.Name.getSpecification().equals(fieldSpecification)) {
                this.setName((QualifiedName)object);
                return this;
            }
            if (Fields.BaseDataType.getSpecification().equals(fieldSpecification)) {
                this.setBaseDataType((NodeId)object);
                return this;
            }
            if (Fields.BuiltInType.getSpecification().equals(fieldSpecification)) {
                this.setBuiltInType((UnsignedByte)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public SimpleTypeDescription build() {
            return new SimpleTypeDescription(this.dataTypeId, this.name, this.baseDataType, this.builtInType);
        }
    }

    public static enum Fields {
        DataTypeId("DataTypeId", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        Name("Name", QualifiedName.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=20")), -1),
        BaseDataType("BaseDataType", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        BuiltInType("BuiltInType", UnsignedByte.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=3")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

