/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.FilterOperand;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=601")
public class SimpleAttributeOperand
extends FilterOperand {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.SimpleAttributeOperand_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.SimpleAttributeOperand_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.SimpleAttributeOperand_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.SimpleAttributeOperand;
    public static final StructureSpecification SPECIFICATION;
    private NodeId typeDefinitionId;
    private QualifiedName[] browsePath;
    private UnsignedInteger attributeId;
    private String indexRange;

    public SimpleAttributeOperand() {
    }

    public SimpleAttributeOperand(NodeId nodeId, QualifiedName[] qualifiedNameArray, UnsignedInteger unsignedInteger, String string) {
        this.typeDefinitionId = nodeId;
        this.browsePath = qualifiedNameArray;
        this.attributeId = unsignedInteger;
        this.indexRange = string;
    }

    public NodeId getTypeDefinitionId() {
        return this.typeDefinitionId;
    }

    public void setTypeDefinitionId(NodeId nodeId) {
        this.typeDefinitionId = nodeId;
    }

    public QualifiedName[] getBrowsePath() {
        return this.browsePath;
    }

    public void setBrowsePath(QualifiedName[] qualifiedNameArray) {
        this.browsePath = qualifiedNameArray;
    }

    public UnsignedInteger getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(UnsignedInteger unsignedInteger) {
        this.attributeId = unsignedInteger;
    }

    public String getIndexRange() {
        return this.indexRange;
    }

    public void setIndexRange(String string) {
        this.indexRange = string;
    }

    @Override
    public SimpleAttributeOperand clone() {
        SimpleAttributeOperand simpleAttributeOperand = (SimpleAttributeOperand)super.clone();
        simpleAttributeOperand.typeDefinitionId = StructureUtils.clone(this.typeDefinitionId);
        simpleAttributeOperand.browsePath = StructureUtils.clone(this.browsePath);
        simpleAttributeOperand.attributeId = StructureUtils.clone(this.attributeId);
        simpleAttributeOperand.indexRange = StructureUtils.clone(this.indexRange);
        return simpleAttributeOperand;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SimpleAttributeOperand simpleAttributeOperand = (SimpleAttributeOperand)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getTypeDefinitionId(), simpleAttributeOperand.getTypeDefinitionId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getBrowsePath(), simpleAttributeOperand.getBrowsePath())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getAttributeId(), simpleAttributeOperand.getAttributeId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getIndexRange(), simpleAttributeOperand.getIndexRange());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getTypeDefinitionId(), this.getBrowsePath(), this.getAttributeId(), this.getIndexRange());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.TypeDefinitionId.getSpecification().equals(fieldSpecification)) {
            return this.getTypeDefinitionId();
        }
        if (Fields.BrowsePath.getSpecification().equals(fieldSpecification)) {
            return this.getBrowsePath();
        }
        if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
            return this.getAttributeId();
        }
        if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
            return this.getIndexRange();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.TypeDefinitionId.getSpecification().equals(fieldSpecification)) {
            this.setTypeDefinitionId((NodeId)object);
            return;
        }
        if (Fields.BrowsePath.getSpecification().equals(fieldSpecification)) {
            this.setBrowsePath((QualifiedName[])object);
            return;
        }
        if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
            this.setAttributeId((UnsignedInteger)object);
            return;
        }
        if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
            this.setIndexRange((String)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = SimpleAttributeOperand.builder();
        builder.setTypeDefinitionId(this.getTypeDefinitionId());
        builder.setBrowsePath(this.getBrowsePath());
        builder.setAttributeId(this.getAttributeId());
        builder.setIndexRange(this.getIndexRange());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.TypeDefinitionId.getSpecification());
        builder.addField(Fields.BrowsePath.getSpecification());
        builder.addField(Fields.AttributeId.getSpecification());
        builder.addField(Fields.IndexRange.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("SimpleAttributeOperand");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.SimpleAttributeOperandSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return SimpleAttributeOperand.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends FilterOperand.Builder {
        private NodeId typeDefinitionId;
        private QualifiedName[] browsePath;
        private UnsignedInteger attributeId;
        private String indexRange;

        protected Builder() {
        }

        public Builder setTypeDefinitionId(NodeId nodeId) {
            this.typeDefinitionId = nodeId;
            return this;
        }

        public Builder setBrowsePath(QualifiedName[] qualifiedNameArray) {
            this.browsePath = qualifiedNameArray;
            return this;
        }

        public Builder setAttributeId(UnsignedInteger unsignedInteger) {
            this.attributeId = unsignedInteger;
            return this;
        }

        public Builder setIndexRange(String string) {
            this.indexRange = string;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.TypeDefinitionId.getSpecification().equals(fieldSpecification)) {
                this.setTypeDefinitionId((NodeId)object);
                return this;
            }
            if (Fields.BrowsePath.getSpecification().equals(fieldSpecification)) {
                this.setBrowsePath((QualifiedName[])object);
                return this;
            }
            if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
                this.setAttributeId((UnsignedInteger)object);
                return this;
            }
            if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
                this.setIndexRange((String)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public SimpleAttributeOperand build() {
            return new SimpleAttributeOperand(this.typeDefinitionId, this.browsePath, this.attributeId, this.indexRange);
        }
    }

    public static enum Fields {
        TypeDefinitionId("TypeDefinitionId", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        BrowsePath("BrowsePath", QualifiedName[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=20")), 1),
        AttributeId("AttributeId", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=288")), -1),
        IndexRange("IndexRange", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=291")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

