/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=871")
public class ServiceCounterDataType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ServiceCounterDataType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ServiceCounterDataType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ServiceCounterDataType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ServiceCounterDataType;
    public static final StructureSpecification SPECIFICATION;
    private UnsignedInteger totalCount;
    private UnsignedInteger errorCount;

    public ServiceCounterDataType() {
    }

    public ServiceCounterDataType(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) {
        this.totalCount = unsignedInteger;
        this.errorCount = unsignedInteger2;
    }

    public UnsignedInteger getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(UnsignedInteger unsignedInteger) {
        this.totalCount = unsignedInteger;
    }

    public UnsignedInteger getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(UnsignedInteger unsignedInteger) {
        this.errorCount = unsignedInteger;
    }

    @Override
    public ServiceCounterDataType clone() {
        ServiceCounterDataType serviceCounterDataType = (ServiceCounterDataType)super.clone();
        serviceCounterDataType.totalCount = StructureUtils.clone(this.totalCount);
        serviceCounterDataType.errorCount = StructureUtils.clone(this.errorCount);
        return serviceCounterDataType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ServiceCounterDataType serviceCounterDataType = (ServiceCounterDataType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getTotalCount(), serviceCounterDataType.getTotalCount())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getErrorCount(), serviceCounterDataType.getErrorCount());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getTotalCount(), this.getErrorCount());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.TotalCount.getSpecification().equals(fieldSpecification)) {
            return this.getTotalCount();
        }
        if (Fields.ErrorCount.getSpecification().equals(fieldSpecification)) {
            return this.getErrorCount();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.TotalCount.getSpecification().equals(fieldSpecification)) {
            this.setTotalCount((UnsignedInteger)object);
            return;
        }
        if (Fields.ErrorCount.getSpecification().equals(fieldSpecification)) {
            this.setErrorCount((UnsignedInteger)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ServiceCounterDataType.builder();
        builder.setTotalCount(this.getTotalCount());
        builder.setErrorCount(this.getErrorCount());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.TotalCount.getSpecification());
        builder.addField(Fields.ErrorCount.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ServiceCounterDataType");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ServiceCounterDataTypeSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ServiceCounterDataType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private UnsignedInteger totalCount;
        private UnsignedInteger errorCount;

        protected Builder() {
        }

        public Builder setTotalCount(UnsignedInteger unsignedInteger) {
            this.totalCount = unsignedInteger;
            return this;
        }

        public Builder setErrorCount(UnsignedInteger unsignedInteger) {
            this.errorCount = unsignedInteger;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.TotalCount.getSpecification().equals(fieldSpecification)) {
                this.setTotalCount((UnsignedInteger)object);
                return this;
            }
            if (Fields.ErrorCount.getSpecification().equals(fieldSpecification)) {
                this.setErrorCount((UnsignedInteger)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ServiceCounterDataType build() {
            return new ServiceCounterDataType(this.totalCount, this.errorCount);
        }
    }

    public static enum Fields {
        TotalCount("TotalCount", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1),
        ErrorCount("ErrorCount", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

